/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import javax.annotation.Nullable;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.entity.item.EntityTNTPrimedBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={BlockTNT.class})
public abstract class BlockTNTMixin
extends BlockMixin {
    private boolean primeCancelled;

    private boolean impl$onRemove(World world, BlockPos pos) {
        boolean removed = !this.primeCancelled && world.func_175698_g(pos);
        this.primeCancelled = false;
        return removed;
    }

    @Inject(method={"explode"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void impl$ThrowPrimeAndMaybeCancel(World worldIn, BlockPos pos, IBlockState state, @Nullable EntityLivingBase igniter, CallbackInfo ci, EntityTNTPrimed tnt) {
        ((EntityTNTPrimedBridge)tnt).bridge$setDetonator(igniter);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                if (igniter != null) {
                    frame.addContext(EventContextKeys.IGNITER, (Living)igniter);
                }
                if (!((FusedExplosiveBridge)tnt).bridge$shouldPrime()) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"onExplosionDestroy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void impl$CheckIfCanPrimeFromExplosion(World worldIn, BlockPos pos, Explosion explosionIn, CallbackInfo ci, EntityTNTPrimed tnt) {
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.DAMAGE_TYPE, DamageTypes.EXPLOSIVE);
                if (!((FusedExplosiveBridge)tnt).bridge$shouldPrime()) {
                    ci.cancel();
                }
            }
        }
    }

    @Redirect(method={"onBlockAdded"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean impl$removePostSetAir(World world, BlockPos pos) {
        return this.impl$onRemove(world, pos);
    }

    @Redirect(method={"neighborChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean impl$removeNeighbor(World world, BlockPos pos) {
        return this.impl$onRemove(world, pos);
    }

    @Redirect(method={"onBlockActivated"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"))
    private boolean impl$removeActivated(World world, BlockPos pos, IBlockState state, int flag) {
        boolean removed = !this.primeCancelled && world.func_180501_a(pos, state, flag);
        this.primeCancelled = false;
        return removed;
    }

    @Redirect(method={"onEntityCollision"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean impl$removeonCollide(World world, BlockPos pos) {
        return this.impl$onRemove(world, pos);
    }
}

