/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableRedstonePoweredData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWireAttachmentData;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeRedstonePoweredData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeWireAttachmentData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockRedstoneWire.class})
public abstract class BlockRedstoneWireMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getPowerFor(blockState), (Object)this.impl$getConnectedDirectionData(blockState), (Object)this.impl$getWireAttachmentData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableRedstonePoweredData.class.isAssignableFrom(immutable) || ImmutableConnectedDirectionData.class.isAssignableFrom(immutable) || ImmutableWireAttachmentData.class.isAssignableFrom(immutable);
    }

    private IBlockState impl$applyConnectedDirections(IBlockState blockState, Set<Direction> directions) {
        HashMap<PropertyEnum<BlockRedstoneWire.EnumAttachPosition>, BlockRedstoneWire.EnumAttachPosition> facingStates = new HashMap<PropertyEnum<BlockRedstoneWire.EnumAttachPosition>, BlockRedstoneWire.EnumAttachPosition>();
        for (PropertyEnum<BlockRedstoneWire.EnumAttachPosition> property : Constants.DirectionFunctions.RedstoneWire.ALL_DIRECTION_PROPERTIES) {
            facingStates.put(property, BlockRedstoneWire.EnumAttachPosition.NONE);
        }
        for (Direction connectedDirection : directions) {
            Optional<PropertyEnum<BlockRedstoneWire.EnumAttachPosition>> facingPropertyBox = Constants.DirectionFunctions.RedstoneWire.getPropertyFromDirection(connectedDirection);
            facingPropertyBox.ifPresent(facingProperty -> {
                BlockRedstoneWire.EnumAttachPosition cfr_ignored_0 = (BlockRedstoneWire.EnumAttachPosition)facingStates.put((PropertyEnum<BlockRedstoneWire.EnumAttachPosition>)facingProperty, (BlockRedstoneWire.EnumAttachPosition)blockState.func_177229_b((IProperty)facingProperty));
            });
        }
        IBlockState resultBlockState = blockState;
        for (PropertyEnum property : facingStates.keySet()) {
            resultBlockState = resultBlockState.func_177226_a((IProperty)property, (Comparable)facingStates.get(property));
        }
        return resultBlockState;
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableRedstonePoweredData) {
            return Optional.of((BlockState)blockState);
        }
        if (manipulator instanceof ImmutableConnectedDirectionData) {
            ImmutableConnectedDirectionData connectedDirectionData = (ImmutableConnectedDirectionData)manipulator;
            return Optional.of((BlockState)this.impl$applyConnectedDirections(blockState, (Set)connectedDirectionData.connectedDirections().get()));
        }
        if (manipulator instanceof ImmutableWireAttachmentData) {
            return Optional.of((BlockState)blockState);
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.POWER)) {
            return Optional.of((BlockState)blockState);
        }
        if (key.equals(Keys.WIRE_ATTACHMENTS) || key.equals(Keys.WIRE_ATTACHMENT_NORTH) || key.equals(Keys.WIRE_ATTACHMENT_SOUTH) || key.equals(Keys.WIRE_ATTACHMENT_EAST) || key.equals(Keys.WIRE_ATTACHMENT_WEST)) {
            return Optional.of((BlockState)blockState);
        }
        if (key.equals(Keys.CONNECTED_DIRECTIONS)) {
            return Optional.of((BlockState)this.impl$applyConnectedDirections(blockState, (Set)value));
        }
        if (key.equals(Keys.CONNECTED_EAST)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneWire.field_176347_b, blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176347_b)));
        }
        if (key.equals(Keys.CONNECTED_NORTH)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneWire.field_176348_a, blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176348_a)));
        }
        if (key.equals(Keys.CONNECTED_SOUTH)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneWire.field_176349_M, blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176349_M)));
        }
        if (key.equals(Keys.CONNECTED_WEST)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockRedstoneWire.field_176350_N, blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176350_N)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutableRedstonePoweredData impl$getPowerFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeRedstonePoweredData.class, blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O));
    }

    private ImmutableConnectedDirectionData impl$getConnectedDirectionData(IBlockState blockState) {
        EnumSet<Direction> directions = EnumSet.noneOf(Direction.class);
        IStringSerializable north = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176348_a);
        IStringSerializable east = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176347_b);
        IStringSerializable west = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176350_N);
        IStringSerializable south = (IStringSerializable)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176349_M);
        if (!north.func_176610_l().matches("none")) {
            directions.add(Direction.NORTH);
        }
        if (!east.func_176610_l().matches("none")) {
            directions.add(Direction.EAST);
        }
        if (!west.func_176610_l().matches("none")) {
            directions.add(Direction.WEST);
        }
        if (!south.func_176610_l().matches("none")) {
            directions.add(Direction.SOUTH);
        }
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeConnectedDirectionData.class, directions);
    }

    private ImmutableWireAttachmentData impl$getWireAttachmentData(IBlockState blockState) {
        EnumMap<Direction, WireAttachmentType> data = new EnumMap<Direction, WireAttachmentType>(Direction.class);
        data.put(Direction.NORTH, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176348_a)));
        data.put(Direction.SOUTH, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176349_M)));
        data.put(Direction.EAST, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176347_b)));
        data.put(Direction.WEST, (WireAttachmentType)((Object)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176350_N)));
        return new ImmutableSpongeWireAttachmentData(data);
    }
}

