/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipeRegistry;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipes;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.SpongeManipulatorRegistry;
import org.spongepowered.common.item.recipe.crafting.DelegateSpongeCraftingRecipe;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.data.KeyRegistryModule;

@RegisterCatalog(value=CraftingRecipes.class)
@RegistrationDependency(value={KeyRegistryModule.class, SpongeManipulatorRegistry.class})
public class SpongeCraftingRecipeRegistry
implements CraftingRecipeRegistry,
SpongeAdditionalCatalogRegistryModule<CraftingRecipe>,
AlternateCatalogRegistryModule<CraftingRecipe> {
    public static SpongeCraftingRecipeRegistry getInstance() {
        return Holder.INSTANCE;
    }

    private SpongeCraftingRecipeRegistry() {
    }

    @Override
    public void register(CraftingRecipe recipe) {
        this.registerAdditionalCatalog(recipe);
    }

    @Override
    public Collection<CraftingRecipe> getRecipes() {
        return this.getAll();
    }

    @Override
    public Optional<CraftingRecipe> getById(String id) {
        return SpongeImplHooks.getRecipeById(id);
    }

    @Override
    public Collection<CraftingRecipe> getAll() {
        return SpongeImplHooks.getCraftingRecipes().stream().map(recipe -> {
            if (recipe instanceof DelegateSpongeCraftingRecipe) {
                return ((DelegateSpongeCraftingRecipe)recipe).getDelegate();
            }
            return recipe;
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, CraftingRecipe> provideCatalogMap() {
        Collection<CraftingRecipe> recipes = this.getAll();
        HashMap<String, CraftingRecipe> mappings = new HashMap<String, CraftingRecipe>();
        for (CraftingRecipe recipe : recipes) {
            String id = recipe.getId();
            int index = id.indexOf(58);
            if (index == -1 || !id.substring(0, index).equals("minecraft")) continue;
            mappings.put(id.substring(index + 1), recipe);
        }
        return mappings;
    }

    @Override
    public Optional<CraftingRecipe> findMatchingRecipe(CraftingGridInventory inventory, World world) {
        return SpongeImplHooks.findMatchingRecipe(inventory, world);
    }

    @Override
    public boolean allowsApiRegistration() {
        return SpongeImplHooks.isVanilla();
    }

    @Override
    public void registerDefaults() {
        RegistryHelper.setFinalStatic(org.spongepowered.api.item.recipe.crafting.Ingredient.class, "NONE", Ingredient.field_193370_a);
    }

    @Override
    public void registerAdditionalCatalog(CraftingRecipe recipe) {
        if (!(recipe instanceof IRecipe)) {
            recipe = new DelegateSpongeCraftingRecipe(recipe);
        }
        SpongeImplHooks.register(new ResourceLocation(recipe.getId()), (IRecipe)recipe);
    }

    private static final class Holder {
        static final SpongeCraftingRecipeRegistry INSTANCE = new SpongeCraftingRecipeRegistry();

        private Holder() {
        }
    }
}

