/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft;

import java.util.Optional;
import net.minecraft.inventory.Container;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.property.EquipmentSlotType;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.EquipmentInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.MainPlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.EquipmentInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.MainPlayerInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class PlayerInventoryLens
extends AbstractLens {
    private static final int EQUIPMENT = 4;
    private static final int OFFHAND = 1;
    private MainPlayerInventoryLensImpl main;
    private EquipmentInventoryLensImpl equipment;
    private SlotLens offhand;
    private final boolean isContainer;

    public PlayerInventoryLens(int size, Class<? extends Inventory> adapter, SlotProvider slots) {
        super(0, size, adapter);
        this.isContainer = false;
        this.init(slots);
    }

    public PlayerInventoryLens(int base, int size, SlotProvider slots) {
        super(base, size, PlayerInventory.class);
        this.isContainer = true;
        this.init(slots);
    }

    protected void init(SlotProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
        int base = this.base;
        if (this.isContainer) {
            this.equipment = new EquipmentInventoryLensImpl(base, 4, 1, slots, true);
            this.addChild(slots.getSlot(base + 0), new EquipmentSlotType(EquipmentTypes.HEADWEAR));
            this.addChild(slots.getSlot(base + 1), new EquipmentSlotType(EquipmentTypes.CHESTPLATE));
            this.addChild(slots.getSlot(base + 2), new EquipmentSlotType(EquipmentTypes.LEGGINGS));
            this.addChild(slots.getSlot(base + 3), new EquipmentSlotType(EquipmentTypes.BOOTS));
            this.main = new MainPlayerInventoryLensImpl(base += 4, slots, true);
            this.offhand = slots.getSlot(base += this.main.slotCount());
            this.addChild(slots.getSlot(base), new EquipmentSlotType(EquipmentTypes.OFF_HAND));
            ++base;
        } else {
            this.main = new MainPlayerInventoryLensImpl(base, slots, false);
            this.equipment = new EquipmentInventoryLensImpl(base += this.main.slotCount(), 4, 1, slots, false);
            this.addChild(slots.getSlot(base + 0), new EquipmentSlotType(EquipmentTypes.BOOTS));
            this.addChild(slots.getSlot(base + 1), new EquipmentSlotType(EquipmentTypes.LEGGINGS));
            this.addChild(slots.getSlot(base + 2), new EquipmentSlotType(EquipmentTypes.CHESTPLATE));
            this.addChild(slots.getSlot(base + 3), new EquipmentSlotType(EquipmentTypes.HEADWEAR));
            this.offhand = slots.getSlot(base += 4);
            this.addChild(slots.getSlot(base), new EquipmentSlotType(EquipmentTypes.OFF_HAND));
            ++base;
        }
        this.finishInit(slots, base);
    }

    @Override
    public InventoryAdapter getAdapter(Fabric fabric, Inventory parent) {
        Container container;
        Optional carrier;
        if (this.isContainer && fabric instanceof Container && (carrier = ((CarriedInventory)(container = (Container)fabric)).getCarrier()).isPresent() && carrier.get() instanceof Player) {
            return (InventoryAdapter)((Object)((Player)carrier.get()).getInventory());
        }
        return fabric.fabric$get(this.base).bridge$getAdapter();
    }

    private void finishInit(SlotProvider slots, int base) {
        this.addSpanningChild(this.main, new InventoryProperty[0]);
        this.addSpanningChild(this.equipment, new InventoryProperty[0]);
        this.addSpanningChild(this.offhand, new InventoryProperty[0]);
        int additionalSlots = this.size - base;
        if (additionalSlots > 0) {
            this.addSpanningChild(new OrderedInventoryLensImpl(base, additionalSlots, slots), new InventoryProperty[0]);
        }
    }

    public MainPlayerInventoryLens getMainLens() {
        return this.main;
    }

    public EquipmentInventoryLens getEquipmentLens() {
        return this.equipment;
    }

    public SlotLens getOffhandLens() {
        return this.offhand;
    }
}

