/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Slot;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.AbstractInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.mixin.core.inventory.SlotAccessor;

public class DelegatingLens
extends AbstractLens {
    private Lens delegate;

    public DelegatingLens(int base, Lens lens, SlotProvider slots) {
        super(base, lens.slotCount(), AbstractInventoryAdapter.class);
        this.delegate = lens;
        this.init(slots);
    }

    public DelegatingLens(int base, List<Slot> containerSlots, Lens lens, SlotProvider slots) {
        super(base, containerSlots.size(), AbstractInventoryAdapter.class);
        this.delegate = lens;
        CustomSlotProvider slotProvider = new CustomSlotProvider();
        for (Slot slot : containerSlots) {
            slotProvider.add(slots.getSlot(((SlotAccessor)slot).accessor$getSlotNumber()));
        }
        this.addSpanningChild(new OrderedInventoryLensImpl(0, containerSlots.size(), slotProvider), new InventoryProperty[0]);
        this.addChild(this.delegate, new InventoryProperty[0]);
    }

    protected void init(SlotProvider slots) {
        this.addSpanningChild(new OrderedInventoryLensImpl(this.base, this.size, slots), new InventoryProperty[0]);
        this.addChild(this.delegate, new InventoryProperty[0]);
    }

    @Override
    public InventoryAdapter getAdapter(Fabric inv, Inventory parent) {
        return new AbstractInventoryAdapter(inv, this, parent);
    }

    public static class CustomSlotProvider
    implements SlotProvider {
        private List<SlotLens> lenses = new ArrayList<SlotLens>();

        public void add(SlotLens toAdd) {
            this.lenses.add(toAdd);
        }

        @Override
        public SlotLens getSlot(int index) {
            return this.lenses.get(index);
        }
    }
}

