/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject.plugin;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import org.slf4j.Logger;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetId;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelId;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.AsynchronousExecutor;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.scheduler.SynchronousExecutor;
import org.spongepowered.common.inject.InjectionPointProvider;
import org.spongepowered.common.inject.provider.ChannelBindingProvider;
import org.spongepowered.common.inject.provider.PluginAssetProvider;
import org.spongepowered.common.inject.provider.SpongeExecutorServiceProvider;
import org.spongepowered.common.inject.provider.config.PluginConfigurationModule;

public class PluginModule
extends AbstractModule {
    private final PluginContainer container;
    private final Class<?> pluginClass;

    public PluginModule(PluginContainer container, Class<?> pluginClass) {
        this.container = container;
        this.pluginClass = pluginClass;
    }

    @Override
    protected void configure() {
        this.bind(this.pluginClass).in(Scopes.SINGLETON);
        this.install(new InjectionPointProvider());
        this.bind(PluginContainer.class).toInstance(this.container);
        this.bind(Logger.class).toInstance(this.container.getLogger());
        this.bind(SpongeExecutorService.class).annotatedWith(SynchronousExecutor.class).toProvider(SpongeExecutorServiceProvider.Synchronous.class);
        this.bind(SpongeExecutorService.class).annotatedWith(AsynchronousExecutor.class).toProvider(SpongeExecutorServiceProvider.Asynchronous.class);
        this.bind(ChannelBinding.IndexedMessageChannel.class).annotatedWith(ChannelId.class).toProvider(ChannelBindingProvider.Indexed.class);
        this.bind(ChannelBinding.RawDataChannel.class).annotatedWith(ChannelId.class).toProvider(ChannelBindingProvider.Raw.class);
        this.bind(Asset.class).annotatedWith(AssetId.class).toProvider(PluginAssetProvider.class);
        this.install(new PluginConfigurationModule());
    }
}

