/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.player;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;

final class PlayerLogoutPhaseState
extends PooledPhaseState<GeneralizedContext>
implements IPhaseState<GeneralizedContext> {
    private final String desc = TrackingUtil.phaseStateToString("Player", this);

    PlayerLogoutPhaseState() {
    }

    @Override
    public GeneralizedContext createNewContext() {
        return (GeneralizedContext)new GeneralizedContext(this).addCaptures();
    }

    @Override
    public void unwind(GeneralizedContext phaseContext) {
        Player player = phaseContext.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing a player leaving, but we're not!", phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> SpongeCommonEventFactory.callDropItemDispense(items, phaseContext));
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {});
            phaseContext.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(items -> {
                List<Entity> drops = items.stream().map(drop -> drop.create((WorldServer)player.getWorld())).map(entity -> (Entity)entity).collect(Collectors.toList());
                SpongeCommonEventFactory.callDropItemCustom(drops, phaseContext);
            });
            TrackingUtil.processBlockCaptures(phaseContext);
        }
    }

    public String toString() {
        return this.desc;
    }
}

