/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;

public class ImmutableSpongeOptionalValue<E>
extends ImmutableSpongeValue<Optional<E>>
implements ImmutableOptionalValue<E> {
    public ImmutableSpongeOptionalValue(Key<? extends BaseValue<Optional<E>>> key) {
        super(key, Optional.empty());
    }

    public ImmutableSpongeOptionalValue(Key<? extends BaseValue<Optional<E>>> key, Optional<E> actualValue) {
        super(key, Optional.empty(), actualValue);
    }

    @Override
    public ImmutableOptionalValue<E> with(Optional<E> value) {
        return new ImmutableSpongeOptionalValue<E>(this.getKey(), (Optional)Preconditions.checkNotNull(value));
    }

    @Override
    public ImmutableOptionalValue<E> transform(Function<Optional<E>, Optional<E>> function) {
        return new ImmutableSpongeOptionalValue<E>(this.getKey(), (Optional)Preconditions.checkNotNull(function.apply((Optional<E>)this.get())));
    }

    @Override
    public OptionalValue<E> asMutable() {
        return new SpongeOptionalValue(this.getKey(), (Optional)this.actualValue);
    }

    @Override
    public ImmutableOptionalValue<E> instead(@Nullable E value) {
        return new ImmutableSpongeOptionalValue<E>(this.getKey(), Optional.ofNullable(value));
    }

    @Override
    public ImmutableValue<E> or(E value) {
        return new ImmutableSpongeValue<Object>(null, ((Optional)this.get()).isPresent() ? ((Optional)this.get()).get() : Preconditions.checkNotNull(value));
    }
}

