/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class VanishCollisionValueProcessor
extends AbstractSpongeValueProcessor<VanishableBridge, Boolean, Value<Boolean>> {
    public VanishCollisionValueProcessor() {
        super(VanishableBridge.class, Keys.VANISH_IGNORES_COLLISION);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.VANISH_IGNORES_COLLISION, false, actualValue);
    }

    @Override
    protected boolean set(VanishableBridge container, Boolean value) {
        if (container instanceof Entity && ((Entity)container).field_70170_p.field_72995_K) {
            return false;
        }
        if (!container.bridge$isVanished()) {
            return false;
        }
        container.bridge$setUncollideable(value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(VanishableBridge container) {
        return Optional.of(container.bridge$isUncollideable());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.VANISH_IGNORES_COLLISION, false, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

