/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityArmorStand;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.mixin.core.entity.item.EntityArmorStandAccessor;
import org.spongepowered.common.util.VecHelper;

public class BodyRotationsValueProcessor
extends AbstractSpongeValueProcessor<EntityArmorStand, Map<BodyPart, Vector3d>, MapValue<BodyPart, Vector3d>> {
    public BodyRotationsValueProcessor() {
        super(EntityArmorStand.class, Keys.BODY_ROTATIONS);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MapValue<BodyPart, Vector3d> constructValue(Map<BodyPart, Vector3d> actualValue) {
        return new SpongeMapValue<BodyPart, Vector3d>(Keys.BODY_ROTATIONS, actualValue);
    }

    @Override
    protected boolean set(EntityArmorStand container, Map<BodyPart, Vector3d> value) {
        container.func_175415_a(VecHelper.toRotation(value.get(BodyParts.HEAD)));
        container.func_175424_b(VecHelper.toRotation(value.get(BodyParts.CHEST)));
        container.func_175405_c(VecHelper.toRotation(value.get(BodyParts.LEFT_ARM)));
        container.func_175428_d(VecHelper.toRotation(value.get(BodyParts.RIGHT_ARM)));
        container.func_175417_e(VecHelper.toRotation(value.get(BodyParts.LEFT_LEG)));
        container.func_175427_f(VecHelper.toRotation(value.get(BodyParts.RIGHT_LEG)));
        return true;
    }

    @Override
    protected Optional<Map<BodyPart, Vector3d>> getVal(EntityArmorStand container) {
        HashMap values = Maps.newHashMap();
        values.put(BodyParts.HEAD, VecHelper.toVector3d(container.func_175418_s()));
        values.put(BodyParts.CHEST, VecHelper.toVector3d(container.func_175408_t()));
        values.put(BodyParts.LEFT_ARM, VecHelper.toVector3d(((EntityArmorStandAccessor)container).accessor$getleftArmRotation()));
        values.put(BodyParts.RIGHT_ARM, VecHelper.toVector3d(((EntityArmorStandAccessor)container).accessor$getrightArmRotation()));
        values.put(BodyParts.LEFT_LEG, VecHelper.toVector3d(((EntityArmorStandAccessor)container).accessor$getleftLegRotation()));
        values.put(BodyParts.RIGHT_LEG, VecHelper.toVector3d(((EntityArmorStandAccessor)container).accessor$getrightLegRotation()));
        return Optional.of(values);
    }

    @Override
    protected ImmutableValue<Map<BodyPart, Vector3d>> constructImmutableValue(Map<BodyPart, Vector3d> value) {
        return this.constructValue(value).asImmutable();
    }
}

