/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value;

import java.util.Optional;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.WeightedCollectionValue;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.processor.common.SpawnerUtils;
import org.spongepowered.common.data.value.mutable.SpongeWeightedCollectionValue;
import org.spongepowered.common.mixin.core.tileentity.MobSpawnerBaseLogicAccessor;
import org.spongepowered.common.mixin.core.tileentity.TileEntityMobSpawnerAccessor;

public class SpawnerEntitiesValueProcessor
extends AbstractSpongeValueProcessor<TileEntityMobSpawnerAccessor, WeightedTable<EntityArchetype>, WeightedCollectionValue<EntityArchetype>> {
    public SpawnerEntitiesValueProcessor() {
        super(TileEntityMobSpawnerAccessor.class, Keys.SPAWNER_ENTITIES);
    }

    @Override
    protected WeightedCollectionValue<EntityArchetype> constructValue(WeightedTable<EntityArchetype> actualValue) {
        return new SpongeWeightedCollectionValue<EntityArchetype>(this.key, actualValue);
    }

    @Override
    protected boolean set(TileEntityMobSpawnerAccessor container, WeightedTable<EntityArchetype> value) {
        MobSpawnerBaseLogicAccessor logic = (MobSpawnerBaseLogicAccessor)container.accessor$getSpawnerLogic();
        SpawnerUtils.setEntities(logic, value);
        SpawnerUtils.setNextEntity((MobSpawnerBaseLogic)logic, SpawnerUtils.getNextEntity(logic));
        return true;
    }

    @Override
    protected Optional<WeightedTable<EntityArchetype>> getVal(TileEntityMobSpawnerAccessor container) {
        return Optional.of(SpawnerUtils.getEntities(container.accessor$getSpawnerLogic()));
    }

    @Override
    protected ImmutableValue<WeightedTable<EntityArchetype>> constructImmutableValue(WeightedTable<EntityArchetype> value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

