/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableAuthorData;
import org.spongepowered.api.data.manipulator.mutable.item.AuthorData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeAuthorData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.text.SpongeTexts;

public class ItemAuthorDataProcessor
extends AbstractItemSingleDataProcessor<Text, Value<Text>, AuthorData, ImmutableAuthorData> {
    public ItemAuthorDataProcessor() {
        super((ItemStack input) -> input.func_77973_b() == Items.field_151099_bA || input.func_77973_b() == Items.field_151164_bB, Keys.BOOK_AUTHOR);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected AuthorData createManipulator() {
        return new SpongeAuthorData();
    }

    @Override
    protected boolean set(ItemStack itemStack, Text value) {
        itemStack.func_77983_a("author", (NBTBase)new NBTTagString(SpongeTexts.toLegacy(value)));
        return true;
    }

    @Override
    protected Optional<Text> getVal(ItemStack itemStack) {
        if (!itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("author")) {
            return Optional.empty();
        }
        String json = itemStack.func_77978_p().func_74779_i("author");
        Text author = TextSerializers.JSON.deserializeUnchecked(json);
        return Optional.of(author);
    }

    @Override
    protected Value<Text> constructValue(Text actualValue) {
        return new SpongeValue<Text>(Keys.BOOK_AUTHOR, Text.of(), actualValue);
    }

    @Override
    protected ImmutableValue<Text> constructImmutableValue(Text value) {
        return new ImmutableSpongeValue<Text>(Keys.BOOK_AUTHOR, Text.of(), value);
    }
}

