/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHealthScalingData;
import org.spongepowered.api.data.manipulator.mutable.entity.HealthScalingData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHealthScaleData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class HealthScalingProcessor
extends AbstractEntitySingleDataProcessor<EntityPlayerMP, Double, MutableBoundedValue<Double>, HealthScalingData, ImmutableHealthScalingData> {
    public HealthScalingProcessor() {
        super(EntityPlayerMP.class, Keys.HEALTH_SCALE);
    }

    @Override
    protected HealthScalingData createManipulator() {
        return new SpongeHealthScaleData();
    }

    @Override
    protected boolean set(EntityPlayerMP dataHolder, Double value) {
        if (value < 1.0) {
            return false;
        }
        if (value > 3.4028234663852886E38) {
            return false;
        }
        EntityPlayerMPBridge mixinPlayer = (EntityPlayerMPBridge)dataHolder;
        mixinPlayer.bridge$setHealthScale(value);
        return true;
    }

    @Override
    protected Optional<Double> getVal(EntityPlayerMP dataHolder) {
        EntityPlayerMPBridge mixinPlayer = (EntityPlayerMPBridge)dataHolder;
        return Optional.ofNullable(mixinPlayer.bridge$isHealthScaled() ? Double.valueOf(mixinPlayer.bridge$getHealthScale()) : null);
    }

    @Override
    protected ImmutableValue<Double> constructImmutableValue(Double value) {
        return SpongeValueFactory.boundedBuilder(Keys.HEALTH_SCALE).minimum(1.0).maximum(3.4028234663852886E38).defaultValue(20.0).actualValue(value).build().asImmutable();
    }

    @Override
    protected MutableBoundedValue<Double> constructValue(Double actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.HEALTH_SCALE).minimum(1.0).maximum(3.4028234663852886E38).defaultValue(20.0).actualValue(actualValue).build();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof EntityPlayerMPBridge)) {
            return DataTransactionResult.failNoData();
        }
        ImmutableValue<Double> current = this.constructImmutableValue(((EntityPlayerMPBridge)((Object)container)).bridge$getHealthScale());
        ((EntityPlayerMPBridge)((Object)container)).bridge$setHealthScale(20.0);
        return DataTransactionResult.successRemove(current);
    }
}

