/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.common.data.processor.common.AbstractSpongeDataProcessor;

public abstract class AbstractMultiDataProcessor<T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>>
extends AbstractSpongeDataProcessor<T, I> {
    protected abstract T createManipulator();

    @Override
    public Optional<T> createFrom(DataHolder dataHolder) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        Optional optional = this.from(dataHolder);
        if (!optional.isPresent()) {
            return Optional.of(this.createManipulator());
        }
        return optional;
    }

    @Override
    public Optional<T> fill(DataHolder dataHolder, T manipulator, MergeFunction overlap) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        DataManipulator merged = (DataManipulator)((MergeFunction)Preconditions.checkNotNull((Object)overlap)).merge(manipulator.copy(), this.from(dataHolder).orElse(null));
        merged.getValues().forEach(arg_0 -> manipulator.set(arg_0));
        return Optional.of(manipulator);
    }
}

