/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFallingBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.FallingBlockData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFallingBlockData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.util.Constants;

public class ImmutableSpongeFallingBlockData
extends AbstractImmutableData<ImmutableFallingBlockData, FallingBlockData>
implements ImmutableFallingBlockData {
    private final double fallDamagePerBlock;
    private final double maxFallDamage;
    private final BlockState blockState;
    private final boolean canPlaceAsBlock;
    private final boolean canDropAsItem;
    private final int fallTime;
    private boolean canHurtEntities;
    private final ImmutableSpongeValue<Double> fallDamagePerBlockValue;
    private final ImmutableSpongeValue<Double> maxFallDamageValue;
    private final ImmutableSpongeValue<BlockState> blockStateValue;
    private final ImmutableSpongeValue<Boolean> canPlaceAsBlockValue;
    private final ImmutableSpongeValue<Boolean> canDropAsItemValue;
    private final ImmutableSpongeValue<Integer> fallTimeValue;
    private final ImmutableSpongeValue<Boolean> canHurtEntitiesValue;

    public ImmutableSpongeFallingBlockData(double fallDamagePerBlock, double maxFallDamage, BlockState blockState, boolean canPlaceAsBlock, boolean canDropAsItem, int fallTime, boolean canHurtEntities) {
        super(ImmutableFallingBlockData.class);
        this.fallDamagePerBlock = fallDamagePerBlock;
        this.maxFallDamage = maxFallDamage;
        this.blockState = blockState;
        this.canPlaceAsBlock = canPlaceAsBlock;
        this.canDropAsItem = canDropAsItem;
        this.fallTime = fallTime;
        this.canHurtEntities = canHurtEntities;
        this.fallDamagePerBlockValue = new ImmutableSpongeValue<Double>(Keys.FALL_DAMAGE_PER_BLOCK, 2.0, this.fallDamagePerBlock);
        this.maxFallDamageValue = new ImmutableSpongeValue<Double>(Keys.MAX_FALL_DAMAGE, 40.0, this.maxFallDamage);
        this.blockStateValue = new ImmutableSpongeValue<BlockState>(Keys.FALLING_BLOCK_STATE, Constants.Catalog.DEFAULT_FALLING_BLOCK_BLOCKSTATE, this.blockState);
        this.canPlaceAsBlockValue = new ImmutableSpongeValue<Boolean>(Keys.CAN_PLACE_AS_BLOCK, false, this.canPlaceAsBlock);
        this.canDropAsItemValue = new ImmutableSpongeValue<Boolean>(Keys.CAN_DROP_AS_ITEM, true, this.canDropAsItem);
        this.fallTimeValue = new ImmutableSpongeValue<Integer>(Keys.FALL_TIME, 1, this.fallTime);
        this.canHurtEntitiesValue = new ImmutableSpongeValue<Boolean>(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, false, this.canHurtEntities);
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.FALL_DAMAGE_PER_BLOCK, this::getFallDamagePerBlock);
        this.registerKeyValue(Keys.FALL_DAMAGE_PER_BLOCK, this::fallDamagePerBlock);
        this.registerFieldGetter(Keys.MAX_FALL_DAMAGE, this::getMaxFallDamage);
        this.registerKeyValue(Keys.MAX_FALL_DAMAGE, this::maxFallDamage);
        this.registerFieldGetter(Keys.FALLING_BLOCK_STATE, this::getBlockState);
        this.registerKeyValue(Keys.FALLING_BLOCK_STATE, this::blockState);
        this.registerFieldGetter(Keys.CAN_PLACE_AS_BLOCK, this::getCanPlaceAsBlock);
        this.registerKeyValue(Keys.CAN_PLACE_AS_BLOCK, this::canPlaceAsBlock);
        this.registerFieldGetter(Keys.CAN_DROP_AS_ITEM, this::getCanDropAsItem);
        this.registerKeyValue(Keys.CAN_DROP_AS_ITEM, this::canDropAsItem);
        this.registerFieldGetter(Keys.FALL_TIME, this::getFallTime);
        this.registerKeyValue(Keys.FALL_TIME, this::fallTime);
        this.registerFieldGetter(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, this::getCanHurtEntities);
        this.registerKeyValue(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, this::canHurtEntities);
    }

    public double getFallDamagePerBlock() {
        return this.fallDamagePerBlock;
    }

    @Override
    public ImmutableValue<Double> fallDamagePerBlock() {
        return this.fallDamagePerBlockValue;
    }

    public double getMaxFallDamage() {
        return this.maxFallDamage;
    }

    @Override
    public ImmutableValue<Double> maxFallDamage() {
        return this.maxFallDamageValue;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public ImmutableValue<BlockState> blockState() {
        return this.blockStateValue;
    }

    public boolean getCanPlaceAsBlock() {
        return this.canPlaceAsBlock;
    }

    @Override
    public ImmutableValue<Boolean> canPlaceAsBlock() {
        return this.canPlaceAsBlockValue;
    }

    public boolean getCanDropAsItem() {
        return this.canDropAsItem;
    }

    @Override
    public ImmutableValue<Boolean> canDropAsItem() {
        return this.canDropAsItemValue;
    }

    public int getFallTime() {
        return this.fallTime;
    }

    @Override
    public ImmutableValue<Integer> fallTime() {
        return this.fallTimeValue;
    }

    public boolean getCanHurtEntities() {
        return this.canHurtEntities;
    }

    @Override
    public ImmutableValue<Boolean> canHurtEntities() {
        return this.canHurtEntitiesValue;
    }

    @Override
    public FallingBlockData asMutable() {
        return new SpongeFallingBlockData(this.fallDamagePerBlock, this.maxFallDamage, this.blockState, this.canPlaceAsBlock, this.canDropAsItem, this.fallTime, this.canHurtEntities);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FALL_DAMAGE_PER_BLOCK.getQuery(), (Object)this.fallDamagePerBlock).set(Keys.MAX_FALL_DAMAGE.getQuery(), (Object)this.maxFallDamage).set(Keys.FALLING_BLOCK_STATE.getQuery(), (Object)this.blockState).set(Keys.CAN_PLACE_AS_BLOCK.getQuery(), (Object)this.canPlaceAsBlock).set(Keys.CAN_DROP_AS_ITEM.getQuery(), (Object)this.canDropAsItem).set(Keys.FALL_TIME.getQuery(), (Object)this.fallTime).set(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, (Object)this.canHurtEntities);
    }
}

