/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.item;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.item.inventory.SpongeItemStackBuilder;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.util.Constants;

public class SpongeItemStackSnapshotBuilder
extends AbstractDataBuilder<ItemStackSnapshot>
implements DataBuilder<ItemStackSnapshot> {
    public SpongeItemStackSnapshotBuilder() {
        super(ItemStackSnapshot.class, 2);
    }

    @Override
    protected Optional<ItemStackSnapshot> buildContent(DataView container) throws InvalidDataException {
        if (container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
            NBTTagCompound compound;
            String itemString = DataUtil.getData(container, Constants.ItemStack.TYPE, String.class);
            ItemType itemType = SpongeImpl.getRegistry().getType(ItemType.class, itemString).get();
            if (itemType == ItemTypes.NONE) {
                return Optional.of(ItemTypeRegistryModule.getInstance().NONE_SNAPSHOT);
            }
            int count = DataUtil.getData(container, Constants.ItemStack.COUNT, Integer.class);
            int damage = container.getInt(Constants.ItemStack.DAMAGE_VALUE).orElse(0);
            ImmutableList<ImmutableDataManipulator<?, ?>> manipulators = container.contains(Constants.Sponge.DATA_MANIPULATORS) ? DataUtil.deserializeImmutableManipulatorList(container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get()) : ImmutableList.of();
            if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                compound = NbtTranslator.getInstance().translateData(container.getView(Constants.Sponge.UNSAFE_NBT).get());
                SpongeItemStackBuilder.fixEnchantmentData(itemType, compound);
            } else {
                compound = null;
            }
            return Optional.of(new SpongeItemStackSnapshot(itemType, count, damage, manipulators, compound));
        }
        return Optional.empty();
    }
}

