/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.channel.impl.DelegateMutableMessageChannel;
import org.spongepowered.api.text.channel.type.CombinedMessageChannel;
import org.spongepowered.api.text.channel.type.FixedMessageChannel;
import org.spongepowered.api.text.channel.type.PermissionMessageChannel;
import org.spongepowered.api.text.channel.type.WorldMessageChannel;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.world.World;

@FunctionalInterface
public interface MessageChannel {
    public static final MessageChannel TO_NONE = ImmutableSet::of;
    public static final MessageChannel TO_PLAYERS = () -> ImmutableSet.copyOf(Sponge.getGame().getServer().getOnlinePlayers());
    public static final MessageChannel TO_CONSOLE = () -> ImmutableSet.of((Object)Sponge.getGame().getServer().getConsole());
    public static final MessageChannel TO_ALL = () -> ImmutableSet.builder().addAll(Sponge.getGame().getServer().getOnlinePlayers()).add((Object)Sponge.getGame().getServer().getConsole()).build();

    public static MessageChannel permission(String permission) {
        return new PermissionMessageChannel(permission);
    }

    public static MessageChannel combined(MessageChannel ... channels) {
        return new CombinedMessageChannel(channels);
    }

    public static MessageChannel combined(Collection<MessageChannel> channels) {
        return new CombinedMessageChannel(channels);
    }

    public static MessageChannel fixed(MessageReceiver ... recipients) {
        return new FixedMessageChannel(recipients);
    }

    public static MessageChannel fixed(Collection<? extends MessageReceiver> recipients) {
        return new FixedMessageChannel(recipients);
    }

    public static MessageChannel world(World world) {
        return new WorldMessageChannel(world);
    }

    default public void send(Text original) {
        this.send(null, original);
    }

    default public void send(Text original, ChatType type) {
        this.send(null, original, type);
    }

    default public void send(@Nullable Object sender, Text original) {
        this.send(sender, original, ChatTypes.SYSTEM);
    }

    default public void send(@Nullable Object sender, Text original, ChatType type) {
        Preconditions.checkNotNull((Object)original, (Object)"original text");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        for (MessageReceiver member : this.getMembers()) {
            if (member instanceof ChatTypeMessageReceiver) {
                this.transformMessage(sender, member, original, type).ifPresent(text -> ((ChatTypeMessageReceiver)((Object)member)).sendMessage(type, (Text)text));
                continue;
            }
            this.transformMessage(sender, member, original, type).ifPresent(member::sendMessage);
        }
    }

    default public Optional<Text> transformMessage(@Nullable Object sender, MessageReceiver recipient, Text original, ChatType type) {
        return Optional.of(original);
    }

    public Collection<MessageReceiver> getMembers();

    default public MutableMessageChannel asMutable() {
        return new DelegateMutableMessageChannel(this);
    }
}

