/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.spongepowered.api.event.cause.entity.ModifierFunction;
import org.spongepowered.api.event.cause.entity.health.HealthFunction;
import org.spongepowered.api.event.cause.entity.health.HealthModifier;
import org.spongepowered.api.event.entity.HealEntityEvent;
import org.spongepowered.api.event.impl.AbstractModifierEvent;
import org.spongepowered.api.util.annotation.eventgen.UseField;

public abstract class AbstractHealEntityEvent
extends AbstractModifierEvent<HealthFunction, HealthModifier>
implements HealEntityEvent {
    @UseField
    protected double originalHealAmount;
    @UseField
    protected List<HealthFunction> originalFunctions;
    @UseField
    protected double baseHealAmount;

    @Override
    protected final void init() {
        this.originalFunctions = this.init(this.originalHealAmount, this.originalFunctions);
        this.baseHealAmount = this.originalHealAmount;
    }

    @Override
    public final double getOriginalHealingModifierAmount(HealthModifier healthModifier) {
        Preconditions.checkArgument((boolean)this.originalModifierMap.containsKey(Preconditions.checkNotNull((Object)healthModifier)), (Object)("The provided damage modifier is not applicable : " + healthModifier.toString()));
        return (Double)this.originalModifierMap.get(Preconditions.checkNotNull((Object)healthModifier));
    }

    @Override
    public final double getOriginalFinalHealAmount() {
        return this.originalFinalAmount;
    }

    @Override
    public final Map<HealthModifier, Double> getOriginalHealingAmounts() {
        return this.originalModifierMap;
    }

    @Override
    public final double getFinalHealAmount() {
        return this.getFinalAmount(this.baseHealAmount);
    }

    @Override
    public final boolean isModifierApplicable(HealthModifier healthModifier) {
        return this.modifiers.containsKey(Preconditions.checkNotNull((Object)healthModifier));
    }

    @Override
    public final double getHealAmount(HealthModifier healthModifier) {
        Preconditions.checkArgument((boolean)this.modifiers.containsKey(Preconditions.checkNotNull((Object)healthModifier)), (Object)("The provided damage modifier is not applicable : " + healthModifier.toString()));
        return (Double)this.modifiers.get(Preconditions.checkNotNull((Object)healthModifier));
    }

    @Override
    public final void setHealAmount(HealthModifier healthModifier, DoubleUnaryOperator function) {
        Preconditions.checkNotNull((Object)healthModifier, (Object)"Damage modifier was null!");
        Preconditions.checkNotNull((Object)function, (Object)"Function was null!");
        int indexToAddTo = 0;
        boolean addAtEnd = true;
        Iterator iterator = this.modifierFunctions.iterator();
        while (iterator.hasNext()) {
            ModifierFunction tuple = (ModifierFunction)iterator.next();
            if (((HealthModifier)tuple.getModifier()).equals(healthModifier)) {
                iterator.remove();
                addAtEnd = false;
                break;
            }
            ++indexToAddTo;
        }
        if (addAtEnd) {
            this.modifierFunctions.add(new HealthFunction(healthModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddTo, new HealthFunction(healthModifier, function));
        }
        this.recalculateDamages(this.baseHealAmount);
    }

    @Override
    public double getBaseHealAmount() {
        return this.baseHealAmount;
    }

    @Override
    public final void setBaseHealAmount(double baseHealAmount) {
        this.baseHealAmount = baseHealAmount;
        this.recalculateDamages(this.baseHealAmount);
    }

    @Override
    protected HealthFunction convertTuple(HealthModifier obj, DoubleUnaryOperator function) {
        return new HealthFunction(obj, function);
    }
}

