/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.LoggerFilterOutputStream;
import org.apache.logging.log4j.io.LoggerOutputStream;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerPrintStream
extends PrintStream {
    private static final String FQCN = LoggerPrintStream.class.getName();

    protected LoggerPrintStream(ExtendedLogger logger, boolean autoFlush, Charset charset, String fqcn, Level level, Marker marker) throws UnsupportedEncodingException {
        super((OutputStream)new LoggerOutputStream(logger, level, marker, LoggerPrintStream.ensureNonNull(charset), fqcn == null ? FQCN : fqcn), autoFlush, LoggerPrintStream.ensureNonNull(charset).name());
    }

    protected LoggerPrintStream(OutputStream out, boolean autoFlush, Charset charset, ExtendedLogger logger, String fqcn, Level level, Marker marker) throws UnsupportedEncodingException {
        super((OutputStream)new LoggerFilterOutputStream(out, LoggerPrintStream.ensureNonNull(charset), logger, fqcn == null ? FQCN : fqcn, level, marker), autoFlush, LoggerPrintStream.ensureNonNull(charset).name());
    }

    private static Charset ensureNonNull(Charset charset) {
        return charset == null ? Charset.defaultCharset() : charset;
    }

    @Override
    public LoggerPrintStream append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public LoggerPrintStream append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public LoggerPrintStream append(CharSequence csq, int start, int end) {
        super.append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public LoggerPrintStream format(Locale l, String format, Object ... args) {
        super.format(l, format, args);
        return this;
    }

    @Override
    public LoggerPrintStream format(String format, Object ... args) {
        super.format(format, args);
        return this;
    }

    @Override
    public void print(boolean b) {
        super.print(b);
    }

    @Override
    public void print(char c) {
        super.print(c);
    }

    @Override
    public void print(char[] s) {
        super.print(s);
    }

    @Override
    public void print(double d) {
        super.print(d);
    }

    @Override
    public void print(float f) {
        super.print(f);
    }

    @Override
    public void print(int i) {
        super.print(i);
    }

    @Override
    public void print(long l) {
        super.print(l);
    }

    @Override
    public void print(Object obj) {
        super.print(obj);
    }

    @Override
    public void print(String s) {
        super.print(s);
    }

    @Override
    public LoggerPrintStream printf(Locale l, String format, Object ... args) {
        super.printf(l, format, args);
        return this;
    }

    @Override
    public LoggerPrintStream printf(String format, Object ... args) {
        super.printf(format, args);
        return this;
    }

    @Override
    public void println() {
        super.println();
    }

    @Override
    public void println(boolean x) {
        super.println(x);
    }

    @Override
    public void println(char x) {
        super.println(x);
    }

    @Override
    public void println(char[] x) {
        super.println(x);
    }

    @Override
    public void println(double x) {
        super.println(x);
    }

    @Override
    public void println(float x) {
        super.println(x);
    }

    @Override
    public void println(int x) {
        super.println(x);
    }

    @Override
    public void println(long x) {
        super.println(x);
    }

    @Override
    public void println(Object x) {
        super.println(x);
    }

    @Override
    public void println(String x) {
        super.println(x);
    }

    public String toString() {
        return LoggerPrintStream.class.getSimpleName() + "{stream=" + this.out + '}';
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
    }

    @Override
    public void write(int b) {
        super.write(b);
    }
}

