/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.noise.module.combiner;

import com.flowpowered.noise.module.Module;

public abstract class Combiner
extends Module {
    protected final Module sourceA;
    protected final Module sourceB;

    public Combiner(Module sourceA, Module sourceB) {
        this.sourceA = sourceA;
        this.sourceB = sourceB;
    }

    public Module getSourceA() {
        return this.sourceA;
    }

    public Module getSourceB() {
        return this.sourceB;
    }

    public static abstract class Builder
    extends Module.Builder {
        protected Module sourceA;
        protected Module sourceB;

        public Module getSourceA() {
            return this.sourceA;
        }

        public Builder setSourceA(Module sourceA) {
            this.sourceA = sourceA;
            return this;
        }

        public Module getSourceB() {
            return this.sourceB;
        }

        public Builder setSourceB(Module sourceB) {
            this.sourceB = sourceB;
            return this;
        }

        public Builder setSources(Module sourceA, Module sourceB) {
            this.setSourceA(sourceA);
            this.setSourceB(sourceB);
            return this;
        }

        @Override
        protected void checkValues() throws IllegalStateException {
            if (this.sourceA == null) {
                throw new IllegalStateException("First source cannot be null");
            }
            if (this.sourceB == null) {
                throw new IllegalStateException("Second source cannot be null");
            }
        }

        @Override
        public abstract Combiner build() throws IllegalStateException;
    }
}

