"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.filter = exports.isEmpty = exports.ConfigurationMapper = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const toml_1 = require("@iarna/toml");
const param_case_1 = require("param-case");
const pascal_case_1 = require("pascal-case");
const snake_case_1 = require("snake-case");
class ConfigurationMapper {
    constructor(props) {
        this.props = props;
    }
    static withDefaults(props) {
        const { globalConfiguration, runnersConfiguration } = props;
        return new ConfigurationMapper({
            globalConfiguration: {
                concurrent: 10,
                checkInterval: 0,
                logFormat: "runner",
                logLevel: "info",
                ...globalConfiguration,
            },
            runnersConfiguration: runnersConfiguration.map((item) => {
                var _b, _c, _d, _e, _f, _g;
                return {
                    url: "https://gitlab.com",
                    limit: 10,
                    outputLimit: 52428800,
                    executor: "docker+machine",
                    environment: ["DOCKER_DRIVER=overlay2", "DOCKER_TLS_CERTDIR=/certs"],
                    ...item,
                    docker: {
                        tlsVerify: false,
                        image: "docker:19.03.5",
                        privileged: true,
                        capAdd: ["CAP_SYS_ADMIN"],
                        waitForServicesTimeout: 300,
                        disableCache: false,
                        volumes: ["/certs/client", "/cache"],
                        shmSize: 0,
                        ...item.docker,
                    },
                    machine: {
                        idleCount: 0,
                        idleTime: 300,
                        maxBuilds: 20,
                        machineDriver: "amazonec2",
                        machineName: "gitlab-runner-%s",
                        ...item.machine,
                        machineOptions: {
                            requestSpotInstance: true,
                            spotPrice: 0.03,
                            ...(_b = item.machine) === null || _b === void 0 ? void 0 : _b.machineOptions,
                        },
                        autoscaling: ((_d = (_c = item.machine) === null || _c === void 0 ? void 0 : _c.autoscaling) === null || _d === void 0 ? void 0 : _d.length) ? (_e = item.machine) === null || _e === void 0 ? void 0 : _e.autoscaling : [
                            {
                                periods: ["* * 7-22 * * mon-fri *"],
                                idleCount: 1,
                                idleTime: 1800,
                                timezone: "Etc/UTC",
                            },
                        ],
                    },
                    cache: ((_f = item.cache) === null || _f === void 0 ? void 0 : _f.s3) && Object.keys((_g = item.cache) === null || _g === void 0 ? void 0 : _g.s3).length
                        ? {
                            type: "s3",
                            shared: true,
                            ...item.cache,
                        }
                        : undefined,
                };
            }),
        });
    }
    static fromProps(props) {
        return new ConfigurationMapper(props);
    }
    toToml() {
        return toml_1.stringify(this._toJsonMap());
    }
    /**
     * @internal
     */
    _toJsonMap() {
        var _b, _c, _d, _e, _f, _g;
        const { globalConfiguration, runnersConfiguration } = this.props;
        const result = toJsonMap(globalConfiguration, snake_case_1.snakeCase);
        result.runners = [];
        for (const config of runnersConfiguration) {
            const runner = toJsonMap(config, snake_case_1.snakeCase);
            // Fix naming convention inconsistencies
            runner["tls-ca-file"] = runner.tls_ca_file;
            delete runner.tls_ca_file;
            runner["tls-cert-file"] = runner.tls_cert_file;
            delete runner.tls_ca_file;
            runner["tls-key-file"] = runner.tls_key_file;
            delete runner.tls_ca_file;
            if (config.docker) {
                runner.docker = toJsonMap(config.docker, snake_case_1.snakeCase);
            }
            runner.machine = toJsonMap(config.machine, pascal_case_1.pascalCase);
            if ((_b = config.machine) === null || _b === void 0 ? void 0 : _b.machineOptions) {
                runner.machine.MachineOptions = this._mapMachineOptions((_c = config.machine) === null || _c === void 0 ? void 0 : _c.machineOptions);
            }
            if ((_e = (_d = config.machine) === null || _d === void 0 ? void 0 : _d.autoscaling) === null || _e === void 0 ? void 0 : _e.length) {
                runner.machine.autoscaling = (_f = config.machine) === null || _f === void 0 ? void 0 : _f.autoscaling.map((autoscaling) => toJsonMap(autoscaling, pascal_case_1.pascalCase));
            }
            delete runner.machine.Autoscaling;
            if (((_g = config === null || config === void 0 ? void 0 : config.cache) === null || _g === void 0 ? void 0 : _g.s3) && Object.keys(config.cache.s3).length) {
                runner.cache = toJsonMap(config.cache, pascal_case_1.pascalCase);
                runner.cache.s3 = toJsonMap(config.cache.s3, pascal_case_1.pascalCase);
                delete runner.cache.s3;
            }
            else {
                delete runner.cache;
            }
            result.runners.push(runner);
        }
        return filter(result, (item) => !isEmpty(item));
    }
    _mapMachineOptions(machineOptions) {
        return toProperties(machineOptions, (key) => `amazonec2-${param_case_1.paramCase(key)}`);
    }
}
exports.ConfigurationMapper = ConfigurationMapper;
_a = JSII_RTTI_SYMBOL_1;
ConfigurationMapper[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.ConfigurationMapper", version: "0.1.8" };
/**
 * Transforms configuration objects to JsonMap. Pass an inflector function to transform object keys.
 *
 * @param configuration
 * @param inflector A function to transform the object key
 */
function toJsonMap(configuration, inflector) {
    const result = {};
    for (const key in configuration) {
        const value = configuration[key];
        if (value === undefined) {
            continue;
        }
        result[inflector(key)] = value;
    }
    return result;
}
/**
 * Transforms configuration objects to a property array. Pass an inflector function to transform object keys.
 *
 * @param configuration
 * @param inflector A function to transform the object key
 * @example
 * // returns ["foo=bar"]
 * toProperties({foo: "bar", (s) => s});
 */
function toProperties(configuration, inflector) {
    const result = [];
    for (const key in configuration) {
        const value = configuration[key];
        if (value === undefined) {
            continue;
        }
        result.push(`${inflector(key)}=${value}`);
    }
    return result;
}
function isEmpty(subject) {
    if (Array.isArray(subject)) {
        return !subject.length;
    }
    if (typeof subject === "object" && !(subject instanceof Date)) {
        return !Object.keys(subject).length;
    }
    if (subject === undefined) {
        return true;
    }
    if (subject === null) {
        return true;
    }
    return false;
}
exports.isEmpty = isEmpty;
function filter(subject, predicate) {
    if (Array.isArray(subject)) {
        const result = [];
        subject.forEach((element) => {
            const filtered = filter(element, predicate);
            if (predicate.call(subject, filtered)) {
                result.push(filtered);
            }
        });
        return result;
    }
    if (typeof subject === "object" && !(subject instanceof Date)) {
        const result = {};
        for (const key in subject) {
            const value = subject[key];
            const filtered = filter(value, predicate);
            if (predicate.call(subject, filtered)) {
                result[key] = filtered;
            }
        }
        return result;
    }
    return subject;
}
exports.filter = filter;
//# sourceMappingURL=data:application/json;base64,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