"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunction = void 0;
const util_1 = require("./util");
/**
 * Use an AWS Lambda function as an event rule target.
 */
class LambdaFunction {
    /**
     *
     */
    constructor(handler, props = {}) {
        this.handler = handler;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Lambda as a result from an EventBridge event.
     */
    bind(rule, _id) {
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, this.handler);
        return {
            id: '',
            arn: this.handler.functionArn,
            input: this.props.event,
            targetResource: this.handler,
        };
    }
}
exports.LambdaFunction = LambdaFunction;
//# sourceMappingURL=data:application/json;base64,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