# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-05-09 04:22
from __future__ import unicode_literals

from decimal import Decimal
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('epic', '0005_alter_datasheet_ds_file'),
    ]

    operations = [
        migrations.AddField(
            model_name='part',
            name='notes',
            field=models.TextField(blank=True),
        ),
        migrations.AlterField(
            model_name='assembly_item',
            name='assy',
            field=models.ForeignKey(help_text='The part number of the assembly this item belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='assembly_item_part', to='epic.Part', verbose_name='Assembly Part #'),
        ),
        migrations.AlterField(
            model_name='assembly_item',
            name='comp',
            field=models.ForeignKey(help_text='The part number of the component of this item.', on_delete=django.db.models.deletion.CASCADE, related_name='assembly_item_comp', to='epic.Part', verbose_name='Component Part #'),
        ),
        migrations.AlterField(
            model_name='assembly_item',
            name='qty',
            field=models.PositiveIntegerField(help_text='The quantity of this component required by the assembly.'),
        ),
        migrations.AlterField(
            model_name='assembly_item',
            name='refdes',
            field=models.TextField(blank=True, default='', help_text='A list of comma-separated reference designators e.g., "R101,R304". The length of this list should match Quantity.', verbose_name='Refdes List'),
        ),
        migrations.AlterField(
            model_name='datasheet',
            name='ds_file',
            field=models.FileField(upload_to='epic/datasheets', verbose_name='Datasheet File'),
        ),
        migrations.AlterField(
            model_name='datasheet',
            name='notes',
            field=models.CharField(blank=True, help_text='For misc. information that may be useful along with the datasheet, such as website retrieved from.', max_length=1024),
        ),
        migrations.AlterField(
            model_name='delta',
            name='adj',
            field=models.IntegerField(help_text='The amount by which the part quantity should be adjusted by.', verbose_name='Adjustment Count'),
        ),
        migrations.AlterField(
            model_name='delta',
            name='is_absolute',
            field=models.BooleanField(default=False, help_text='If set, the adjustment is absolute otherwise it is relative.', verbose_name='Absolute Adjustment'),
        ),
        migrations.AlterField(
            model_name='delta',
            name='part',
            field=models.ForeignKey(help_text='The part whose quantity gets adjusted.', on_delete=django.db.models.deletion.CASCADE, to='epic.Part', verbose_name='Part #'),
        ),
        migrations.AlterField(
            model_name='delta',
            name='txtn',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='epic.Transaction', verbose_name='Transaction #'),
        ),
        migrations.AlterField(
            model_name='line_item',
            name='index',
            field=models.PositiveIntegerField(help_text='Sequential and unchanging index of this line-item.'),
        ),
        migrations.AlterField(
            model_name='line_item',
            name='line_cost',
            field=models.DecimalField(decimal_places=2, help_text='The total cost of this line-item.  Part-cost is line-item cost divided by quantity.', max_digits=9, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))], verbose_name='Amount'),
        ),
        migrations.AlterField(
            model_name='line_item',
            name='part',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='epic.Part', verbose_name='Part #'),
        ),
        migrations.AlterField(
            model_name='line_item',
            name='qty',
            field=models.PositiveIntegerField(help_text='The quantity of this part.'),
        ),
        migrations.AlterField(
            model_name='line_item',
            name='txtn',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='epic.Transaction', verbose_name='Transaction #'),
        ),
        migrations.AlterField(
            model_name='order',
            name='expected_arrival_date',
            field=models.DateField(help_text='Date when the order is expected to arrive.', verbose_name='Expected Arrival Date'),
        ),
        migrations.AlterField(
            model_name='order',
            name='status',
            field=models.IntegerField(choices=[(0, 'open'), (1, 'closed')], default=0, verbose_name='Order Status'),
        ),
        migrations.AlterField(
            model_name='order',
            name='vendor',
            field=models.ForeignKey(help_text='The name of the vendor (distributor) where the order was placed.', on_delete=django.db.models.deletion.CASCADE, to='epic.Vendor'),
        ),
        migrations.AlterField(
            model_name='part',
            name='descr',
            field=models.CharField(blank=True, default='', help_text='Brief listing of key parameters of the part, such as temperature range, drift, max. voltages, etc.', max_length=127, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='part',
            name='footprint',
            field=models.CharField(blank=True, default='', help_text="The part's PCB footprint.", max_length=63),
        ),
        migrations.AlterField(
            model_name='part',
            name='last_bom_mod_name',
            field=models.CharField(blank=True, default='', help_text='Name of entity which last modified this part.', max_length=31),
        ),
        migrations.AlterField(
            model_name='part',
            name='last_bom_mod_type',
            field=models.IntegerField(choices=[(0, 'user'), (1, 'tool')], default=0),
        ),
        migrations.AlterField(
            model_name='part',
            name='lead_time',
            field=models.PositiveIntegerField(help_text='Lead-time in weeks.', verbose_name='Lead-time [weeks]'),
        ),
        migrations.AlterField(
            model_name='part',
            name='mfg',
            field=models.CharField(help_text='The name of the manufacturer of the part.', max_length=31, verbose_name='Manufacturer'),
        ),
        migrations.AlterField(
            model_name='part',
            name='mfg_pn',
            field=models.CharField(max_length=31, verbose_name="Manufacturer's Part #"),
        ),
        migrations.AlterField(
            model_name='part',
            name='mounting',
            field=models.IntegerField(choices=[(0, 'SMD'), (1, 'THD'), (2, 'chassis'), (3, 'free')], default=0, help_text="How the part is mounted to a PCB (free if it's not mounted at all, such as a plug).", verbose_name='Mounting Type'),
        ),
        migrations.AlterField(
            model_name='part',
            name='overage',
            field=models.DecimalField(decimal_places=3, help_text='Worst-case percentage of parts we expect to lose due to attrition at the assembly-house.', max_digits=6, validators=[django.core.validators.MinValueValidator(Decimal('0')), django.core.validators.MaxValueValidator(Decimal('100'))], verbose_name='Overage [%]'),
        ),
        migrations.AlterField(
            model_name='part',
            name='spq',
            field=models.IntegerField(default=1, help_text='The number of parts in a standard package.  For example, 10,000 pieces in a reel.', verbose_name='Standard-Package Qty'),
        ),
        migrations.AlterField(
            model_name='part',
            name='status',
            field=models.IntegerField(choices=[(0, 'preview'), (1, 'active'), (2, 'deprecated'), (3, 'obsolete')], default=0, help_text="The life-time status of this part. Parts marked `preview' and `obsolete' are not considered orderable.", verbose_name='Life-time Status'),
        ),
        migrations.AlterField(
            model_name='part',
            name='substitute',
            field=models.ForeignKey(blank=True, help_text='List of other parts that are (identical) substitutes for this part.', null=True, on_delete=django.db.models.deletion.CASCADE, to='epic.Part', verbose_name='Substitutes'),
        ),
        migrations.AlterField(
            model_name='part',
            name='target_price',
            field=models.DecimalField(decimal_places=6, help_text='The expected price of the part.', max_digits=10, validators=[django.core.validators.MinValueValidator(Decimal('0.000001'))], verbose_name='Target price [$]'),
        ),
        migrations.AlterField(
            model_name='part',
            name='val',
            field=models.CharField(blank=True, default='', help_text='The primary value of the part such as resistance for a resistor or capacitance for a capacitor.', max_length=31, verbose_name='Value'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='cost_discount',
            field=models.DecimalField(decimal_places=2, help_text='Discounts given by the shipper, such as early payment discount.', max_digits=9, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))], verbose_name='Discount Given'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='cost_freight',
            field=models.DecimalField(decimal_places=2, max_digits=9, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))], verbose_name='Freight Cost'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='cost_other',
            field=models.DecimalField(decimal_places=2, help_text='Other costs assessed by the shipper, such as handling costs.', max_digits=9, validators=[django.core.validators.MinValueValidator(Decimal('0.00'))], verbose_name='Other Costs'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='from_warehouse',
            field=models.ForeignKey(blank=True, help_text='For an inter-warehouse shipment, the warehouse the shipment originates from.', null=True, on_delete=django.db.models.deletion.CASCADE, to='epic.Warehouse'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='ordr',
            field=models.ForeignKey(blank=True, help_text='For an order shipment, the order that resulted in this shipment.', null=True, on_delete=django.db.models.deletion.CASCADE, to='epic.Order', verbose_name='Order #'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='tracking',
            field=models.CharField(blank=True, default='', help_text='Comma-separated list of tracking numbers.', max_length=127, verbose_name='Tracking #s'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='notes',
            field=models.TextField(blank=True, help_text='Comments and notes for this transaction', verbose_name='Notes'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='ts',
            field=models.DateTimeField(help_text='Date and time when this transaction was created.', verbose_name='Creation Time'),
        ),
        migrations.AlterField(
            model_name='transaction',
            name='warehouse',
            field=models.ForeignKey(help_text='The (destination) warehouse this transaction applies to.', on_delete=django.db.models.deletion.CASCADE, to='epic.Warehouse', verbose_name='Warehouse'),
        ),
        migrations.AlterField(
            model_name='vendor',
            name='name',
            field=models.CharField(db_index=True, max_length=31, unique=True, verbose_name='Vendor Name'),
        ),
        migrations.AlterField(
            model_name='vendor',
            name='search_url',
            field=models.CharField(blank=True, default='', help_text="This pattern defines how to search for a particular part on the vendor's website.  %(vendor_pn)s gets replaced by the vendor's part-number, %(mfg)s by the manufacturer's name, and %(mfg_pn)s by the manufacturer's part-number.", max_length=127, verbose_name='Search URL Pattern'),
        ),
        migrations.AlterField(
            model_name='vendor_part',
            name='part',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='epic.Part', verbose_name='Part #'),
        ),
        migrations.AlterField(
            model_name='vendor_part',
            name='status',
            field=models.IntegerField(choices=[(0, 'preview'), (1, 'active'), (2, 'deprecated'), (3, 'obsolete')], default=1, help_text='The life-time status of this vendor part.', verbose_name='Life-time Status'),
        ),
        migrations.AlterField(
            model_name='vendor_part',
            name='vendor_pn',
            field=models.CharField(max_length=31, verbose_name="Vendor's Part #"),
        ),
        migrations.AlterField(
            model_name='warehouse',
            name='address',
            field=models.TextField(blank=True, default='', help_text='The shipping address for the warehouse.'),
        ),
        migrations.AlterField(
            model_name='warehouse',
            name='name',
            field=models.CharField(help_text='The name of the warehouse.', max_length=31, unique=True),
        ),
    ]
