# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.voice.v1.dialing_permissions import DialingPermissionsList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Voice

        :returns: V1 version of Voice
        :rtype: twilio.rest.voice.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._dialing_permissions = None

    @property
    def dialing_permissions(self):
        """
        :rtype: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsList
        """
        if self._dialing_permissions is None:
            self._dialing_permissions = DialingPermissionsList(self)
        return self._dialing_permissions

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1>'
