# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TerminatingSipDomainList(ListResource):
    """  """

    def __init__(self, version, trunk_sid):
        """
        Initialize the TerminatingSipDomainList

        :param Version version: Version that contains the resource
        :param trunk_sid: The SID of the Trunk to which we should route calls

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainList
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainList
        """
        super(TerminatingSipDomainList, self).__init__(version)

        # Path Solution
        self._solution = {'trunk_sid': trunk_sid, }
        self._uri = '/Trunks/{trunk_sid}/TerminatingSipDomains'.format(**self._solution)

    def create(self, sip_domain_sid):
        """
        Create the TerminatingSipDomainInstance

        :param unicode sip_domain_sid: The SID of the SIP Domain to associate with the trunk

        :returns: The created TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        """
        data = values.of({'SipDomainSid': sip_domain_sid, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return TerminatingSipDomainInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def stream(self, limit=None, page_size=None):
        """
        Streams TerminatingSipDomainInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists TerminatingSipDomainInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of TerminatingSipDomainInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return TerminatingSipDomainPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of TerminatingSipDomainInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return TerminatingSipDomainPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a TerminatingSipDomainContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        """
        return TerminatingSipDomainContext(self._version, trunk_sid=self._solution['trunk_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a TerminatingSipDomainContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        """
        return TerminatingSipDomainContext(self._version, trunk_sid=self._solution['trunk_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trunking.V1.TerminatingSipDomainList>'


class TerminatingSipDomainPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the TerminatingSipDomainPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param trunk_sid: The SID of the Trunk to which we should route calls

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainPage
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainPage
        """
        super(TerminatingSipDomainPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TerminatingSipDomainInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        """
        return TerminatingSipDomainInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trunking.V1.TerminatingSipDomainPage>'


class TerminatingSipDomainContext(InstanceContext):
    """  """

    def __init__(self, version, trunk_sid, sid):
        """
        Initialize the TerminatingSipDomainContext

        :param Version version: Version that contains the resource
        :param trunk_sid: The SID of the Trunk with the resource to fetch
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        """
        super(TerminatingSipDomainContext, self).__init__(version)

        # Path Solution
        self._solution = {'trunk_sid': trunk_sid, 'sid': sid, }
        self._uri = '/Trunks/{trunk_sid}/TerminatingSipDomains/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the TerminatingSipDomainInstance

        :returns: The fetched TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return TerminatingSipDomainInstance(
            self._version,
            payload,
            trunk_sid=self._solution['trunk_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the TerminatingSipDomainInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trunking.V1.TerminatingSipDomainContext {}>'.format(context)


class TerminatingSipDomainInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, trunk_sid, sid=None):
        """
        Initialize the TerminatingSipDomainInstance

        :returns: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        """
        super(TerminatingSipDomainInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'api_version': payload.get('api_version'),
            'auth_type': payload.get('auth_type'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'domain_name': payload.get('domain_name'),
            'friendly_name': payload.get('friendly_name'),
            'sid': payload.get('sid'),
            'url': payload.get('url'),
            'voice_fallback_method': payload.get('voice_fallback_method'),
            'voice_fallback_url': payload.get('voice_fallback_url'),
            'voice_method': payload.get('voice_method'),
            'voice_status_callback_method': payload.get('voice_status_callback_method'),
            'voice_status_callback_url': payload.get('voice_status_callback_url'),
            'voice_url': payload.get('voice_url'),
            'sip_registration': payload.get('sip_registration'),
            'trunk_sid': payload.get('trunk_sid'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'trunk_sid': trunk_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: TerminatingSipDomainContext for this TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainContext
        """
        if self._context is None:
            self._context = TerminatingSipDomainContext(
                self._version,
                trunk_sid=self._solution['trunk_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def api_version(self):
        """
        :returns: The API version used to process the call
        :rtype: unicode
        """
        return self._properties['api_version']

    @property
    def auth_type(self):
        """
        :returns: The types of authentication mapped to the domain
        :rtype: unicode
        """
        return self._properties['auth_type']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def domain_name(self):
        """
        :returns: The unique address you reserve on Twilio to which you route your SIP traffic
        :rtype: unicode
        """
        return self._properties['domain_name']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def voice_fallback_method(self):
        """
        :returns: The HTTP method used with voice_fallback_url
        :rtype: unicode
        """
        return self._properties['voice_fallback_method']

    @property
    def voice_fallback_url(self):
        """
        :returns: The URL that we call when an error occurs in executing TwiML
        :rtype: unicode
        """
        return self._properties['voice_fallback_url']

    @property
    def voice_method(self):
        """
        :returns: The HTTP method used with voice_url
        :rtype: unicode
        """
        return self._properties['voice_method']

    @property
    def voice_status_callback_method(self):
        """
        :returns: The HTTP method that we use to call the voice_status_callback_url
        :rtype: unicode
        """
        return self._properties['voice_status_callback_method']

    @property
    def voice_status_callback_url(self):
        """
        :returns: The URL that we call to pass status parameters to your application
        :rtype: unicode
        """
        return self._properties['voice_status_callback_url']

    @property
    def voice_url(self):
        """
        :returns: The URL we call when the domain receives a call
        :rtype: unicode
        """
        return self._properties['voice_url']

    @property
    def sip_registration(self):
        """
        :returns: Whether SIP Endpoints can register with the domain to receive calls
        :rtype: bool
        """
        return self._properties['sip_registration']

    @property
    def trunk_sid(self):
        """
        :returns: The SID of the Trunk to which we should route calls
        :rtype: unicode
        """
        return self._properties['trunk_sid']

    @property
    def links(self):
        """
        :returns: The URLs of related resources
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the TerminatingSipDomainInstance

        :returns: The fetched TerminatingSipDomainInstance
        :rtype: twilio.rest.trunking.v1.trunk.terminating_sip_domain.TerminatingSipDomainInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the TerminatingSipDomainInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trunking.V1.TerminatingSipDomainInstance {}>'.format(context)
