# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class OriginationUrlList(ListResource):
    """  """

    def __init__(self, version, trunk_sid):
        """
        Initialize the OriginationUrlList

        :param Version version: Version that contains the resource
        :param trunk_sid: The SID of the Trunk that owns the Origination URL

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlList
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlList
        """
        super(OriginationUrlList, self).__init__(version)

        # Path Solution
        self._solution = {'trunk_sid': trunk_sid, }
        self._uri = '/Trunks/{trunk_sid}/OriginationUrls'.format(**self._solution)

    def create(self, weight, priority, enabled, friendly_name, sip_url):
        """
        Create the OriginationUrlInstance

        :param unicode weight: The value that determines the relative load the URI should receive compared to others with the same priority
        :param unicode priority: The relative importance of the URI
        :param bool enabled: Whether the URL is enabled
        :param unicode friendly_name: A string to describe the resource
        :param unicode sip_url: The SIP address you want Twilio to route your Origination calls to

        :returns: The created OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        data = values.of({
            'Weight': weight,
            'Priority': priority,
            'Enabled': enabled,
            'FriendlyName': friendly_name,
            'SipUrl': sip_url,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return OriginationUrlInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def stream(self, limit=None, page_size=None):
        """
        Streams OriginationUrlInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists OriginationUrlInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of OriginationUrlInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return OriginationUrlPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of OriginationUrlInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return OriginationUrlPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a OriginationUrlContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        """
        return OriginationUrlContext(self._version, trunk_sid=self._solution['trunk_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a OriginationUrlContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        """
        return OriginationUrlContext(self._version, trunk_sid=self._solution['trunk_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trunking.V1.OriginationUrlList>'


class OriginationUrlPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the OriginationUrlPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param trunk_sid: The SID of the Trunk that owns the Origination URL

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlPage
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlPage
        """
        super(OriginationUrlPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of OriginationUrlInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        return OriginationUrlInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trunking.V1.OriginationUrlPage>'


class OriginationUrlContext(InstanceContext):
    """  """

    def __init__(self, version, trunk_sid, sid):
        """
        Initialize the OriginationUrlContext

        :param Version version: Version that contains the resource
        :param trunk_sid: The SID of the Trunk from which to fetch the OriginationUrl
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        """
        super(OriginationUrlContext, self).__init__(version)

        # Path Solution
        self._solution = {'trunk_sid': trunk_sid, 'sid': sid, }
        self._uri = '/Trunks/{trunk_sid}/OriginationUrls/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the OriginationUrlInstance

        :returns: The fetched OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return OriginationUrlInstance(
            self._version,
            payload,
            trunk_sid=self._solution['trunk_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the OriginationUrlInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def update(self, weight=values.unset, priority=values.unset,
               enabled=values.unset, friendly_name=values.unset,
               sip_url=values.unset):
        """
        Update the OriginationUrlInstance

        :param unicode weight: The value that determines the relative load the URI should receive compared to others with the same priority
        :param unicode priority: The relative importance of the URI
        :param bool enabled: Whether the URL is enabled
        :param unicode friendly_name: A string to describe the resource
        :param unicode sip_url: The SIP address you want Twilio to route your Origination calls to

        :returns: The updated OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        data = values.of({
            'Weight': weight,
            'Priority': priority,
            'Enabled': enabled,
            'FriendlyName': friendly_name,
            'SipUrl': sip_url,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return OriginationUrlInstance(
            self._version,
            payload,
            trunk_sid=self._solution['trunk_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trunking.V1.OriginationUrlContext {}>'.format(context)


class OriginationUrlInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, trunk_sid, sid=None):
        """
        Initialize the OriginationUrlInstance

        :returns: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        super(OriginationUrlInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'sid': payload.get('sid'),
            'trunk_sid': payload.get('trunk_sid'),
            'weight': deserialize.integer(payload.get('weight')),
            'enabled': payload.get('enabled'),
            'sip_url': payload.get('sip_url'),
            'friendly_name': payload.get('friendly_name'),
            'priority': deserialize.integer(payload.get('priority')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'trunk_sid': trunk_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: OriginationUrlContext for this OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlContext
        """
        if self._context is None:
            self._context = OriginationUrlContext(
                self._version,
                trunk_sid=self._solution['trunk_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def trunk_sid(self):
        """
        :returns: The SID of the Trunk that owns the Origination URL
        :rtype: unicode
        """
        return self._properties['trunk_sid']

    @property
    def weight(self):
        """
        :returns: The value that determines the relative load the URI should receive compared to others with the same priority
        :rtype: unicode
        """
        return self._properties['weight']

    @property
    def enabled(self):
        """
        :returns: Whether the URL is enabled
        :rtype: bool
        """
        return self._properties['enabled']

    @property
    def sip_url(self):
        """
        :returns: The SIP address you want Twilio to route your Origination calls to
        :rtype: unicode
        """
        return self._properties['sip_url']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def priority(self):
        """
        :returns: The relative importance of the URI
        :rtype: unicode
        """
        return self._properties['priority']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the OriginationUrlInstance

        :returns: The fetched OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the OriginationUrlInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def update(self, weight=values.unset, priority=values.unset,
               enabled=values.unset, friendly_name=values.unset,
               sip_url=values.unset):
        """
        Update the OriginationUrlInstance

        :param unicode weight: The value that determines the relative load the URI should receive compared to others with the same priority
        :param unicode priority: The relative importance of the URI
        :param bool enabled: Whether the URL is enabled
        :param unicode friendly_name: A string to describe the resource
        :param unicode sip_url: The SIP address you want Twilio to route your Origination calls to

        :returns: The updated OriginationUrlInstance
        :rtype: twilio.rest.trunking.v1.trunk.origination_url.OriginationUrlInstance
        """
        return self._proxy.update(
            weight=weight,
            priority=priority,
            enabled=enabled,
            friendly_name=friendly_name,
            sip_url=sip_url,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trunking.V1.OriginationUrlInstance {}>'.format(context)
