# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.sync.v1.service.document import DocumentList
from twilio.rest.sync.v1.service.sync_list import SyncListList
from twilio.rest.sync.v1.service.sync_map import SyncMapList
from twilio.rest.sync.v1.service.sync_stream import SyncStreamList


class ServiceList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the ServiceList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.sync.v1.service.ServiceList
        :rtype: twilio.rest.sync.v1.service.ServiceList
        """
        super(ServiceList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Services'.format(**self._solution)

    def create(self, friendly_name=values.unset, webhook_url=values.unset,
               reachability_webhooks_enabled=values.unset, acl_enabled=values.unset,
               reachability_debouncing_enabled=values.unset,
               reachability_debouncing_window=values.unset,
               webhooks_from_rest_enabled=values.unset):
        """
        Create the ServiceInstance

        :param unicode friendly_name: A string that you assign to describe the resource
        :param unicode webhook_url: The URL we should call when Sync objects are manipulated
        :param bool reachability_webhooks_enabled: Whether the service instance should call webhook_url when client endpoints connect to Sync
        :param bool acl_enabled: Whether token identities in the Service must be granted access to Sync objects by using the Permissions resource
        :param bool reachability_debouncing_enabled: Whether every endpoint_disconnected event occurs after a configurable delay
        :param unicode reachability_debouncing_window: The reachability event delay in milliseconds
        :param bool webhooks_from_rest_enabled: Whether the Service instance should call webhook_url when the REST API is used to update Sync objects

        :returns: The created ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'WebhookUrl': webhook_url,
            'ReachabilityWebhooksEnabled': reachability_webhooks_enabled,
            'AclEnabled': acl_enabled,
            'ReachabilityDebouncingEnabled': reachability_debouncing_enabled,
            'ReachabilityDebouncingWindow': reachability_debouncing_window,
            'WebhooksFromRestEnabled': webhooks_from_rest_enabled,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ServiceInstance(self._version, payload, )

    def stream(self, limit=None, page_size=None):
        """
        Streams ServiceInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.sync.v1.service.ServiceInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ServiceInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.sync.v1.service.ServiceInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ServiceInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServicePage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ServicePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ServiceInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServicePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ServicePage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a ServiceContext

        :param sid: The SID of the Service resource to fetch

        :returns: twilio.rest.sync.v1.service.ServiceContext
        :rtype: twilio.rest.sync.v1.service.ServiceContext
        """
        return ServiceContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a ServiceContext

        :param sid: The SID of the Service resource to fetch

        :returns: twilio.rest.sync.v1.service.ServiceContext
        :rtype: twilio.rest.sync.v1.service.ServiceContext
        """
        return ServiceContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Sync.V1.ServiceList>'


class ServicePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the ServicePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.sync.v1.service.ServicePage
        :rtype: twilio.rest.sync.v1.service.ServicePage
        """
        super(ServicePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ServiceInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.sync.v1.service.ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        return ServiceInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Sync.V1.ServicePage>'


class ServiceContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, sid):
        """
        Initialize the ServiceContext

        :param Version version: Version that contains the resource
        :param sid: The SID of the Service resource to fetch

        :returns: twilio.rest.sync.v1.service.ServiceContext
        :rtype: twilio.rest.sync.v1.service.ServiceContext
        """
        super(ServiceContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Services/{sid}'.format(**self._solution)

        # Dependents
        self._documents = None
        self._sync_lists = None
        self._sync_maps = None
        self._sync_streams = None

    def fetch(self):
        """
        Fetch the ServiceInstance

        :returns: The fetched ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ServiceInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the ServiceInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def update(self, webhook_url=values.unset, friendly_name=values.unset,
               reachability_webhooks_enabled=values.unset, acl_enabled=values.unset,
               reachability_debouncing_enabled=values.unset,
               reachability_debouncing_window=values.unset,
               webhooks_from_rest_enabled=values.unset):
        """
        Update the ServiceInstance

        :param unicode webhook_url: The URL we should call when Sync objects are manipulated
        :param unicode friendly_name: A string that you assign to describe the resource
        :param bool reachability_webhooks_enabled: Whether the service instance should call webhook_url when client endpoints connect to Sync
        :param bool acl_enabled: Whether token identities in the Service must be granted access to Sync objects by using the Permissions resource
        :param bool reachability_debouncing_enabled: Whether every endpoint_disconnected event occurs after a configurable delay
        :param unicode reachability_debouncing_window: The reachability event delay in milliseconds
        :param bool webhooks_from_rest_enabled: Whether the Service instance should call webhook_url when the REST API is used to update Sync objects

        :returns: The updated ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        data = values.of({
            'WebhookUrl': webhook_url,
            'FriendlyName': friendly_name,
            'ReachabilityWebhooksEnabled': reachability_webhooks_enabled,
            'AclEnabled': acl_enabled,
            'ReachabilityDebouncingEnabled': reachability_debouncing_enabled,
            'ReachabilityDebouncingWindow': reachability_debouncing_window,
            'WebhooksFromRestEnabled': webhooks_from_rest_enabled,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return ServiceInstance(self._version, payload, sid=self._solution['sid'], )

    @property
    def documents(self):
        """
        Access the documents

        :returns: twilio.rest.sync.v1.service.document.DocumentList
        :rtype: twilio.rest.sync.v1.service.document.DocumentList
        """
        if self._documents is None:
            self._documents = DocumentList(self._version, service_sid=self._solution['sid'], )
        return self._documents

    @property
    def sync_lists(self):
        """
        Access the sync_lists

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListList
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListList
        """
        if self._sync_lists is None:
            self._sync_lists = SyncListList(self._version, service_sid=self._solution['sid'], )
        return self._sync_lists

    @property
    def sync_maps(self):
        """
        Access the sync_maps

        :returns: twilio.rest.sync.v1.service.sync_map.SyncMapList
        :rtype: twilio.rest.sync.v1.service.sync_map.SyncMapList
        """
        if self._sync_maps is None:
            self._sync_maps = SyncMapList(self._version, service_sid=self._solution['sid'], )
        return self._sync_maps

    @property
    def sync_streams(self):
        """
        Access the sync_streams

        :returns: twilio.rest.sync.v1.service.sync_stream.SyncStreamList
        :rtype: twilio.rest.sync.v1.service.sync_stream.SyncStreamList
        """
        if self._sync_streams is None:
            self._sync_streams = SyncStreamList(self._version, service_sid=self._solution['sid'], )
        return self._sync_streams

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Sync.V1.ServiceContext {}>'.format(context)


class ServiceInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, sid=None):
        """
        Initialize the ServiceInstance

        :returns: twilio.rest.sync.v1.service.ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        super(ServiceInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'unique_name': payload.get('unique_name'),
            'account_sid': payload.get('account_sid'),
            'friendly_name': payload.get('friendly_name'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
            'webhook_url': payload.get('webhook_url'),
            'webhooks_from_rest_enabled': payload.get('webhooks_from_rest_enabled'),
            'reachability_webhooks_enabled': payload.get('reachability_webhooks_enabled'),
            'acl_enabled': payload.get('acl_enabled'),
            'reachability_debouncing_enabled': payload.get('reachability_debouncing_enabled'),
            'reachability_debouncing_window': deserialize.integer(payload.get('reachability_debouncing_window')),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ServiceContext for this ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceContext
        """
        if self._context is None:
            self._context = ServiceContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def unique_name(self):
        """
        :returns: An application-defined string that uniquely identifies the resource
        :rtype: unicode
        """
        return self._properties['unique_name']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Service resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def webhook_url(self):
        """
        :returns: The URL we call when Sync objects are manipulated
        :rtype: unicode
        """
        return self._properties['webhook_url']

    @property
    def webhooks_from_rest_enabled(self):
        """
        :returns: Whether the Service instance should call webhook_url when the REST API is used to update Sync objects
        :rtype: bool
        """
        return self._properties['webhooks_from_rest_enabled']

    @property
    def reachability_webhooks_enabled(self):
        """
        :returns: Whether the service instance calls webhook_url when client endpoints connect to Sync
        :rtype: bool
        """
        return self._properties['reachability_webhooks_enabled']

    @property
    def acl_enabled(self):
        """
        :returns: Whether token identities in the Service must be granted access to Sync objects by using the Permissions resource
        :rtype: bool
        """
        return self._properties['acl_enabled']

    @property
    def reachability_debouncing_enabled(self):
        """
        :returns: Whether every endpoint_disconnected event occurs after a configurable delay
        :rtype: bool
        """
        return self._properties['reachability_debouncing_enabled']

    @property
    def reachability_debouncing_window(self):
        """
        :returns: The reachability event delay in milliseconds
        :rtype: unicode
        """
        return self._properties['reachability_debouncing_window']

    @property
    def links(self):
        """
        :returns: The URLs of related resources
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the ServiceInstance

        :returns: The fetched ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the ServiceInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def update(self, webhook_url=values.unset, friendly_name=values.unset,
               reachability_webhooks_enabled=values.unset, acl_enabled=values.unset,
               reachability_debouncing_enabled=values.unset,
               reachability_debouncing_window=values.unset,
               webhooks_from_rest_enabled=values.unset):
        """
        Update the ServiceInstance

        :param unicode webhook_url: The URL we should call when Sync objects are manipulated
        :param unicode friendly_name: A string that you assign to describe the resource
        :param bool reachability_webhooks_enabled: Whether the service instance should call webhook_url when client endpoints connect to Sync
        :param bool acl_enabled: Whether token identities in the Service must be granted access to Sync objects by using the Permissions resource
        :param bool reachability_debouncing_enabled: Whether every endpoint_disconnected event occurs after a configurable delay
        :param unicode reachability_debouncing_window: The reachability event delay in milliseconds
        :param bool webhooks_from_rest_enabled: Whether the Service instance should call webhook_url when the REST API is used to update Sync objects

        :returns: The updated ServiceInstance
        :rtype: twilio.rest.sync.v1.service.ServiceInstance
        """
        return self._proxy.update(
            webhook_url=webhook_url,
            friendly_name=friendly_name,
            reachability_webhooks_enabled=reachability_webhooks_enabled,
            acl_enabled=acl_enabled,
            reachability_debouncing_enabled=reachability_debouncing_enabled,
            reachability_debouncing_window=reachability_debouncing_window,
            webhooks_from_rest_enabled=webhooks_from_rest_enabled,
        )

    @property
    def documents(self):
        """
        Access the documents

        :returns: twilio.rest.sync.v1.service.document.DocumentList
        :rtype: twilio.rest.sync.v1.service.document.DocumentList
        """
        return self._proxy.documents

    @property
    def sync_lists(self):
        """
        Access the sync_lists

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListList
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListList
        """
        return self._proxy.sync_lists

    @property
    def sync_maps(self):
        """
        Access the sync_maps

        :returns: twilio.rest.sync.v1.service.sync_map.SyncMapList
        :rtype: twilio.rest.sync.v1.service.sync_map.SyncMapList
        """
        return self._proxy.sync_maps

    @property
    def sync_streams(self):
        """
        Access the sync_streams

        :returns: twilio.rest.sync.v1.service.sync_stream.SyncStreamList
        :rtype: twilio.rest.sync.v1.service.sync_stream.SyncStreamList
        """
        return self._proxy.sync_streams

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Sync.V1.ServiceInstance {}>'.format(context)
