# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class MetricList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, call_sid):
        """
        Initialize the MetricList

        :param Version version: Version that contains the resource
        :param call_sid: The call_sid

        :returns: twilio.rest.insights.v1.call.metric.MetricList
        :rtype: twilio.rest.insights.v1.call.metric.MetricList
        """
        super(MetricList, self).__init__(version)

        # Path Solution
        self._solution = {'call_sid': call_sid, }
        self._uri = '/Voice/{call_sid}/Metrics'.format(**self._solution)

    def stream(self, edge=values.unset, direction=values.unset, limit=None,
               page_size=None):
        """
        Streams MetricInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param MetricInstance.TwilioEdge edge: The edge
        :param MetricInstance.StreamDirection direction: The direction
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.insights.v1.call.metric.MetricInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(edge=edge, direction=direction, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, edge=values.unset, direction=values.unset, limit=None,
             page_size=None):
        """
        Lists MetricInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param MetricInstance.TwilioEdge edge: The edge
        :param MetricInstance.StreamDirection direction: The direction
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.insights.v1.call.metric.MetricInstance]
        """
        return list(self.stream(edge=edge, direction=direction, limit=limit, page_size=page_size, ))

    def page(self, edge=values.unset, direction=values.unset,
             page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of MetricInstance records from the API.
        Request is executed immediately

        :param MetricInstance.TwilioEdge edge: The edge
        :param MetricInstance.StreamDirection direction: The direction
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of MetricInstance
        :rtype: twilio.rest.insights.v1.call.metric.MetricPage
        """
        data = values.of({
            'Edge': edge,
            'Direction': direction,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return MetricPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of MetricInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of MetricInstance
        :rtype: twilio.rest.insights.v1.call.metric.MetricPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return MetricPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.MetricList>'


class MetricPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the MetricPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param call_sid: The call_sid

        :returns: twilio.rest.insights.v1.call.metric.MetricPage
        :rtype: twilio.rest.insights.v1.call.metric.MetricPage
        """
        super(MetricPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of MetricInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.insights.v1.call.metric.MetricInstance
        :rtype: twilio.rest.insights.v1.call.metric.MetricInstance
        """
        return MetricInstance(self._version, payload, call_sid=self._solution['call_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.MetricPage>'


class MetricInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    class TwilioEdge(object):
        UNKNOWN_EDGE = "unknown_edge"
        CARRIER_EDGE = "carrier_edge"
        SIP_EDGE = "sip_edge"
        SDK_EDGE = "sdk_edge"
        CLIENT_EDGE = "client_edge"

    class StreamDirection(object):
        UNKNOWN = "unknown"
        INBOUND = "inbound"
        OUTBOUND = "outbound"
        BOTH = "both"

    def __init__(self, version, payload, call_sid):
        """
        Initialize the MetricInstance

        :returns: twilio.rest.insights.v1.call.metric.MetricInstance
        :rtype: twilio.rest.insights.v1.call.metric.MetricInstance
        """
        super(MetricInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'timestamp': payload.get('timestamp'),
            'call_sid': payload.get('call_sid'),
            'account_sid': payload.get('account_sid'),
            'edge': payload.get('edge'),
            'direction': payload.get('direction'),
            'carrier_edge': payload.get('carrier_edge'),
            'sip_edge': payload.get('sip_edge'),
            'sdk_edge': payload.get('sdk_edge'),
            'client_edge': payload.get('client_edge'),
        }

        # Context
        self._context = None
        self._solution = {'call_sid': call_sid, }

    @property
    def timestamp(self):
        """
        :returns: The timestamp
        :rtype: unicode
        """
        return self._properties['timestamp']

    @property
    def call_sid(self):
        """
        :returns: The call_sid
        :rtype: unicode
        """
        return self._properties['call_sid']

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def edge(self):
        """
        :returns: The edge
        :rtype: MetricInstance.TwilioEdge
        """
        return self._properties['edge']

    @property
    def direction(self):
        """
        :returns: The direction
        :rtype: MetricInstance.StreamDirection
        """
        return self._properties['direction']

    @property
    def carrier_edge(self):
        """
        :returns: The carrier_edge
        :rtype: dict
        """
        return self._properties['carrier_edge']

    @property
    def sip_edge(self):
        """
        :returns: The sip_edge
        :rtype: dict
        """
        return self._properties['sip_edge']

    @property
    def sdk_edge(self):
        """
        :returns: The sdk_edge
        :rtype: dict
        """
        return self._properties['sdk_edge']

    @property
    def client_edge(self):
        """
        :returns: The client_edge
        :rtype: dict
        """
        return self._properties['client_edge']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.MetricInstance>'
