# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class FieldValueList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, field_type_sid):
        """
        Initialize the FieldValueList

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the FieldType associated with the resource
        :param field_type_sid: The SID of the Field Type associated with the Field Value

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueList
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueList
        """
        super(FieldValueList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'field_type_sid': field_type_sid, }
        self._uri = '/Assistants/{assistant_sid}/FieldTypes/{field_type_sid}/FieldValues'.format(**self._solution)

    def stream(self, language=values.unset, limit=None, page_size=None):
        """
        Streams FieldValueInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode language: The ISO language-country tag that identifies the language of the value
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(language=language, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, language=values.unset, limit=None, page_size=None):
        """
        Lists FieldValueInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode language: The ISO language-country tag that identifies the language of the value
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance]
        """
        return list(self.stream(language=language, limit=limit, page_size=page_size, ))

    def page(self, language=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of FieldValueInstance records from the API.
        Request is executed immediately

        :param unicode language: The ISO language-country tag that identifies the language of the value
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValuePage
        """
        data = values.of({
            'Language': language,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return FieldValuePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of FieldValueInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValuePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return FieldValuePage(self._version, response, self._solution)

    def create(self, language, value, synonym_of=values.unset):
        """
        Create the FieldValueInstance

        :param unicode language: The ISO language-country tag that identifies the language of the value
        :param unicode value: The Field Value data
        :param unicode synonym_of: The string value that indicates which word the field value is a synonym of

        :returns: The created FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        """
        data = values.of({'Language': language, 'Value': value, 'SynonymOf': synonym_of, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return FieldValueInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            field_type_sid=self._solution['field_type_sid'],
        )

    def get(self, sid):
        """
        Constructs a FieldValueContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        """
        return FieldValueContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            field_type_sid=self._solution['field_type_sid'],
            sid=sid,
        )

    def __call__(self, sid):
        """
        Constructs a FieldValueContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        """
        return FieldValueContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            field_type_sid=self._solution['field_type_sid'],
            sid=sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.FieldValueList>'


class FieldValuePage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the FieldValuePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The SID of the Assistant that is the parent of the FieldType associated with the resource
        :param field_type_sid: The SID of the Field Type associated with the Field Value

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValuePage
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValuePage
        """
        super(FieldValuePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of FieldValueInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        """
        return FieldValueInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            field_type_sid=self._solution['field_type_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.FieldValuePage>'


class FieldValueContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, field_type_sid, sid):
        """
        Initialize the FieldValueContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the FieldType associated with the resource to fetch
        :param field_type_sid: The SID of the Field Type associated with  the Field Value to fetch
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        """
        super(FieldValueContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'field_type_sid': field_type_sid, 'sid': sid, }
        self._uri = '/Assistants/{assistant_sid}/FieldTypes/{field_type_sid}/FieldValues/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the FieldValueInstance

        :returns: The fetched FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return FieldValueInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            field_type_sid=self._solution['field_type_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the FieldValueInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.FieldValueContext {}>'.format(context)


class FieldValueInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid, field_type_sid, sid=None):
        """
        Initialize the FieldValueInstance

        :returns: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        """
        super(FieldValueInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'field_type_sid': payload.get('field_type_sid'),
            'language': payload.get('language'),
            'assistant_sid': payload.get('assistant_sid'),
            'sid': payload.get('sid'),
            'value': payload.get('value'),
            'url': payload.get('url'),
            'synonym_of': payload.get('synonym_of'),
        }

        # Context
        self._context = None
        self._solution = {
            'assistant_sid': assistant_sid,
            'field_type_sid': field_type_sid,
            'sid': sid or self._properties['sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: FieldValueContext for this FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueContext
        """
        if self._context is None:
            self._context = FieldValueContext(
                self._version,
                assistant_sid=self._solution['assistant_sid'],
                field_type_sid=self._solution['field_type_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def field_type_sid(self):
        """
        :returns: The SID of the Field Type associated with the Field Value
        :rtype: unicode
        """
        return self._properties['field_type_sid']

    @property
    def language(self):
        """
        :returns: The ISO language-country tag that identifies the language of the value
        :rtype: unicode
        """
        return self._properties['language']

    @property
    def assistant_sid(self):
        """
        :returns: The SID of the Assistant that is the parent of the FieldType associated with the resource
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def value(self):
        """
        :returns: The Field Value data
        :rtype: unicode
        """
        return self._properties['value']

    @property
    def url(self):
        """
        :returns: The absolute URL of the FieldValue resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def synonym_of(self):
        """
        :returns: The word for which the field value is a synonym of
        :rtype: unicode
        """
        return self._properties['synonym_of']

    def fetch(self):
        """
        Fetch the FieldValueInstance

        :returns: The fetched FieldValueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.field_type.field_value.FieldValueInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the FieldValueInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.FieldValueInstance {}>'.format(context)
