# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ExportAssistantList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the ExportAssistantList

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant to export.

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantList
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantList
        """
        super(ExportAssistantList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }

    def get(self):
        """
        Constructs a ExportAssistantContext

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        """
        return ExportAssistantContext(self._version, assistant_sid=self._solution['assistant_sid'], )

    def __call__(self):
        """
        Constructs a ExportAssistantContext

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        """
        return ExportAssistantContext(self._version, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.ExportAssistantList>'


class ExportAssistantPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ExportAssistantPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The SID of the Assistant to export.

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantPage
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantPage
        """
        super(ExportAssistantPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ExportAssistantInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantInstance
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantInstance
        """
        return ExportAssistantInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.ExportAssistantPage>'


class ExportAssistantContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the ExportAssistantContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant to export.

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        """
        super(ExportAssistantContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }
        self._uri = '/Assistants/{assistant_sid}/Export'.format(**self._solution)

    def fetch(self):
        """
        Fetch the ExportAssistantInstance

        :returns: The fetched ExportAssistantInstance
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ExportAssistantInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.ExportAssistantContext {}>'.format(context)


class ExportAssistantInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    class Status(object):
        COMPLETED = "completed"
        FAILED = "failed"

    def __init__(self, version, payload, assistant_sid):
        """
        Initialize the ExportAssistantInstance

        :returns: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantInstance
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantInstance
        """
        super(ExportAssistantInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assistant_sid': payload.get('assistant_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'status': payload.get('status'),
            'error_code': deserialize.integer(payload.get('error_code')),
            'url': payload.get('url'),
            'schema': payload.get('schema'),
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ExportAssistantContext for this ExportAssistantInstance
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantContext
        """
        if self._context is None:
            self._context = ExportAssistantContext(self._version, assistant_sid=self._solution['assistant_sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The SID of the Assistant to export.
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def status(self):
        """
        :returns: The status of the export
        :rtype: ExportAssistantInstance.Status
        """
        return self._properties['status']

    @property
    def error_code(self):
        """
        :returns: More information about why the export failed, if `status` is `failed`
        :rtype: unicode
        """
        return self._properties['error_code']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Export resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def schema(self):
        """
        :returns: The JSON string that describes the requested Assistant.
        :rtype: dict
        """
        return self._properties['schema']

    def fetch(self):
        """
        Fetch the ExportAssistantInstance

        :returns: The fetched ExportAssistantInstance
        :rtype: twilio.rest.autopilot.v1.assistant.export_assistant.ExportAssistantInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.ExportAssistantInstance {}>'.format(context)
