# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.authy.v1.service.entity import EntityList


class ServiceList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the ServiceList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.authy.v1.service.ServiceList
        :rtype: twilio.rest.authy.v1.service.ServiceList
        """
        super(ServiceList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Services'.format(**self._solution)

    def create(self, friendly_name, push=values.unset,
               twilio_authy_sandbox_mode=values.unset):
        """
        Create the ServiceInstance

        :param unicode friendly_name: A human readable description of this resource.
        :param unicode push: Optional service level push factors configuration
        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: The created ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        data = values.of({'FriendlyName': friendly_name, 'Push': push, })
        headers = values.of({'Twilio-Authy-Sandbox-Mode': twilio_authy_sandbox_mode, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, headers=headers, )

        return ServiceInstance(self._version, payload, )

    def stream(self, twilio_authy_sandbox_mode=values.unset, limit=None,
               page_size=None):
        """
        Streams ServiceInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.authy.v1.service.ServiceInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(twilio_authy_sandbox_mode=twilio_authy_sandbox_mode, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, twilio_authy_sandbox_mode=values.unset, limit=None,
             page_size=None):
        """
        Lists ServiceInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.authy.v1.service.ServiceInstance]
        """
        return list(self.stream(
            twilio_authy_sandbox_mode=twilio_authy_sandbox_mode,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, twilio_authy_sandbox_mode=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of ServiceInstance records from the API.
        Request is executed immediately

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServicePage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })
        headers = values.of({'Twilio-Authy-Sandbox-Mode': twilio_authy_sandbox_mode, })

        response = self._version.page(method='GET', uri=self._uri, params=data, headers=headers, )

        return ServicePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ServiceInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServicePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ServicePage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a ServiceContext

        :param sid: A string that uniquely identifies this Service.

        :returns: twilio.rest.authy.v1.service.ServiceContext
        :rtype: twilio.rest.authy.v1.service.ServiceContext
        """
        return ServiceContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a ServiceContext

        :param sid: A string that uniquely identifies this Service.

        :returns: twilio.rest.authy.v1.service.ServiceContext
        :rtype: twilio.rest.authy.v1.service.ServiceContext
        """
        return ServiceContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Authy.V1.ServiceList>'


class ServicePage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ServicePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.authy.v1.service.ServicePage
        :rtype: twilio.rest.authy.v1.service.ServicePage
        """
        super(ServicePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ServiceInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.authy.v1.service.ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        return ServiceInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Authy.V1.ServicePage>'


class ServiceContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, sid):
        """
        Initialize the ServiceContext

        :param Version version: Version that contains the resource
        :param sid: A string that uniquely identifies this Service.

        :returns: twilio.rest.authy.v1.service.ServiceContext
        :rtype: twilio.rest.authy.v1.service.ServiceContext
        """
        super(ServiceContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Services/{sid}'.format(**self._solution)

        # Dependents
        self._entities = None

    def delete(self, twilio_authy_sandbox_mode=values.unset):
        """
        Deletes the ServiceInstance

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        headers = values.of({'Twilio-Authy-Sandbox-Mode': twilio_authy_sandbox_mode, })

        return self._version.delete(method='DELETE', uri=self._uri, headers=headers, )

    def fetch(self, twilio_authy_sandbox_mode=values.unset):
        """
        Fetch the ServiceInstance

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: The fetched ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        headers = values.of({'Twilio-Authy-Sandbox-Mode': twilio_authy_sandbox_mode, })

        payload = self._version.fetch(method='GET', uri=self._uri, headers=headers, )

        return ServiceInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, friendly_name=values.unset,
               twilio_authy_sandbox_mode=values.unset):
        """
        Update the ServiceInstance

        :param unicode friendly_name: A human readable description of this resource.
        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: The updated ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        data = values.of({'FriendlyName': friendly_name, })
        headers = values.of({'Twilio-Authy-Sandbox-Mode': twilio_authy_sandbox_mode, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, headers=headers, )

        return ServiceInstance(self._version, payload, sid=self._solution['sid'], )

    @property
    def entities(self):
        """
        Access the entities

        :returns: twilio.rest.authy.v1.service.entity.EntityList
        :rtype: twilio.rest.authy.v1.service.entity.EntityList
        """
        if self._entities is None:
            self._entities = EntityList(self._version, service_sid=self._solution['sid'], )
        return self._entities

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Authy.V1.ServiceContext {}>'.format(context)


class ServiceInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, sid=None):
        """
        Initialize the ServiceInstance

        :returns: twilio.rest.authy.v1.service.ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        super(ServiceInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'friendly_name': payload.get('friendly_name'),
            'account_sid': payload.get('account_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
            'links': payload.get('links'),
            'configuration': payload.get('configuration'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ServiceContext for this ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceContext
        """
        if self._context is None:
            self._context = ServiceContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: A string that uniquely identifies this Service.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def friendly_name(self):
        """
        :returns: A human readable description of this resource.
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def account_sid(self):
        """
        :returns: Account Sid.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def date_created(self):
        """
        :returns: The date this Service was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date this Service was updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: Nested resource URLs.
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def configuration(self):
        """
        :returns: The service level configuration of all the factor types.
        :rtype: dict
        """
        return self._properties['configuration']

    def delete(self, twilio_authy_sandbox_mode=values.unset):
        """
        Deletes the ServiceInstance

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete(twilio_authy_sandbox_mode=twilio_authy_sandbox_mode, )

    def fetch(self, twilio_authy_sandbox_mode=values.unset):
        """
        Fetch the ServiceInstance

        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: The fetched ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        return self._proxy.fetch(twilio_authy_sandbox_mode=twilio_authy_sandbox_mode, )

    def update(self, friendly_name=values.unset,
               twilio_authy_sandbox_mode=values.unset):
        """
        Update the ServiceInstance

        :param unicode friendly_name: A human readable description of this resource.
        :param unicode twilio_authy_sandbox_mode: The Twilio-Authy-Sandbox-Mode HTTP request header

        :returns: The updated ServiceInstance
        :rtype: twilio.rest.authy.v1.service.ServiceInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            twilio_authy_sandbox_mode=twilio_authy_sandbox_mode,
        )

    @property
    def entities(self):
        """
        Access the entities

        :returns: twilio.rest.authy.v1.service.entity.EntityList
        :rtype: twilio.rest.authy.v1.service.entity.EntityList
        """
        return self._proxy.entities

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Authy.V1.ServiceInstance {}>'.format(context)
