# dash-arcgis-open

Open Source implementation of Plotly Dash mapping components, powered by the ESRI ArcGIS API for Javascript.

## Installation

Dash ArcGIS Open is distributed via pip. 

```
pip install dash-arcgis-open
```
## DISCLAIMER

**This library is not in any way affiliated with either ESRI or Plotly.**

Contributions welcome.

## Resources 

- [ArcGIS API for Javascript](https://developers.arcgis.com/javascript/latest/)
- [Dash ArcGIS (Part of Dash Enterprise)](https://dash.plotly.com/dash-arcgis)


## Roadmap

Current functionality implemented "inspired" by the dash-arcgis documentation.

### Maps

:heavy_check_mark: [MapView](https://dash.plotly.com/dash-arcgis/reference/maps) 

:heavy_check_mark: [Webmap](https://dash.plotly.com/dash-arcgis/reference/maps#-dash_arcgis.webmap)

:x:[SceneView](https://dash.plotly.com/dash-arcgis/reference/maps#-dash_arcgis.sceneview) 


:x:[WebScene](https://dash.plotly.com/dash-arcgis/reference/maps#-dash_arcgis.webscene)

### Layers
:heavy_check_mark: [GeoJSONLayer](https://dash.plotly.com/dash-arcgis/reference/layers#-dash_arcgis.geojsonlayer)

:x: [ImageryLayer](https://dash.plotly.com/dash-arcgis/reference/layers#-dash_arcgis.imagerylayer)

:x: [OGCFeatureLayer](https://dash.plotly.com/dash-arcgis/reference/layers#-dash_arcgis.ogcfeaturelayer)

:x: [VectorTileLayer](https://dash.plotly.com/dash-arcgis/reference/layers#-dash_arcgis.vectortilelayer)

:x: [WFSLayer](https://dash.plotly.com/dash-arcgis/reference/layers#-dash_arcgis.wfslayer)

:x: [WMSLayer](https://dash.plotly.com/dash-arcgis/reference/layers#-dash_arcgis.wmslayer)

### Widgets
:heavy_check_mark: [BasemapGallery](https://dash.plotly.com/dash-arcgis/reference/widgets)

:heavy_check_mark: [Bookmarks](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.bookmarks)

:heavy_check_mark: [Editor](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.editor)

:heavy_check_mark: [Expand](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.expand)

:x: [Home](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.home)

:x: [LayerList](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.layerlist)

:x: [NavigationToggle](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.navigationtoggle)

:x: [Print](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.print)

:x: [ScaleBar](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.scalebar)

:x: [TimeSlider](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.timeslider)

:x: [Zoom](https://dash.plotly.com/dash-arcgis/reference/widgets#-dash_arcgis.zoom) 


