"""Parse luxtonik parameters."""
import logging

from luxtronik.datatypes import (
    Celsius,
    CoolingMode,
    HeatingMode,
    HotWaterMode,
    Hours,
    MixedCircuitMode,
    PoolMode,
    SolarMode,
    Unknown,
    VentilationMode,
)

LOGGER = logging.getLogger("Luxtronik.Parameters")


class Parameters:
    """Class that holds all parameters."""

    parameters = {
        0: Unknown("ID_Transfert_LuxNet"),
        1: Celsius("ID_Einst_WK_akt"),
        2: Celsius("ID_Einst_BWS_akt", True),
        3: HeatingMode("ID_Ba_Hz_akt", True),
        4: HotWaterMode("ID_Ba_Bw_akt", True),
        5: Unknown("ID_Ba_Al_akt"),
        6: Unknown("ID_SU_FrkdHz"),
        7: Unknown("ID_SU_FrkdBw"),
        8: Unknown("ID_SU_FrkdAl"),
        9: Unknown("ID_Einst_HReg_akt"),
        10: Unknown("ID_Einst_HzHwMAt_akt"),
        11: Unknown("ID_Einst_HzHwHKE_akt"),
        12: Unknown("ID_Einst_HzHKRANH_akt"),
        13: Unknown("ID_Einst_HzHKRABS_akt"),
        14: Unknown("ID_Einst_HzMK1E_akt"),
        15: Unknown("ID_Einst_HzMK1ANH_akt"),
        16: Unknown("ID_Einst_HzMK1ABS_akt"),
        17: Unknown("ID_Einst_HzFtRl_akt"),
        18: Unknown("ID_Einst_HzFtMK1Vl_akt"),
        19: Unknown("ID_Einst_SUBW_akt"),
        20: Unknown("ID_Einst_BwTDI_akt_MO"),
        21: Unknown("ID_Einst_BwTDI_akt_DI"),
        22: Unknown("ID_Einst_BwTDI_akt_MI"),
        23: Unknown("ID_Einst_BwTDI_akt_DO"),
        24: Unknown("ID_Einst_BwTDI_akt_FR"),
        25: Unknown("ID_Einst_BwTDI_akt_SA"),
        26: Unknown("ID_Einst_BwTDI_akt_SO"),
        27: Unknown("ID_Einst_BwTDI_akt_AL"),
        28: Unknown("ID_Einst_AnlKonf_akt"),
        29: Unknown("ID_Einst_Sprache_akt"),
        30: Unknown("ID_Switchoff_Zahler"),
        31: Unknown("ID_Switchoff_index"),
        32: Unknown("ID_Einst_EvuTyp_akt"),
        33: Unknown("ID_Einst_RFVEinb_akt"),
        34: Unknown("ID_Einst_AbtZykMax_akt"),
        35: Unknown("ID_Einst_HREinb_akt"),
        36: Unknown("ID_Einst_ZWE1Art_akt"),
        37: Unknown("ID_Einst_ZWE1Fkt_akt"),
        38: Unknown("ID_Einst_ZWE2Art_akt"),
        39: Unknown("ID_Einst_ZWE2Fkt_akt"),
        40: Unknown("ID_Einst_BWBer_akt"),
        41: Unknown("ID_Einst_En_Inst"),
        42: Unknown("ID_Einst_MK1Typ_akt"),
        43: Unknown("ID_Einst_ABTLuft_akt"),
        44: Unknown("ID_Einst_TLAbt_akt"),
        45: Unknown("ID_Einst_LAbtTime_akt"),
        46: Unknown("ID_Einst_ASDTyp_akt"),
        47: Unknown("ID_Einst_LGST_akt"),
        48: Unknown("ID_Einst_BwWpTime_akt"),
        49: Unknown("ID_Einst_Popt_akt"),
        50: Unknown("ID_Einst_Kurzprog_akt"),
        51: Unknown("ID_Timer_Kurzprog_akt"),
        52: Unknown("ID_Einst_ManAbt_akt"),
        53: Unknown("ID_Einst_Ahz_akt"),
        54: Unknown("ID_Einst_TVL_Ahz_1"),
        55: Unknown("ID_Einst_TVL_Ahz_2"),
        56: Unknown("ID_Einst_TVL_Ahz_3"),
        57: Unknown("ID_Einst_TVL_Ahz_4"),
        58: Unknown("ID_Einst_TVL_Ahz_5"),
        59: Unknown("ID_Einst_TVL_Ahz_6"),
        60: Unknown("ID_Einst_TVL_Ahz_7"),
        61: Unknown("ID_Einst_TVL_Ahz_8"),
        62: Unknown("ID_Einst_TVL_Ahz_9"),
        63: Unknown("ID_Einst_TVL_Ahz_10"),
        64: Unknown("ID_Einst_TVL_Std_1"),
        65: Unknown("ID_Einst_TVL_Std_2"),
        66: Unknown("ID_Einst_TVL_Std_3"),
        67: Unknown("ID_Einst_TVL_Std_4"),
        68: Unknown("ID_Einst_TVL_Std_5"),
        69: Unknown("ID_Einst_TVL_Std_6"),
        70: Unknown("ID_Einst_TVL_Std_7"),
        71: Unknown("ID_Einst_TVL_Std_8"),
        72: Unknown("ID_Einst_TVL_Std_9"),
        73: Unknown("ID_Einst_TVL_Std_10"),
        74: Unknown("ID_Einst_BWS_Hyst_akt"),
        75: Unknown("ID_Temp_TBW_BwHD_saved"),
        76: Unknown("ID_Einst_ABT1_akt"),
        77: Unknown("ID_Einst_LABTpaus_akt"),
        78: Unknown("ID_AHZ_state_akt"),
        79: Celsius("ID_Sollwert_TRL_HZ_AHZ", True),
        80: Unknown("ID_AHP_valid_records"),
        81: Unknown("ID_Timer_AHZ_akt"),
        82: Unknown("ID_Einst_BWTINP_akt"),
        83: Unknown("ID_Einst_ZUPTYP_akt"),
        84: Unknown("ID_Sollwert_TLG_max"),
        85: Unknown("ID_Einst_BWZIP_akt"),
        86: Unknown("ID_Einst_ERRmZWE_akt"),
        87: Unknown("ID_Einst_TRBegr_akt"),
        88: Unknown("ID_Einst_HRHyst_akt"),
        89: Unknown("ID_Einst_TRErhmax_akt"),
        90: Unknown("ID_Einst_ZWEFreig_akt"),
        91: Unknown("ID_Einst_TAmax_akt"),
        92: Unknown("ID_Einst_TAmin_akt"),
        93: Unknown("ID_Einst_TWQmin_akt"),
        94: Unknown("ID_Einst_THGmax_akt"),
        95: Unknown("ID_Einst_FRGT2VD_akt"),
        96: Unknown("ID_Einst_TV2VDBW_akt"),
        97: Unknown("ID_Einst_SuAll_akt"),
        98: Unknown("ID_Einst_TAbtEnd_akt"),
        99: Unknown("ID_Einst_NrKlingel_akt"),
        100: Unknown("ID_Einst_BWStyp_akt"),
        101: Unknown("ID_Einst_ABT2_akt"),
        102: Unknown("ID_Einst_UeVd_akt"),
        103: Unknown("ID_Einst_RTyp_akt"),
        104: Unknown("ID_Einst_AhpM_akt"),
        105: Celsius("ID_Soll_BWS_akt", True),
        106: Unknown("ID_Timer_Password"),
        107: Unknown("ID_Einst_Zugangscode"),
        108: CoolingMode("ID_Einst_BA_Kuehl_akt", True),
        109: Unknown("ID_Sollwert_Kuehl1_akt"),
        110: Celsius("ID_Einst_KuehlFreig_akt", True),
        111: Unknown("ID_Einst_TAbsMin_akt"),
        112: Unknown("ID_TWQmin_saved"),
        113: Unknown("ID_CWP_saved"),
        114: Unknown("ID_Einst_Anode_akt"),
        115: Unknown("ID_Timer_pexoff_akt"),
        116: Unknown("ID_Einst_AnlPrio_Hzakt"),
        117: Unknown("ID_Einst_AnlPrio_Bwakt"),
        118: Unknown("ID_Einst_AnlPrio_Swakt"),
        119: PoolMode("ID_Ba_Sw_akt", True),
        120: Unknown("ID_Einst_RTypMK1_akt"),
        121: Unknown("ID_Einst_RTypMK2_akt"),
        122: Unknown("ID_Einst_TDC_Ein_akt"),
        123: Unknown("ID_Einst_TDC_Aus_akt"),
        124: Celsius("ID_Einst_TDC_Max_akt", True),
        125: Unknown("ID_Einst_HysHzExEn_akt"),
        126: Unknown("ID_Einst_HysBwExEn_akt"),
        127: Unknown("ID_Einst_ZWE3Art_akt"),
        128: Unknown("ID_Einst_ZWE3Fkt_akt"),
        129: Unknown("ID_Einst_HzSup_akt"),
        130: Unknown("ID_Einst_MK2Typ_akt"),
        131: Unknown("ID_Einst_KuTyp_akt"),
        132: Celsius("ID_Sollwert_KuCft1_akt", True),
        133: Celsius("ID_Sollwert_KuCft2_akt", True),
        134: Celsius("ID_Sollwert_AtDif1_akt", True),
        135: Celsius("ID_Sollwert_AtDif2_akt", True),
        136: Unknown("ID_SU_FrkdSwb"),
        137: Unknown("ID_Einst_SwbBer_akt"),
        138: Unknown("ID_Einst_TV2VDSWB_akt"),
        139: Unknown("ID_Einst_MinSwan_Time_akt"),
        140: Unknown("ID_Einst_SuMk2_akt"),
        141: Unknown("ID_Einst_HzMK2E_akt"),
        142: Unknown("ID_Einst_HzMK2ANH_akt"),
        143: Unknown("ID_Einst_HzMK2ABS_akt"),
        144: Unknown("ID_Einst_HzMK2Hgr_akt"),
        145: Unknown("ID_Einst_HzFtMK2Vl_akt"),
        146: Unknown("ID_Temp_THG_BwHD_saved"),
        147: Unknown("ID_Temp_TA_BwHD_saved"),
        148: Unknown("ID_Einst_BwHup_akt"),
        149: Unknown("ID_Einst_TVLmax_akt"),
        150: Unknown("ID_Einst_MK1LzFaktor_akt"),
        151: Unknown("ID_Einst_MK2LzFaktor_akt"),
        152: Unknown("ID_Einst_MK1PerFaktor_akt"),
        153: Unknown("ID_Einst_MK2PerFaktor_akt"),
        154: Unknown("ID_Entl_Zyklus_akt"),
        155: Unknown("ID_Einst_Entl_time_akt"),
        156: Unknown("ID_Entl_Pause"),
        157: Unknown("ID_Entl_timer"),
        158: Unknown("ID_Einst_Entl_akt"),
        159: Unknown("ID_Ahz_HLeist_confirmed"),
        160: Unknown("ID_FirstInit_akt"),
        161: Unknown("ID_Einst_SuAll_akt2"),
        162: Unknown("ID_Einst_SuAllWo_zeit_0_0"),
        163: Unknown("ID_Einst_SuAllWo_zeit_0_1"),
        164: Unknown("ID_Einst_SuAllWo_zeit_1_0"),
        165: Unknown("ID_Einst_SuAllWo_zeit_1_1"),
        166: Unknown("ID_Einst_SuAllWo_zeit_2_0"),
        167: Unknown("ID_Einst_SuAllWo_zeit_2_1"),
        168: Unknown("ID_Einst_SuAll25_zeit_0_0"),
        169: Unknown("ID_Einst_SuAll25_zeit_0_1"),
        170: Unknown("ID_Einst_SuAll25_zeit_1_0"),
        171: Unknown("ID_Einst_SuAll25_zeit_1_1"),
        172: Unknown("ID_Einst_SuAll25_zeit_2_0"),
        173: Unknown("ID_Einst_SuAll25_zeit_2_1"),
        174: Unknown("ID_Einst_SuAll25_zeit_0_2"),
        175: Unknown("ID_Einst_SuAll25_zeit_0_3"),
        176: Unknown("ID_Einst_SuAll25_zeit_1_2"),
        177: Unknown("ID_Einst_SuAll25_zeit_1_3"),
        178: Unknown("ID_Einst_SuAll25_zeit_2_2"),
        179: Unknown("ID_Einst_SuAll25_zeit_2_3"),
        180: Unknown("ID_Einst_SuAllTg_zeit_0_0"),
        181: Unknown("ID_Einst_SuAllTg_zeit_0_1"),
        182: Unknown("ID_Einst_SuAllTg_zeit_1_0"),
        183: Unknown("ID_Einst_SuAllTg_zeit_1_1"),
        184: Unknown("ID_Einst_SuAllTg_zeit_2_0"),
        185: Unknown("ID_Einst_SuAllTg_zeit_2_1"),
        186: Unknown("ID_Einst_SuAllTg_zeit_0_2"),
        187: Unknown("ID_Einst_SuAllTg_zeit_0_3"),
        188: Unknown("ID_Einst_SuAllTg_zeit_1_2"),
        189: Unknown("ID_Einst_SuAllTg_zeit_1_3"),
        190: Unknown("ID_Einst_SuAllTg_zeit_2_2"),
        191: Unknown("ID_Einst_SuAllTg_zeit_2_3"),
        192: Unknown("ID_Einst_SuAllTg_zeit_0_4"),
        193: Unknown("ID_Einst_SuAllTg_zeit_0_5"),
        194: Unknown("ID_Einst_SuAllTg_zeit_1_4"),
        195: Unknown("ID_Einst_SuAllTg_zeit_1_5"),
        196: Unknown("ID_Einst_SuAllTg_zeit_2_4"),
        197: Unknown("ID_Einst_SuAllTg_zeit_2_5"),
        198: Unknown("ID_Einst_SuAllTg_zeit_0_6"),
        199: Unknown("ID_Einst_SuAllTg_zeit_0_7"),
        200: Unknown("ID_Einst_SuAllTg_zeit_1_6"),
        201: Unknown("ID_Einst_SuAllTg_zeit_1_7"),
        202: Unknown("ID_Einst_SuAllTg_zeit_2_6"),
        203: Unknown("ID_Einst_SuAllTg_zeit_2_7"),
        204: Unknown("ID_Einst_SuAllTg_zeit_0_8"),
        205: Unknown("ID_Einst_SuAllTg_zeit_0_9"),
        206: Unknown("ID_Einst_SuAllTg_zeit_1_8"),
        207: Unknown("ID_Einst_SuAllTg_zeit_1_9"),
        208: Unknown("ID_Einst_SuAllTg_zeit_2_8"),
        209: Unknown("ID_Einst_SuAllTg_zeit_2_9"),
        210: Unknown("ID_Einst_SuAllTg_zeit_0_10"),
        211: Unknown("ID_Einst_SuAllTg_zeit_0_11"),
        212: Unknown("ID_Einst_SuAllTg_zeit_1_10"),
        213: Unknown("ID_Einst_SuAllTg_zeit_1_11"),
        214: Unknown("ID_Einst_SuAllTg_zeit_2_10"),
        215: Unknown("ID_Einst_SuAllTg_zeit_2_11"),
        216: Unknown("ID_Einst_SuAllTg_zeit_0_12"),
        217: Unknown("ID_Einst_SuAllTg_zeit_0_13"),
        218: Unknown("ID_Einst_SuAllTg_zeit_1_12"),
        219: Unknown("ID_Einst_SuAllTg_zeit_1_13"),
        220: Unknown("ID_Einst_SuAllTg_zeit_2_12"),
        221: Unknown("ID_Einst_SuAllTg_zeit_2_13"),
        222: Unknown("ID_Einst_SuHkr_akt"),
        223: Unknown("ID_Einst_SuHkrW0_zeit_0_0"),
        224: Unknown("ID_Einst_SuHkrW0_zeit_0_1"),
        225: Unknown("ID_Einst_SuHkrW0_zeit_1_0"),
        226: Unknown("ID_Einst_SuHkrW0_zeit_1_1"),
        227: Unknown("ID_Einst_SuHkrW0_zeit_2_0"),
        228: Unknown("ID_Einst_SuHkrW0_zeit_2_1"),
        229: Unknown("ID_Einst_SuHkr25_zeit_0_0"),
        230: Unknown("ID_Einst_SuHkr25_zeit_0_1"),
        231: Unknown("ID_Einst_SuHkr25_zeit_1_0"),
        232: Unknown("ID_Einst_SuHkr25_zeit_1_1"),
        233: Unknown("ID_Einst_SuHkr25_zeit_2_0"),
        234: Unknown("ID_Einst_SuHkr25_zeit_2_1"),
        235: Unknown("ID_Einst_SuHkr25_zeit_0_2"),
        236: Unknown("ID_Einst_SuHkr25_zeit_0_3"),
        237: Unknown("ID_Einst_SuHkr25_zeit_1_2"),
        238: Unknown("ID_Einst_SuHkr25_zeit_1_3"),
        239: Unknown("ID_Einst_SuHkr25_zeit_2_2"),
        240: Unknown("ID_Einst_SuHkr25_zeit_2_3"),
        241: Unknown("ID_Einst_SuHkrTG_zeit_0_0"),
        242: Unknown("ID_Einst_SuHkrTG_zeit_0_1"),
        243: Unknown("ID_Einst_SuHkrTG_zeit_1_0"),
        244: Unknown("ID_Einst_SuHkrTG_zeit_1_1"),
        245: Unknown("ID_Einst_SuHkrTG_zeit_2_0"),
        246: Unknown("ID_Einst_SuHkrTG_zeit_2_1"),
        247: Unknown("ID_Einst_SuHkrTG_zeit_0_2"),
        248: Unknown("ID_Einst_SuHkrTG_zeit_0_3"),
        249: Unknown("ID_Einst_SuHkrTG_zeit_1_2"),
        250: Unknown("ID_Einst_SuHkrTG_zeit_1_3"),
        251: Unknown("ID_Einst_SuHkrTG_zeit_2_2"),
        252: Unknown("ID_Einst_SuHkrTG_zeit_2_3"),
        253: Unknown("ID_Einst_SuHkrTG_zeit_0_4"),
        254: Unknown("ID_Einst_SuHkrTG_zeit_0_5"),
        255: Unknown("ID_Einst_SuHkrTG_zeit_1_4"),
        256: Unknown("ID_Einst_SuHkrTG_zeit_1_5"),
        257: Unknown("ID_Einst_SuHkrTG_zeit_2_4"),
        258: Unknown("ID_Einst_SuHkrTG_zeit_2_5"),
        259: Unknown("ID_Einst_SuHkrTG_zeit_0_6"),
        260: Unknown("ID_Einst_SuHkrTG_zeit_0_7"),
        261: Unknown("ID_Einst_SuHkrTG_zeit_1_6"),
        262: Unknown("ID_Einst_SuHkrTG_zeit_1_7"),
        263: Unknown("ID_Einst_SuHkrTG_zeit_2_6"),
        264: Unknown("ID_Einst_SuHkrTG_zeit_2_7"),
        265: Unknown("ID_Einst_SuHkrTG_zeit_0_8"),
        266: Unknown("ID_Einst_SuHkrTG_zeit_0_9"),
        267: Unknown("ID_Einst_SuHkrTG_zeit_1_8"),
        268: Unknown("ID_Einst_SuHkrTG_zeit_1_9"),
        269: Unknown("ID_Einst_SuHkrTG_zeit_2_8"),
        270: Unknown("ID_Einst_SuHkrTG_zeit_2_9"),
        271: Unknown("ID_Einst_SuHkrTG_zeit_0_10"),
        272: Unknown("ID_Einst_SuHkrTG_zeit_0_11"),
        273: Unknown("ID_Einst_SuHkrTG_zeit_1_10"),
        274: Unknown("ID_Einst_SuHkrTG_zeit_1_11"),
        275: Unknown("ID_Einst_SuHkrTG_zeit_2_10"),
        276: Unknown("ID_Einst_SuHkrTG_zeit_2_11"),
        277: Unknown("ID_Einst_SuHkrTG_zeit_0_12"),
        278: Unknown("ID_Einst_SuHkrTG_zeit_0_13"),
        279: Unknown("ID_Einst_SuHkrTG_zeit_1_12"),
        280: Unknown("ID_Einst_SuHkrTG_zeit_1_13"),
        281: Unknown("ID_Einst_SuHkrTG_zeit_2_12"),
        282: Unknown("ID_Einst_SuHkrTG_zeit_2_13"),
        283: Unknown("ID_Einst_SuMk1_akt"),
        284: Unknown("ID_Einst_SuMk1W0_zeit_0_0"),
        285: Unknown("ID_Einst_SuMk1W0_zeit_0_1"),
        286: Unknown("ID_Einst_SuMk1W0_zeit_1_0"),
        287: Unknown("ID_Einst_SuMk1W0_zeit_1_1"),
        288: Unknown("ID_Einst_SuMk1W0_zeit_2_0"),
        289: Unknown("ID_Einst_SuMk1W0_zeit_2_1"),
        290: Unknown("ID_Einst_SuMk125_zeit_0_0"),
        291: Unknown("ID_Einst_SuMk125_zeit_0_1"),
        292: Unknown("ID_Einst_SuMk125_zeit_1_0"),
        293: Unknown("ID_Einst_SuMk125_zeit_1_1"),
        294: Unknown("ID_Einst_SuMk125_zeit_2_0"),
        295: Unknown("ID_Einst_SuMk125_zeit_2_1"),
        296: Unknown("ID_Einst_SuMk125_zeit_0_2"),
        297: Unknown("ID_Einst_SuMk125_zeit_0_3"),
        298: Unknown("ID_Einst_SuMk125_zeit_1_2"),
        299: Unknown("ID_Einst_SuMk125_zeit_1_3"),
        300: Unknown("ID_Einst_SuMk125_zeit_2_2"),
        301: Unknown("ID_Einst_SuMk125_zeit_2_3"),
        302: Unknown("ID_Einst_SuMk1TG_zeit_0_0"),
        303: Unknown("ID_Einst_SuMk1TG_zeit_0_1"),
        304: Unknown("ID_Einst_SuMk1TG_zeit_1_0"),
        305: Unknown("ID_Einst_SuMk1TG_zeit_1_1"),
        306: Unknown("ID_Einst_SuMk1TG_zeit_2_0"),
        307: Unknown("ID_Einst_SuMk1TG_zeit_2_1"),
        308: Unknown("ID_Einst_SuMk1TG_zeit_0_2"),
        309: Unknown("ID_Einst_SuMk1TG_zeit_0_3"),
        310: Unknown("ID_Einst_SuMk1TG_zeit_1_2"),
        311: Unknown("ID_Einst_SuMk1TG_zeit_1_3"),
        312: Unknown("ID_Einst_SuMk1TG_zeit_2_2"),
        313: Unknown("ID_Einst_SuMk1TG_zeit_2_3"),
        314: Unknown("ID_Einst_SuMk1TG_zeit_0_4"),
        315: Unknown("ID_Einst_SuMk1TG_zeit_0_5"),
        316: Unknown("ID_Einst_SuMk1TG_zeit_1_4"),
        317: Unknown("ID_Einst_SuMk1TG_zeit_1_5"),
        318: Unknown("ID_Einst_SuMk1TG_zeit_2_4"),
        319: Unknown("ID_Einst_SuMk1TG_zeit_2_5"),
        320: Unknown("ID_Einst_SuMk1TG_zeit_0_6"),
        321: Unknown("ID_Einst_SuMk1TG_zeit_0_7"),
        322: Unknown("ID_Einst_SuMk1TG_zeit_1_6"),
        323: Unknown("ID_Einst_SuMk1TG_zeit_1_7"),
        324: Unknown("ID_Einst_SuMk1TG_zeit_2_6"),
        325: Unknown("ID_Einst_SuMk1TG_zeit_2_7"),
        326: Unknown("ID_Einst_SuMk1TG_zeit_0_8"),
        327: Unknown("ID_Einst_SuMk1TG_zeit_0_9"),
        328: Unknown("ID_Einst_SuMk1TG_zeit_1_8"),
        329: Unknown("ID_Einst_SuMk1TG_zeit_1_9"),
        330: Unknown("ID_Einst_SuMk1TG_zeit_2_8"),
        331: Unknown("ID_Einst_SuMk1TG_zeit_2_9"),
        332: Unknown("ID_Einst_SuMk1TG_zeit_0_10"),
        333: Unknown("ID_Einst_SuMk1TG_zeit_0_11"),
        334: Unknown("ID_Einst_SuMk1TG_zeit_1_10"),
        335: Unknown("ID_Einst_SuMk1TG_zeit_1_11"),
        336: Unknown("ID_Einst_SuMk1TG_zeit_2_10"),
        337: Unknown("ID_Einst_SuMk1TG_zeit_2_11"),
        338: Unknown("ID_Einst_SuMk1TG_zeit_0_12"),
        339: Unknown("ID_Einst_SuMk1TG_zeit_0_13"),
        340: Unknown("ID_Einst_SuMk1TG_zeit_1_12"),
        341: Unknown("ID_Einst_SuMk1TG_zeit_1_13"),
        342: Unknown("ID_Einst_SuMk1TG_zeit_2_12"),
        343: Unknown("ID_Einst_SuMk1TG_zeit_2_13"),
        344: Unknown("ID_Einst_SuMk2_akt2"),
        345: Unknown("ID_Einst_SuMk2Wo_zeit_0_0"),
        346: Unknown("ID_Einst_SuMk2Wo_zeit_0_1"),
        347: Unknown("ID_Einst_SuMk2Wo_zeit_1_0"),
        348: Unknown("ID_Einst_SuMk2Wo_zeit_1_1"),
        349: Unknown("ID_Einst_SuMk2Wo_zeit_2_0"),
        350: Unknown("ID_Einst_SuMk2Wo_zeit_2_1"),
        351: Unknown("ID_Einst_SuMk225_zeit_0_0"),
        352: Unknown("ID_Einst_SuMk225_zeit_0_1"),
        353: Unknown("ID_Einst_SuMk225_zeit_1_0"),
        354: Unknown("ID_Einst_SuMk225_zeit_1_1"),
        355: Unknown("ID_Einst_SuMk225_zeit_2_0"),
        356: Unknown("ID_Einst_SuMk225_zeit_2_1"),
        357: Unknown("ID_Einst_SuMk225_zeit_0_2"),
        358: Unknown("ID_Einst_SuMk225_zeit_0_3"),
        359: Unknown("ID_Einst_SuMk225_zeit_1_2"),
        360: Unknown("ID_Einst_SuMk225_zeit_1_3"),
        361: Unknown("ID_Einst_SuMk225_zeit_2_2"),
        362: Unknown("ID_Einst_SuMk225_zeit_2_3"),
        363: Unknown("ID_Einst_SuMk2Tg_zeit_0_0"),
        364: Unknown("ID_Einst_SuMk2Tg_zeit_0_1"),
        365: Unknown("ID_Einst_SuMk2Tg_zeit_1_0"),
        366: Unknown("ID_Einst_SuMk2Tg_zeit_1_1"),
        367: Unknown("ID_Einst_SuMk2Tg_zeit_2_0"),
        368: Unknown("ID_Einst_SuMk2Tg_zeit_2_1"),
        369: Unknown("ID_Einst_SuMk2Tg_zeit_0_2"),
        370: Unknown("ID_Einst_SuMk2Tg_zeit_0_3"),
        371: Unknown("ID_Einst_SuMk2Tg_zeit_1_2"),
        372: Unknown("ID_Einst_SuMk2Tg_zeit_1_3"),
        373: Unknown("ID_Einst_SuMk2Tg_zeit_2_2"),
        374: Unknown("ID_Einst_SuMk2Tg_zeit_2_3"),
        375: Unknown("ID_Einst_SuMk2Tg_zeit_0_4"),
        376: Unknown("ID_Einst_SuMk2Tg_zeit_0_5"),
        377: Unknown("ID_Einst_SuMk2Tg_zeit_1_4"),
        378: Unknown("ID_Einst_SuMk2Tg_zeit_1_5"),
        379: Unknown("ID_Einst_SuMk2Tg_zeit_2_4"),
        380: Unknown("ID_Einst_SuMk2Tg_zeit_2_5"),
        381: Unknown("ID_Einst_SuMk2Tg_zeit_0_6"),
        382: Unknown("ID_Einst_SuMk2Tg_zeit_0_7"),
        383: Unknown("ID_Einst_SuMk2Tg_zeit_1_6"),
        384: Unknown("ID_Einst_SuMk2Tg_zeit_1_7"),
        385: Unknown("ID_Einst_SuMk2Tg_zeit_2_6"),
        386: Unknown("ID_Einst_SuMk2Tg_zeit_2_7"),
        387: Unknown("ID_Einst_SuMk2Tg_zeit_0_8"),
        388: Unknown("ID_Einst_SuMk2Tg_zeit_0_9"),
        389: Unknown("ID_Einst_SuMk2Tg_zeit_1_8"),
        390: Unknown("ID_Einst_SuMk2Tg_zeit_1_9"),
        391: Unknown("ID_Einst_SuMk2Tg_zeit_2_8"),
        392: Unknown("ID_Einst_SuMk2Tg_zeit_2_9"),
        393: Unknown("ID_Einst_SuMk2Tg_zeit_0_10"),
        394: Unknown("ID_Einst_SuMk2Tg_zeit_0_11"),
        395: Unknown("ID_Einst_SuMk2Tg_zeit_1_10"),
        396: Unknown("ID_Einst_SuMk2Tg_zeit_1_11"),
        397: Unknown("ID_Einst_SuMk2Tg_zeit_2_10"),
        398: Unknown("ID_Einst_SuMk2Tg_zeit_2_11"),
        399: Unknown("ID_Einst_SuMk2Tg_zeit_0_12"),
        400: Unknown("ID_Einst_SuMk2Tg_zeit_0_13"),
        401: Unknown("ID_Einst_SuMk2Tg_zeit_1_12"),
        402: Unknown("ID_Einst_SuMk2Tg_zeit_1_13"),
        403: Unknown("ID_Einst_SuMk2Tg_zeit_2_12"),
        404: Unknown("ID_Einst_SuMk2Tg_zeit_2_13"),
        405: Unknown("ID_Einst_SUBW_akt2"),
        406: Unknown("ID_Einst_SuBwWO_zeit_0_0"),
        407: Unknown("ID_Einst_SuBwWO_zeit_0_1"),
        408: Unknown("ID_Einst_SuBwWO_zeit_1_0"),
        409: Unknown("ID_Einst_SuBwWO_zeit_1_1"),
        410: Unknown("ID_Einst_SuBwWO_zeit_2_0"),
        411: Unknown("ID_Einst_SuBwWO_zeit_2_1"),
        412: Unknown("ID_Einst_SuBwWO_zeit_3_0"),
        413: Unknown("ID_Einst_SuBwWO_zeit_3_1"),
        414: Unknown("ID_Einst_SuBwWO_zeit_4_0"),
        415: Unknown("ID_Einst_SuBwWO_zeit_4_1"),
        416: Unknown("ID_Einst_SuBw25_zeit_0_0"),
        417: Unknown("ID_Einst_SuBw25_zeit_0_1"),
        418: Unknown("ID_Einst_SuBw25_zeit_1_0"),
        419: Unknown("ID_Einst_SuBw25_zeit_1_1"),
        420: Unknown("ID_Einst_SuBw25_zeit_2_0"),
        421: Unknown("ID_Einst_SuBw25_zeit_2_1"),
        422: Unknown("ID_Einst_SuBw25_zeit_3_0"),
        423: Unknown("ID_Einst_SuBw25_zeit_3_1"),
        424: Unknown("ID_Einst_SuBw25_zeit_4_0"),
        425: Unknown("ID_Einst_SuBw25_zeit_4_1"),
        426: Unknown("ID_Einst_SuBw25_zeit_0_2"),
        427: Unknown("ID_Einst_SuBw25_zeit_0_3"),
        428: Unknown("ID_Einst_SuBw25_zeit_1_2"),
        429: Unknown("ID_Einst_SuBw25_zeit_1_3"),
        430: Unknown("ID_Einst_SuBw25_zeit_2_2"),
        431: Unknown("ID_Einst_SuBw25_zeit_2_3"),
        432: Unknown("ID_Einst_SuBw25_zeit_3_2"),
        433: Unknown("ID_Einst_SuBw25_zeit_3_3"),
        434: Unknown("ID_Einst_SuBw25_zeit_4_2"),
        435: Unknown("ID_Einst_SuBw25_zeit_4_3"),
        436: Unknown("ID_Einst_SuBwTG_zeit_0_0"),
        437: Unknown("ID_Einst_SuBwTG_zeit_0_1"),
        438: Unknown("ID_Einst_SuBwTG_zeit_1_0"),
        439: Unknown("ID_Einst_SuBwTG_zeit_1_1"),
        440: Unknown("ID_Einst_SuBwTG_zeit_2_0"),
        441: Unknown("ID_Einst_SuBwTG_zeit_2_1"),
        442: Unknown("ID_Einst_SuBwTG_zeit_3_0"),
        443: Unknown("ID_Einst_SuBwTG_zeit_3_1"),
        444: Unknown("ID_Einst_SuBwTG_zeit_4_0"),
        445: Unknown("ID_Einst_SuBwTG_zeit_4_1"),
        446: Unknown("ID_Einst_SuBwTG_zeit_0_2"),
        447: Unknown("ID_Einst_SuBwTG_zeit_0_3"),
        448: Unknown("ID_Einst_SuBwTG_zeit_1_2"),
        449: Unknown("ID_Einst_SuBwTG_zeit_1_3"),
        450: Unknown("ID_Einst_SuBwTG_zeit_2_2"),
        451: Unknown("ID_Einst_SuBwTG_zeit_2_3"),
        452: Unknown("ID_Einst_SuBwTG_zeit_3_2"),
        453: Unknown("ID_Einst_SuBwTG_zeit_3_3"),
        454: Unknown("ID_Einst_SuBwTG_zeit_4_2"),
        455: Unknown("ID_Einst_SuBwTG_zeit_4_3"),
        456: Unknown("ID_Einst_SuBwTG_zeit_0_4"),
        457: Unknown("ID_Einst_SuBwTG_zeit_0_5"),
        458: Unknown("ID_Einst_SuBwTG_zeit_1_4"),
        459: Unknown("ID_Einst_SuBwTG_zeit_1_5"),
        460: Unknown("ID_Einst_SuBwTG_zeit_2_4"),
        461: Unknown("ID_Einst_SuBwTG_zeit_2_5"),
        462: Unknown("ID_Einst_SuBwTG_zeit_3_4"),
        463: Unknown("ID_Einst_SuBwTG_zeit_3_5"),
        464: Unknown("ID_Einst_SuBwTG_zeit_4_4"),
        465: Unknown("ID_Einst_SuBwTG_zeit_4_5"),
        466: Unknown("ID_Einst_SuBwTG_zeit_0_6"),
        467: Unknown("ID_Einst_SuBwTG_zeit_0_7"),
        468: Unknown("ID_Einst_SuBwTG_zeit_1_6"),
        469: Unknown("ID_Einst_SuBwTG_zeit_1_7"),
        470: Unknown("ID_Einst_SuBwTG_zeit_2_6"),
        471: Unknown("ID_Einst_SuBwTG_zeit_2_7"),
        472: Unknown("ID_Einst_SuBwTG_zeit_3_6"),
        473: Unknown("ID_Einst_SuBwTG_zeit_3_7"),
        474: Unknown("ID_Einst_SuBwTG_zeit_4_6"),
        475: Unknown("ID_Einst_SuBwTG_zeit_4_7"),
        476: Unknown("ID_Einst_SuBwTG_zeit_0_8"),
        477: Unknown("ID_Einst_SuBwTG_zeit_0_9"),
        478: Unknown("ID_Einst_SuBwTG_zeit_1_8"),
        479: Unknown("ID_Einst_SuBwTG_zeit_1_9"),
        480: Unknown("ID_Einst_SuBwTG_zeit_2_8"),
        481: Unknown("ID_Einst_SuBwTG_zeit_2_9"),
        482: Unknown("ID_Einst_SuBwTG_zeit_3_8"),
        483: Unknown("ID_Einst_SuBwTG_zeit_3_9"),
        484: Unknown("ID_Einst_SuBwTG_zeit_4_8"),
        485: Unknown("ID_Einst_SuBwTG_zeit_4_9"),
        486: Unknown("ID_Einst_SuBwTG_zeit_0_10"),
        487: Unknown("ID_Einst_SuBwTG_zeit_0_11"),
        488: Unknown("ID_Einst_SuBwTG_zeit_1_10"),
        489: Unknown("ID_Einst_SuBwTG_zeit_1_11"),
        490: Unknown("ID_Einst_SuBwTG_zeit_2_10"),
        491: Unknown("ID_Einst_SuBwTG_zeit_2_11"),
        492: Unknown("ID_Einst_SuBwTG_zeit_3_10"),
        493: Unknown("ID_Einst_SuBwTG_zeit_3_11"),
        494: Unknown("ID_Einst_SuBwTG_zeit_4_10"),
        495: Unknown("ID_Einst_SuBwTG_zeit_4_11"),
        496: Unknown("ID_Einst_SuBwTG_zeit_0_12"),
        497: Unknown("ID_Einst_SuBwTG_zeit_0_13"),
        498: Unknown("ID_Einst_SuBwTG_zeit_1_12"),
        499: Unknown("ID_Einst_SuBwTG_zeit_1_13"),
        500: Unknown("ID_Einst_SuBwTG_zeit_2_12"),
        501: Unknown("ID_Einst_SuBwTG_zeit_2_13"),
        502: Unknown("ID_Einst_SuBwTG_zeit_3_12"),
        503: Unknown("ID_Einst_SuBwTG_zeit_3_13"),
        504: Unknown("ID_Einst_SuBwTG_zeit_4_12"),
        505: Unknown("ID_Einst_SuBwTG_zeit_4_13"),
        506: Unknown("ID_Einst_SuZIP_akt"),
        507: Unknown("ID_Einst_SuZIPWo_zeit_0_0"),
        508: Unknown("ID_Einst_SuZIPWo_zeit_0_1"),
        509: Unknown("ID_Einst_SuZIPWo_zeit_1_0"),
        510: Unknown("ID_Einst_SuZIPWo_zeit_1_1"),
        511: Unknown("ID_Einst_SuZIPWo_zeit_2_0"),
        512: Unknown("ID_Einst_SuZIPWo_zeit_2_1"),
        513: Unknown("ID_Einst_SuZIPWo_zeit_3_0"),
        514: Unknown("ID_Einst_SuZIPWo_zeit_3_1"),
        515: Unknown("ID_Einst_SuZIPWo_zeit_4_0"),
        516: Unknown("ID_Einst_SuZIPWo_zeit_4_1"),
        517: Unknown("ID_Einst_SuZIP25_zeit_0_0"),
        518: Unknown("ID_Einst_SuZIP25_zeit_0_1"),
        519: Unknown("ID_Einst_SuZIP25_zeit_1_0"),
        520: Unknown("ID_Einst_SuZIP25_zeit_1_1"),
        521: Unknown("ID_Einst_SuZIP25_zeit_2_0"),
        522: Unknown("ID_Einst_SuZIP25_zeit_2_1"),
        523: Unknown("ID_Einst_SuZIP25_zeit_3_0"),
        524: Unknown("ID_Einst_SuZIP25_zeit_3_1"),
        525: Unknown("ID_Einst_SuZIP25_zeit_4_0"),
        526: Unknown("ID_Einst_SuZIP25_zeit_4_1"),
        527: Unknown("ID_Einst_SuZIP25_zeit_0_2"),
        528: Unknown("ID_Einst_SuZIP25_zeit_0_3"),
        529: Unknown("ID_Einst_SuZIP25_zeit_1_2"),
        530: Unknown("ID_Einst_SuZIP25_zeit_1_3"),
        531: Unknown("ID_Einst_SuZIP25_zeit_2_2"),
        532: Unknown("ID_Einst_SuZIP25_zeit_2_3"),
        533: Unknown("ID_Einst_SuZIP25_zeit_3_2"),
        534: Unknown("ID_Einst_SuZIP25_zeit_3_3"),
        535: Unknown("ID_Einst_SuZIP25_zeit_4_2"),
        536: Unknown("ID_Einst_SuZIP25_zeit_4_3"),
        537: Unknown("ID_Einst_SuZIPTg_zeit_0_0"),
        538: Unknown("ID_Einst_SuZIPTg_zeit_0_1"),
        539: Unknown("ID_Einst_SuZIPTg_zeit_1_0"),
        540: Unknown("ID_Einst_SuZIPTg_zeit_1_1"),
        541: Unknown("ID_Einst_SuZIPTg_zeit_2_0"),
        542: Unknown("ID_Einst_SuZIPTg_zeit_2_1"),
        543: Unknown("ID_Einst_SuZIPTg_zeit_3_0"),
        544: Unknown("ID_Einst_SuZIPTg_zeit_3_1"),
        545: Unknown("ID_Einst_SuZIPTg_zeit_4_0"),
        546: Unknown("ID_Einst_SuZIPTg_zeit_4_1"),
        547: Unknown("ID_Einst_SuZIPTg_zeit_0_2"),
        548: Unknown("ID_Einst_SuZIPTg_zeit_0_3"),
        549: Unknown("ID_Einst_SuZIPTg_zeit_1_2"),
        550: Unknown("ID_Einst_SuZIPTg_zeit_1_3"),
        551: Unknown("ID_Einst_SuZIPTg_zeit_2_2"),
        552: Unknown("ID_Einst_SuZIPTg_zeit_2_3"),
        553: Unknown("ID_Einst_SuZIPTg_zeit_3_2"),
        554: Unknown("ID_Einst_SuZIPTg_zeit_3_3"),
        555: Unknown("ID_Einst_SuZIPTg_zeit_4_2"),
        556: Unknown("ID_Einst_SuZIPTg_zeit_4_3"),
        557: Unknown("ID_Einst_SuZIPTg_zeit_0_4"),
        558: Unknown("ID_Einst_SuZIPTg_zeit_0_5"),
        559: Unknown("ID_Einst_SuZIPTg_zeit_1_4"),
        560: Unknown("ID_Einst_SuZIPTg_zeit_1_5"),
        561: Unknown("ID_Einst_SuZIPTg_zeit_2_4"),
        562: Unknown("ID_Einst_SuZIPTg_zeit_2_5"),
        563: Unknown("ID_Einst_SuZIPTg_zeit_3_4"),
        564: Unknown("ID_Einst_SuZIPTg_zeit_3_5"),
        565: Unknown("ID_Einst_SuZIPTg_zeit_4_4"),
        566: Unknown("ID_Einst_SuZIPTg_zeit_4_5"),
        567: Unknown("ID_Einst_SuZIPTg_zeit_0_6"),
        568: Unknown("ID_Einst_SuZIPTg_zeit_0_7"),
        569: Unknown("ID_Einst_SuZIPTg_zeit_1_6"),
        570: Unknown("ID_Einst_SuZIPTg_zeit_1_7"),
        571: Unknown("ID_Einst_SuZIPTg_zeit_2_6"),
        572: Unknown("ID_Einst_SuZIPTg_zeit_2_7"),
        573: Unknown("ID_Einst_SuZIPTg_zeit_3_6"),
        574: Unknown("ID_Einst_SuZIPTg_zeit_3_7"),
        575: Unknown("ID_Einst_SuZIPTg_zeit_4_6"),
        576: Unknown("ID_Einst_SuZIPTg_zeit_4_7"),
        577: Unknown("ID_Einst_SuZIPTg_zeit_0_8"),
        578: Unknown("ID_Einst_SuZIPTg_zeit_0_9"),
        579: Unknown("ID_Einst_SuZIPTg_zeit_1_8"),
        580: Unknown("ID_Einst_SuZIPTg_zeit_1_9"),
        581: Unknown("ID_Einst_SuZIPTg_zeit_2_8"),
        582: Unknown("ID_Einst_SuZIPTg_zeit_2_9"),
        583: Unknown("ID_Einst_SuZIPTg_zeit_3_8"),
        584: Unknown("ID_Einst_SuZIPTg_zeit_3_9"),
        585: Unknown("ID_Einst_SuZIPTg_zeit_4_8"),
        586: Unknown("ID_Einst_SuZIPTg_zeit_4_9"),
        587: Unknown("ID_Einst_SuZIPTg_zeit_0_10"),
        588: Unknown("ID_Einst_SuZIPTg_zeit_0_11"),
        589: Unknown("ID_Einst_SuZIPTg_zeit_1_10"),
        590: Unknown("ID_Einst_SuZIPTg_zeit_1_11"),
        591: Unknown("ID_Einst_SuZIPTg_zeit_2_10"),
        592: Unknown("ID_Einst_SuZIPTg_zeit_2_11"),
        593: Unknown("ID_Einst_SuZIPTg_zeit_3_10"),
        594: Unknown("ID_Einst_SuZIPTg_zeit_3_11"),
        595: Unknown("ID_Einst_SuZIPTg_zeit_4_10"),
        596: Unknown("ID_Einst_SuZIPTg_zeit_4_11"),
        597: Unknown("ID_Einst_SuZIPTg_zeit_0_12"),
        598: Unknown("ID_Einst_SuZIPTg_zeit_0_13"),
        599: Unknown("ID_Einst_SuZIPTg_zeit_1_12"),
        600: Unknown("ID_Einst_SuZIPTg_zeit_1_13"),
        601: Unknown("ID_Einst_SuZIPTg_zeit_2_12"),
        602: Unknown("ID_Einst_SuZIPTg_zeit_2_13"),
        603: Unknown("ID_Einst_SuZIPTg_zeit_3_12"),
        604: Unknown("ID_Einst_SuZIPTg_zeit_3_13"),
        605: Unknown("ID_Einst_SuZIPTg_zeit_4_12"),
        606: Unknown("ID_Einst_SuZIPTg_zeit_4_13"),
        607: Unknown("ID_Einst_SuSwb_akt"),
        608: Unknown("ID_Einst_SuSwbWo_zeit_0_0"),
        609: Unknown("ID_Einst_SuSwbWo_zeit_0_1"),
        610: Unknown("ID_Einst_SuSwbWo_zeit_1_0"),
        611: Unknown("ID_Einst_SuSwbWo_zeit_1_1"),
        612: Unknown("ID_Einst_SuSwbWo_zeit_2_0"),
        613: Unknown("ID_Einst_SuSwbWo_zeit_2_1"),
        614: Unknown("ID_Einst_SuSwb25_zeit_0_0"),
        615: Unknown("ID_Einst_SuSwb25_zeit_0_1"),
        616: Unknown("ID_Einst_SuSwb25_zeit_1_0"),
        617: Unknown("ID_Einst_SuSwb25_zeit_1_1"),
        618: Unknown("ID_Einst_SuSwb25_zeit_2_0"),
        619: Unknown("ID_Einst_SuSwb25_zeit_2_1"),
        620: Unknown("ID_Einst_SuSwb25_zeit_0_2"),
        621: Unknown("ID_Einst_SuSwb25_zeit_0_3"),
        622: Unknown("ID_Einst_SuSwb25_zeit_1_2"),
        623: Unknown("ID_Einst_SuSwb25_zeit_1_3"),
        624: Unknown("ID_Einst_SuSwb25_zeit_2_2"),
        625: Unknown("ID_Einst_SuSwb25_zeit_2_3"),
        626: Unknown("ID_Einst_SuSwbTg_zeit_0_0"),
        627: Unknown("ID_Einst_SuSwbTg_zeit_0_1"),
        628: Unknown("ID_Einst_SuSwbTg_zeit_1_0"),
        629: Unknown("ID_Einst_SuSwbTg_zeit_1_1"),
        630: Unknown("ID_Einst_SuSwbTg_zeit_2_0"),
        631: Unknown("ID_Einst_SuSwbTg_zeit_2_1"),
        632: Unknown("ID_Einst_SuSwbTg_zeit_0_2"),
        633: Unknown("ID_Einst_SuSwbTg_zeit_0_3"),
        634: Unknown("ID_Einst_SuSwbTg_zeit_1_2"),
        635: Unknown("ID_Einst_SuSwbTg_zeit_1_3"),
        636: Unknown("ID_Einst_SuSwbTg_zeit_2_2"),
        637: Unknown("ID_Einst_SuSwbTg_zeit_2_3"),
        638: Unknown("ID_Einst_SuSwbTg_zeit_0_4"),
        639: Unknown("ID_Einst_SuSwbTg_zeit_0_5"),
        640: Unknown("ID_Einst_SuSwbTg_zeit_1_4"),
        641: Unknown("ID_Einst_SuSwbTg_zeit_1_5"),
        642: Unknown("ID_Einst_SuSwbTg_zeit_2_4"),
        643: Unknown("ID_Einst_SuSwbTg_zeit_2_5"),
        644: Unknown("ID_Einst_SuSwbTg_zeit_0_6"),
        645: Unknown("ID_Einst_SuSwbTg_zeit_0_7"),
        646: Unknown("ID_Einst_SuSwbTg_zeit_1_6"),
        647: Unknown("ID_Einst_SuSwbTg_zeit_1_7"),
        648: Unknown("ID_Einst_SuSwbTg_zeit_2_6"),
        649: Unknown("ID_Einst_SuSwbTg_zeit_2_7"),
        650: Unknown("ID_Einst_SuSwbTg_zeit_0_8"),
        651: Unknown("ID_Einst_SuSwbTg_zeit_0_9"),
        652: Unknown("ID_Einst_SuSwbTg_zeit_1_8"),
        653: Unknown("ID_Einst_SuSwbTg_zeit_1_9"),
        654: Unknown("ID_Einst_SuSwbTg_zeit_2_8"),
        655: Unknown("ID_Einst_SuSwbTg_zeit_2_9"),
        656: Unknown("ID_Einst_SuSwbTg_zeit_0_10"),
        657: Unknown("ID_Einst_SuSwbTg_zeit_0_11"),
        658: Unknown("ID_Einst_SuSwbTg_zeit_1_10"),
        659: Unknown("ID_Einst_SuSwbTg_zeit_1_11"),
        660: Unknown("ID_Einst_SuSwbTg_zeit_2_10"),
        661: Unknown("ID_Einst_SuSwbTg_zeit_2_11"),
        662: Unknown("ID_Einst_SuSwbTg_zeit_0_12"),
        663: Unknown("ID_Einst_SuSwbTg_zeit_0_13"),
        664: Unknown("ID_Einst_SuSwbTg_zeit_1_12"),
        665: Unknown("ID_Einst_SuSwbTg_zeit_1_13"),
        666: Unknown("ID_Einst_SuSwbTg_zeit_2_12"),
        667: Unknown("ID_Einst_SuSwbTg_zeit_2_13"),
        668: Unknown("ID_Zaehler_BetrZeitWP"),
        669: Unknown("ID_Zaehler_BetrZeitVD1"),
        670: Unknown("ID_Zaehler_BetrZeitVD2"),
        671: Unknown("ID_Zaehler_BetrZeitZWE1"),
        672: Unknown("ID_Zaehler_BetrZeitZWE2"),
        673: Unknown("ID_Zaehler_BetrZeitZWE3"),
        674: Unknown("ID_Zaehler_BetrZeitImpVD1"),
        675: Unknown("ID_Zaehler_BetrZeitImpVD2"),
        676: Unknown("ID_Zaehler_BetrZeitEZMVD1"),
        677: Unknown("ID_Zaehler_BetrZeitEZMVD2"),
        678: Unknown("ID_Einst_Entl_Typ_0"),
        679: Unknown("ID_Einst_Entl_Typ_1"),
        680: Unknown("ID_Einst_Entl_Typ_2"),
        681: Unknown("ID_Einst_Entl_Typ_3"),
        682: Unknown("ID_Einst_Entl_Typ_4"),
        683: Unknown("ID_Einst_Entl_Typ_5"),
        684: Unknown("ID_Einst_Entl_Typ_6"),
        685: Unknown("ID_Einst_Entl_Typ_7"),
        686: Unknown("ID_Einst_Entl_Typ_8"),
        687: Unknown("ID_Einst_Entl_Typ_9"),
        688: Unknown("ID_Einst_Entl_Typ_10"),
        689: Unknown("ID_Einst_Entl_Typ_11"),
        690: Unknown("ID_Einst_Entl_Typ_12"),
        691: Unknown("ID_Einst_Vorl_max_MK1"),
        692: Unknown("ID_Einst_Vorl_max_MK2"),
        693: Unknown("ID_SU_FrkdMK1"),
        694: Unknown("ID_SU_FrkdMK2"),
        695: Unknown("ID_Ba_Hz_MK1_akt"),
        696: Unknown("ID_Ba_Hz_MK2_akt"),
        697: Unknown("ID_Einst_Zirk_Ein_akt"),
        698: Unknown("ID_Einst_Zirk_Aus_akt"),
        699: Unknown("ID_Einst_Heizgrenze"),
        700: Unknown("ID_Einst_Heizgrenze_Temp"),
        701: Unknown("ID_VariablenIBNgespeichert"),
        702: Unknown("ID_SchonIBNAssistant"),
        703: Unknown("ID_Heizgrenze_0"),
        704: Unknown("ID_Heizgrenze_1"),
        705: Unknown("ID_Heizgrenze_2"),
        706: Unknown("ID_Heizgrenze_3"),
        707: Unknown("ID_Heizgrenze_4"),
        708: Unknown("ID_Heizgrenze_5"),
        709: Unknown("ID_Heizgrenze_6"),
        710: Unknown("ID_Heizgrenze_7"),
        711: Unknown("ID_Heizgrenze_8"),
        712: Unknown("ID_Heizgrenze_9"),
        713: Unknown("ID_Heizgrenze_10"),
        714: Unknown("ID_Heizgrenze_11"),
        715: Unknown("ID_SchemenIBNgewahlt"),
        716: Unknown("ID_Switchoff_file_0_0"),
        717: Unknown("ID_Switchoff_file_1_0"),
        718: Unknown("ID_Switchoff_file_2_0"),
        719: Unknown("ID_Switchoff_file_3_0"),
        720: Unknown("ID_Switchoff_file_4_0"),
        721: Unknown("ID_Switchoff_file_0_1"),
        722: Unknown("ID_Switchoff_file_1_1"),
        723: Unknown("ID_Switchoff_file_2_1"),
        724: Unknown("ID_Switchoff_file_3_1"),
        725: Unknown("ID_Switchoff_file_4_1"),
        726: Unknown("ID_DauerDatenLoggerAktiv"),
        727: Unknown("ID_Laufvar_Heizgrenze"),
        728: Unknown("ID_Zaehler_BetrZeitHz"),
        729: Unknown("ID_Zaehler_BetrZeitBW"),
        730: Unknown("ID_Zaehler_BetrZeitKue"),
        731: Unknown("ID_SU_FstdHz"),
        732: Unknown("ID_SU_FstdBw"),
        733: Unknown("ID_SU_FstdSwb"),
        734: Unknown("ID_SU_FstdMK1"),
        735: Unknown("ID_SU_FstdMK2"),
        736: Unknown("ID_FerienAbsenkungHz"),
        737: Unknown("ID_FerienAbsenkungMK1"),
        738: Unknown("ID_FerienAbsenkungMK2"),
        739: Unknown("ID_FerienModusAktivHz"),
        740: Unknown("ID_FerienModusAktivBw"),
        741: Unknown("ID_FerienModusAktivSwb"),
        742: Unknown("ID_FerienModusAktivMk1"),
        743: Unknown("ID_FerienModusAktivMk2"),
        744: Unknown("ID_DisplayContrast_akt"),
        745: Unknown("ID_Ba_Hz_saved"),
        746: Unknown("ID_Ba_Bw_saved"),
        747: Unknown("ID_Ba_Sw_saved"),
        748: Unknown("ID_Ba_Hz_MK1_saved"),
        749: Unknown("ID_Ba_Hz_MK2_saved"),
        750: Unknown("ID_AdresseIP_akt"),
        751: Unknown("ID_SubNetMask_akt"),
        752: Unknown("ID_Add_Broadcast_akt"),
        753: Unknown("ID_Add_StdGateway_akt"),
        754: Unknown("ID_DHCPServerAktiv_akt"),
        755: Unknown("ID_WebserverPasswort_1_akt"),
        756: Unknown("ID_WebserverPasswort_2_akt"),
        757: Unknown("ID_WebserverPasswort_3_akt"),
        758: Unknown("ID_WebserverPasswort_4_akt"),
        759: Unknown("ID_WebserverPasswort_5_akt"),
        760: Unknown("ID_WebserverPasswort_6_akt"),
        761: Unknown("ID_WebServerWerteBekommen"),
        762: Unknown("ID_Einst_ParBetr_akt"),
        763: Unknown("ID_Einst_WpAnz_akt"),
        764: Unknown("ID_Einst_PhrTime_akt"),
        765: Unknown("ID_Einst_HysPar_akt"),
        766: Unknown("ID_IP_PB_Slave_0"),
        767: Unknown("ID_IP_PB_Slave_1"),
        768: Unknown("ID_IP_PB_Slave_2"),
        769: Unknown("ID_IP_PB_Slave_3"),
        770: Unknown("ID_IP_PB_Slave_4"),
        771: Unknown("ID_IP_PB_Slave_5"),
        772: Unknown("ID_Einst_BwHup_akt_backup"),
        773: Unknown("ID_Einst_SuMk3_akt"),
        774: Unknown("ID_Einst_HzMK3E_akt"),
        775: Unknown("ID_Einst_HzMK3ANH_akt"),
        776: Unknown("ID_Einst_HzMK3ABS_akt"),
        777: Unknown("ID_Einst_HzMK3Hgr_akt"),
        778: Unknown("ID_Einst_HzFtMK3Vl_akt"),
        779: MixedCircuitMode("ID_Ba_Hz_MK3_akt", True),
        780: Unknown("ID_Einst_MK3Typ_akt"),
        781: Unknown("ID_Einst_RTypMK3_akt"),
        782: Unknown("ID_Einst_MK3LzFaktor_akt"),
        783: Unknown("ID_Einst_MK3PerFaktor_akt"),
        784: Unknown("ID_FerienModusAktivMk3"),
        785: Unknown("ID_SU_FrkdMK3"),
        786: Unknown("ID_FerienAbsenkungMK3"),
        787: Unknown("ID_SU_FstdMK3"),
        788: Unknown("ID_Einst_SuMk3_akt2"),
        789: Unknown("ID_Einst_SuMk3Wo_zeit_0_0"),
        790: Unknown("ID_Einst_SuMk3Wo_zeit_0_1"),
        791: Unknown("ID_Einst_SuMk3Wo_zeit_1_0"),
        792: Unknown("ID_Einst_SuMk3Wo_zeit_1_1"),
        793: Unknown("ID_Einst_SuMk3Wo_zeit_2_0"),
        794: Unknown("ID_Einst_SuMk3Wo_zeit_2_1"),
        795: Unknown("ID_Einst_SuMk325_zeit_0_0"),
        796: Unknown("ID_Einst_SuMk325_zeit_0_1"),
        797: Unknown("ID_Einst_SuMk325_zeit_1_0"),
        798: Unknown("ID_Einst_SuMk325_zeit_1_1"),
        799: Unknown("ID_Einst_SuMk325_zeit_2_0"),
        800: Unknown("ID_Einst_SuMk325_zeit_2_1"),
        801: Unknown("ID_Einst_SuMk325_zeit_0_2"),
        802: Unknown("ID_Einst_SuMk325_zeit_0_3"),
        803: Unknown("ID_Einst_SuMk325_zeit_1_2"),
        804: Unknown("ID_Einst_SuMk325_zeit_1_3"),
        805: Unknown("ID_Einst_SuMk325_zeit_2_2"),
        806: Unknown("ID_Einst_SuMk325_zeit_2_3"),
        807: Unknown("ID_Einst_SuMk3Tg_zeit_0_0"),
        808: Unknown("ID_Einst_SuMk3Tg_zeit_0_1"),
        809: Unknown("ID_Einst_SuMk3Tg_zeit_1_0"),
        810: Unknown("ID_Einst_SuMk3Tg_zeit_1_1"),
        811: Unknown("ID_Einst_SuMk3Tg_zeit_2_0"),
        812: Unknown("ID_Einst_SuMk3Tg_zeit_2_1"),
        813: Unknown("ID_Einst_SuMk3Tg_zeit_0_2"),
        814: Unknown("ID_Einst_SuMk3Tg_zeit_0_3"),
        815: Unknown("ID_Einst_SuMk3Tg_zeit_1_2"),
        816: Unknown("ID_Einst_SuMk3Tg_zeit_1_3"),
        817: Unknown("ID_Einst_SuMk3Tg_zeit_2_2"),
        818: Unknown("ID_Einst_SuMk3Tg_zeit_2_3"),
        819: Unknown("ID_Einst_SuMk3Tg_zeit_0_4"),
        820: Unknown("ID_Einst_SuMk3Tg_zeit_0_5"),
        821: Unknown("ID_Einst_SuMk3Tg_zeit_1_4"),
        822: Unknown("ID_Einst_SuMk3Tg_zeit_1_5"),
        823: Unknown("ID_Einst_SuMk3Tg_zeit_2_4"),
        824: Unknown("ID_Einst_SuMk3Tg_zeit_2_5"),
        825: Unknown("ID_Einst_SuMk3Tg_zeit_0_6"),
        826: Unknown("ID_Einst_SuMk3Tg_zeit_0_7"),
        827: Unknown("ID_Einst_SuMk3Tg_zeit_1_6"),
        828: Unknown("ID_Einst_SuMk3Tg_zeit_1_7"),
        829: Unknown("ID_Einst_SuMk3Tg_zeit_2_6"),
        830: Unknown("ID_Einst_SuMk3Tg_zeit_2_7"),
        831: Unknown("ID_Einst_SuMk3Tg_zeit_0_8"),
        832: Unknown("ID_Einst_SuMk3Tg_zeit_0_9"),
        833: Unknown("ID_Einst_SuMk3Tg_zeit_1_8"),
        834: Unknown("ID_Einst_SuMk3Tg_zeit_1_9"),
        835: Unknown("ID_Einst_SuMk3Tg_zeit_2_8"),
        836: Unknown("ID_Einst_SuMk3Tg_zeit_2_9"),
        837: Unknown("ID_Einst_SuMk3Tg_zeit_0_10"),
        838: Unknown("ID_Einst_SuMk3Tg_zeit_0_11"),
        839: Unknown("ID_Einst_SuMk3Tg_zeit_1_10"),
        840: Unknown("ID_Einst_SuMk3Tg_zeit_1_11"),
        841: Unknown("ID_Einst_SuMk3Tg_zeit_2_10"),
        842: Unknown("ID_Einst_SuMk3Tg_zeit_2_11"),
        843: Unknown("ID_Einst_SuMk3Tg_zeit_0_12"),
        844: Unknown("ID_Einst_SuMk3Tg_zeit_0_13"),
        845: Unknown("ID_Einst_SuMk3Tg_zeit_1_12"),
        846: Unknown("ID_Einst_SuMk3Tg_zeit_1_13"),
        847: Unknown("ID_Einst_SuMk3Tg_zeit_2_12"),
        848: Unknown("ID_Einst_SuMk3Tg_zeit_2_13"),
        849: Unknown("ID_Ba_Hz_MK3_saved"),
        850: Hours("ID_Einst_Kuhl_Zeit_Ein_akt", True),
        851: Hours("ID_Einst_Kuhl_Zeit_Aus_akt", True),
        852: Unknown("ID_Waermemenge_Seit"),
        853: Unknown("ID_Waermemenge_WQ"),
        854: Unknown("ID_Waermemenge_Hz"),
        855: Unknown("ID_Waermemenge_WQ_ges"),
        856: Unknown("ID_Einst_Entl_Typ_13"),
        857: Unknown("ID_Einst_Entl_Typ_14"),
        858: Unknown("ID_Einst_Entl_Typ_15"),
        859: Unknown("ID_Zaehler_BetrZeitSW"),
        860: Unknown("ID_Einst_Fernwartung_akt"),
        861: Unknown("ID_AdresseIPServ_akt"),
        862: Unknown("ID_Einst_TA_EG_akt"),
        863: Unknown("ID_Einst_TVLmax_EG_akt"),
        864: Unknown("ID_Einst_Popt_Nachlauf_akt"),
        865: Unknown("ID_FernwartungVertrag_akt"),
        866: Unknown("ID_FernwartungAktuZeit"),
        867: Unknown("ID_Einst_Effizienzpumpe_Nominal_akt"),
        868: Unknown("ID_Einst_Effizienzpumpe_Minimal_akt"),
        869: Unknown("ID_Einst_Effizienzpumpe_akt"),
        870: Unknown("ID_Einst_Waermemenge_akt"),
        871: Unknown("ID_Einst_Wm_Versorgung_Korrektur_akt"),
        872: Unknown("ID_Einst_Wm_Auswertung_Korrektur_akt"),
        873: Unknown("ID_SoftwareUpdateJetztGemacht_akt"),
        874: Unknown("ID_WP_SerienNummer_DATUM"),
        875: Unknown("ID_WP_SerienNummer_HEX"),
        876: Unknown("ID_WP_SerienNummer_INDEX"),
        877: Unknown("ID_ProgWerteWebSrvBeobarten"),
        878: Unknown("ID_Waermemenge_BW"),
        879: Unknown("ID_Waermemenge_SW"),
        880: Unknown("ID_Waermemenge_Datum"),
        881: SolarMode("ID_Einst_Solar_akt", True),
        882: Unknown("ID_BSTD_Solar"),
        883: Unknown("ID_Einst_TDC_Koll_Max_akt"),
        884: Unknown("ID_Einst_Akt_Kuehlung_akt"),
        885: Unknown("ID_Einst_Vorlauf_VBO_akt"),
        886: Unknown("ID_Einst_KRHyst_akt"),
        887: Unknown("ID_Einst_Akt_Kuehl_Speicher_min_akt"),
        888: Unknown("ID_Einst_Akt_Kuehl_Freig_WQE_akt"),
        889: Unknown("ID_NDAB_WW_Anzahl"),
        890: Unknown("ID_NDS_WW_KD_Quitt"),
        891: Unknown("ID_Einst_AbtZykMin_akt"),
        892: Unknown("ID_Einst_VD2_Zeit_Min_akt"),
        893: Unknown("ID_Einst_Hysterese_HR_verkuerzt_akt"),
        894: VentilationMode("ID_Einst_BA_Lueftung_akt", True),
        895: Unknown("ID_Einst_SuLuf_akt"),
        896: Unknown("ID_Einst_SuLufWo_zeit_0_0_0"),
        897: Unknown("ID_Einst_SuLufWo_zeit_0_1_0"),
        898: Unknown("ID_Einst_SuLufWo_zeit_0_2_0"),
        899: Unknown("ID_Einst_SuLuf25_zeit_0_0_0"),
        900: Unknown("ID_Einst_SuLuf25_zeit_0_1_0"),
        901: Unknown("ID_Einst_SuLuf25_zeit_0_2_0"),
        902: Unknown("ID_Einst_SuLuf25_zeit_0_0_2"),
        903: Unknown("ID_Einst_SuLuf25_zeit_0_1_2"),
        904: Unknown("ID_Einst_SuLuf25_zeit_0_2_2"),
        905: Unknown("ID_Einst_SuLufTg_zeit_0_0_0"),
        906: Unknown("ID_Einst_SuLufTg_zeit_0_1_0"),
        907: Unknown("ID_Einst_SuLufTg_zeit_0_2_0"),
        908: Unknown("ID_Einst_SuLufTg_zeit_0_0_2"),
        909: Unknown("ID_Einst_SuLufTg_zeit_0_1_2"),
        910: Unknown("ID_Einst_SuLufTg_zeit_0_2_2"),
        911: Unknown("ID_Einst_SuLufTg_zeit_0_0_4"),
        912: Unknown("ID_Einst_SuLufTg_zeit_0_1_4"),
        913: Unknown("ID_Einst_SuLufTg_zeit_0_2_4"),
        914: Unknown("ID_Einst_SuLufTg_zeit_0_0_6"),
        915: Unknown("ID_Einst_SuLufTg_zeit_0_1_6"),
        916: Unknown("ID_Einst_SuLufTg_zeit_0_2_6"),
        917: Unknown("ID_Einst_SuLufTg_zeit_0_0_8"),
        918: Unknown("ID_Einst_SuLufTg_zeit_0_1_8"),
        919: Unknown("ID_Einst_SuLufTg_zeit_0_2_8"),
        920: Unknown("ID_Einst_SuLufTg_zeit_0_0_10"),
        921: Unknown("ID_Einst_SuLufTg_zeit_0_1_10"),
        922: Unknown("ID_Einst_SuLufTg_zeit_0_2_10"),
        923: Unknown("ID_Einst_SuLufTg_zeit_0_0_12"),
        924: Unknown("ID_Einst_SuLufTg_zeit_0_1_12"),
        925: Unknown("ID_Einst_SuLufTg_zeit_0_2_12"),
        926: Unknown("ID_Einst_SuLufWo_zeit_1_0_0"),
        927: Unknown("ID_Einst_SuLufWo_zeit_1_1_0"),
        928: Unknown("ID_Einst_SuLufWo_zeit_1_2_0"),
        929: Unknown("ID_Einst_SuLuf25_zeit_1_0_0"),
        930: Unknown("ID_Einst_SuLuf25_zeit_1_1_0"),
        931: Unknown("ID_Einst_SuLuf25_zeit_1_2_0"),
        932: Unknown("ID_Einst_SuLuf25_zeit_1_0_2"),
        933: Unknown("ID_Einst_SuLuf25_zeit_1_1_2"),
        934: Unknown("ID_Einst_SuLuf25_zeit_1_2_2"),
        935: Unknown("ID_Einst_SuLufTg_zeit_1_0_0"),
        936: Unknown("ID_Einst_SuLufTg_zeit_1_1_0"),
        937: Unknown("ID_Einst_SuLufTg_zeit_1_2_0"),
        938: Unknown("ID_Einst_SuLufTg_zeit_1_0_2"),
        939: Unknown("ID_Einst_SuLufTg_zeit_1_1_2"),
        940: Unknown("ID_Einst_SuLufTg_zeit_1_2_2"),
        941: Unknown("ID_Einst_SuLufTg_zeit_1_0_4"),
        942: Unknown("ID_Einst_SuLufTg_zeit_1_1_4"),
        943: Unknown("ID_Einst_SuLufTg_zeit_1_2_4"),
        944: Unknown("ID_Einst_SuLufTg_zeit_1_0_6"),
        945: Unknown("ID_Einst_SuLufTg_zeit_1_1_6"),
        946: Unknown("ID_Einst_SuLufTg_zeit_1_2_6"),
        947: Unknown("ID_Einst_SuLufTg_zeit_1_0_8"),
        948: Unknown("ID_Einst_SuLufTg_zeit_1_1_8"),
        949: Unknown("ID_Einst_SuLufTg_zeit_1_2_8"),
        950: Unknown("ID_Einst_SuLufTg_zeit_1_0_10"),
        951: Unknown("ID_Einst_SuLufTg_zeit_1_1_10"),
        952: Unknown("ID_Einst_SuLufTg_zeit_1_2_10"),
        953: Unknown("ID_Einst_SuLufTg_zeit_1_0_12"),
        954: Unknown("ID_Einst_SuLufTg_zeit_1_1_12"),
        955: Unknown("ID_Einst_SuLufTg_zeit_1_2_12"),
        956: Unknown("ID_FerienModusAktivLueftung"),
        957: Unknown("ID_Einst_BA_Lueftung_saved"),
        958: Unknown("ID_SU_FrkdLueftung"),
        959: Unknown("ID_SU_FstdLueftung"),
        960: Unknown("ID_Einst_Luf_Feuchteschutz_akt"),
        961: Unknown("ID_Einst_Luf_Reduziert_akt"),
        962: Unknown("ID_Einst_Luf_Nennlueftung_akt"),
        963: Unknown("ID_Einst_Luf_Intensivlueftung_akt"),
        964: Unknown("ID_Timer_Fil_4Makt"),
        965: Unknown("ID_Timer_Fil_WoAkt"),
        966: Celsius("ID_Sollwert_KuCft3_akt", True),
        967: Celsius("ID_Sollwert_AtDif3_akt", True),
        968: Unknown("ID_Bitmaske_0"),
        969: Unknown("ID_Einst_Lueftungsstufen"),
        970: Unknown("ID_SysEin_Meldung_TDI"),
        971: Unknown("ID_SysEin_Typ_WZW"),
        972: Unknown("ID_Einst_GLT_aktiviert"),
        973: Unknown("ID_Einst_BW_max"),
        974: Unknown("ID_Einst_Sollwert_TRL_Kuehlen"),
        975: Unknown("ID_Einst_Medium_Waermequelle"),
        976: Unknown("ID_Einst_Photovoltaik_akt"),
        977: Unknown("ID_Einst_Multispeicher_akt"),
        978: Unknown("ID_Einst_PKuehlTime_akt"),
        979: Unknown("ID_Einst_Minimale_Ruecklaufsolltemperatur"),
        980: Unknown("ID_RBE_Einflussfaktor_RT_akt"),
        981: Unknown("ID_RBE_Freigabe_Kuehlung_akt"),
        982: Unknown("ID_RBE_Waermeverteilsystem_akt"),
        983: Unknown("ID_RBE_Zeit_Heizstab_aktiv"),
        984: Unknown("ID_SEC_ND_Alarmgrenze"),
        985: Unknown("ID_SEC_HD_Alarmgrenze"),
        986: Unknown("ID_SEC_Abtauendtemperatur"),
        987: Unknown("ID_Einst_Min_RPM_BW"),
        988: Unknown("ID_Einst_Luf_Feuchteschutz_Faktor_akt"),
        989: Unknown("ID_Einst_Luf_Reduziert_Faktor_akt"),
        990: Unknown("ID_Einst_Luf_Nennlueftung_Faktor_akt"),
        991: Unknown("ID_Einst_Luf_Intensivlueftung_Faktor_akt"),
        992: Unknown("ID_Einst_Freigabe_Zeit_ZWE"),
        993: Unknown("ID_Einst_min_VL_Kuehl"),
        994: Unknown("ID_Einst_Warmwasser_Nachheizung"),
        995: Unknown("ID_Switchoff_file_LWD2_0_0"),
        996: Unknown("ID_Switchoff_file_LWD2_1_0"),
        997: Unknown("ID_Switchoff_file_LWD2_2_0"),
        998: Unknown("ID_Switchoff_file_LWD2_3_0"),
        999: Unknown("ID_Switchoff_file_LWD2_4_0"),
        1000: Unknown("ID_Switchoff_file_LWD2_0_1"),
        1001: Unknown("ID_Switchoff_file_LWD2_1_1"),
        1002: Unknown("ID_Switchoff_file_LWD2_2_1"),
        1003: Unknown("ID_Switchoff_file_LWD2_3_1"),
        1004: Unknown("ID_Switchoff_file_LWD2_4_1"),
        1005: Unknown("ID_Switchoff_index_LWD2"),
        1006: Unknown("ID_Einst_Effizienzpumpe_Nominal_2"),
        1007: Unknown("ID_Einst_Effizienzpumpe_Minimal_2"),
        1008: Unknown("ID_Einst_Wm_Versorgung_Korrektur_2"),
        1009: Unknown("ID_Einst_Wm_Auswertung_Korrektur_2"),
        1010: Unknown("ID_Einst_isTwin"),
        1011: Unknown("ID_Einst_TAmin_2"),
        1012: Unknown("ID_Einst_TVLmax_2"),
        1013: Unknown("ID_Einst_TA_EG_2"),
        1014: Unknown("ID_Einst_TVLmax_EG_2"),
        1015: Unknown("ID_Waermemenge_Hz_2"),
        1016: Unknown("ID_Waermemenge_BW_2"),
        1017: Unknown("ID_Waermemenge_SW_2"),
        1018: Unknown("ID_Waermemenge_Seit_2"),
        1019: Unknown("ID_Einst_Entl_Typ_15_2"),
        1020: Unknown("ID_Einst_WW_Nachheizung_max"),
        1021: Unknown("ID_Einst_Kuhl_Zeit_Ein_RT"),
        1022: Unknown("ID_Einst_ZWE1_Pos"),
        1023: Unknown("ID_Einst_ZWE2_Pos"),
        1024: Unknown("ID_Einst_ZWE3_Pos"),
        1025: Unknown("ID_Einst_Leistung_ZWE"),
        1026: Unknown("ID_WP_SN2_DATUM"),
        1027: Unknown("ID_WP_SN2_HEX"),
        1028: Unknown("ID_WP_SN2_INDEX"),
        1029: Unknown("ID_CWP_saved2"),
        1030: Unknown("ID_Einst_SmartGrid"),
        1031: Unknown("ID_Einst_P155_HDS"),
        1032: Unknown("ID_Einst_P155_PumpHeat_Max"),
        1033: Unknown("ID_Einst_P155_PumpHeatCtrl"),
        1034: Unknown("ID_Einst_P155_PumpDHWCtrl"),
        1035: Unknown("ID_Einst_P155_PumpDHW_RPM"),
        1036: Unknown("ID_Einst_P155_PumpPoolCtrl"),
        1037: Unknown("ID_Einst_P155_PumpPool_RPM"),
        1038: Unknown("ID_Einst_P155_PumpCool_RPM"),
        1039: Unknown("ID_Einst_P155_PumpVBOCtrl"),
        1040: Unknown("ID_Einst_P155_PumpVBO_RPM_C"),
        1041: Unknown("ID_Einst_P155_PumpDHW_Max"),
        1042: Unknown("ID_Einst_P155_PumpPool_Max"),
        1043: Unknown("ID_Einst_P155_Sperrband_1"),
        1044: Unknown("ID_Einst_P155_Leistungsfreigabe"),
        1045: Unknown("ID_Einst_P155_DHW_Freq"),
        1046: Unknown("ID_Einst_SWHUP"),
        1047: Unknown("ID_Einst_P155_SWB_Freq"),
        1048: Unknown("ID_Einst_MK1_Regelung"),
        1049: Unknown("ID_Einst_MK2_Regelung"),
        1050: Unknown("ID_Einst_MK3_Regelung"),
        1051: Unknown("ID_Einst_PV_WW_Sperrzeit"),
        1052: Unknown("ID_Einst_Warmwasser_extra"),
        1053: Unknown("ID_Einst_Vorl_akt_Kuehl"),
        1054: Unknown("ID_WP_SN3_DATUM"),
        1055: Unknown("ID_WP_SN3_HEX"),
        1056: Unknown("ID_WP_SN3_INDEX"),
        1057: Unknown("ID_Einst_Vorlauf_ZUP"),
        1058: Unknown("ID_Einst_Abtauen_im_Warmwasser"),
        1059: Unknown("ID_Waermemenge_ZWE"),
        1060: Unknown("ID_Waermemenge_Reset"),
        1061: Unknown("ID_Waermemenge_Reset_2"),
        1062: Unknown("ID_Einst_Brunnenpumpe_min"),
        1063: Unknown("ID_Einst_Brunnenpumpe_max"),
        1064: Unknown("ID_Einst_SmartHomeID"),
        1065: Unknown("ID_Einst_SmartHK"),
        1066: Unknown("ID_Einst_SmartMK1"),
        1067: Unknown("ID_Einst_SmartMK2"),
        1068: Unknown("ID_Einst_SmartMK3"),
        1069: Unknown("ID_Einst_SmartWW"),
        1070: Unknown("ID_Einst_SmartDefrost"),
        1071: Unknown("ID_Einst_Empty1071"),
        1072: Unknown("ID_Einst_MinVLMK1"),
        1073: Unknown("ID_Einst_MinVLMK2"),
        1074: Unknown("ID_Einst_MinVLMK3"),
        1075: Unknown("ID_Einst_MaxVLMK1"),
        1076: Unknown("ID_Einst_MaxVLMK2"),
        1077: Unknown("ID_Einst_MaxVLMK3"),
        1078: Unknown("ID_Einst_SmartPlusHz"),
        1079: Unknown("ID_Einst_SmartMinusHz"),
        1080: Unknown("ID_Einst_SmartPlusMK1"),
        1081: Unknown("ID_Einst_SmartMinusMK1"),
        1082: Unknown("ID_Einst_SmartPlusMK2"),
        1083: Unknown("ID_Einst_SmartMinusMK2"),
        1084: Unknown("ID_Einst_SmartPlusMK3"),
        1085: Unknown("ID_Einst_SmartMinusMK3"),
        1086: Unknown("Unknown_Parameter_1086"),
        1087: Unknown("Unknown_Parameter_1087"),
        1088: Unknown("Unknown_Parameter_1088"),
        1089: Unknown("Unknown_Parameter_1089"),
        1090: Unknown("Unknown_Parameter_1090"),
        1091: Unknown("Unknown_Parameter_1091"),
        1092: Unknown("Unknown_Parameter_1092"),
        1093: Unknown("Unknown_Parameter_1093"),
        1094: Unknown("Unknown_Parameter_1094"),
        1095: Unknown("Unknown_Parameter_1095"),
        1096: Unknown("Unknown_Parameter_1096"),
        1097: Unknown("Unknown_Parameter_1097"),
        1098: Unknown("Unknown_Parameter_1098"),
        1099: Unknown("Unknown_Parameter_1099"),
        1100: Unknown("Unknown_Parameter_1100"),
        1101: Unknown("Unknown_Parameter_1101"),
        1102: Unknown("Unknown_Parameter_1102"),
        1103: Unknown("Unknown_Parameter_1103"),
        1104: Unknown("Unknown_Parameter_1104"),
        1105: Unknown("Unknown_Parameter_1105"),
        1106: Unknown("Unknown_Parameter_1106"),
        1107: Unknown("Unknown_Parameter_1107"),
        1108: Unknown("Unknown_Parameter_1108"),
        1109: Unknown("Unknown_Parameter_1109"),
        1110: Unknown("Unknown_Parameter_1110"),
        1111: Unknown("Unknown_Parameter_1111"),
        1112: Unknown("Unknown_Parameter_1112"),
        1113: Unknown("Unknown_Parameter_1113"),
        1114: Unknown("Unknown_Parameter_1114"),
        1115: Unknown("Unknown_Parameter_1115"),
        1116: Unknown("Unknown_Parameter_1116"),
        1117: Unknown("Unknown_Parameter_1117"),
        1118: Unknown("Unknown_Parameter_1118"),
        1119: Unknown("Unknown_Parameter_1119"),
        1120: Unknown("Unknown_Parameter_1120"),
        1121: Unknown("Unknown_Parameter_1121"),
        1122: Unknown("Unknown_Parameter_1122"),
        1123: Unknown("Unknown_Parameter_1123"),
        1124: Unknown("Unknown_Parameter_1124"),
    }

    def __init__(self, safe=True):
        """Initialize parameters class."""
        self.safe = safe
        self.queue = {}

    def parse(self, raw_data):
        """Parse raw parameter data."""
        for index, data in enumerate(raw_data):
            parameter = self.parameters.get(index, False)
            if parameter is not False:
                parameter.value = parameter.from_heatpump(data)
            else:
                LOGGER.warning("Parameter '%d' not in list of parameters", index)

    def _lookup(self, target):
        """Lookup parameter by either id or name."""
        if isinstance(target, int):
            return target, self.parameters.get(target, None)
        if isinstance(target, str):
            try:
                target = int(target)
                return target, self.parameters.get(target, None)
            except ValueError:
                for index, parameter in self.parameters.items():
                    if parameter.name == target:
                        return index, parameter
        LOGGER.warning("Parameter '%s' not found", target)
        return None, None

    def get(self, target):
        """Get parameter by id or name."""
        index, parameter = self._lookup(target)
        return index, parameter

    def set(self, target, value):
        """Set parameter to new value."""
        index, parameter = self._lookup(target)
        if index:
            if parameter.writeable or not self.safe:
                self.queue[index] = parameter.to_heatpump(value)
            else:
                LOGGER.warning("Parameter '%s' not safe for writing!", parameter.name)
