from . import ParameterType, ParameterCategory


NAME_PTYPE_MAP = {
    "w": ParameterType.BEAMSIZE,
    "w1": ParameterType.BEAMSIZE_M1,
    "w2": ParameterType.BEAMSIZE_M2,
    "g": ParameterType.CAV_GFACTOR,
    "L": ParameterType.CAV_LENGTH,
    "div": ParameterType.DIVERGENCE,
    "finesse": ParameterType.FINESSE,
    "FSR": ParameterType.FSR,
    "FWHM": ParameterType.FWHM,
    "g1": ParameterType.GFACTOR_M1,
    "g2": ParameterType.GFACTOR_M2,
    "gouy": ParameterType.GOUY,
    "gs": ParameterType.GFACTOR_SINGLE,
    "L1": ParameterType.LOSS_M1,
    "L2": ParameterType.LOSS_M2,
    "modesep": ParameterType.MODESEP,
    "pole": ParameterType.POLE,
    "R1": ParameterType.REFLECTIVITY_M1,
    "R2": ParameterType.REFLECTIVITY_M2,
    "Rc": ParameterType.ROC,
    "Rc1": ParameterType.ROC_M1,
    "Rc2": ParameterType.ROC_M2,
    "T1": ParameterType.TRANSMISSION_M1,
    "T2": ParameterType.TRANSMISSION_M2,
    "z0": ParameterType.WAISTPOS,
    "w0": ParameterType.WAISTSIZE,
    "wl": ParameterType.WAVELENGTH,
}

PTYPE_NAME_MAP = {ptype: pname for pname, ptype in NAME_PTYPE_MAP.items()}

PTYPE_CATEGORY_MAP = {
    ParameterType.DIVERGENCE: ParameterCategory.Angle,
    ParameterType.BEAMSIZE: ParameterCategory.BeamRadius,
    ParameterType.BEAMSIZE_M1: ParameterCategory.BeamRadius,
    ParameterType.BEAMSIZE_M2: ParameterCategory.BeamRadius,
    ParameterType.WAISTSIZE: ParameterCategory.BeamRadius,
    ParameterType.ROC: ParameterCategory.Curvature,
    ParameterType.ROC_M1: ParameterCategory.Curvature,
    ParameterType.ROC_M2: ParameterCategory.Curvature,
    ParameterType.CAV_LENGTH: ParameterCategory.Distance,
    ParameterType.WAISTPOS: ParameterCategory.Distance,
    ParameterType.FSR: ParameterCategory.Frequency,
    ParameterType.FWHM: ParameterCategory.Frequency,
    ParameterType.POLE: ParameterCategory.Frequency,
    ParameterType.MODESEP: ParameterCategory.Frequency,
    ParameterType.GOUY: ParameterCategory.Phase,
    ParameterType.LOSS_M1: ParameterCategory.Power,
    ParameterType.LOSS_M2: ParameterCategory.Power,
    ParameterType.REFLECTIVITY_M1: ParameterCategory.Power,
    ParameterType.REFLECTIVITY_M2: ParameterCategory.Power,
    ParameterType.TRANSMISSION_M1: ParameterCategory.Power,
    ParameterType.TRANSMISSION_M2: ParameterCategory.Power,
    ParameterType.FINESSE: ParameterCategory.Power,
    ParameterType.CAV_GFACTOR: ParameterCategory.Stability,
    ParameterType.GFACTOR_SINGLE: ParameterCategory.Stability,
    ParameterType.GFACTOR_M1: ParameterCategory.Stability,
    ParameterType.GFACTOR_M2: ParameterCategory.Stability,
    ParameterType.WAVELENGTH: ParameterCategory.Wave,
}

PTYPE_DESCR_MAP = {
    ParameterType.BEAMSIZE: "Radius of beam at mirrors",
    ParameterType.BEAMSIZE_M1: "Radius of beam at first mirror",
    ParameterType.BEAMSIZE_M2: "Radius of beam at second mirror",
    ParameterType.CAV_GFACTOR: "Stability g-factor of cavity",
    ParameterType.CAV_LENGTH: "Cavity length",
    ParameterType.DIVERGENCE: "Divergence angle",
    ParameterType.FINESSE: "Finesse",
    ParameterType.FSR: "FSR",
    ParameterType.FWHM: "FWHM",
    ParameterType.GFACTOR_M1: "Stability g-factor of first mirror",
    ParameterType.GFACTOR_M2: "Stability g-factor of second mirror",
    ParameterType.GFACTOR_SINGLE: "Stability g-factor of both mirrors",
    ParameterType.GOUY: "Round-trip Gouy phase",
    ParameterType.LOSS_M1: "Loss of first mirror",
    ParameterType.LOSS_M2: "Loss of second mirror",
    ParameterType.MODESEP: "Mode separation frequency",
    ParameterType.POLE: "Pole frequency",
    ParameterType.REFLECTIVITY_M1: "Reflectivity of first mirror",
    ParameterType.REFLECTIVITY_M2: "Reflectivity of second mirror",
    ParameterType.ROC: "Radius of curvature of both mirrors",
    ParameterType.ROC_M1: "Radius of curvature of first mirror",
    ParameterType.ROC_M2: "Radius of curvature of second mirror",
    ParameterType.TRANSMISSION_M1: "Transmission of first mirror",
    ParameterType.TRANSMISSION_M2: "Transmission of second mirror",
    ParameterType.WAISTPOS: "Position of beam waist (from first mirror)",
    ParameterType.WAISTSIZE: "Radius of beam at waist",
    ParameterType.WAVELENGTH: "Wavelength of beam",
}

PTYPE_SYMBOL_MAP = {
    ParameterType.BEAMSIZE: "$w$",
    ParameterType.BEAMSIZE_M1: "$w_1$",
    ParameterType.BEAMSIZE_M2: "$w_2$",
    ParameterType.CAV_GFACTOR: "$g$",
    ParameterType.CAV_LENGTH: "$L$",
    ParameterType.DIVERGENCE: r"$\theta$",
    ParameterType.FINESSE: r"$\mathcal{F}$",
    ParameterType.FSR: r"$\Delta \nu_{\mathrm{FSR}}$",
    ParameterType.FWHM: "FWHM",
    ParameterType.GFACTOR_M1: "$g_1$",
    ParameterType.GFACTOR_M2: "$g_2$",
    ParameterType.GFACTOR_SINGLE: "$g_s$",
    ParameterType.GOUY: r"$\psi$",
    ParameterType.LOSS_M1: "$L_1$",
    ParameterType.LOSS_M2: "$L_2$",
    ParameterType.MODESEP: r"$\delta f$",
    ParameterType.POLE: r"$\nu_p$",
    ParameterType.REFLECTIVITY_M1: "$R_1$",
    ParameterType.REFLECTIVITY_M2: "$R_2$",
    ParameterType.ROC: "$R_C$",
    ParameterType.ROC_M1: "$R_{C,1}$",
    ParameterType.ROC_M2: "$R_{C,2}$",
    ParameterType.TRANSMISSION_M1: "$T_1$",
    ParameterType.TRANSMISSION_M2: "$T_2$",
    ParameterType.WAISTPOS: "$z_0$",
    ParameterType.WAISTSIZE: "$w_0$",
    ParameterType.WAVELENGTH: r"$\lambda$",
}
