# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Project']


class Project(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_transfer: Optional[pulumi.Input[bool]] = None,
                 bgp_config: Optional[pulumi.Input[pulumi.InputType['ProjectBgpConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 payment_method_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Packet project resource to allow you manage devices
        in your projects.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_packet as packet

        # Create a new project
        tf_project1 = packet.Project("tfProject1", name="Terraform Fun")
        ```

        Example with BGP config

        ```python
        import pulumi
        import pulumi_packet as packet

        # Create a new Project
        tf_project1 = packet.Project("tfProject1",
            bgp_config=packet.ProjectBgpConfigArgs(
                asn=65000,
                deployment_type="local",
                md5="C179c28c41a85b",
            ),
            name="tftest")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backend_transfer: Enable or disable [Backend Transfer](https://www.packet.com/developers/docs/network/basic/backend-transfer/), default is false
        :param pulumi.Input[pulumi.InputType['ProjectBgpConfigArgs']] bgp_config: Optional BGP settings. Refer to [Packet guide for BGP](https://www.packet.com/developers/docs/network/advanced/local-and-global-bgp/).
        :param pulumi.Input[str] name: The name of the project
        :param pulumi.Input[str] organization_id: The UUID of organization under which you want to create the project. If you leave it out, the project will be create under your the default organization of your account.
        :param pulumi.Input[str] payment_method_id: The UUID of payment method for this project. The payment method and the project need to belong to the same organization (passed with `organization_id`, or default).
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['backend_transfer'] = backend_transfer
            __props__['bgp_config'] = bgp_config
            if name is None:
                raise TypeError("Missing required property 'name'")
            __props__['name'] = name
            __props__['organization_id'] = organization_id
            __props__['payment_method_id'] = payment_method_id
            __props__['created'] = None
            __props__['updated'] = None
        super(Project, __self__).__init__(
            'packet:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_transfer: Optional[pulumi.Input[bool]] = None,
            bgp_config: Optional[pulumi.Input[pulumi.InputType['ProjectBgpConfigArgs']]] = None,
            created: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            payment_method_id: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backend_transfer: Enable or disable [Backend Transfer](https://www.packet.com/developers/docs/network/basic/backend-transfer/), default is false
        :param pulumi.Input[pulumi.InputType['ProjectBgpConfigArgs']] bgp_config: Optional BGP settings. Refer to [Packet guide for BGP](https://www.packet.com/developers/docs/network/advanced/local-and-global-bgp/).
        :param pulumi.Input[str] created: The timestamp for when the project was created
        :param pulumi.Input[str] name: The name of the project
        :param pulumi.Input[str] organization_id: The UUID of organization under which you want to create the project. If you leave it out, the project will be create under your the default organization of your account.
        :param pulumi.Input[str] payment_method_id: The UUID of payment method for this project. The payment method and the project need to belong to the same organization (passed with `organization_id`, or default).
        :param pulumi.Input[str] updated: The timestamp for the last time the project was updated
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend_transfer"] = backend_transfer
        __props__["bgp_config"] = bgp_config
        __props__["created"] = created
        __props__["name"] = name
        __props__["organization_id"] = organization_id
        __props__["payment_method_id"] = payment_method_id
        __props__["updated"] = updated
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendTransfer")
    def backend_transfer(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable [Backend Transfer](https://www.packet.com/developers/docs/network/basic/backend-transfer/), default is false
        """
        return pulumi.get(self, "backend_transfer")

    @property
    @pulumi.getter(name="bgpConfig")
    def bgp_config(self) -> pulumi.Output[Optional['outputs.ProjectBgpConfig']]:
        """
        Optional BGP settings. Refer to [Packet guide for BGP](https://www.packet.com/developers/docs/network/advanced/local-and-global-bgp/).
        """
        return pulumi.get(self, "bgp_config")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The timestamp for when the project was created
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the project
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The UUID of organization under which you want to create the project. If you leave it out, the project will be create under your the default organization of your account.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="paymentMethodId")
    def payment_method_id(self) -> pulumi.Output[str]:
        """
        The UUID of payment method for this project. The payment method and the project need to belong to the same organization (passed with `organization_id`, or default).
        """
        return pulumi.get(self, "payment_method_id")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The timestamp for the last time the project was updated
        """
        return pulumi.get(self, "updated")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

