# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rivuletpy', 'rivuletpy.utils']

package_data = \
{'': ['*'], 'rivuletpy': ['msfm/*']}

install_requires = \
['Cython>=0.29.32,<0.30.0',
 'matplotlib>=3.6.0,<4.0.0',
 'nibabel>=4.0.2,<5.0.0',
 'numpy>=1.23.3,<2.0.0',
 'pyglet>=1.5.27,<2.0.0',
 'pylibtiff>=0.4.4,<0.5.0',
 'scikit-fmm>=2022.8.15,<2023.0.0',
 'scikit-image>=0.18,<0.19',
 'scipy>=1.9.1,<2.0.0',
 'tqdm>=4.64.1,<5.0.0']

setup_kwargs = {
    'name': 'rivuletpy',
    'version': '0.3.0',
    'description': 'Rivuletpy: a powerful tool to automatically trace single neurons from 3D light microscopic images.',
    'long_description': '<!--\n Copyright (c) 2016, RivuletStudio, The University of Sydney, AU\n All rights reserved.\n\n This file is part of Rivuletpy <https://github.com/RivuletStudio/rivuletpy>\n\n Redistribution and use in source and binary forms, with or without\n modification, are permitted provided that the following conditions are met:\n\n     1. Redistributions of source code must retain the above copyright\n        notice, this list of conditions and the following disclaimer.\n     2. Redistributions in binary form must reproduce the above copyright\n        notice, this list of conditions and the following disclaimer in the\n        documentation and/or other materials provided with the distribution.\n     3. Neither the name of the copyright holder nor the names of\n        its contributors may be used to endorse or promote products\n        derived from this software without specific prior written permission.\n\n THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND\n ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY\n DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n -->\n\n# Rivuletpy\n\n## Example Neuron Tracings\n\n![alt text](meta/rivulet2_showcase.png "neuron showcase")\n\n## Example Lung Airway Tracing\n\n![alt text](meta/rivulet2_airway.png "airway showcase")\n\n## Rivuletpy == Rivulet2\n\nRivuletpy is a Python3 toolkit for automatically reconstructing single neuron models from 3D microscopic image stacks & other tree structures from 3D medical images.\n\nIt is actively maintained and being used in industry scale image analysis applications.\n\nThe project was initiated in the [BigNeuron project](https://alleninstitute.org/bigneuron/about/)\n\nThe `rtrace` command is powered by the Rivulet2 algorithm published in IEEE Trans. TMI:\n\n[1] S. Liu, D. Zhang, Y. Song, H. Peng and W. Cai, "Automated 3D Neuron Tracing with Precise Branch Erasing and Confidence Controlled Back-Tracking," in IEEE Transactions on Medical Imaging. URL: <http://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=8354803&isnumber=4359023>\n\nPDF [https://www.biorxiv.org/content/biorxiv/early/2017/11/27/109892.full.pdf]\n\nThe predecessor Rivulet1 was published on Neuroinformatics:\n\n[2] Siqi Liu, Donghao Zhang, Sidong Liu, Dagan Feng, Hanchuan Peng, Weidong Cai,\n"Rivulet: 3D Neuron Morphology Tracing with Iterative Back-Tracking",\nNeuroinformatics, Vol.14, Issue 4, pp387-401, 2016.\n\nA C++ implementation of the Rivulet2 algorithm is also available in the lastest [Vaa3D](https://github.com/Vaa3D) sources under the [Rivulet Plugin](https://github.com/Vaa3D/vaa3d_tools/tree/master/released_plugins/v3d_plugins/bigneuron_siqi_rivuletv3d) (Not yet available in the released build). However you can build Vaa3D easily on Mac/Linux following the [Vaa3D wiki](https://github.com/Vaa3D/Vaa3D_Wiki/wiki/Build-Vaa3D-on-Linux) carefully.\n\n## Issues / questions / pull requests\n\nIssues should be reported to the\n[Rivuletpy github repository issue tracker](https://github.com/RivuletStudio/rivuletpy/issues).\nThe ability and speed with which issues can be resolved depends on how complete and\nsuccinct the report is. For this reason, it is recommended that reports be accompanied\nwith a minimal but self-contained code sample that reproduces the issue, the observed and\nexpected output, and if possible, the commit ID of the version used. If reporting a\nregression, the commit ID of the change that introduced the problem is also extremely valuable\ninformation.\n\nQuestions are also welcomed in the [Rivuletpy github repository issue tracker](https://github.com/RivuletStudio/rivuletpy/issues).\nIf you put on a `question` label. We consider every question as an issue since it means we should have made things clearer/easier for the users.\n\nPull requests are definitely welcomed! Before you make a pull requests, please kindly create an issue first to discuss the optimal solution.\n\n## Installation\n\n### Setting up virtual environment\n\nIt is recommended to install rivulet in a virtual enviornment.\n\n```bash\n# create env and activate it\nconda create -n riv\nconda activate riv\n# install pip and git\nconda install pip git\n```\n\n### Install from PyPI\n\nTo install `rivuletpy` from **PyPI** simply activate your virtual environment and run:\n\n```bash\npip install rivuletpy\n```\n\n### Install from GitHub\n\nOptionally, you can use `pip` to install the latest version directly from GitHub:\n\n```bash\npip install git+https://github.com/RivuletStudio/rivuletpy\n```  \n\n## Test Installation\n\nIn ./rivuletpy/\n`sh quicktest.sh`\n\nThis will download a simple neuron image and perform a neuron tracing with rivulet2 algorithm. If you encountered any issues while installing Rivuletpy, you are welcome to raise an issue for the developers in the [issue tracker](https://github.com/RivuletStudio/rivuletpy/issues)\n\n## Usage\n\n* Reconstruct single neuron file.\n\nThe script rtrace command will be installed\n\n```bash\n$ rtrace --help\nusage: rtrace [-h] -f FILE [-o OUT] [-t THRESHOLD] [-z ZOOM_FACTOR]\n              [--save-soma] [--no-save-soma] [--speed]\n              [--quality] [--no-quality] [--clean] [--no-clean] [--silent]\n              [--no-silent] [-v] [--no-view]\n              [--tracing_resolution TRACING_RESOLUTION] [--vtk]\n\nArguments to perform the Rivulet2 tracing algorithm.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -f FILE, --file FILE  The input file. A image file (*.tif, *.nii, *.mat).\n  -o OUT, --out OUT     The name of the output file\n  -t THRESHOLD, --threshold THRESHOLD\n                        threshold to distinguish the foreground and\n                        background. Default 0. If threshold<0, otsu will be\n                        used.\n  -z ZOOM_FACTOR, --zoom_factor ZOOM_FACTOR\n                        The factor to zoom the image to speed up the whole\n                        thing. Default 1.\n  --save-soma           Save the automatically reconstructed soma volume along\n                        with the SWC.\n  --no-save-soma        Don\'t save the automatically reconstructed soma volume\n                        along with the SWC (default)  \n  --speed               Use the input directly as speed image\n  --quality             Reconstruct the neuron with higher quality and\n                        slightly more computing time\n  --no-quality          Reconstruct the neuron with lower quality and slightly\n                        more computing time\n  --clean               Remove the unconnected segments (default). It is\n                        relatively safe to do with the Rivulet2 algorithm\n  --no-clean            Keep the unconnected segments\n  --silent              Omit the terminal outputs\n  --no-silent           Show the terminal outputs & the nice logo (default)\n  -v, --view            View the reconstructed neuron when rtrace finishes\n  --no-view\n  --tracing_resolution TRACING_RESOLUTION\n                        Only valid for mhd input files. Will resample the mhd\n                        array into isotropic resolution before tracing.\n                        Default 1mm\n  --vtk                 Store the world coordinate vtk format along with the\n                        swc\n```\n\nExample Usecases with single neurons in a TIFF image\n\n```bash\nrtrace -f example.tif -t 10 # Simple like this. Reconstruct a neuron in example.tif with a background threshold of 10\nrtrace -f example.tif -t 10 --quality # Better results with longer running time\nrtrace -f example.tif -t 10 --quality -v # Open a 3D swc viewer after reconstruction \n```\n\nExample Usecases with general tree structures in a mhd image\n\n```bash\nrtrace -f example.mhd -t 10 --tracing_resolution 1.5 --vtk # Perform the tracing under an isotropic resolution of 1.5mmx1.5mmx1.5mm and output a vtk output file under the world coordinates along side the swc.\nrtrace -f example.mhd -t 10 --tracing_resolution 1.5 --vtk --speed # Use the input image directly as the source of making speed image. Recommended if the input mhd is a probablity map of centerlines.\n```\n\nPlease note that Rivulet2 is powerful of handling the noises, a relatively low intensity threshold is preferred to include all the candidate voxels.\n\n* Compare a swc reconstruction against the manual ground truth\n\n```bash\n$ compareswc --help\nusage: compareswc [-h] --target TARGET --groundtruth GROUNDTRUTH\n                  [--sigma SIGMA]\n\nArguments for comparing two swc files.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --target TARGET       The input target swc file.\n  --groundtruth GROUNDTRUTH\n                        The input ground truth swc file.\n  --sigma SIGMA         The sigma value to use for the Gaussian function in\n                        NetMets.\n\n$ compareswc --target r2_tracing.swc --groundtruth hand_tracing.swc\n0.9970 0.8946 0.9865 1 3\n```\n\nThe `compareswc` command outputs five numbers which are in order:\n\nprecision, recall, f1-score, No. connection error type A, No. connection error type B\n\n## FAQ\n\n### What if I see on Mac OS ```ImportError: Failed to find TIFF library. Make sure that libtiff is installed and its location is listed in PATH|LD_LIBRARY_PATH|..```\n\nTry\n\n```bash\nbrew install libtiff\n```\n\n### What if I see ```...version `GLIBCXX_3.4.21\' not found...``` when I run `rtrace` under Anaconda?\n\nTry\n\n```bash\n(riv)$ conda install libgcc # Upgrades the gcc in your conda environment to the newest\n```\n\n### What if I see ```Intel MKL FATAL ERROR: Cannot load libmkl_avx2.so or libmkl_def.so.```?\n\nTry to get rid of the mkl in your conda, it has been reported to cause many issues\n\n```bash\n(riv)$ conda install nomkl numpy scipy scikit-learn numexpr\n(riv)$ conda remove mkl mkl-service\n```\n\n## Dependencies\n\nThe build-time and runtime dependencies of Rivuletpy are:\n\n* [numpy](http://www.numpy.org/)\n* [scipy](http://www.scipy.org/)\n* [Cython](http://cython.org/)\n* [scikit-fmm](https://github.com/scikit-fmm)\n* [scikit-image](https://github.com/scikit-image)\n* [matplotlib](http://www.matplotlib.org/)\n* [tqdm](https://github.com/noamraph/tqdm)\n* [nibabel](http://nipy.org/nibabel/)\n',
    'author': 'RivuletStudio',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.11',
}
from build import *
build(setup_kwargs)

setup(**setup_kwargs)
