"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.ClassificationString = exports.SerializationLibrary = exports.OutputFormat = exports.InputFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Absolute class name of the Hadoop `InputFormat` to use when reading table files.
 */
class InputFormat {
    constructor(className) {
        this.className = className;
    }
}
exports.InputFormat = InputFormat;
_a = JSII_RTTI_SYMBOL_1;
InputFormat[_a] = { fqn: "@aws-cdk/aws-glue-alpha.InputFormat", version: "2.22.0-alpha.0" };
/**
 * InputFormat for Avro files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerInputFormat.html
 */
InputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat');
/**
 * InputFormat for Cloudtrail Logs.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
InputFormat.CLOUDTRAIL = new InputFormat('com.amazon.emr.cloudtrail.CloudTrailInputFormat');
/**
 * InputFormat for Orc files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcInputFormat.html
 */
InputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcInputFormat');
/**
 * InputFormat for Parquet files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetInputFormat.html
 */
InputFormat.PARQUET = new InputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat');
/**
 * An InputFormat for plain text files. Files are broken into lines. Either linefeed or
 * carriage-return are used to signal end of line. Keys are the position in the file, and
 * values are the line of text.
 * JSON & CSV files are examples of this InputFormat
 *
 * @see https://hadoop.apache.org/docs/stable/api/org/apache/hadoop/mapred/TextInputFormat.html
 */
InputFormat.TEXT = new InputFormat('org.apache.hadoop.mapred.TextInputFormat');
/**
 * Absolute class name of the Hadoop `OutputFormat` to use when writing table files.
 */
class OutputFormat {
    constructor(className) {
        this.className = className;
    }
}
exports.OutputFormat = OutputFormat;
_b = JSII_RTTI_SYMBOL_1;
OutputFormat[_b] = { fqn: "@aws-cdk/aws-glue-alpha.OutputFormat", version: "2.22.0-alpha.0" };
/**
 * Writes text data with a null key (value only).
 *
 * @see https://hive.apache.org/javadocs/r2.2.0/api/org/apache/hadoop/hive/ql/io/HiveIgnoreKeyTextOutputFormat.html
 */
OutputFormat.HIVE_IGNORE_KEY_TEXT = new OutputFormat('org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat');
/**
 * OutputFormat for Avro files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerOutputFormat.html
 */
OutputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat');
/**
 * OutputFormat for Orc files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcOutputFormat.html
 */
OutputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat');
/**
 * OutputFormat for Parquet files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetOutputFormat.html
 */
OutputFormat.PARQUET = new OutputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat');
/**
 * Serialization library to use when serializing/deserializing (SerDe) table records.
 *
 * @see https://cwiki.apache.org/confluence/display/Hive/SerDe
 */
class SerializationLibrary {
    constructor(className) {
        this.className = className;
    }
}
exports.SerializationLibrary = SerializationLibrary;
_c = JSII_RTTI_SYMBOL_1;
SerializationLibrary[_c] = { fqn: "@aws-cdk/aws-glue-alpha.SerializationLibrary", version: "2.22.0-alpha.0" };
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/avro/AvroSerDe.html
 */
SerializationLibrary.AVRO = new SerializationLibrary('org.apache.hadoop.hive.serde2.avro.AvroSerDe');
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
SerializationLibrary.CLOUDTRAIL = new SerializationLibrary('com.amazon.emr.hive.serde.CloudTrailSerde');
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
 */
SerializationLibrary.GROK = new SerializationLibrary('com.amazonaws.glue.serde.GrokSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hive/hcatalog/data/JsonSerDe.html
 */
SerializationLibrary.HIVE_JSON = new SerializationLibrary('org.apache.hive.hcatalog.data.JsonSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/lazy/LazySimpleSerDe.html
 */
SerializationLibrary.LAZY_SIMPLE = new SerializationLibrary('org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/OpenCSVSerde.html
 */
SerializationLibrary.OPEN_CSV = new SerializationLibrary('org.apache.hadoop.hive.serde2.OpenCSVSerde');
/**
 * @see https://github.com/rcongiu/Hive-JSON-Serde
 */
SerializationLibrary.OPENX_JSON = new SerializationLibrary('org.openx.data.jsonserde.JsonSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html
 */
SerializationLibrary.ORC = new SerializationLibrary('org.apache.hadoop.hive.ql.io.orc.OrcSerde');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html
 */
SerializationLibrary.PARQUET = new SerializationLibrary('org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/RegexSerDe.html
 */
SerializationLibrary.REGEXP = new SerializationLibrary('org.apache.hadoop.hive.serde2.RegexSerDe');
/**
 * Classification string given to tables with this data format.
 *
 * @see https://docs.aws.amazon.com/glue/latest/dg/add-classifier.html#classifier-built-in
 */
class ClassificationString {
    constructor(value) {
        this.value = value;
    }
}
exports.ClassificationString = ClassificationString;
_d = JSII_RTTI_SYMBOL_1;
ClassificationString[_d] = { fqn: "@aws-cdk/aws-glue-alpha.ClassificationString", version: "2.22.0-alpha.0" };
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-avro
 */
ClassificationString.AVRO = new ClassificationString('avro');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-csv
 */
ClassificationString.CSV = new ClassificationString('csv');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-json
 */
ClassificationString.JSON = new ClassificationString('json');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-xml
 */
ClassificationString.XML = new ClassificationString('xml');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-parquet
 */
ClassificationString.PARQUET = new ClassificationString('parquet');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-orc
 */
ClassificationString.ORC = new ClassificationString('orc');
/**
 * Defines the input/output formats and ser/de for a single DataFormat.
 */
class DataFormat {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_DataFormatProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.inputFormat = props.inputFormat;
        this.outputFormat = props.outputFormat;
        this.serializationLibrary = props.serializationLibrary;
        this.classificationString = props.classificationString;
    }
}
exports.DataFormat = DataFormat;
_e = JSII_RTTI_SYMBOL_1;
DataFormat[_e] = { fqn: "@aws-cdk/aws-glue-alpha.DataFormat", version: "2.22.0-alpha.0" };
/**
 * DataFormat for Apache Web Server Logs. Also works for CloudFront logs
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/apache.html
 */
DataFormat.APACHE_LOGS = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.REGEXP,
});
/**
 * DataFormat for Apache Avro
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/avro.html
 */
DataFormat.AVRO = new DataFormat({
    inputFormat: InputFormat.AVRO,
    outputFormat: OutputFormat.AVRO,
    serializationLibrary: SerializationLibrary.AVRO,
    classificationString: ClassificationString.AVRO,
});
/**
 * DataFormat for CloudTrail logs stored on S3
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
DataFormat.CLOUDTRAIL_LOGS = new DataFormat({
    inputFormat: InputFormat.CLOUDTRAIL,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.CLOUDTRAIL,
});
/**
 * DataFormat for CSV Files
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/csv.html
 */
DataFormat.CSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPEN_CSV,
    classificationString: ClassificationString.CSV,
});
/**
 * Stored as plain text files in JSON format.
 * Uses OpenX Json SerDe for serialization and deseralization.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/json.html
 */
DataFormat.JSON = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPENX_JSON,
    classificationString: ClassificationString.JSON,
});
/**
 * DataFormat for Logstash Logs, using the GROK SerDe
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
 */
DataFormat.LOGSTASH = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.GROK,
});
/**
 * DataFormat for Apache ORC (Optimized Row Columnar)
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/orc.html
 */
DataFormat.ORC = new DataFormat({
    inputFormat: InputFormat.ORC,
    outputFormat: OutputFormat.ORC,
    serializationLibrary: SerializationLibrary.ORC,
    classificationString: ClassificationString.ORC,
});
/**
 * DataFormat for Apache Parquet
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/parquet.html
 */
DataFormat.PARQUET = new DataFormat({
    inputFormat: InputFormat.PARQUET,
    outputFormat: OutputFormat.PARQUET,
    serializationLibrary: SerializationLibrary.PARQUET,
    classificationString: ClassificationString.PARQUET,
});
/**
 * DataFormat for TSV (Tab-Separated Values)
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html
 */
DataFormat.TSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.LAZY_SIMPLE,
});
//# sourceMappingURL=data:application/json;base64,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