# Generated by Django 4.2.16 on 2025-11-10 08:57

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('appauth', '0008_appusermodel_auth_config_userrolemodel_auth_config_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='SAMLModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=200, verbose_name='Label for SAML Option')),
                ('is_strict', models.BooleanField(default=True, verbose_name='If strict is True, then unsigned or unencrypted messages are  rejected if they are expected to be signed/encrypted')),
                ('is_debug_true', models.BooleanField(default=False, verbose_name='Enable debug mode (outputs errors)')),
                ('sp_entityId', models.URLField(verbose_name='Service Provider Entity ID E.g. tenant.zelthy.in/metadata/2/')),
                ('sp_acsURL', models.URLField(verbose_name='Service Provider ACS URL E.g. http://tenant.zelthy.in/acs/2/')),
                ('sp_slo', models.URLField(blank=True, verbose_name='Service Provider Single Log Out. Not Implemented Yet')),
                ('sp_x509cert', models.TextField(blank=True, max_length=2000, verbose_name='Service Provider Public Key x509 Certificate')),
                ('sp_privatekey', models.TextField(blank=True, max_length=2000, verbose_name='Service Provider Private Key')),
                ('idp_entityId', models.URLField(verbose_name='IDP Entity ID . Eg. https://app.onelogin.com/saml/metadata/ace2ffad-66f5-4d43-ae51-bddef851f997')),
                ('idp_sso', models.URLField(verbose_name='IDP Single Sing On.  Eg. https://zelthy1.onelogin.com/trust/saml2/http-post/sso/881614')),
                ('idp_slo', models.URLField(blank=True, verbose_name='IDP Single Log On. E.g https://app.onelogin.com/trust/saml2/http-redirect/slo/<onelogin_connector_id>')),
                ('idp_x509cert', models.TextField(max_length=2000, verbose_name='IdP Public Key x509 Certificate')),
                ('security_nameIdEncrypted', models.BooleanField(default=False, verbose_name='security_nameIdEncrypted. Indicates that the nameID of the <samlp:logoutRequest> sent by this SP will be encrypted')),
                ('security_authnRequestsSigned', models.BooleanField(default=False, verbose_name='Indicates whether the <samlp:AuthnRequest> messages sent by this SP will be signed')),
                ('security_logoutRequestSigned', models.BooleanField(default=False, verbose_name='I Indicates whether the <samlp:logoutResponse> messages sent by this SP will be signed')),
                ('security_logoutResponseSigned', models.BooleanField(default=False, verbose_name='Indicates whether the <samlp:logoutResponse> messages sent by this SP will be signed')),
                ('security_signMetadata', models.BooleanField(default=False, verbose_name='Sign the Metadata')),
                ('security_wantMessagesSigned', models.BooleanField(default=False, verbose_name='Indicates a requirement for the <samlp:Response>, <samlp:LogoutRequest> and <samlp:LogoutResponse> elements received by this SP to be signed')),
                ('security_wantAssertionsSigned', models.BooleanField(default=False, verbose_name='Indicates a requirement for the <saml:Assertion> elements received by this SP to be signed')),
                ('security_wantAssertionsEncrypted', models.BooleanField(default=False, verbose_name='Indicates a requirement for the <saml:Assertion> elements received by this SP to be encrypted.')),
                ('security_wantNameId', models.BooleanField(default=True, verbose_name='Indicates a requirement for the NameID element on the SAMLResponse received by this SP to be present.')),
                ('security_wantNameIdEncrypted', models.BooleanField(default=False, verbose_name='Indicates a requirement for the NameID received by this SP to be encrypted')),
                ('security_wantAttributeStatement', models.BooleanField(default=True, verbose_name='Indicates a requirement for the AttributeStatement element')),
                ('security_rejectUnsolicitedResponsesWithInResponseTo', models.BooleanField(default=False, verbose_name=' Rejects SAML responses with a InResponseTo attribute when request_id not provided in the process_response method that later call the response is_valid method with that parameter.')),
                ('security_requestedAuthnContext', models.BooleanField(default=True, verbose_name='Authentication context')),
                ('security_requestedAuthnContextComparison', models.CharField(default='exact', max_length=10, verbose_name='Indicates whether the <samlp:AuthnRequest> messages sent by this SP will be signed')),
                ('security_signatureAlgorithm', models.CharField(choices=[('http://www.w3.org/2000/09/xmldsig#rsa-sha1', 'http://www.w3.org/2000/09/xmldsig#rsa-sha1'), ('http://www.w3.org/2000/09/xmldsig#dsa-sha1', 'http://www.w3.org/2000/09/xmldsig#dsa-sha1'), ('http://www.w3.org/2001/04/xmldsig-more#rsa-sha256', 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256'), ('http://www.w3.org/2001/04/xmldsig-more#rsa-sha384', 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha384'), ('http://www.w3.org/2001/04/xmldsig-more#rsa-sha512', 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha512')], default='http://www.w3.org/2000/09/xmldsig#rsa-sha1', max_length=200)),
                ('security_digestAlgorithm', models.CharField(choices=[('http://www.w3.org/2000/09/xmldsig#sha1', 'http://www.w3.org/2000/09/xmldsig#sha1'), ('http://www.w3.org/2001/04/xmlenc#sha256', 'http://www.w3.org/2001/04/xmlenc#sha256'), ('http://www.w3.org/2001/04/xmldsig-more#sha384', 'http://www.w3.org/2001/04/xmldsig-more#sha384'), ('http://www.w3.org/2001/04/xmlenc#sha512', 'http://www.w3.org/2001/04/xmlenc#sha512')], default='http://www.w3.org/2000/09/xmldsig#sha1', max_length=200)),
                ('name_id_format', models.CharField(default='urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified', max_length=200)),
                ('is_active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='SAMLRequestId',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('request_id', models.CharField(max_length=255, verbose_name='SAML Request ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
    ]
