from src.util.make_test_constants import make_test_constants_without_genesis

test_constants = make_test_constants_without_genesis(
    {
        "DIFFICULTY_STARTING": 1,
        "DISCRIMINANT_SIZE_BITS": 8,
        "BLOCK_TIME_TARGET": 10,
        "DIFFICULTY_EPOCH": 12,  # The number of blocks per epoch
        "DIFFICULTY_DELAY": 3,  # EPOCH / WARP_FACTOR
        "PROPAGATION_THRESHOLD": 10,
        "PROPAGATION_DELAY_THRESHOLD": 20,
        "TX_PER_SEC": 1,
        "MEMPOOL_BLOCK_BUFFER": 10,
        "MIN_ITERS_STARTING": 50 * 1,
        "NUMBER_ZERO_BITS_CHALLENGE_SIG": 1,
        "CLVM_COST_RATIO_CONSTANT": 108,
        "COINBASE_FREEZE_PERIOD": 0,
        "GENESIS_BLOCK": b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nyI]\xd2\x91\x85\xf7\xe5ZX\x9bya\x8b\xa2D\xeb\xd83\xdaG\xbf\xa0\xf0R\x17\xb7\xba\xe7?5\x8f\x91h\xfe7\x00\x00\xfe\xdfB\xc0*\xd6j\xcc\x85\x98U}!\x8a\x83U\x19e'\x01M\xe0\xd3\x83\x0c\xf2p\xac9r\xafd\xed\x90|\x94\xfdg\xac\xdb\x7f\xf2\xc2\xc5\xe6\x04\x0c\x7fUZ\xa7\xafJ&\x1c\xf1n\x12\x00\x00\x00\x90t\x0e\xf0hK\xe5\x95\xff\xbb\xfc\xcd\xb2kNXj\xf3\x98\xf1\xcc\xa9\xdbT\x98\x80\xabq\xc4\xb9\x9d\xa2V;,W\xe8M\x99\xd8\x10'\xb8\x01\xc5\xd4\x02R\xecD\xe8\x86]\x81A\xfc\xc1\xe3\x9dH\xbf\x07p\xc1\xdd\x82\x9f\xc8\x0b\xde,\x9d\x9d\xd4\x9e\x11\xd7\x97\xc8\xa6q@S\x0f\xca\x89\xf3\x88(2b\x9a#\n9\xd3\xc77\x13\xed\x92\x03g\x02\r\xc5\xe2P\xe3\xa7{k\xf5de\xafmi\xfa\x1c\xeb=\x90\xac\xee\xfe;\x19\x00_\x0cE\x0f\xab\xdd\xaeG\x1f\xd4%\x13\x0czn\x8f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\n<\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x02\x02\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00_\x04\x933\xcb\xa2N\x14\xce\x07\xbay\xf6H\xe3L\x03\xc9\xaa\xdb\x9ak\x89\x03|\xc6\n\xe0R\xa5R\xeb\xcc\xe5\x7f\x8c\xce\xf81\xc8\x185b\x93r\xde!\x92\x1d\xa3\xf5\xe9\xc9\xc3\x9c\xd8a\xb5\x0f,P&*b\xe6w\x04]\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\n<\x80\xa1\xd5wIO\x9d.\xb9\x1c\xb1D\x96\xeb\xcb\x00\xe0\xf1r\xeb\x88\xe7\xd8\xf3K\x06wkW\xf8\xa2\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\xee\x08sI\xa7t\xe9\xd8+\xf5\xa3I\xd8\x82\x95\xd1+l\xd4Fp\x8f+\x13\x06\xc2\r\x85\x14]\xce\x00\x00\x01\xd1\xa9J \x00kL\xc3\xbc,\xd8\x04J\xf1\xe7 &\x8f\xbaW\x96\xc0\xb2\xc7\xff\x94_\x11\x9dn\xbfb\xe65\xad=?\x00\x00\x00\x00\xca\x00Y\xa8Q\x03\xe9\xa4\x12S\x9c\xean\xf6\xd2nv\x8c\xa8X%\xfa\xa8@\xf8\x18\x0e}\x05E\xca\xf6r\r\xc0\x1c\xfd[\xaf\x97\x02\xe8\xd7\xeb\xc3\xae\x85\xd3\rz\x14\xd28q\xf4\x87\x15\x9aH\xab\xc2\xce{\xfa\x8a\x94\x85q\xca\x8b\xa3\xe8\x1d\x02a\x0ea1\xe0^\x92P\xf3\x8a\rk\xf1iP\xda;\xb9\xd9\xef4 \x00\x00\x00\x00\x00\x00\x00\x00!2\x0fz\xc0o\x86\x19\xdd\xb2{\x8c\xa7`a42\xf5\xaa\x87\xa0\rQQB\x1ah*\x07y\xd83\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xd2\"y\x05Z>d\xb9\x13k\x1bWC\xea[i\xeeE\xf0\xec\xd6(\xceM\x1f\xd0\x13;\x9f\xacsC$\\2\x81Hi\x03\x01v\xde\x9c\xac1e\xcb\x03\xfb\x94B\t&\xf9\xe0RW\xb6\xa6\x8fY7W\xb4\x8a\x0e\xda:\xfc$H)\xdf\xbb#\x93Hlfdy+\x00\xdd\xb4\x86\xb5\x16\xca\xf4\xfe\xf5\x9f\xeb@\x00\x00\x00\x00\x07\x02=49\xfc\xce\x80",  # noqa: E501
    }
)

if __name__ == "__main__":
    from src.util.default_root import DEFAULT_ROOT_PATH
    from src.util.block_tools import BlockTools

    bt = BlockTools(root_path=DEFAULT_ROOT_PATH)
    new_genesis_block = bt.create_genesis_block(test_constants, bytes([0] * 32), b"0")

    print(bytes(new_genesis_block))
