# generated by datamodel-codegen:
#   filename:  schema/type/auditLog.json
#   timestamp: 2021-12-29T06:41:14+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from . import basic


class Method(Enum):
    POST = 'POST'
    PUT = 'PUT'
    PATCH = 'PATCH'
    DELETE = 'DELETE'


class AuditLog(BaseModel):
    class Config:
        extra = Extra.forbid

    method: Method = Field(..., description='HTTP Method used in a call.')
    responseCode: int = Field(
        ..., description='HTTP response code for the api requested.'
    )
    path: str = Field(..., description='Requested API Path.')
    userName: str = Field(..., description='Name of the user who made the API request.')
    entityId: basic.Uuid = Field(
        ..., description='Identifier of entity that was modified by the operation.'
    )
    entityType: str = Field(
        ..., description='Type of Entity that is modified by the operation.'
    )
    dateTime: Optional[basic.DateTime] = Field(
        None, description='Date when the API call is made.'
    )
