
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/python/arcor2_dobot:arcor2_dobot_dist

from setuptools import setup

setup(**{
    'author': 'Robo@FIT',
    'author_email': 'imaterna@fit.vut.cz',
    'classifiers': [
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)',
        'Programming Language :: Python :: 3.8',
        'Natural Language :: English',
        'Topic :: Scientific/Engineering',
    ],
    'description': 'ARCOR2 Dobot service',
    'license': 'LGPL',
    'long_description': """# arcor2_dobot

## Environment variables

- `ARCOR2_DOBOT_URL=http://0.0.0.0:5018` - by default, the service listens on port 5018.
- `ARCOR2_DOBOT_MOCK=1` - the service will start in a mock (simulator) mode.
# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),

## [0.3.0] - 2021-10-25

### Changed
 - New environment variable `ARCOR2_DOBOT_MOCK` to start the service in a mock mode.
 - Classes updated to match `Robot` (new argument `include_gripper`). 
 - Handle `DobotApi` exceptions to produce nice error messages.
 - Use HTTP code 204 instead of 200 where it makes sense.

## [0.2.3] - 2021-05-21

### Fixed
 - EEF orientation.
 - State controller paths.

## [0.2.2] - 2021-03-17

### Fixed
 - Suction offset for M1 adjusted

## [0.2.1] - 2021-03-15

### Fixed
 - Dobot axis Z is in mm
 - Added fixed offset for suction

## [0.2.0] - 2021-03-03

### Changed
- Integration of `pydobot` library (own modified fork).
- API for hand teaching mode.

## [0.1.0] - 2021-02-08

### Changed
- Initial release of the Dobot service.""",
    'long_description_content_type': 'text/markdown',
    'name': 'arcor2_dobot',
    'python_requires': '==3.8.*',
    'version': '0.3.0',
    'packages': (
        'arcor2_dobot',
        'arcor2_dobot.scripts',
    ),
    'namespace_packages': (
    ),
    'package_data': {
        'arcor2_dobot': (
            'VERSION',
            'py.typed',
        ),
    },
    'install_requires': (
        'Flask==2.0.2',
        'arcor2~=0.22.0',
        'numpy-quaternion[numba,scipy]==2021.10.7.23.40.37',
        'numpy==1.21.3',
        'pyserial==3.5',
    ),
    'entry_points': {
        'console_scripts': [
            'arcor2_dobot = arcor2_dobot.scripts.dobot:main',
        ],
    },
})
