/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectInstance;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.JMXAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXComplexAttribute
extends JMXAttribute {
    private HashMap<String, HashMap<String, Object>> subAttributeList = new HashMap();

    public JMXComplexAttribute(MBeanAttributeInfo a, ObjectInstance instance, String instance_name, Connection connection, HashMap<String, String> instanceTags) {
        super(a, instance, instance_name, connection, instanceTags);
    }

    private void _populateSubAttributeList(Object attributeValue) {
        block3: {
            block2: {
                if (!this.attribute.getType().equals("javax.management.openmbean.CompositeData")) break block2;
                CompositeData data = (CompositeData)attributeValue;
                for (String key : data.getCompositeType().keySet()) {
                    HashMap sub_attr_params = new HashMap();
                    this.subAttributeList.put(key, sub_attr_params);
                }
                break block3;
            }
            if (!this.attribute.getType().equals("java.util.HashMap")) break block3;
            HashMap data = (HashMap)attributeValue;
            for (String key : data.keySet()) {
                HashMap sub_attr_params = new HashMap();
                this.subAttributeList.put(key, sub_attr_params);
            }
        }
    }

    @Override
    public LinkedList<HashMap<String, Object>> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        LinkedList<HashMap<String, Object>> metrics = new LinkedList<HashMap<String, Object>>();
        for (Map.Entry<String, HashMap<String, Object>> pairs : this.subAttributeList.entrySet()) {
            String subAttribute = pairs.getKey();
            HashMap<String, Object> metric = pairs.getValue();
            if (metric.get("alias") == null) {
                metric.put("alias", JMXComplexAttribute.convertMetricName(this._getAlias(subAttribute)));
            }
            if (metric.get("metric_type") == null) {
                metric.put("metric_type", this._getMetricType(subAttribute));
            }
            if (metric.get("tags") == null) {
                metric.put("tags", this.tags);
            }
            metric.put("value", this._getValue(subAttribute));
            metrics.add(metric);
        }
        return metrics;
    }

    private double _getValue(String subAttribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object value = this.getJmxValue();
        if (this.attribute.getType().equals("javax.management.openmbean.CompositeData")) {
            CompositeData data = (CompositeData)value;
            Object sub_value = data.get(subAttribute);
            return this._getValueAsDouble(sub_value);
        }
        if (this.attribute.getType().equals("java.util.HashMap")) {
            HashMap data = (HashMap)value;
            Object sub_value = data.get(subAttribute);
            return this._getValueAsDouble(sub_value);
        }
        throw new NumberFormatException();
    }

    private Object _getMetricType(String subAttribute) {
        String subAttributeName = this.attribute.getName() + "." + subAttribute;
        String metricType = null;
        if (this.matching_conf.include.get("attribute") instanceof LinkedHashMap && (metricType = (String)((LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(subAttributeName)).get("metric_type")) == null) {
            metricType = (String)((LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(subAttributeName)).get("type");
        }
        if (metricType == null) {
            metricType = "gauge";
        }
        return metricType;
    }

    private String _getAlias(String subAttribute) {
        String subAttributeName = this.attribute.getName() + "." + subAttribute;
        if (this.matching_conf.include.get("attribute") instanceof LinkedHashMap) {
            return (String)((LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(subAttributeName)).get("alias");
        }
        if (this.matching_conf.conf.get("metric_prefix") != null) {
            return this.matching_conf.conf.get("metric_prefix") + "." + this.beanName.split(":")[0] + "." + subAttributeName;
        }
        return "jmx." + this.beanName.split(":")[0] + "." + subAttributeName;
    }

    @Override
    public boolean match(Configuration configuration) {
        if (!this.matchDomain(configuration) || !this.matchBean(configuration) || this.excludeMatchDomain(configuration) || this.excludeMatchBean(configuration)) {
            return false;
        }
        try {
            this._populateSubAttributeList(this.getJmxValue());
        }
        catch (Exception e) {
            return false;
        }
        return this._matchAttribute(configuration) && !this._excludeMatchAttribute(configuration);
    }

    private boolean _matchSubAttribute(LinkedHashMap<String, Object> params, String subAttributeName, boolean matchOnEmpty) {
        if (params.get("attribute") instanceof LinkedHashMap && ((LinkedHashMap)params.get("attribute")).containsKey(subAttributeName)) {
            return true;
        }
        if (params.get("attribute") instanceof ArrayList && ((ArrayList)params.get("attribute")).contains(subAttributeName)) {
            return true;
        }
        if (params.get("attribute") == null) {
            return matchOnEmpty;
        }
        return false;
    }

    private boolean _matchAttribute(Configuration configuration) {
        if (this._matchSubAttribute(configuration.include, this.attributeName, true)) {
            return true;
        }
        Iterator<String> it = this.subAttributeList.keySet().iterator();
        while (it.hasNext()) {
            String subAttribute = it.next();
            if (this._matchSubAttribute(configuration.include, this.attributeName + "." + subAttribute, true)) continue;
            it.remove();
        }
        return this.subAttributeList.size() > 0;
    }

    private boolean _excludeMatchAttribute(Configuration configuration) {
        if (configuration.exclude.get("attribute") != null && this._matchSubAttribute(configuration.exclude, this.attributeName, false)) {
            return true;
        }
        Iterator<String> it = this.subAttributeList.keySet().iterator();
        while (it.hasNext()) {
            String subAttribute = it.next();
            if (!this._matchSubAttribute(configuration.exclude, this.attributeName + "." + subAttribute, false)) continue;
            it.remove();
        }
        return this.subAttributeList.size() <= 0;
    }
}

