# 👾 Code Interpreter API

[![Version](https://badge.fury.io/py/codeinterpreterapi.svg)](https://badge.fury.io/py/codeinterpreterapi)
[![code-check](https://github.com/shroominic/codeinterpreter-api/actions/workflows/code-check.yml/badge.svg)](https://github.com/shroominic/codeinterpreter-api/actions/workflows/code-check.yml)
![Downloads](https://img.shields.io/pypi/dm/codeinterpreterapi)
![License](https://img.shields.io/pypi/l/codeinterpreterapi)
![PyVersion](https://img.shields.io/pypi/pyversions/codeinterpreterapi)

CodeInterpreterAPI allows you to easily build apps like the "Advanced Data Analysis" you may know from ChatGPT. Build on top of [LangChain](https://github.com/langchain-ai/langchain) and [CodeBox](https://github.com/shroominic/codebox-api), it provides a simple API for chatting with an AI that can run Python code to do anything you want.

## Key features

- Dataset Analysis, Stock Charting, Image Manipulation, ....
- Internet access and auto Python package installation
- Input `text + files` -> Receive `text + files`
- Conversation Memory: respond based on previous inputs
- Run everything local except the OpenAI API (OpenOrca or others maybe soon)
- Use CodeBox API for easy scaling in production

## Resources

- [Blog Post](https://blog.langchain.dev/code-interpreter-api/)
- [Github Repo](https://github.com/shroominic/codeinterpreter-api/)
- [Documentation](https://shroominic.github.io/codeinterpreter-api/)
- [Join the Discord](https://discord.gg/Vaq25XJvvW)
