"""
Contains scraper module constants.
"""

from ..types import (
    ScrapedDefinitionResponse,
    ScrapedExampleResponse,
    ScrapedIdiomProverbResponse,
    ScrapedViewResponse,
    ScrapedWordResponse,
    WordOfTheDayResponse
)

_VIEW_URL = 'https://krdict.korean.go.kr{}/dicSearch/SearchView?{}ParaWordNo={}'

_RESPONSE_TYPES = {
    'dfn': ScrapedDefinitionResponse,
    'ip': ScrapedIdiomProverbResponse,
    'semantic_category': ScrapedWordResponse,
    'subject_category': ScrapedWordResponse,
    'exam': ScrapedExampleResponse,
    'view': ScrapedViewResponse,
    'word': ScrapedWordResponse,
    'word_of_the_day': WordOfTheDayResponse
}

# word info strings
_CONJUGATION_STR = '활용'
_DERIVATIVE_STR = '파생어'
_POS_STR = '품사'
_PRONUNCIATION_STR = '발음'
_ALL_REFERENCE_STR = '참고'
_SENTENCE_REFERENCE_STR = '※'

# subword strings
_IDIOM_STR = '관용구'
_PROVERB_STR = '속담'

# definition info strings
_SENTENCE_PATT_STR = '문형'
_SENTENCE_PATT_REF_STR = '문형참고'
_ABBREV_STR = '준말'
_HIGH_FORM_STR = '높임말'
_SOFT_FORM_STR = '여린말'
_ANTONYM_STR = '반대말'
_DIMINUTIVE_STR = '작은말'
_LOW_FORM_STR = '낮춤말'
_EMPHATIC_STR = '센말'
_REFERENCE_STR = '참고어'
_HEAVY_FORM_STR = '큰말'
_ORIG_FORM_STR = '본말'
_SYNONYM_STR = '유의어'

# original language strings
_NATIVE_STR = '고유어'
_HANJA_STR = '한자'
_UNKNOWN_STR = '안 밝힘'
_ENG_STR = '영어'
_GREEK_STR = '그리스어'
_GERMAN_STR = '독일어'
_LATIN_STR = '라틴어'
_SANSKRIT_STR = '산스크리트어'
_SPANISH_STR = '에스파냐어'
_ITALIAN_STR = '이탈리아어'
_JAPANESE_STR = '일본어'
_CHINESE_STR = '중국어'
_PERSIAN_STR = '페르시아어'
_PORTUGUESE_STR = '포르투갈어'
_FRENCH_STR = '프랑스어'
_HEBREW_STR = '히브리어'
_OTHER_STR = '기타어'

_RELATED_STRINGS = {
    _ABBREV_STR,
    _HIGH_FORM_STR,
    _SOFT_FORM_STR,
    _ANTONYM_STR,
    _DIMINUTIVE_STR,
    _LOW_FORM_STR,
    _EMPHATIC_STR,
    _REFERENCE_STR,
    _HEAVY_FORM_STR,
    _ORIG_FORM_STR,
    _SYNONYM_STR
}
_VIEW_TRANSLATION_MAPS = {
    'eng': {
        'Pronunciation': _PRONUNCIATION_STR,
        'Part of Speech': _POS_STR,
        'Application': _CONJUGATION_STR,
        'Derivative': _DERIVATIVE_STR,
        'Reference': _SENTENCE_REFERENCE_STR,
        'All References': _ALL_REFERENCE_STR,
        'Idiom': _IDIOM_STR,
        'Proverbs': _PROVERB_STR,
        # definition info
        'Sentence': _SENTENCE_PATT_STR,
        'Sentence Reference': _SENTENCE_PATT_REF_STR,
        'Short Form': _ABBREV_STR,
        'Respectful Form': _HIGH_FORM_STR,
        'Soft Variant': _SOFT_FORM_STR,
        'Antonym': _ANTONYM_STR,
        'Light Variant': _DIMINUTIVE_STR,
        'Low Form': _LOW_FORM_STR,
        'Emphatic Variant': _EMPHATIC_STR,
        'Reference Word': _REFERENCE_STR,
        'Heavy Variant': _HEAVY_FORM_STR,
        'Original Form': _ORIG_FORM_STR,
        'Synonym': _SYNONYM_STR,
        # original language
        'Native word': _NATIVE_STR,
        'Sino-Korean word': _HANJA_STR,
        'Unknown': _UNKNOWN_STR,
        'English': _ENG_STR,
        'Greek': _GREEK_STR,
        'German': _GERMAN_STR,
        'Latin': _LATIN_STR,
        'Sanskrit': _SANSKRIT_STR,
        'Spanish': _SPANISH_STR,
        'Italian': _ITALIAN_STR,
        'Japanese': _JAPANESE_STR,
        'Chinese': _CHINESE_STR,
        'Persian': _PERSIAN_STR,
        'Portuguese': _PORTUGUESE_STR,
        'French': _FRENCH_STR,
        'Hebrew': _HEBREW_STR,
        'Other': _OTHER_STR,
    },
    'rus': {
        'произношение': _PRONUNCIATION_STR,
        'Части речи': _POS_STR,
        'склонение': _CONJUGATION_STR,
        'производное слово': _DERIVATIVE_STR,
        'ссылка': _SENTENCE_REFERENCE_STR,
        'ссылка на всё': _ALL_REFERENCE_STR,
        'поговорка': _IDIOM_STR,
        'пословица': _PROVERB_STR,
        # definition info
        'схема': _SENTENCE_PATT_STR,
        'ссылка на схему': _SENTENCE_PATT_REF_STR,
        'аббревиатура': _ABBREV_STR,
        'уважительное выражение': _HIGH_FORM_STR,
        'нежное выражение': _SOFT_FORM_STR,
        'антоним': _ANTONYM_STR,
        'словечко': _DIMINUTIVE_STR,
        'фамильярдность': _LOW_FORM_STR,
        'усилительное слово': _EMPHATIC_STR,
        'слово по ссылке': _REFERENCE_STR,
        'обобщающее выражение': _HEAVY_FORM_STR,
        'развёрнутое выражение': _ORIG_FORM_STR,
        'синоним': _SYNONYM_STR,
        # original language
        'исконно-корейские слова': _NATIVE_STR,
        'иероглифические слова': _HANJA_STR,
        'нет информации': _UNKNOWN_STR,
        'английский': _ENG_STR,
        'греческий язык': _GREEK_STR,
        'немецкий язык': _GERMAN_STR,
        'латинский язык': _LATIN_STR,
        'санскрит': _SANSKRIT_STR,
        'испанский язык': _SPANISH_STR,
        'итальянский язык': _ITALIAN_STR,
        'японский': _JAPANESE_STR,
        'китайский язык': _CHINESE_STR,
        'персидский язык': _PERSIAN_STR,
        'португальский язык': _PORTUGUESE_STR,
        'французский язык': _FRENCH_STR,
        'иврит': _HEBREW_STR,
        'другой язык': _OTHER_STR,
    },
    'mon': {
        'Дуудлага': _PRONUNCIATION_STR,
        'Үг хэллэг': _POS_STR,
        'склонение': _CONJUGATION_STR,
        'Үүсмэл үг': _DERIVATIVE_STR,
        'Нэмэлт тайлбар': _SENTENCE_REFERENCE_STR,
        # all references excluded; equivalent to sentence reference string
        'Хэлц үг': _IDIOM_STR,
        'Зүйр үг': _PROVERB_STR,
        # definition info
        'Өгүүлбэрийн бүтэц': _SENTENCE_PATT_STR,
        'Өгүүлбэрийн бүтцийн нэмэлт тайлбар': _SENTENCE_PATT_REF_STR,
        'Товчилсон үг ': _ABBREV_STR,
        'Хүндэтгэлийн үг': _HIGH_FORM_STR,
        'Зөөлрүүлсэн үг': _SOFT_FORM_STR,
        'Эсрэг үг': _ANTONYM_STR,
        'Утга бууруулсан үг': _DIMINUTIVE_STR,
        'Хүндэтгэлийн бус үг': _LOW_FORM_STR,
        'усилительное слово': _EMPHATIC_STR,
        'Нэмэлт тайлбар үг': _REFERENCE_STR,
        'обобщающее выражение': _HEAVY_FORM_STR,
        'Үндсэн үг': _ORIG_FORM_STR,
        'Ойролцоо үг': _SYNONYM_STR,
        # original language
        'Солонгос үг': _NATIVE_STR,
        'Ханз үг': _HANJA_STR,
        'Тухайн мэдээлэл байхгүй': _UNKNOWN_STR,
        'Англи хэл': _ENG_STR,
        'Грек хэл': _GREEK_STR,
        'герман хэл': _GERMAN_STR,
        'Латин хэл': _LATIN_STR,
        'Санскрит хэл': _SANSKRIT_STR,
        'Испани хэл': _SPANISH_STR,
        'Итали хэл': _ITALIAN_STR,
        'Япон хэл': _JAPANESE_STR,
        'хятад хэл': _CHINESE_STR,
        'Перс хэл': _PERSIAN_STR,
        'Португали хэл': _PORTUGUESE_STR,
        'Франц хэл': _FRENCH_STR,
        'Еврей хэл': _HEBREW_STR,
        'Бусад': _OTHER_STR,
    },
    'vie': {
        'Phát âm': _PRONUNCIATION_STR,
        'Từ loại': _POS_STR,
        'Ứng dụng': _CONJUGATION_STR,
        'Từ phái sinh': _DERIVATIVE_STR,
        'Tham khảo': _SENTENCE_REFERENCE_STR,
        'Tham khảo toàn bộ': _ALL_REFERENCE_STR,
        'Thành ngữ': _IDIOM_STR,
        'Tục ngữ': _PROVERB_STR,
        # definition info
        'Cấu trúc ngữ pháp': _SENTENCE_PATT_STR,
        'Tham khảo cấu trúc ngữ pháp': _SENTENCE_PATT_REF_STR,
        'Từ viết tắt ': _ABBREV_STR,
        'Cách nói kính trọng': _HIGH_FORM_STR,
        'Từ mang lại cảm giác nhẹ hơn': _SOFT_FORM_STR,
        'Từ trái nghĩa': _ANTONYM_STR,
        'Từ mang lại cảm giác nhỏ': _DIMINUTIVE_STR,
        'Cách nói khiêm nhường': _LOW_FORM_STR,
        'Хүч нэмсэн үг': _EMPHATIC_STR,
        'Từ tham khảo': _REFERENCE_STR,
        'Утга өсгөсөн үг': _HEAVY_FORM_STR,
        'Cách nói vốn dĩ': _ORIG_FORM_STR,
        'Từ đồng nghĩa': _SYNONYM_STR,
        # original language
        'từ thuần Hàn': _NATIVE_STR,
        'từ Hán Hàn': _HANJA_STR,
        'chưa rõ': _UNKNOWN_STR,
        'tiếng Anh': _ENG_STR,
        'Tiếng Hy Lạp': _GREEK_STR,
        'tiếng Đức': _GERMAN_STR,
        'Tiếng La tinh': _LATIN_STR,
        'Tiếng Phạn': _SANSKRIT_STR,
        'Tiếng Esprađa': _SPANISH_STR,
        'Tiếng Ý': _ITALIAN_STR,
        'tiếng Nhật': _JAPANESE_STR,
        'tiếng Trung Quốc': _CHINESE_STR,
        'Tiếng Persien': _PERSIAN_STR,
        'Tiếng Bồ Đào Nha': _PORTUGUESE_STR,
        'Tiếng Pháp': _FRENCH_STR,
        'Tiếng Hebrew': _HEBREW_STR,
        'Ngôn ngữ khác': _OTHER_STR,
    },
    'spa': {
        'Pronunciación': _PRONUNCIATION_STR,
        'Categoría gramatical': _POS_STR,
        'Uso': _CONJUGATION_STR,
        'Palabra derivada': _DERIVATIVE_STR,
        'Referencia': _SENTENCE_REFERENCE_STR,
        'Tomar todo como referencia': _ALL_REFERENCE_STR,
        'Modismo': _IDIOM_STR,
        'Proverbio': _PROVERB_STR,
        # definition info
        'Estructura oracional': _SENTENCE_PATT_STR,
        'Consultar estructura oracional': _SENTENCE_PATT_REF_STR,
        'Forma abreviada de la palabra': _ABBREV_STR,
        'Habla o término respetuoso': _HIGH_FORM_STR,
        'Forma suavizada de una palabra': _SOFT_FORM_STR,
        'Antónimo': _ANTONYM_STR,
        'Forma diminutiva de la palabra': _DIMINUTIVE_STR,
        'Habla o término familiar': _LOW_FORM_STR,
        'Forma enfática de una palabra': _EMPHATIC_STR,
        'Palabar de referencia': _REFERENCE_STR,
        'Forma aumentativa de la palabra': _HEAVY_FORM_STR,
        'Forma original de la sílaba': _ORIG_FORM_STR,
        'Sinónimo': _SYNONYM_STR,
        # original language
        'Palabras nativas': _NATIVE_STR,
        'Palabras en caracteres chinos / Palabras chino-coreanas': _HANJA_STR,
        'Sin especificar': _UNKNOWN_STR,
        'Inglés': _ENG_STR,
        'Griego': _GREEK_STR,
        'alemán': _GERMAN_STR,
        'Latín': _LATIN_STR,
        'Sánscrito': _SANSKRIT_STR,
        'Español': _SPANISH_STR,
        'Italiano': _ITALIAN_STR,
        'Japonés': _JAPANESE_STR,
        'chino': _CHINESE_STR,
        'Persa': _PERSIAN_STR,
        'Portugués': _PORTUGUESE_STR,
        'Francés': _FRENCH_STR,
        'Hebreo': _HEBREW_STR,
        'Otros': _OTHER_STR,
    },
    'ara': {
        'النطق': _PRONUNCIATION_STR,
        'أقسام الكلام': _POS_STR,
        'تصريف': _CONJUGATION_STR,
        'اشتقاق': _DERIVATIVE_STR,
        'مرجع': _SENTENCE_REFERENCE_STR,
        'مرجع كامل': _ALL_REFERENCE_STR,
        'تعبير اصطلاحي': _IDIOM_STR,
        'حكمة': _PROVERB_STR,
        # definition info
        'بنية الجملة': _SENTENCE_PATT_STR,
        'مرجع بنية الجملة': _SENTENCE_PATT_REF_STR,
        'كلمة مختصرة': _ABBREV_STR,
        'كلام تبجيلي': _HIGH_FORM_STR,
        'كلام لطيف': _SOFT_FORM_STR,
        'مضاد': _ANTONYM_STR,
        'نظير خفيف من كلام': _DIMINUTIVE_STR,
        'كلام ساخر': _LOW_FORM_STR,
        'كلام تعزيزي': _EMPHATIC_STR,
        'كلمة مرجعية': _REFERENCE_STR,
        'نظير ثقيل من كلام': _HEAVY_FORM_STR,
        'كلام أصليّ': _ORIG_FORM_STR,
        'مرادف': _SYNONYM_STR,
        # original language
        'اللغة الأصلية/ اللغة الأم': _NATIVE_STR,
        'كلمة من الحروف الصينية': _HANJA_STR,
        'غير محدّد': _UNKNOWN_STR,
        'اللغة الإنجليزية': _ENG_STR,
        'اللغة اليونانية': _GREEK_STR,
        'اللغة الألمانية': _GERMAN_STR,
        'اللغة اللاتينية': _LATIN_STR,
        'اللغة السنسكريتية': _SANSKRIT_STR,
        'اللغة الأسبانية': _SPANISH_STR,
        'اللغة الإيطالية': _ITALIAN_STR,
        'اللغة اليابانية': _JAPANESE_STR,
        'اللغة الصينية': _CHINESE_STR,
        'اللغة الفارسية': _PERSIAN_STR,
        'اللغة البرتغالية': _PORTUGUESE_STR,
        'اللغة الفرنسية': _FRENCH_STR,
        'اللغة العبرية': _HEBREW_STR,
        'لغات أخرى': _OTHER_STR,
    },
    'ind': {
        'Pelafalan': _PRONUNCIATION_STR,
        'Kelas Kata': _POS_STR,
        'Penggunaan': _CONJUGATION_STR,
        'Kata Jadian': _DERIVATIVE_STR,
        'Rujukan': _SENTENCE_REFERENCE_STR,
        'Rujuk Semua': _ALL_REFERENCE_STR,
        'Idiom': _IDIOM_STR,
        'Peribahasa': _PROVERB_STR,
        # definition info
        'Struktur Kalimat': _SENTENCE_PATT_STR,
        'Rujukan Struktur Kalimat': _SENTENCE_PATT_REF_STR,
        'Singkatan': _ABBREV_STR,
        'Bentuk Sopan': _HIGH_FORM_STR,
        'Ujaran Lembut': _SOFT_FORM_STR,
        'Antonim': _ANTONYM_STR,
        'Ujaran Ringan': _DIMINUTIVE_STR,
        'Bentuk Kasar': _LOW_FORM_STR,
        'Ujaran Keras': _EMPHATIC_STR,
        'Kata Rujukan': _REFERENCE_STR,
        'Ujaran Berat': _HEAVY_FORM_STR,
        'Kata Asal': _ORIG_FORM_STR,
        'Sinonim': _SYNONYM_STR,
        # original language
        'Kosakata Asli': _NATIVE_STR,
        'Kosakata Sino-Korea': _HANJA_STR,
        'Tidak dijelaskan': _UNKNOWN_STR,
        'Bahasa Inggris': _ENG_STR,
        'Bahasa Yunani': _GREEK_STR,
        'bahasa Jerman': _GERMAN_STR,
        'Bahasa Latin': _LATIN_STR,
        'Bahasa Sanskerta': _SANSKRIT_STR,
        'Bahasa Spanyol': _SPANISH_STR,
        'Bahasa Italia': _ITALIAN_STR,
        'Bahasa Jepang': _JAPANESE_STR,
        'bahasa Cina': _CHINESE_STR,
        'Bahasa Persia': _PERSIAN_STR,
        'Bahasa Portugis': _PORTUGUESE_STR,
        'Bahasa Prancis': _FRENCH_STR,
        'Bahasa Yahudi': _HEBREW_STR,
        'Bahasa lain': _OTHER_STR,
    },
    'jpn': {
        '発音': _PRONUNCIATION_STR,
        '品詞': _POS_STR,
        '活用形': _CONJUGATION_STR,
        '派生語': _DERIVATIVE_STR,
        '参考': _SENTENCE_REFERENCE_STR,
        '全体参考': _ALL_REFERENCE_STR,
        '慣用句': _IDIOM_STR,
        'ことわざ': _PROVERB_STR,
        # definition info
        '文型': _SENTENCE_PATT_STR,
        '文型参考': _SENTENCE_PATT_REF_STR,
        '縮約語': _ABBREV_STR,
        '敬称': _HIGH_FORM_STR,
        'ヨリンマル': _SOFT_FORM_STR,
        '対義語': _ANTONYM_STR,
        'チャグンマル': _DIMINUTIVE_STR,
        '卑称': _LOW_FORM_STR,
        'センマル': _EMPHATIC_STR,
        '参考語': _REFERENCE_STR,
        'クンマル': _HEAVY_FORM_STR,
        '元の語': _ORIG_FORM_STR,
        '類義語': _SYNONYM_STR,
        # original language
        '固有語': _NATIVE_STR,
        '漢字語': _HANJA_STR,
        '表示しない': _UNKNOWN_STR,
        '英語': _ENG_STR,
        'ギリシャ語': _GREEK_STR,
        'ドイツ語': _GERMAN_STR,
        'ラテン語': _LATIN_STR,
        'サンスクリット語': _SANSKRIT_STR,
        'イスパニア語': _SPANISH_STR,
        'イタリア語': _ITALIAN_STR,
        '日本語': _JAPANESE_STR,
        '中国語': _CHINESE_STR,
        'ペルシア語': _PERSIAN_STR,
        'ポルトガル語': _PORTUGUESE_STR,
        'フランス語': _FRENCH_STR,
        'ヘブライ語': _HEBREW_STR,
        'その他の言語': _OTHER_STR,
    },
    'chn': {
        '发音': _PRONUNCIATION_STR,
        '词类': _POS_STR,
        '活用': _CONJUGATION_STR,
        '派生词': _DERIVATIVE_STR,
        '参考': _SENTENCE_REFERENCE_STR,
        '全部参考': _ALL_REFERENCE_STR,
        '惯用语': _IDIOM_STR,
        '谚语': _PROVERB_STR,
        # definition info
        '句型': _SENTENCE_PATT_STR,
        '参考句型': _SENTENCE_PATT_REF_STR,
        '缩略词': _ABBREV_STR,
        '尊称': _HIGH_FORM_STR,
        '弱势词': _SOFT_FORM_STR,
        '反义词': _ANTONYM_STR,
        '拟小词': _DIMINUTIVE_STR,
        '谦称': _LOW_FORM_STR,
        '强势词': _EMPHATIC_STR,
        '参考词': _REFERENCE_STR,
        '拟大词': _HEAVY_FORM_STR,
        '原始词': _ORIG_FORM_STR,
        '近义词': _SYNONYM_STR,
        # original language
        '固有词': _NATIVE_STR,
        '汉字词': _HANJA_STR,
        '不详': _UNKNOWN_STR,
        '英语': _ENG_STR,
        '希腊语': _GREEK_STR,
        '德语': _GERMAN_STR,
        '拉丁语': _LATIN_STR,
        '梵语': _SANSKRIT_STR,
        '西班牙语': _SPANISH_STR,
        '意大利语': _ITALIAN_STR,
        '日语': _JAPANESE_STR,
        '汉语': _CHINESE_STR,
        '波斯语': _PERSIAN_STR,
        '葡萄牙语': _PORTUGUESE_STR,
        '法语': _FRENCH_STR,
        '希伯来语': _HEBREW_STR,
        '其他语言': _OTHER_STR,
    },
    'tha': {
        'การออกเสียง': _PRONUNCIATION_STR,
        'ชนิดของคำ': _POS_STR,
        'การประยุกต์ใช้': _CONJUGATION_STR,
        'คำแผลง': _DERIVATIVE_STR,
        'ดูเพิ่มเติม': _SENTENCE_REFERENCE_STR,
        'ดูเพิ่มเติมทั้งหมด': _ALL_REFERENCE_STR,
        'สำนวน': _IDIOM_STR,
        'สุภาษิต': _PROVERB_STR,
        # definition info
        'รูปแบบประโยค': _SENTENCE_PATT_STR,
        'รูปแบบประโยคเพิ่มเติม': _SENTENCE_PATT_REF_STR,
        'คำย่อ': _ABBREV_STR,
        'คำยกย่อง': _HIGH_FORM_STR,
        'คำที่ให้ความรู้สึกในเชิงเบา': _SOFT_FORM_STR,
        'คำตรงกันข้าม': _ANTONYM_STR,
        'คำที่ให้ความรู้สึกในเชิงบวก': _DIMINUTIVE_STR,
        'คำไม่สุภาพ': _LOW_FORM_STR,
        'คำที่ให้ความรู้สึกในเชิงหนัก': _EMPHATIC_STR,
        'คำเพิ่มเติม': _REFERENCE_STR,
        'คำที่ให้ความรู้สึกในเชิงลบ': _HEAVY_FORM_STR,
        'คำเต็ม': _ORIG_FORM_STR,
        'คำพ้องความหมาย': _SYNONYM_STR,
        # original language
        'คำเกาหลีแท้': _NATIVE_STR,
        'คำจีน': _HANJA_STR,
        'ไม่ระบุ': _UNKNOWN_STR,
        'ภาษาอังกฤษ': _ENG_STR,
        'ภาษากรีก': _GREEK_STR,
        'ภาษาเยอรมัน': _GERMAN_STR,
        'ภาษาละติน': _LATIN_STR,
        'ภาษาสันสกฤต': _SANSKRIT_STR,
        'ภาษาสเปน': _SPANISH_STR,
        'ภาษาอิตาลี': _ITALIAN_STR,
        'ภาษาญี่ปุ่น': _JAPANESE_STR,
        'ภาษาจีน': _CHINESE_STR,
        'ภาษาเปอร์เซีย': _PERSIAN_STR,
        'ภาษาโปรตุเกส': _PORTUGUESE_STR,
        'ภาษาฝรั่งเศส': _FRENCH_STR,
        'ภาษาฮีบรู': _HEBREW_STR,
        'ภาษาอื่น ๆ': _OTHER_STR,
    },
    'fra': {
        'Prononciation': _PRONUNCIATION_STR,
        'Catégorie grammaticale': _POS_STR,
        'Déclinaison': _CONJUGATION_STR,
        'Mot dérivé': _DERIVATIVE_STR,
        'Référence': _SENTENCE_REFERENCE_STR,
        'Référence générale': _ALL_REFERENCE_STR,
        'Expressions idiomatiques': _IDIOM_STR,
        'Proverbes': _PROVERB_STR,
        # definition info
        'Structure de phrase': _SENTENCE_PATT_STR,
        'Consulter la structure de phrase': _SENTENCE_PATT_REF_STR,
        'Abréviations': _ABBREV_STR,
        'Forme honorifique': _HIGH_FORM_STR,
        'Variante douce': _SOFT_FORM_STR,
        'Antonyme(s)': _ANTONYM_STR,
        'Variante légère': _DIMINUTIVE_STR,
        'Forme non honorifique': _LOW_FORM_STR,
        'Variante forte': _EMPHATIC_STR,
        'Terme(s) de référence': _REFERENCE_STR,
        'Variante lourde': _HEAVY_FORM_STR,
        'Terme principal': _ORIG_FORM_STR,
        'Synonyme(s)': _SYNONYM_STR,
        # original language
        'Mot purement coréen': _NATIVE_STR,
        'Mot sino-coréen': _HANJA_STR,
        'inconnue': _UNKNOWN_STR,
        'anglais': _ENG_STR,
        'grec': _GREEK_STR,
        'allemand': _GERMAN_STR,
        'latin': _LATIN_STR,
        'sanskrit': _SANSKRIT_STR,
        'espagnol': _SPANISH_STR,
        'italien': _ITALIAN_STR,
        'japonais': _JAPANESE_STR,
        'chinois': _CHINESE_STR,
        'perse': _PERSIAN_STR,
        'portuguais': _PORTUGUESE_STR,
        'français': _FRENCH_STR,
        'hébreu': _HEBREW_STR,
        'autre': _OTHER_STR,
    }
}
