# coding: utf-8

"""
    ExtremeCloud IQ API

    ExtremeCloud IQ RESTful API for external and internal applications.  # noqa: E501

    The version of the OpenAPI document: 22.6.4.1
    Contact: support@extremenetworks.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from extremecloudiq.api_client import ApiClient
from extremecloudiq.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ConfigurationUserManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_key_based_pcg_users(self, policy_id, xiq_create_key_based_pcg_users_request, **kwargs):  # noqa: E501
        """Add users to a PCG-enabled network policy  # noqa: E501

        Add users to a PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_key_based_pcg_users(policy_id, xiq_create_key_based_pcg_users_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqCreateKeyBasedPcgUsersRequest xiq_create_key_based_pcg_users_request: The payload of add users to PCG-enabled network policy (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_key_based_pcg_users_with_http_info(policy_id, xiq_create_key_based_pcg_users_request, **kwargs)  # noqa: E501

    def add_key_based_pcg_users_with_http_info(self, policy_id, xiq_create_key_based_pcg_users_request, **kwargs):  # noqa: E501
        """Add users to a PCG-enabled network policy  # noqa: E501

        Add users to a PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_key_based_pcg_users_with_http_info(policy_id, xiq_create_key_based_pcg_users_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqCreateKeyBasedPcgUsersRequest xiq_create_key_based_pcg_users_request: The payload of add users to PCG-enabled network policy (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'xiq_create_key_based_pcg_users_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_key_based_pcg_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `add_key_based_pcg_users`")  # noqa: E501
        # verify the required parameter 'xiq_create_key_based_pcg_users_request' is set
        if self.api_client.client_side_validation and ('xiq_create_key_based_pcg_users_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_create_key_based_pcg_users_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_create_key_based_pcg_users_request` when calling `add_key_based_pcg_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_create_key_based_pcg_users_request' in local_var_params:
            body_params = local_var_params['xiq_create_key_based_pcg_users_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_ports(self, policy_id, xiq_pcg_assign_ports_request, **kwargs):  # noqa: E501
        """Assign ports to devices in network policy  # noqa: E501

        Assign ports for devices (only support AP150W now) in a network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_ports(policy_id, xiq_pcg_assign_ports_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqPcgAssignPortsRequest xiq_pcg_assign_ports_request: The payload of assign ports for devices (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqPcgAssignPortsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assign_ports_with_http_info(policy_id, xiq_pcg_assign_ports_request, **kwargs)  # noqa: E501

    def assign_ports_with_http_info(self, policy_id, xiq_pcg_assign_ports_request, **kwargs):  # noqa: E501
        """Assign ports to devices in network policy  # noqa: E501

        Assign ports for devices (only support AP150W now) in a network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_ports_with_http_info(policy_id, xiq_pcg_assign_ports_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqPcgAssignPortsRequest xiq_pcg_assign_ports_request: The payload of assign ports for devices (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqPcgAssignPortsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'xiq_pcg_assign_ports_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `assign_ports`")  # noqa: E501
        # verify the required parameter 'xiq_pcg_assign_ports_request' is set
        if self.api_client.client_side_validation and ('xiq_pcg_assign_ports_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_pcg_assign_ports_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_pcg_assign_ports_request` when calling `assign_ports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_pcg_assign_ports_request' in local_var_params:
            body_params = local_var_params['xiq_pcg_assign_ports_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/port-assignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqPcgAssignPortsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_end_user(self, xiq_create_end_user_request, **kwargs):  # noqa: E501
        """Create an end user  # noqa: E501

        Create a new end user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_end_user(xiq_create_end_user_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqCreateEndUserRequest xiq_create_end_user_request: Create end user request body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqEndUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_end_user_with_http_info(xiq_create_end_user_request, **kwargs)  # noqa: E501

    def create_end_user_with_http_info(self, xiq_create_end_user_request, **kwargs):  # noqa: E501
        """Create an end user  # noqa: E501

        Create a new end user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_end_user_with_http_info(xiq_create_end_user_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqCreateEndUserRequest xiq_create_end_user_request: Create end user request body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqEndUser, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'xiq_create_end_user_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_end_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'xiq_create_end_user_request' is set
        if self.api_client.client_side_validation and ('xiq_create_end_user_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_create_end_user_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_create_end_user_request` when calling `create_end_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_create_end_user_request' in local_var_params:
            body_params = local_var_params['xiq_create_end_user_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/endusers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqEndUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_user_group(self, xiq_create_user_group_request, **kwargs):  # noqa: E501
        """Create user group  # noqa: E501

        Create a new user group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_group(xiq_create_user_group_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqCreateUserGroupRequest xiq_create_user_group_request: Create user group request body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqUserGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_user_group_with_http_info(xiq_create_user_group_request, **kwargs)  # noqa: E501

    def create_user_group_with_http_info(self, xiq_create_user_group_request, **kwargs):  # noqa: E501
        """Create user group  # noqa: E501

        Create a new user group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_group_with_http_info(xiq_create_user_group_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqCreateUserGroupRequest xiq_create_user_group_request: Create user group request body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqUserGroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'xiq_create_user_group_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'xiq_create_user_group_request' is set
        if self.api_client.client_side_validation and ('xiq_create_user_group_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_create_user_group_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_create_user_group_request` when calling `create_user_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_create_user_group_request' in local_var_params:
            body_params = local_var_params['xiq_create_user_group_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/usergroups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqUserGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_key_based_pcg_users(self, policy_id, xiq_delete_key_based_pcg_users_request, **kwargs):  # noqa: E501
        """Delete users from a PCG-enabled network policy  # noqa: E501

        Delete users from a PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_key_based_pcg_users(policy_id, xiq_delete_key_based_pcg_users_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqDeleteKeyBasedPcgUsersRequest xiq_delete_key_based_pcg_users_request: The payload of delete Key-based PCG users request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_key_based_pcg_users_with_http_info(policy_id, xiq_delete_key_based_pcg_users_request, **kwargs)  # noqa: E501

    def delete_key_based_pcg_users_with_http_info(self, policy_id, xiq_delete_key_based_pcg_users_request, **kwargs):  # noqa: E501
        """Delete users from a PCG-enabled network policy  # noqa: E501

        Delete users from a PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_key_based_pcg_users_with_http_info(policy_id, xiq_delete_key_based_pcg_users_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqDeleteKeyBasedPcgUsersRequest xiq_delete_key_based_pcg_users_request: The payload of delete Key-based PCG users request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'xiq_delete_key_based_pcg_users_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_key_based_pcg_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `delete_key_based_pcg_users`")  # noqa: E501
        # verify the required parameter 'xiq_delete_key_based_pcg_users_request' is set
        if self.api_client.client_side_validation and ('xiq_delete_key_based_pcg_users_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_delete_key_based_pcg_users_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_delete_key_based_pcg_users_request` when calling `delete_key_based_pcg_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_delete_key_based_pcg_users_request' in local_var_params:
            body_params = local_var_params['xiq_delete_key_based_pcg_users_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/users', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_pcg(self, policy_id, ids, **kwargs):  # noqa: E501
        """Delete Private Client Group from a network policy  # noqa: E501

        Delete Private Client Group settings from a network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pcg(policy_id, ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param list[int] ids: The IDs of the Key-based PCG entity to be deleted from network policy (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_pcg_with_http_info(policy_id, ids, **kwargs)  # noqa: E501

    def delete_pcg_with_http_info(self, policy_id, ids, **kwargs):  # noqa: E501
        """Delete Private Client Group from a network policy  # noqa: E501

        Delete Private Client Group settings from a network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pcg_with_http_info(policy_id, ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param list[int] ids: The IDs of the Key-based PCG entity to be deleted from network policy (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pcg" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `delete_pcg`")  # noqa: E501
        # verify the required parameter 'ids' is set
        if self.api_client.client_side_validation and ('ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ids` when calling `delete_pcg`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []
        if 'ids' in local_var_params and local_var_params['ids'] is not None:  # noqa: E501
            query_params.append(('ids', local_var_params['ids']))  # noqa: E501
            collection_formats['ids'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ssid_user(self, id, **kwargs):  # noqa: E501
        """Delete end user by ID  # noqa: E501

        Delete a specific end user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ssid_user(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The end user ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ssid_user_with_http_info(id, **kwargs)  # noqa: E501

    def delete_ssid_user_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete end user by ID  # noqa: E501

        Delete a specific end user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ssid_user_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The end user ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ssid_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_ssid_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/endusers/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_user_group(self, id, **kwargs):  # noqa: E501
        """Delete user group by ID  # noqa: E501

        Delete the user-group for the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_group(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The user group ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_user_group_with_http_info(id, **kwargs)  # noqa: E501

    def delete_user_group_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete user group by ID  # noqa: E501

        Delete the user-group for the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_group_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The user group ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_user_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/usergroups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def email_keys(self, policy_id, user_ids, **kwargs):  # noqa: E501
        """Send keys to users in network policy via Email  # noqa: E501

        Send keys to specified users in PCG-enabled network policy via Email.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_keys(policy_id, user_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param list[int] user_ids: The user IDs (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.email_keys_with_http_info(policy_id, user_ids, **kwargs)  # noqa: E501

    def email_keys_with_http_info(self, policy_id, user_ids, **kwargs):  # noqa: E501
        """Send keys to users in network policy via Email  # noqa: E501

        Send keys to specified users in PCG-enabled network policy via Email.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.email_keys_with_http_info(policy_id, user_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param list[int] user_ids: The user IDs (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'user_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method email_keys" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `email_keys`")  # noqa: E501
        # verify the required parameter 'user_ids' is set
        if self.api_client.client_side_validation and ('user_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_ids` when calling `email_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []
        if 'user_ids' in local_var_params and local_var_params['user_ids'] is not None:  # noqa: E501
            query_params.append(('userIds', local_var_params['user_ids']))  # noqa: E501
            collection_formats['userIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/keys/:email', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_keys(self, policy_id, user_ids, **kwargs):  # noqa: E501
        """Generate shared keys for users in network policy  # noqa: E501

        Generate/regenerate shared keys for specified users in a specific PCG-enable network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_keys(policy_id, user_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param list[int] user_ids: The user IDs (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.generate_keys_with_http_info(policy_id, user_ids, **kwargs)  # noqa: E501

    def generate_keys_with_http_info(self, policy_id, user_ids, **kwargs):  # noqa: E501
        """Generate shared keys for users in network policy  # noqa: E501

        Generate/regenerate shared keys for specified users in a specific PCG-enable network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_keys_with_http_info(policy_id, user_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param list[int] user_ids: The user IDs (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'user_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_keys" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `generate_keys`")  # noqa: E501
        # verify the required parameter 'user_ids' is set
        if self.api_client.client_side_validation and ('user_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_ids` when calling `generate_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []
        if 'user_ids' in local_var_params and local_var_params['user_ids'] is not None:  # noqa: E501
            query_params.append(('userIds', local_var_params['user_ids']))  # noqa: E501
            collection_formats['userIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/keys/:generate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_key_based_pcg_users(self, policy_id, **kwargs):  # noqa: E501
        """Get users for a PCG-enabled network policy  # noqa: E501

        Get users for a specific PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_key_based_pcg_users(policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[XiqKeyBasedPcgUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_key_based_pcg_users_with_http_info(policy_id, **kwargs)  # noqa: E501

    def get_key_based_pcg_users_with_http_info(self, policy_id, **kwargs):  # noqa: E501
        """Get users for a PCG-enabled network policy  # noqa: E501

        Get users for a specific PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_key_based_pcg_users_with_http_info(policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[XiqKeyBasedPcgUser], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_key_based_pcg_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `get_key_based_pcg_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[XiqKeyBasedPcgUser]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_port_assignments(self, policy_id, **kwargs):  # noqa: E501
        """Get device port assignments in network policy  # noqa: E501

        Get port assignments for devices (only support AP150W now) in a network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_port_assignments(policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqGetPortAssignmentDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_port_assignments_with_http_info(policy_id, **kwargs)  # noqa: E501

    def get_port_assignments_with_http_info(self, policy_id, **kwargs):  # noqa: E501
        """Get device port assignments in network policy  # noqa: E501

        Get port assignments for devices (only support AP150W now) in a network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_port_assignments_with_http_info(policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqGetPortAssignmentDetailsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_port_assignments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `get_port_assignments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/port-assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqGetPortAssignmentDetailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_email_templates(self, **kwargs):  # noqa: E501
        """List Email templates  # noqa: E501

        List all Email notification templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_email_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqPasswordType password_type: The password type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[XiqEmailTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_email_templates_with_http_info(**kwargs)  # noqa: E501

    def list_email_templates_with_http_info(self, **kwargs):  # noqa: E501
        """List Email templates  # noqa: E501

        List all Email notification templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_email_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqPasswordType password_type: The password type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[XiqEmailTemplate], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'password_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_email_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'password_type' in local_var_params and local_var_params['password_type'] is not None:  # noqa: E501
            query_params.append(('passwordType', local_var_params['password_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/email-templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[XiqEmailTemplate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_end_users(self, **kwargs):  # noqa: E501
        """List end users  # noqa: E501

        List a page of end users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_end_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param list[int] user_group_ids: The user group IDs
        :param list[str] usernames: The list of username
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedXiqEndUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_end_users_with_http_info(**kwargs)  # noqa: E501

    def list_end_users_with_http_info(self, **kwargs):  # noqa: E501
        """List end users  # noqa: E501

        List a page of end users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_end_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param list[int] user_group_ids: The user group IDs
        :param list[str] usernames: The list of username
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedXiqEndUser, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'page',
            'limit',
            'user_group_ids',
            'usernames'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_end_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'page' in local_var_params and local_var_params['page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_end_users`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_end_users`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_end_users`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'user_group_ids' in local_var_params and local_var_params['user_group_ids'] is not None:  # noqa: E501
            query_params.append(('user_group_ids', local_var_params['user_group_ids']))  # noqa: E501
            collection_formats['user_group_ids'] = 'multi'  # noqa: E501
        if 'usernames' in local_var_params and local_var_params['usernames'] is not None:  # noqa: E501
            query_params.append(('usernames', local_var_params['usernames']))  # noqa: E501
            collection_formats['usernames'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/endusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedXiqEndUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_key_based_private_client_groups(self, **kwargs):  # noqa: E501
        """List Key-based Private Client Groups  # noqa: E501

        List all Key-based Private Client Groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_key_based_private_client_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[XiqKeyBasedPcg]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_key_based_private_client_groups_with_http_info(**kwargs)  # noqa: E501

    def list_key_based_private_client_groups_with_http_info(self, **kwargs):  # noqa: E501
        """List Key-based Private Client Groups  # noqa: E501

        List all Key-based Private Client Groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_key_based_private_client_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[XiqKeyBasedPcg], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_key_based_private_client_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[XiqKeyBasedPcg]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sms_templates(self, **kwargs):  # noqa: E501
        """List SMS templates  # noqa: E501

        List all SMS notification templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sms_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqPasswordType password_type: The password type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[XiqSmsTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_sms_templates_with_http_info(**kwargs)  # noqa: E501

    def list_sms_templates_with_http_info(self, **kwargs):  # noqa: E501
        """List SMS templates  # noqa: E501

        List all SMS notification templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sms_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqPasswordType password_type: The password type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[XiqSmsTemplate], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'password_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sms_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'password_type' in local_var_params and local_var_params['password_type'] is not None:  # noqa: E501
            query_params.append(('passwordType', local_var_params['password_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/sms-templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[XiqSmsTemplate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_user_groups(self, **kwargs):  # noqa: E501
        """List user groups  # noqa: E501

        List a page of user groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_user_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param XiqPasswordDbLocation password_db_location: The password DB location
        :param XiqPasswordType password_type: The password type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedXiqUserGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_user_groups_with_http_info(**kwargs)  # noqa: E501

    def list_user_groups_with_http_info(self, **kwargs):  # noqa: E501
        """List user groups  # noqa: E501

        List a page of user groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_user_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param XiqPasswordDbLocation password_db_location: The password DB location
        :param XiqPasswordType password_type: The password type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedXiqUserGroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'page',
            'limit',
            'password_db_location',
            'password_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_user_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'page' in local_var_params and local_var_params['page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_user_groups`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_user_groups`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_user_groups`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'password_db_location' in local_var_params and local_var_params['password_db_location'] is not None:  # noqa: E501
            query_params.append(('password_db_location', local_var_params['password_db_location']))  # noqa: E501
        if 'password_type' in local_var_params and local_var_params['password_type'] is not None:  # noqa: E501
            query_params.append(('password_type', local_var_params['password_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/usergroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedXiqUserGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def onboard_key_based_private_client_group(self, policy_id, xiq_onboard_key_based_pcg_request, **kwargs):  # noqa: E501
        """Create Key-based PCG in network policy  # noqa: E501

        Create a Key-based Private Client Group for a specific network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.onboard_key_based_private_client_group(policy_id, xiq_onboard_key_based_pcg_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqOnboardKeyBasedPcgRequest xiq_onboard_key_based_pcg_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.onboard_key_based_private_client_group_with_http_info(policy_id, xiq_onboard_key_based_pcg_request, **kwargs)  # noqa: E501

    def onboard_key_based_private_client_group_with_http_info(self, policy_id, xiq_onboard_key_based_pcg_request, **kwargs):  # noqa: E501
        """Create Key-based PCG in network policy  # noqa: E501

        Create a Key-based Private Client Group for a specific network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.onboard_key_based_private_client_group_with_http_info(policy_id, xiq_onboard_key_based_pcg_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqOnboardKeyBasedPcgRequest xiq_onboard_key_based_pcg_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'xiq_onboard_key_based_pcg_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method onboard_key_based_private_client_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `onboard_key_based_private_client_group`")  # noqa: E501
        # verify the required parameter 'xiq_onboard_key_based_pcg_request' is set
        if self.api_client.client_side_validation and ('xiq_onboard_key_based_pcg_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_onboard_key_based_pcg_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_onboard_key_based_pcg_request` when calling `onboard_key_based_private_client_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_onboard_key_based_pcg_request' in local_var_params:
            body_params = local_var_params['xiq_onboard_key_based_pcg_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/:onboard', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def regenerate_end_user_password(self, id, **kwargs):  # noqa: E501
        """Regenerate a new password for the end user  # noqa: E501

        Update the user's password with a system generated password.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.regenerate_end_user_password(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The enduser's ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqRegenerateEndUserPasswordResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.regenerate_end_user_password_with_http_info(id, **kwargs)  # noqa: E501

    def regenerate_end_user_password_with_http_info(self, id, **kwargs):  # noqa: E501
        """Regenerate a new password for the end user  # noqa: E501

        Update the user's password with a system generated password.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.regenerate_end_user_password_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The enduser's ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqRegenerateEndUserPasswordResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method regenerate_end_user_password" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `regenerate_end_user_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/endusers/{id}/:regenerate-password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqRegenerateEndUserPasswordResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def setup_key_based_private_client_group_network_policy(self, xiq_init_key_based_pcg_network_policy_request, **kwargs):  # noqa: E501
        """Setup a Key-based Private Client Group  # noqa: E501

        Setup a Key-based Private Client Group, including network policy, user, user group, SSID, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.setup_key_based_private_client_group_network_policy(xiq_init_key_based_pcg_network_policy_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqInitKeyBasedPcgNetworkPolicyRequest xiq_init_key_based_pcg_network_policy_request: The request to setup Key-based PCG network policy (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.setup_key_based_private_client_group_network_policy_with_http_info(xiq_init_key_based_pcg_network_policy_request, **kwargs)  # noqa: E501

    def setup_key_based_private_client_group_network_policy_with_http_info(self, xiq_init_key_based_pcg_network_policy_request, **kwargs):  # noqa: E501
        """Setup a Key-based Private Client Group  # noqa: E501

        Setup a Key-based Private Client Group, including network policy, user, user group, SSID, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.setup_key_based_private_client_group_network_policy_with_http_info(xiq_init_key_based_pcg_network_policy_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqInitKeyBasedPcgNetworkPolicyRequest xiq_init_key_based_pcg_network_policy_request: The request to setup Key-based PCG network policy (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'xiq_init_key_based_pcg_network_policy_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method setup_key_based_private_client_group_network_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'xiq_init_key_based_pcg_network_policy_request' is set
        if self.api_client.client_side_validation and ('xiq_init_key_based_pcg_network_policy_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_init_key_based_pcg_network_policy_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_init_key_based_pcg_network_policy_request` when calling `setup_key_based_private_client_group_network_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_init_key_based_pcg_network_policy_request' in local_var_params:
            body_params = local_var_params['xiq_init_key_based_pcg_network_policy_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_end_user(self, id, xiq_update_end_user_request, **kwargs):  # noqa: E501
        """Update an end user  # noqa: E501

        Update a specific end user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_end_user(id, xiq_update_end_user_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The end user ID (required)
        :param XiqUpdateEndUserRequest xiq_update_end_user_request: Update end user request body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqEndUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_end_user_with_http_info(id, xiq_update_end_user_request, **kwargs)  # noqa: E501

    def update_end_user_with_http_info(self, id, xiq_update_end_user_request, **kwargs):  # noqa: E501
        """Update an end user  # noqa: E501

        Update a specific end user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_end_user_with_http_info(id, xiq_update_end_user_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The end user ID (required)
        :param XiqUpdateEndUserRequest xiq_update_end_user_request: Update end user request body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqEndUser, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'xiq_update_end_user_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_end_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_end_user`")  # noqa: E501
        # verify the required parameter 'xiq_update_end_user_request' is set
        if self.api_client.client_side_validation and ('xiq_update_end_user_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_update_end_user_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_update_end_user_request` when calling `update_end_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_update_end_user_request' in local_var_params:
            body_params = local_var_params['xiq_update_end_user_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/endusers/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqEndUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_key_based_pcg_users(self, policy_id, xiq_update_key_based_pcg_users_request, **kwargs):  # noqa: E501
        """Replace all users in a PCG-enabled network policy  # noqa: E501

        Replace all users in a specific PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_key_based_pcg_users(policy_id, xiq_update_key_based_pcg_users_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqUpdateKeyBasedPcgUsersRequest xiq_update_key_based_pcg_users_request: The payload of update Key-based PCG users request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_key_based_pcg_users_with_http_info(policy_id, xiq_update_key_based_pcg_users_request, **kwargs)  # noqa: E501

    def update_key_based_pcg_users_with_http_info(self, policy_id, xiq_update_key_based_pcg_users_request, **kwargs):  # noqa: E501
        """Replace all users in a PCG-enabled network policy  # noqa: E501

        Replace all users in a specific PCG-enabled network policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_key_based_pcg_users_with_http_info(policy_id, xiq_update_key_based_pcg_users_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int policy_id: The network policy ID (required)
        :param XiqUpdateKeyBasedPcgUsersRequest xiq_update_key_based_pcg_users_request: The payload of update Key-based PCG users request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'policy_id',
            'xiq_update_key_based_pcg_users_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_key_based_pcg_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_id' is set
        if self.api_client.client_side_validation and ('policy_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_id` when calling `update_key_based_pcg_users`")  # noqa: E501
        # verify the required parameter 'xiq_update_key_based_pcg_users_request' is set
        if self.api_client.client_side_validation and ('xiq_update_key_based_pcg_users_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_update_key_based_pcg_users_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_update_key_based_pcg_users_request` when calling `update_key_based_pcg_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in local_var_params:
            path_params['policyId'] = local_var_params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_update_key_based_pcg_users_request' in local_var_params:
            body_params = local_var_params['xiq_update_key_based_pcg_users_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pcgs/key-based/network-policy-{policyId}/users', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_group(self, id, xiq_update_user_group_request, **kwargs):  # noqa: E501
        """Update user group  # noqa: E501

        Update existing user group information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_group(id, xiq_update_user_group_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The user group ID. (required)
        :param XiqUpdateUserGroupRequest xiq_update_user_group_request: Update user-group request body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqUserGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_user_group_with_http_info(id, xiq_update_user_group_request, **kwargs)  # noqa: E501

    def update_user_group_with_http_info(self, id, xiq_update_user_group_request, **kwargs):  # noqa: E501
        """Update user group  # noqa: E501

        Update existing user group information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_group_with_http_info(id, xiq_update_user_group_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: The user group ID. (required)
        :param XiqUpdateUserGroupRequest xiq_update_user_group_request: Update user-group request body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqUserGroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'xiq_update_user_group_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_user_group`")  # noqa: E501
        # verify the required parameter 'xiq_update_user_group_request' is set
        if self.api_client.client_side_validation and ('xiq_update_user_group_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['xiq_update_user_group_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `xiq_update_user_group_request` when calling `update_user_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'xiq_update_user_group_request' in local_var_params:
            body_params = local_var_params['xiq_update_user_group_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/usergroups/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqUserGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
