# extremecloudiq-api
ExtremeCloud IQ RESTful API for external and internal applications.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 22.6.4.1
- Package version: 22.6.4.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.extremenetworks.com/support](https://www.extremenetworks.com/support)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import extremecloudiq
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import extremecloudiq
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import extremecloudiq
from extremecloudiq.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8081
# See configuration.py for a list of all supported configuration parameters.
configuration = extremecloudiq.Configuration(
    host = "http://localhost:8081"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): BearerAuth
configuration = extremecloudiq.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with extremecloudiq.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = extremecloudiq.AccountApi(api_client)
    
    try:
        # Backup VIQ
        api_instance.backup_viq()
    except ApiException as e:
        print("Exception when calling AccountApi->backup_viq: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8081*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**backup_viq**](docs/AccountApi.md#backup_viq) | **POST** /account/viq/:backup | Backup VIQ
*AccountApi* | [**get_default_device_password**](docs/AccountApi.md#get_default_device_password) | **GET** /account/viq/default-device-password | Get the default device password in the account
*AccountApi* | [**get_home_account**](docs/AccountApi.md#get_home_account) | **GET** /account/home | Get home ExtremeCloud IQ account info
*AccountApi* | [**get_viq_info**](docs/AccountApi.md#get_viq_info) | **GET** /account/viq | Get VIQ Info
*AccountApi* | [**list_external_accounts**](docs/AccountApi.md#list_external_accounts) | **GET** /account/external | List accessible external guest accounts
*AccountApi* | [**switch_account**](docs/AccountApi.md#switch_account) | **POST** /account/:switch | Switch to another ExtremeCloud IQ account
*AccountApi* | [**update_default_device_password**](docs/AccountApi.md#update_default_device_password) | **PUT** /account/viq/default-device-password | Update the default device password in the account
*ApplicationApi* | [**list_application_top_clients_usage**](docs/ApplicationApi.md#list_application_top_clients_usage) | **GET** /applications/{id}/clients/top{n} | List the TopN clients for a application
*ApplicationApi* | [**list_applications**](docs/ApplicationApi.md#list_applications) | **GET** /applications | List the applications
*ApplicationApi* | [**list_top_applications_usage**](docs/ApplicationApi.md#list_top_applications_usage) | **GET** /applications/top{n} | List the TopN applications
*AuthenticationApi* | [**login**](docs/AuthenticationApi.md#login) | **POST** /login | User login with username and password
*AuthenticationApi* | [**logout**](docs/AuthenticationApi.md#logout) | **POST** /logout | User logout (Revoke the current access token)
*AuthorizationApi* | [**check_permissions**](docs/AuthorizationApi.md#check_permissions) | **POST** /auth/permissions/:check | Check permissions
*AuthorizationApi* | [**generate_api_token**](docs/AuthorizationApi.md#generate_api_token) | **POST** /auth/apitoken | Generate new API token
*AuthorizationApi* | [**get_current_api_token_info**](docs/AuthorizationApi.md#get_current_api_token_info) | **GET** /auth/apitoken/info | Get current API token details
*AuthorizationApi* | [**list_permissions**](docs/AuthorizationApi.md#list_permissions) | **GET** /auth/permissions | Get permissions for current login user
*ClientApi* | [**get_client**](docs/ClientApi.md#get_client) | **GET** /clients/{id} | Get client info
*ClientApi* | [**get_client_summary**](docs/ClientApi.md#get_client_summary) | **GET** /clients/summary | Get client summary metrics
*ClientApi* | [**get_client_usage**](docs/ClientApi.md#get_client_usage) | **GET** /clients/usage | Get usage per client
*ClientApi* | [**list_active_clients**](docs/ClientApi.md#list_active_clients) | **GET** /clients/active | List active clients
*ConfigurationAuthenticationApi* | [**create_external_radius_server**](docs/ConfigurationAuthenticationApi.md#create_external_radius_server) | **POST** /radius-servers/external | Create external RADIUS server configuration
*ConfigurationAuthenticationApi* | [**create_internal_radius_server**](docs/ConfigurationAuthenticationApi.md#create_internal_radius_server) | **POST** /radius-servers/internal | Create internal RADIUS server configuration
*ConfigurationAuthenticationApi* | [**create_ldap_server**](docs/ConfigurationAuthenticationApi.md#create_ldap_server) | **POST** /ldap-servers | Create LDAP server
*ConfigurationAuthenticationApi* | [**create_radius_client_object**](docs/ConfigurationAuthenticationApi.md#create_radius_client_object) | **POST** /radius-client-objects | Create RADIUS client object configuration
*ConfigurationAuthenticationApi* | [**create_radius_proxy**](docs/ConfigurationAuthenticationApi.md#create_radius_proxy) | **POST** /radius-proxies | Create RADIUS proxy configuration
*ConfigurationAuthenticationApi* | [**delete_external_radius_server**](docs/ConfigurationAuthenticationApi.md#delete_external_radius_server) | **DELETE** /radius-servers/external/{id} | Delete external RADIUS server configuration
*ConfigurationAuthenticationApi* | [**delete_internal_radius_server**](docs/ConfigurationAuthenticationApi.md#delete_internal_radius_server) | **DELETE** /radius-servers/internal/{id} | Delete internal RADIUS server configuration
*ConfigurationAuthenticationApi* | [**delete_ldap_server**](docs/ConfigurationAuthenticationApi.md#delete_ldap_server) | **DELETE** /ldap-servers/{id} | Delete a LDAP server
*ConfigurationAuthenticationApi* | [**delete_radius_client_object**](docs/ConfigurationAuthenticationApi.md#delete_radius_client_object) | **DELETE** /radius-client-objects/{id} | Delete a RADIUS client object configuration
*ConfigurationAuthenticationApi* | [**delete_radius_proxy**](docs/ConfigurationAuthenticationApi.md#delete_radius_proxy) | **DELETE** /radius-proxies/{id} | Delete the RADIUS proxy configuration
*ConfigurationAuthenticationApi* | [**get_external_radius_server**](docs/ConfigurationAuthenticationApi.md#get_external_radius_server) | **GET** /radius-servers/external/{id} | Get external RADIUS server by ID
*ConfigurationAuthenticationApi* | [**get_internal_radius_server**](docs/ConfigurationAuthenticationApi.md#get_internal_radius_server) | **GET** /radius-servers/internal/{id} | Get internal RADIUS server by ID
*ConfigurationAuthenticationApi* | [**get_ldap_server**](docs/ConfigurationAuthenticationApi.md#get_ldap_server) | **GET** /ldap-servers/{id} | Get LDAP server by ID
*ConfigurationAuthenticationApi* | [**get_radius_client_object**](docs/ConfigurationAuthenticationApi.md#get_radius_client_object) | **GET** /radius-client-objects/{id} | Get RADIUS client object by ID
*ConfigurationAuthenticationApi* | [**get_radius_proxy**](docs/ConfigurationAuthenticationApi.md#get_radius_proxy) | **GET** /radius-proxies/{id} | Get the RADIUS proxy configuration
*ConfigurationAuthenticationApi* | [**list_active_directory_servers**](docs/ConfigurationAuthenticationApi.md#list_active_directory_servers) | **GET** /ad-servers | List active directory servers
*ConfigurationAuthenticationApi* | [**list_captive_web_portals**](docs/ConfigurationAuthenticationApi.md#list_captive_web_portals) | **GET** /cwps | List captive web portals
*ConfigurationAuthenticationApi* | [**list_external_radius_servers**](docs/ConfigurationAuthenticationApi.md#list_external_radius_servers) | **GET** /radius-servers/external | List external RADIUS servers
*ConfigurationAuthenticationApi* | [**list_internal_radius_devices**](docs/ConfigurationAuthenticationApi.md#list_internal_radius_devices) | **GET** /radius-servers/internal/devices | List all internal RADIUS devices
*ConfigurationAuthenticationApi* | [**list_internal_radius_servers**](docs/ConfigurationAuthenticationApi.md#list_internal_radius_servers) | **GET** /radius-servers/internal | List all internal RADIUS servers
*ConfigurationAuthenticationApi* | [**list_ldap_servers**](docs/ConfigurationAuthenticationApi.md#list_ldap_servers) | **GET** /ldap-servers | List LDAP servers
*ConfigurationAuthenticationApi* | [**list_radius_client_objects**](docs/ConfigurationAuthenticationApi.md#list_radius_client_objects) | **GET** /radius-client-objects | List RADIUS client objects
*ConfigurationAuthenticationApi* | [**list_radius_proxies**](docs/ConfigurationAuthenticationApi.md#list_radius_proxies) | **GET** /radius-proxies | List RADIUS proxies
*ConfigurationAuthenticationApi* | [**list_radius_proxy_devices**](docs/ConfigurationAuthenticationApi.md#list_radius_proxy_devices) | **GET** /radius-proxies/devices | List Radius proxy devices
*ConfigurationAuthenticationApi* | [**update_external_radius_server**](docs/ConfigurationAuthenticationApi.md#update_external_radius_server) | **PUT** /radius-servers/external/{id} | Update external RADIUS server configuration
*ConfigurationAuthenticationApi* | [**update_internal_radius_server**](docs/ConfigurationAuthenticationApi.md#update_internal_radius_server) | **PUT** /radius-servers/internal/{id} | Update internal RADIUS server configuration
*ConfigurationAuthenticationApi* | [**update_ldap_server**](docs/ConfigurationAuthenticationApi.md#update_ldap_server) | **PUT** /ldap-servers/{id} | Update LDAP server configuration
*ConfigurationAuthenticationApi* | [**update_radius_client_object**](docs/ConfigurationAuthenticationApi.md#update_radius_client_object) | **PUT** /radius-client-objects/{id} | Update RADIUS client object configuration
*ConfigurationAuthenticationApi* | [**update_radius_proxy**](docs/ConfigurationAuthenticationApi.md#update_radius_proxy) | **PUT** /radius-proxies/{id} | Update RADIUS proxy configuration
*ConfigurationBasicApi* | [**create_vlan_profile**](docs/ConfigurationBasicApi.md#create_vlan_profile) | **POST** /vlan-profiles | Create VLAN profile
*ConfigurationBasicApi* | [**delete_vlan_profile**](docs/ConfigurationBasicApi.md#delete_vlan_profile) | **DELETE** /vlan-profiles/{id} | Delete a VLAN profile
*ConfigurationBasicApi* | [**get_vlan_profile**](docs/ConfigurationBasicApi.md#get_vlan_profile) | **GET** /vlan-profiles/{id} | Get a VLAN profile
*ConfigurationBasicApi* | [**list_vlan_profiles**](docs/ConfigurationBasicApi.md#list_vlan_profiles) | **GET** /vlan-profiles | List VLAN profiles
*ConfigurationBasicApi* | [**update_vlan_profile**](docs/ConfigurationBasicApi.md#update_vlan_profile) | **PATCH** /vlan-profiles/{id} | Update a VLAN profile
*ConfigurationCertificateApi* | [**list_certificates**](docs/ConfigurationCertificateApi.md#list_certificates) | **GET** /certificates | List certificates
*ConfigurationDeploymentApi* | [**deploy_config**](docs/ConfigurationDeploymentApi.md#deploy_config) | **POST** /deployments | Push configuration and upgrade firmware
*ConfigurationDeploymentApi* | [**get_deploy_overview**](docs/ConfigurationDeploymentApi.md#get_deploy_overview) | **GET** /deployments/overview | Get configuration deployment overview
*ConfigurationDeploymentApi* | [**get_deploy_status**](docs/ConfigurationDeploymentApi.md#get_deploy_status) | **GET** /deployments/status | Get configuration deployment status
*ConfigurationPolicyApi* | [**attach_cwp_to_ssid**](docs/ConfigurationPolicyApi.md#attach_cwp_to_ssid) | **POST** /ssids/{id}/cwp/:attach | Attach CWP to an SSID
*ConfigurationPolicyApi* | [**attach_radius_server_group_to_ssid**](docs/ConfigurationPolicyApi.md#attach_radius_server_group_to_ssid) | **POST** /ssids/{id}/radius-server-group/:attach | Attach radius server group to an SSID
*ConfigurationPolicyApi* | [**attach_user_profile_to_ssid**](docs/ConfigurationPolicyApi.md#attach_user_profile_to_ssid) | **POST** /ssids/{id}/user-profile/:attach | Attach user profile to an SSID
*ConfigurationPolicyApi* | [**change_psk_password**](docs/ConfigurationPolicyApi.md#change_psk_password) | **PUT** /ssids/{id}/psk/password | Change the SSID PSK password
*ConfigurationPolicyApi* | [**create_classification_rule**](docs/ConfigurationPolicyApi.md#create_classification_rule) | **POST** /classification-rules | Create classification rule
*ConfigurationPolicyApi* | [**create_cloud_config_group**](docs/ConfigurationPolicyApi.md#create_cloud_config_group) | **POST** /ccgs | Create new cloud config group
*ConfigurationPolicyApi* | [**create_mac_oui_profile**](docs/ConfigurationPolicyApi.md#create_mac_oui_profile) | **POST** /radio-profiles/mac-ouis | Create a MAC OUI profile
*ConfigurationPolicyApi* | [**create_radio_profile**](docs/ConfigurationPolicyApi.md#create_radio_profile) | **POST** /radio-profiles | Create a radio profile
*ConfigurationPolicyApi* | [**create_user_profile**](docs/ConfigurationPolicyApi.md#create_user_profile) | **POST** /user-profiles | Create a user profile
*ConfigurationPolicyApi* | [**delete_classification_rule**](docs/ConfigurationPolicyApi.md#delete_classification_rule) | **DELETE** /classification-rules/{id} | Delete classification rule by ID
*ConfigurationPolicyApi* | [**delete_cloud_config_group**](docs/ConfigurationPolicyApi.md#delete_cloud_config_group) | **DELETE** /ccgs/{id} | Delete a cloud config group
*ConfigurationPolicyApi* | [**delete_co_user_profile**](docs/ConfigurationPolicyApi.md#delete_co_user_profile) | **DELETE** /user-profiles/{id} | Delete an user profile by ID
*ConfigurationPolicyApi* | [**delete_radio_profile**](docs/ConfigurationPolicyApi.md#delete_radio_profile) | **DELETE** /radio-profiles/{id} | Delete radio profile by ID
*ConfigurationPolicyApi* | [**delete_rp_mac_oui_profile**](docs/ConfigurationPolicyApi.md#delete_rp_mac_oui_profile) | **DELETE** /radio-profiles/mac-ouis/{id} | Delete MAC OUI profile
*ConfigurationPolicyApi* | [**disable_ssid_cwp**](docs/ConfigurationPolicyApi.md#disable_ssid_cwp) | **POST** /ssids/{id}/cwp/:disable | Disable the CWP on the SSID
*ConfigurationPolicyApi* | [**enable_ssid_cwp**](docs/ConfigurationPolicyApi.md#enable_ssid_cwp) | **POST** /ssids/{id}/cwp/:enable | Enable and attach the CWP on the SSID
*ConfigurationPolicyApi* | [**get_classification_rule**](docs/ConfigurationPolicyApi.md#get_classification_rule) | **GET** /classification-rules/{id} | Get a classification rule by ID
*ConfigurationPolicyApi* | [**get_cloud_config_group**](docs/ConfigurationPolicyApi.md#get_cloud_config_group) | **GET** /ccgs/{id} | Get a cloud config group
*ConfigurationPolicyApi* | [**get_neighborhood_analysis**](docs/ConfigurationPolicyApi.md#get_neighborhood_analysis) | **GET** /radio-profiles/neighborhood-analysis/{id} | Get neighborhood analysis settings
*ConfigurationPolicyApi* | [**get_radio_profile**](docs/ConfigurationPolicyApi.md#get_radio_profile) | **GET** /radio-profiles/{id} | Get radio profile by ID
*ConfigurationPolicyApi* | [**get_rp_channel_selection**](docs/ConfigurationPolicyApi.md#get_rp_channel_selection) | **GET** /radio-profiles/channel-selection/{id} | Get channel selection settings
*ConfigurationPolicyApi* | [**get_rp_mac_oui_profile**](docs/ConfigurationPolicyApi.md#get_rp_mac_oui_profile) | **GET** /radio-profiles/mac-ouis/{id} | Get MAC OUI profile
*ConfigurationPolicyApi* | [**get_rp_miscellaneous_settings**](docs/ConfigurationPolicyApi.md#get_rp_miscellaneous_settings) | **GET** /radio-profiles/miscellaneous/{id} | Get radio miscellaneous settings
*ConfigurationPolicyApi* | [**get_rp_radio_usage_optimization**](docs/ConfigurationPolicyApi.md#get_rp_radio_usage_optimization) | **GET** /radio-profiles/radio-usage-opt/{id} | Get radio usage optimization settings
*ConfigurationPolicyApi* | [**get_rp_sensor_scan_settings**](docs/ConfigurationPolicyApi.md#get_rp_sensor_scan_settings) | **GET** /radio-profiles/sensor-scan/{id} | Get sensor scan settings
*ConfigurationPolicyApi* | [**get_rp_wmm_qos_settings**](docs/ConfigurationPolicyApi.md#get_rp_wmm_qos_settings) | **GET** /radio-profiles/wmm-qos/{id} | Get Wmm QoS settings
*ConfigurationPolicyApi* | [**get_user_profile**](docs/ConfigurationPolicyApi.md#get_user_profile) | **GET** /user-profiles/{id} | Get user profile by ID
*ConfigurationPolicyApi* | [**list_classification_rules**](docs/ConfigurationPolicyApi.md#list_classification_rules) | **GET** /classification-rules | List classification rules
*ConfigurationPolicyApi* | [**list_cloud_config_groups**](docs/ConfigurationPolicyApi.md#list_cloud_config_groups) | **GET** /ccgs | List clould config groups
*ConfigurationPolicyApi* | [**list_l3_address_profiles**](docs/ConfigurationPolicyApi.md#list_l3_address_profiles) | **GET** /l3-address-profiles | List L3 address profiles
*ConfigurationPolicyApi* | [**list_radio_profiles**](docs/ConfigurationPolicyApi.md#list_radio_profiles) | **GET** /radio-profiles | List radio profiles
*ConfigurationPolicyApi* | [**list_rp_mac_oui_profiles**](docs/ConfigurationPolicyApi.md#list_rp_mac_oui_profiles) | **GET** /radio-profiles/mac-ouis | List MAC OUI profiles
*ConfigurationPolicyApi* | [**list_ssids**](docs/ConfigurationPolicyApi.md#list_ssids) | **GET** /ssids | List SSIDs
*ConfigurationPolicyApi* | [**list_user_profiles**](docs/ConfigurationPolicyApi.md#list_user_profiles) | **GET** /user-profiles | List user profiles
*ConfigurationPolicyApi* | [**rename_ssid**](docs/ConfigurationPolicyApi.md#rename_ssid) | **POST** /ssids/{id}/:rename | Rename SSID (Wireless name)
*ConfigurationPolicyApi* | [**set_ssid_mode_dot1x**](docs/ConfigurationPolicyApi.md#set_ssid_mode_dot1x) | **PUT** /ssids/{id}/mode/dot1x | Change the SSID mode to 802.1x
*ConfigurationPolicyApi* | [**set_ssid_mode_open**](docs/ConfigurationPolicyApi.md#set_ssid_mode_open) | **PUT** /ssids/{id}/mode/open | Change the SSID mode to open access
*ConfigurationPolicyApi* | [**set_ssid_mode_ppsk**](docs/ConfigurationPolicyApi.md#set_ssid_mode_ppsk) | **PUT** /ssids/{id}/mode/ppsk | Change the SSID mode to PPSK
*ConfigurationPolicyApi* | [**set_ssid_mode_psk**](docs/ConfigurationPolicyApi.md#set_ssid_mode_psk) | **PUT** /ssids/{id}/mode/psk | Change the SSID mode to PSK
*ConfigurationPolicyApi* | [**set_ssid_mode_wep**](docs/ConfigurationPolicyApi.md#set_ssid_mode_wep) | **PUT** /ssids/{id}/mode/wep | Change the SSID mode to WEP
*ConfigurationPolicyApi* | [**update_classification_rule**](docs/ConfigurationPolicyApi.md#update_classification_rule) | **PUT** /classification-rules/{id} | Update classification rule
*ConfigurationPolicyApi* | [**update_cloud_config_group**](docs/ConfigurationPolicyApi.md#update_cloud_config_group) | **PUT** /ccgs/{id} | Update cloud config group information
*ConfigurationPolicyApi* | [**update_co_user_profile**](docs/ConfigurationPolicyApi.md#update_co_user_profile) | **PUT** /user-profiles/{id} | Update user profile
*ConfigurationPolicyApi* | [**update_neighborhood_analysis**](docs/ConfigurationPolicyApi.md#update_neighborhood_analysis) | **PUT** /radio-profiles/neighborhood-analysis/{id} | Update neighborhood analysis settings
*ConfigurationPolicyApi* | [**update_radio_profile**](docs/ConfigurationPolicyApi.md#update_radio_profile) | **PUT** /radio-profiles/{id} | Update radio profile by ID
*ConfigurationPolicyApi* | [**update_rp_channel_selection**](docs/ConfigurationPolicyApi.md#update_rp_channel_selection) | **PUT** /radio-profiles/channel-selection/{id} | Update channel selection settings
*ConfigurationPolicyApi* | [**update_rp_mac_oui_profile**](docs/ConfigurationPolicyApi.md#update_rp_mac_oui_profile) | **PUT** /radio-profiles/mac-ouis/{id} | Update MAC OUI profile
*ConfigurationPolicyApi* | [**update_rp_miscellaneous_settings**](docs/ConfigurationPolicyApi.md#update_rp_miscellaneous_settings) | **PUT** /radio-profiles/miscellaneous/{id} | Update radio miscellaneous settings
*ConfigurationPolicyApi* | [**update_rp_radio_usage_optimization**](docs/ConfigurationPolicyApi.md#update_rp_radio_usage_optimization) | **PUT** /radio-profiles/radio-usage-opt/{id} | Update radio usage optimization settings
*ConfigurationPolicyApi* | [**update_rp_sensor_scan_settings**](docs/ConfigurationPolicyApi.md#update_rp_sensor_scan_settings) | **PUT** /radio-profiles/sensor-scan/{id} | Update sensor scan settings
*ConfigurationPolicyApi* | [**update_rp_wmm_qos_settings**](docs/ConfigurationPolicyApi.md#update_rp_wmm_qos_settings) | **PUT** /radio-profiles/wmm-qos/{id} | Update Wmm QoS settings
*ConfigurationUserManagementApi* | [**add_key_based_pcg_users**](docs/ConfigurationUserManagementApi.md#add_key_based_pcg_users) | **POST** /pcgs/key-based/network-policy-{policyId}/users | Add users to a PCG-enabled network policy
*ConfigurationUserManagementApi* | [**assign_ports**](docs/ConfigurationUserManagementApi.md#assign_ports) | **POST** /pcgs/key-based/network-policy-{policyId}/port-assignments | Assign ports to devices in network policy
*ConfigurationUserManagementApi* | [**create_end_user**](docs/ConfigurationUserManagementApi.md#create_end_user) | **POST** /endusers | Create an end user
*ConfigurationUserManagementApi* | [**create_user_group**](docs/ConfigurationUserManagementApi.md#create_user_group) | **POST** /usergroups | Create user group
*ConfigurationUserManagementApi* | [**delete_key_based_pcg_users**](docs/ConfigurationUserManagementApi.md#delete_key_based_pcg_users) | **DELETE** /pcgs/key-based/network-policy-{policyId}/users | Delete users from a PCG-enabled network policy
*ConfigurationUserManagementApi* | [**delete_pcg**](docs/ConfigurationUserManagementApi.md#delete_pcg) | **DELETE** /pcgs/key-based/network-policy-{policyId} | Delete Private Client Group from a network policy
*ConfigurationUserManagementApi* | [**delete_ssid_user**](docs/ConfigurationUserManagementApi.md#delete_ssid_user) | **DELETE** /endusers/{id} | Delete end user by ID
*ConfigurationUserManagementApi* | [**delete_user_group**](docs/ConfigurationUserManagementApi.md#delete_user_group) | **DELETE** /usergroups/{id} | Delete user group by ID
*ConfigurationUserManagementApi* | [**email_keys**](docs/ConfigurationUserManagementApi.md#email_keys) | **POST** /pcgs/key-based/network-policy-{policyId}/keys/:email | Send keys to users in network policy via Email
*ConfigurationUserManagementApi* | [**generate_keys**](docs/ConfigurationUserManagementApi.md#generate_keys) | **POST** /pcgs/key-based/network-policy-{policyId}/keys/:generate | Generate shared keys for users in network policy
*ConfigurationUserManagementApi* | [**get_key_based_pcg_users**](docs/ConfigurationUserManagementApi.md#get_key_based_pcg_users) | **GET** /pcgs/key-based/network-policy-{policyId}/users | Get users for a PCG-enabled network policy
*ConfigurationUserManagementApi* | [**get_port_assignments**](docs/ConfigurationUserManagementApi.md#get_port_assignments) | **GET** /pcgs/key-based/network-policy-{policyId}/port-assignments | Get device port assignments in network policy
*ConfigurationUserManagementApi* | [**list_email_templates**](docs/ConfigurationUserManagementApi.md#list_email_templates) | **GET** /email-templates | List Email templates
*ConfigurationUserManagementApi* | [**list_end_users**](docs/ConfigurationUserManagementApi.md#list_end_users) | **GET** /endusers | List end users
*ConfigurationUserManagementApi* | [**list_key_based_private_client_groups**](docs/ConfigurationUserManagementApi.md#list_key_based_private_client_groups) | **GET** /pcgs/key-based | List Key-based Private Client Groups
*ConfigurationUserManagementApi* | [**list_sms_templates**](docs/ConfigurationUserManagementApi.md#list_sms_templates) | **GET** /sms-templates | List SMS templates
*ConfigurationUserManagementApi* | [**list_user_groups**](docs/ConfigurationUserManagementApi.md#list_user_groups) | **GET** /usergroups | List user groups
*ConfigurationUserManagementApi* | [**onboard_key_based_private_client_group**](docs/ConfigurationUserManagementApi.md#onboard_key_based_private_client_group) | **POST** /pcgs/key-based/network-policy-{policyId}/:onboard | Create Key-based PCG in network policy
*ConfigurationUserManagementApi* | [**regenerate_end_user_password**](docs/ConfigurationUserManagementApi.md#regenerate_end_user_password) | **POST** /endusers/{id}/:regenerate-password | Regenerate a new password for the end user
*ConfigurationUserManagementApi* | [**setup_key_based_private_client_group_network_policy**](docs/ConfigurationUserManagementApi.md#setup_key_based_private_client_group_network_policy) | **POST** /pcgs/key-based | Setup a Key-based Private Client Group
*ConfigurationUserManagementApi* | [**update_end_user**](docs/ConfigurationUserManagementApi.md#update_end_user) | **PUT** /endusers/{id} | Update an end user
*ConfigurationUserManagementApi* | [**update_key_based_pcg_users**](docs/ConfigurationUserManagementApi.md#update_key_based_pcg_users) | **PUT** /pcgs/key-based/network-policy-{policyId}/users | Replace all users in a PCG-enabled network policy
*ConfigurationUserManagementApi* | [**update_user_group**](docs/ConfigurationUserManagementApi.md#update_user_group) | **PUT** /usergroups/{id} | Update user group
*DeviceApi* | [**assign_device_location**](docs/DeviceApi.md#assign_device_location) | **PUT** /devices/{id}/location | Assign location to a device
*DeviceApi* | [**assign_device_network_policy**](docs/DeviceApi.md#assign_device_network_policy) | **PUT** /devices/{id}/network-policy | Assign network policy to a device
*DeviceApi* | [**assign_devices_country_code**](docs/DeviceApi.md#assign_devices_country_code) | **POST** /devices/country-code/:assign | Assign a country code to devices
*DeviceApi* | [**assign_devices_location**](docs/DeviceApi.md#assign_devices_location) | **POST** /devices/location/:assign | Assign location to multiple devices
*DeviceApi* | [**assign_devices_network_policy**](docs/DeviceApi.md#assign_devices_network_policy) | **POST** /devices/network-policy/:assign | Assign network policy to multiple devices
*DeviceApi* | [**assign_devices_radius_proxy**](docs/DeviceApi.md#assign_devices_radius_proxy) | **PUT** /devices/radius-proxy/:assign | Assign RADIUS proxy to devices
*DeviceApi* | [**change_device_description**](docs/DeviceApi.md#change_device_description) | **PUT** /devices/{id}/description | Change description for a device
*DeviceApi* | [**change_device_level_ssid_status**](docs/DeviceApi.md#change_device_level_ssid_status) | **POST** /devices/{id}/ssid/status/:change | Enable or disable SSID for a device
*DeviceApi* | [**change_device_status_to_manage**](docs/DeviceApi.md#change_device_status_to_manage) | **POST** /devices/{id}/:manage | Change admin state to &#39;Managed&#39; for a device
*DeviceApi* | [**change_device_status_to_unmanage**](docs/DeviceApi.md#change_device_status_to_unmanage) | **POST** /devices/{id}/:unmanage | Change admin state to &#39;Unmanaged&#39; for a device
*DeviceApi* | [**change_devices_os_mode**](docs/DeviceApi.md#change_devices_os_mode) | **POST** /devices/os/:change | Change device OS mode
*DeviceApi* | [**change_hostname**](docs/DeviceApi.md#change_hostname) | **PUT** /devices/{id}/hostname | Change hostname for a device
*DeviceApi* | [**change_status_to_manage**](docs/DeviceApi.md#change_status_to_manage) | **POST** /devices/:manage | Change status to Managed
*DeviceApi* | [**change_status_to_unmanage**](docs/DeviceApi.md#change_status_to_unmanage) | **POST** /devices/:unmanage | Change status to Unmanaged
*DeviceApi* | [**delete_device**](docs/DeviceApi.md#delete_device) | **DELETE** /devices/{id} | Delete a device
*DeviceApi* | [**delete_devices**](docs/DeviceApi.md#delete_devices) | **POST** /devices/:delete | Delete devices
*DeviceApi* | [**get_device**](docs/DeviceApi.md#get_device) | **GET** /devices/{id} | Get device info for a specific device
*DeviceApi* | [**get_device_cpu_memory_history**](docs/DeviceApi.md#get_device_cpu_memory_history) | **GET** /devices/{id}/history/cpu-mem | Get device CPU/memory usage history
*DeviceApi* | [**get_device_level_ssid_status**](docs/DeviceApi.md#get_device_level_ssid_status) | **GET** /devices/{id}/ssid/status | Get SSID status for a device
*DeviceApi* | [**get_device_location**](docs/DeviceApi.md#get_device_location) | **GET** /devices/{id}/location | Get location for a device
*DeviceApi* | [**get_device_network_policy**](docs/DeviceApi.md#get_device_network_policy) | **GET** /devices/{id}/network-policy | Get network policy for a device
*DeviceApi* | [**get_device_stats**](docs/DeviceApi.md#get_device_stats) | **GET** /devices/stats | Get device stats
*DeviceApi* | [**list_device_alarm**](docs/DeviceApi.md#list_device_alarm) | **GET** /devices/{id}/alarms | List alarms for a device
*DeviceApi* | [**list_devices**](docs/DeviceApi.md#list_devices) | **GET** /devices | [LRO] List devices
*DeviceApi* | [**list_devices_by_network_policy**](docs/DeviceApi.md#list_devices_by_network_policy) | **GET** /devices/network-policy/{policyId} | List assigned devices for network policy
*DeviceApi* | [**onboard_devices**](docs/DeviceApi.md#onboard_devices) | **POST** /devices/:onboard | Onboard Devices
*DeviceApi* | [**override_device_level_ssid**](docs/DeviceApi.md#override_device_level_ssid) | **POST** /devices/{id}/ssid/:override | Override SSID for a device
*DeviceApi* | [**query_devices_location**](docs/DeviceApi.md#query_devices_location) | **POST** /devices/location/:query | Query location for multiple devices
*DeviceApi* | [**query_devices_network_policy**](docs/DeviceApi.md#query_devices_network_policy) | **POST** /devices/network-policy/:query | Query network policy for multiple devices
*DeviceApi* | [**reboot_device**](docs/DeviceApi.md#reboot_device) | **POST** /devices/{id}/:reboot | Reboot a device
*DeviceApi* | [**reboot_devices**](docs/DeviceApi.md#reboot_devices) | **POST** /devices/:reboot | Reboot devices
*DeviceApi* | [**reset_device**](docs/DeviceApi.md#reset_device) | **POST** /devices/{id}/:reset | [LRO] Reset a device to factory default
*DeviceApi* | [**revoke_device_location**](docs/DeviceApi.md#revoke_device_location) | **DELETE** /devices/{id}/location | Revoke location for a device
*DeviceApi* | [**revoke_device_network_policy**](docs/DeviceApi.md#revoke_device_network_policy) | **DELETE** /devices/{id}/network-policy | Revoke network policy for a device
*DeviceApi* | [**revoke_devices_location**](docs/DeviceApi.md#revoke_devices_location) | **POST** /devices/location/:revoke | Revoke location for multiple devices
*DeviceApi* | [**revoke_devices_network_policy**](docs/DeviceApi.md#revoke_devices_network_policy) | **POST** /devices/network-policy/:revoke | Revoke network policy for multiple devices
*DeviceApi* | [**revoke_devices_radius_proxy**](docs/DeviceApi.md#revoke_devices_radius_proxy) | **DELETE** /devices/radius-proxy/:revoke | Revoke RADIUS proxy from multiple devices
*DeviceApi* | [**send_cli_to_device**](docs/DeviceApi.md#send_cli_to_device) | **POST** /devices/{id}/:cli | Send CLI to a device
*DeviceApi* | [**send_cli_to_devices**](docs/DeviceApi.md#send_cli_to_devices) | **POST** /devices/:cli | [LRO] Send CLI to devices
*HIQApi* | [**create_organization**](docs/HIQApi.md#create_organization) | **POST** /hiq/organizations | Create a new organization
*HIQApi* | [**delete_organization**](docs/HIQApi.md#delete_organization) | **DELETE** /hiq/organizations/{id} | Delete an existing organization
*HIQApi* | [**get_creating_org_id**](docs/HIQApi.md#get_creating_org_id) | **GET** /hiq/context/creating | Get organization for creating new data
*HIQApi* | [**get_hiq_context**](docs/HIQApi.md#get_hiq_context) | **GET** /hiq/context | Get HIQ context
*HIQApi* | [**get_hiq_status**](docs/HIQApi.md#get_hiq_status) | **GET** /hiq/status | Get HIQ status
*HIQApi* | [**get_reading_org_ids**](docs/HIQApi.md#get_reading_org_ids) | **GET** /hiq/context/reading | Get organizations for reading data
*HIQApi* | [**list_organizations**](docs/HIQApi.md#list_organizations) | **GET** /hiq/organizations | List all organizations
*HIQApi* | [**rename_organization**](docs/HIQApi.md#rename_organization) | **POST** /hiq/organizations/{id}/:rename | Rename an existing organization
*HIQApi* | [**set_creating_org_id**](docs/HIQApi.md#set_creating_org_id) | **PUT** /hiq/context/creating | Set organization for creating new data
*HIQApi* | [**set_hiq_context**](docs/HIQApi.md#set_hiq_context) | **PUT** /hiq/context | Set HIQ context
*HIQApi* | [**set_reading_org_ids**](docs/HIQApi.md#set_reading_org_ids) | **PUT** /hiq/context/reading | Set organizations for reading data
*LocationApi* | [**create_building**](docs/LocationApi.md#create_building) | **POST** /locations/building | Create building
*LocationApi* | [**create_floor**](docs/LocationApi.md#create_floor) | **POST** /locations/floor | Create floor
*LocationApi* | [**create_location**](docs/LocationApi.md#create_location) | **POST** /locations | Create location
*LocationApi* | [**delete_building**](docs/LocationApi.md#delete_building) | **DELETE** /locations/building/{id} | Delete building by ID
*LocationApi* | [**delete_floor**](docs/LocationApi.md#delete_floor) | **DELETE** /locations/floor/{id} | Delete floor by ID
*LocationApi* | [**delete_location**](docs/LocationApi.md#delete_location) | **DELETE** /locations/{id} | Delete location by ID
*LocationApi* | [**get_location_tree**](docs/LocationApi.md#get_location_tree) | **GET** /locations/tree | Get location tree
*LocationApi* | [**update_building**](docs/LocationApi.md#update_building) | **PUT** /locations/building/{id} | Update building
*LocationApi* | [**update_floor**](docs/LocationApi.md#update_floor) | **PUT** /locations/floor/{id} | Update floor
*LocationApi* | [**update_location**](docs/LocationApi.md#update_location) | **PUT** /locations/{id} | Update location
*LocationApi* | [**upload_floorplan**](docs/LocationApi.md#upload_floorplan) | **POST** /locations/floorplan | Upload floorplan
*LogApi* | [**list_accounting_logs**](docs/LogApi.md#list_accounting_logs) | **GET** /logs/accounting | List accounting logs
*LogApi* | [**list_audit_logs**](docs/LogApi.md#list_audit_logs) | **GET** /logs/audit | List audit logs
*LogApi* | [**list_auth_logs**](docs/LogApi.md#list_auth_logs) | **GET** /logs/auth | List auth logs
*LogApi* | [**list_credential_logs**](docs/LogApi.md#list_credential_logs) | **GET** /logs/credential | List credential logs
*LogApi* | [**list_email_logs**](docs/LogApi.md#list_email_logs) | **GET** /logs/email | List Email logs
*LogApi* | [**list_sms_logs**](docs/LogApi.md#list_sms_logs) | **GET** /logs/sms | List SMS logs
*NetworkPolicyApi* | [**add_ssids_to_network_policy**](docs/NetworkPolicyApi.md#add_ssids_to_network_policy) | **POST** /network-policies/{id}/ssids/:add | Add SSIDs to a network policy
*NetworkPolicyApi* | [**create_network_policy**](docs/NetworkPolicyApi.md#create_network_policy) | **POST** /network-policies | Create network policy
*NetworkPolicyApi* | [**delete_network_policy**](docs/NetworkPolicyApi.md#delete_network_policy) | **DELETE** /network-policies/{id} | Delete the network policy
*NetworkPolicyApi* | [**delete_ssids_from_network_policy**](docs/NetworkPolicyApi.md#delete_ssids_from_network_policy) | **POST** /network-policies/{id}/ssids/:remove | Removes SSIDs from the network policy
*NetworkPolicyApi* | [**get_network_policy**](docs/NetworkPolicyApi.md#get_network_policy) | **GET** /network-policies/{id} | Get the network policy
*NetworkPolicyApi* | [**list_network_polices**](docs/NetworkPolicyApi.md#list_network_polices) | **GET** /network-policies | List network policies
*NetworkPolicyApi* | [**list_ssids_by_network_policy**](docs/NetworkPolicyApi.md#list_ssids_by_network_policy) | **GET** /network-policies/{id}/ssids | List SSIDs for a network policy
*NetworkPolicyApi* | [**update_network_policy**](docs/NetworkPolicyApi.md#update_network_policy) | **PUT** /network-policies/{id} | Update the network policy
*NotificationApi* | [**create_subscriptions**](docs/NotificationApi.md#create_subscriptions) | **POST** /subscriptions/webhook | Create webhook subscriptions
*NotificationApi* | [**delete_subscription**](docs/NotificationApi.md#delete_subscription) | **DELETE** /subscriptions/webhook/{id} | Delete webhook subscription
*NotificationApi* | [**list**](docs/NotificationApi.md#list) | **GET** /subscriptions/webhook | List webhook subscriptions
*OperationApi* | [**cancel_operation**](docs/OperationApi.md#cancel_operation) | **POST** /operations/{operationId}/:cancel | Cancel Long-Running Operation (LRO)
*OperationApi* | [**delete_operation**](docs/OperationApi.md#delete_operation) | **DELETE** /operations/{operationId} | Delete Long-Running Operation (LRO)
*OperationApi* | [**get_operation**](docs/OperationApi.md#get_operation) | **GET** /operations/{operationId} | Get Long-Running Operation (LRO) status and result
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /users | Create new user
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /users/{id} | Delete user by ID
*UserApi* | [**get_current_user**](docs/UserApi.md#get_current_user) | **GET** /users/me | Get current user info
*UserApi* | [**get_external_user**](docs/UserApi.md#get_external_user) | **GET** /users/external/{id} | Get external access info
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /users/{id} | Get user info by ID
*UserApi* | [**grant_external_user**](docs/UserApi.md#grant_external_user) | **POST** /users/external | Grant external access
*UserApi* | [**list_external_users**](docs/UserApi.md#list_external_users) | **GET** /users/external | List external access users
*UserApi* | [**list_users**](docs/UserApi.md#list_users) | **GET** /users | List all users
*UserApi* | [**revoke_external_user**](docs/UserApi.md#revoke_external_user) | **DELETE** /users/external/{id} | Revoke external access
*UserApi* | [**update_external_user**](docs/UserApi.md#update_external_user) | **PATCH** /users/external/{id} | Update external access info
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PATCH** /users/{id} | Update user info


## Documentation For Models

 - [InlineObject](docs/InlineObject.md)
 - [PagedXiqAccountingLog](docs/PagedXiqAccountingLog.md)
 - [PagedXiqActiveDirectoryServer](docs/PagedXiqActiveDirectoryServer.md)
 - [PagedXiqApplication](docs/PagedXiqApplication.md)
 - [PagedXiqAuditLog](docs/PagedXiqAuditLog.md)
 - [PagedXiqAuthLog](docs/PagedXiqAuthLog.md)
 - [PagedXiqCertificate](docs/PagedXiqCertificate.md)
 - [PagedXiqClassificationRule](docs/PagedXiqClassificationRule.md)
 - [PagedXiqClient](docs/PagedXiqClient.md)
 - [PagedXiqCloudConfigGroup](docs/PagedXiqCloudConfigGroup.md)
 - [PagedXiqCredentialLog](docs/PagedXiqCredentialLog.md)
 - [PagedXiqCwp](docs/PagedXiqCwp.md)
 - [PagedXiqDevice](docs/PagedXiqDevice.md)
 - [PagedXiqDeviceAlarm](docs/PagedXiqDeviceAlarm.md)
 - [PagedXiqEmailLog](docs/PagedXiqEmailLog.md)
 - [PagedXiqEndUser](docs/PagedXiqEndUser.md)
 - [PagedXiqExternalRadiusServer](docs/PagedXiqExternalRadiusServer.md)
 - [PagedXiqExternalUser](docs/PagedXiqExternalUser.md)
 - [PagedXiqInternalRadiusDevice](docs/PagedXiqInternalRadiusDevice.md)
 - [PagedXiqInternalRadiusServer](docs/PagedXiqInternalRadiusServer.md)
 - [PagedXiqLdapServer](docs/PagedXiqLdapServer.md)
 - [PagedXiqNetworkPolicy](docs/PagedXiqNetworkPolicy.md)
 - [PagedXiqRadioProfile](docs/PagedXiqRadioProfile.md)
 - [PagedXiqRadiusClientObject](docs/PagedXiqRadiusClientObject.md)
 - [PagedXiqRadiusProxy](docs/PagedXiqRadiusProxy.md)
 - [PagedXiqRpMacOuiProfile](docs/PagedXiqRpMacOuiProfile.md)
 - [PagedXiqSmsLog](docs/PagedXiqSmsLog.md)
 - [PagedXiqSsid](docs/PagedXiqSsid.md)
 - [PagedXiqUser](docs/PagedXiqUser.md)
 - [PagedXiqUserGroup](docs/PagedXiqUserGroup.md)
 - [PagedXiqUserProfile](docs/PagedXiqUserProfile.md)
 - [PagedXiqVlanProfile](docs/PagedXiqVlanProfile.md)
 - [XiqAccount](docs/XiqAccount.md)
 - [XiqAccountMode](docs/XiqAccountMode.md)
 - [XiqAccountType](docs/XiqAccountType.md)
 - [XiqAccountingLog](docs/XiqAccountingLog.md)
 - [XiqActiveDirectoryServer](docs/XiqActiveDirectoryServer.md)
 - [XiqActiveDirectoryServerBaseDnFetchMode](docs/XiqActiveDirectoryServerBaseDnFetchMode.md)
 - [XiqApiTokenInfo](docs/XiqApiTokenInfo.md)
 - [XiqApplication](docs/XiqApplication.md)
 - [XiqApplicationDetectionProtocol](docs/XiqApplicationDetectionProtocol.md)
 - [XiqApplicationDetectionRule](docs/XiqApplicationDetectionRule.md)
 - [XiqApplicationDetectionType](docs/XiqApplicationDetectionType.md)
 - [XiqApplicationSortField](docs/XiqApplicationSortField.md)
 - [XiqApplicationTopClientsUsage](docs/XiqApplicationTopClientsUsage.md)
 - [XiqAssignDevicesCountryCodeRequest](docs/XiqAssignDevicesCountryCodeRequest.md)
 - [XiqAssignDevicesLocationRequest](docs/XiqAssignDevicesLocationRequest.md)
 - [XiqAssignDevicesNetworkPolicyRequest](docs/XiqAssignDevicesNetworkPolicyRequest.md)
 - [XiqAuditLog](docs/XiqAuditLog.md)
 - [XiqAuditLogCategory](docs/XiqAuditLogCategory.md)
 - [XiqAuthLog](docs/XiqAuthLog.md)
 - [XiqBuilding](docs/XiqBuilding.md)
 - [XiqCertificate](docs/XiqCertificate.md)
 - [XiqCertificateType](docs/XiqCertificateType.md)
 - [XiqChangeDevicesOsModeRequest](docs/XiqChangeDevicesOsModeRequest.md)
 - [XiqCheckPermissionRequest](docs/XiqCheckPermissionRequest.md)
 - [XiqCheckPermissionResponse](docs/XiqCheckPermissionResponse.md)
 - [XiqClassification](docs/XiqClassification.md)
 - [XiqClassificationRule](docs/XiqClassificationRule.md)
 - [XiqClassificationType](docs/XiqClassificationType.md)
 - [XiqCliOutput](docs/XiqCliOutput.md)
 - [XiqCliResponseCode](docs/XiqCliResponseCode.md)
 - [XiqClient](docs/XiqClient.md)
 - [XiqClientField](docs/XiqClientField.md)
 - [XiqClientSummary](docs/XiqClientSummary.md)
 - [XiqClientUsage](docs/XiqClientUsage.md)
 - [XiqClientView](docs/XiqClientView.md)
 - [XiqCloudConfigGroup](docs/XiqCloudConfigGroup.md)
 - [XiqCountryCode](docs/XiqCountryCode.md)
 - [XiqCreateBuildingRequest](docs/XiqCreateBuildingRequest.md)
 - [XiqCreateClassificationRequest](docs/XiqCreateClassificationRequest.md)
 - [XiqCreateClassificationRuleRequest](docs/XiqCreateClassificationRuleRequest.md)
 - [XiqCreateCloudConfigGroupRequest](docs/XiqCreateCloudConfigGroupRequest.md)
 - [XiqCreateEndUserRequest](docs/XiqCreateEndUserRequest.md)
 - [XiqCreateExternalRadiusServerRequest](docs/XiqCreateExternalRadiusServerRequest.md)
 - [XiqCreateFloorRequest](docs/XiqCreateFloorRequest.md)
 - [XiqCreateInternalRadiusServerRequest](docs/XiqCreateInternalRadiusServerRequest.md)
 - [XiqCreateKeyBasedPcgUsersRequest](docs/XiqCreateKeyBasedPcgUsersRequest.md)
 - [XiqCreateLdapServerRequest](docs/XiqCreateLdapServerRequest.md)
 - [XiqCreateLocationRequest](docs/XiqCreateLocationRequest.md)
 - [XiqCreateNetworkPolicyRequest](docs/XiqCreateNetworkPolicyRequest.md)
 - [XiqCreateOrganizationRequest](docs/XiqCreateOrganizationRequest.md)
 - [XiqCreateRadioProfileRequest](docs/XiqCreateRadioProfileRequest.md)
 - [XiqCreateRadiusClient](docs/XiqCreateRadiusClient.md)
 - [XiqCreateRadiusClientObjectRequest](docs/XiqCreateRadiusClientObjectRequest.md)
 - [XiqCreateRadiusProxyRealm](docs/XiqCreateRadiusProxyRealm.md)
 - [XiqCreateRadiusProxyRequest](docs/XiqCreateRadiusProxyRequest.md)
 - [XiqCreateRpMacOuiProfileRequest](docs/XiqCreateRpMacOuiProfileRequest.md)
 - [XiqCreateUserGroupRequest](docs/XiqCreateUserGroupRequest.md)
 - [XiqCreateUserProfileRequest](docs/XiqCreateUserProfileRequest.md)
 - [XiqCreateUserRequest](docs/XiqCreateUserRequest.md)
 - [XiqCreateVlanObjectClassifiedEntryRequest](docs/XiqCreateVlanObjectClassifiedEntryRequest.md)
 - [XiqCreateVlanProfileRequest](docs/XiqCreateVlanProfileRequest.md)
 - [XiqCreateWebhookSubscriptionRequest](docs/XiqCreateWebhookSubscriptionRequest.md)
 - [XiqCredentialLog](docs/XiqCredentialLog.md)
 - [XiqCwp](docs/XiqCwp.md)
 - [XiqDateTimeType](docs/XiqDateTimeType.md)
 - [XiqDateTimeUnitType](docs/XiqDateTimeUnitType.md)
 - [XiqDefaultDevicePassword](docs/XiqDefaultDevicePassword.md)
 - [XiqDeleteKeyBasedPcgUsersRequest](docs/XiqDeleteKeyBasedPcgUsersRequest.md)
 - [XiqDeliverySettings](docs/XiqDeliverySettings.md)
 - [XiqDellDevices](docs/XiqDellDevices.md)
 - [XiqDeploymentOverview](docs/XiqDeploymentOverview.md)
 - [XiqDeploymentPolicy](docs/XiqDeploymentPolicy.md)
 - [XiqDeploymentRequest](docs/XiqDeploymentRequest.md)
 - [XiqDeploymentResponse](docs/XiqDeploymentResponse.md)
 - [XiqDeploymentStatus](docs/XiqDeploymentStatus.md)
 - [XiqDevice](docs/XiqDevice.md)
 - [XiqDeviceAdminState](docs/XiqDeviceAdminState.md)
 - [XiqDeviceAlarm](docs/XiqDeviceAlarm.md)
 - [XiqDeviceCpuMemoryUsage](docs/XiqDeviceCpuMemoryUsage.md)
 - [XiqDeviceField](docs/XiqDeviceField.md)
 - [XiqDeviceFilter](docs/XiqDeviceFilter.md)
 - [XiqDeviceFunction](docs/XiqDeviceFunction.md)
 - [XiqDeviceLevelSsid](docs/XiqDeviceLevelSsid.md)
 - [XiqDeviceLevelSsidStatus](docs/XiqDeviceLevelSsidStatus.md)
 - [XiqDeviceLocation](docs/XiqDeviceLocation.md)
 - [XiqDeviceLocationAssignment](docs/XiqDeviceLocationAssignment.md)
 - [XiqDeviceSortField](docs/XiqDeviceSortField.md)
 - [XiqDeviceStats](docs/XiqDeviceStats.md)
 - [XiqDeviceType](docs/XiqDeviceType.md)
 - [XiqDeviceView](docs/XiqDeviceView.md)
 - [XiqEmailLog](docs/XiqEmailLog.md)
 - [XiqEmailTemplate](docs/XiqEmailTemplate.md)
 - [XiqEndUser](docs/XiqEndUser.md)
 - [XiqEntitlementType](docs/XiqEntitlementType.md)
 - [XiqError](docs/XiqError.md)
 - [XiqExosDevices](docs/XiqExosDevices.md)
 - [XiqExpirationActionType](docs/XiqExpirationActionType.md)
 - [XiqExpirationSettings](docs/XiqExpirationSettings.md)
 - [XiqExpirationType](docs/XiqExpirationType.md)
 - [XiqExternalAccount](docs/XiqExternalAccount.md)
 - [XiqExternalRadiusServer](docs/XiqExternalRadiusServer.md)
 - [XiqExternalUser](docs/XiqExternalUser.md)
 - [XiqExternalUserDirectory](docs/XiqExternalUserDirectory.md)
 - [XiqExternalUserDirectoryEntry](docs/XiqExternalUserDirectoryEntry.md)
 - [XiqExternalUserDirectoryType](docs/XiqExternalUserDirectoryType.md)
 - [XiqExtremeDevices](docs/XiqExtremeDevices.md)
 - [XiqFirmwareActivateOption](docs/XiqFirmwareActivateOption.md)
 - [XiqFirmwareUpgradePolicy](docs/XiqFirmwareUpgradePolicy.md)
 - [XiqFloor](docs/XiqFloor.md)
 - [XiqGenerateApiTokenRequest](docs/XiqGenerateApiTokenRequest.md)
 - [XiqGenerateApiTokenResponse](docs/XiqGenerateApiTokenResponse.md)
 - [XiqGetPortAssignmentDetailsResponse](docs/XiqGetPortAssignmentDetailsResponse.md)
 - [XiqGrantExternalUserRequest](docs/XiqGrantExternalUserRequest.md)
 - [XiqHiqContext](docs/XiqHiqContext.md)
 - [XiqHiqStatus](docs/XiqHiqStatus.md)
 - [XiqInitKeyBasedPcgNetworkPolicyRequest](docs/XiqInitKeyBasedPcgNetworkPolicyRequest.md)
 - [XiqInternalRadiusDevice](docs/XiqInternalRadiusDevice.md)
 - [XiqInternalRadiusServer](docs/XiqInternalRadiusServer.md)
 - [XiqInternalRadiusServerAuthenticationMethod](docs/XiqInternalRadiusServerAuthenticationMethod.md)
 - [XiqInternalRadiusServerAuthenticationMethodGroup](docs/XiqInternalRadiusServerAuthenticationMethodGroup.md)
 - [XiqKeyBasedPcg](docs/XiqKeyBasedPcg.md)
 - [XiqKeyBasedPcgUser](docs/XiqKeyBasedPcgUser.md)
 - [XiqKeyBasedPcgUserBaseInfo](docs/XiqKeyBasedPcgUserBaseInfo.md)
 - [XiqL3AddressProfile](docs/XiqL3AddressProfile.md)
 - [XiqL3AddressType](docs/XiqL3AddressType.md)
 - [XiqLdapProtocolType](docs/XiqLdapProtocolType.md)
 - [XiqLdapServer](docs/XiqLdapServer.md)
 - [XiqLdapServerVerificationMode](docs/XiqLdapServerVerificationMode.md)
 - [XiqLicenseMode](docs/XiqLicenseMode.md)
 - [XiqLicenseStatus](docs/XiqLicenseStatus.md)
 - [XiqLocation](docs/XiqLocation.md)
 - [XiqLocationLegend](docs/XiqLocationLegend.md)
 - [XiqLoginRequest](docs/XiqLoginRequest.md)
 - [XiqLoginResponse](docs/XiqLoginResponse.md)
 - [XiqMeasurementUnit](docs/XiqMeasurementUnit.md)
 - [XiqNetworkPolicy](docs/XiqNetworkPolicy.md)
 - [XiqNetworkPolicyType](docs/XiqNetworkPolicyType.md)
 - [XiqOnboardDeviceRequest](docs/XiqOnboardDeviceRequest.md)
 - [XiqOnboardKeyBasedPcgRequest](docs/XiqOnboardKeyBasedPcgRequest.md)
 - [XiqOperationMetadata](docs/XiqOperationMetadata.md)
 - [XiqOperationObject](docs/XiqOperationObject.md)
 - [XiqOperationStatus](docs/XiqOperationStatus.md)
 - [XiqOrganization](docs/XiqOrganization.md)
 - [XiqOrganizationType](docs/XiqOrganizationType.md)
 - [XiqPasswordCharacterType](docs/XiqPasswordCharacterType.md)
 - [XiqPasswordDbLocation](docs/XiqPasswordDbLocation.md)
 - [XiqPasswordSettings](docs/XiqPasswordSettings.md)
 - [XiqPasswordType](docs/XiqPasswordType.md)
 - [XiqPcgAssignPortsRequest](docs/XiqPcgAssignPortsRequest.md)
 - [XiqPcgAssignPortsResponse](docs/XiqPcgAssignPortsResponse.md)
 - [XiqPcgPortAssignment](docs/XiqPcgPortAssignment.md)
 - [XiqPcgPortAssignmentEntry](docs/XiqPcgPortAssignmentEntry.md)
 - [XiqPcgPortAssignmentEntryDetail](docs/XiqPcgPortAssignmentEntryDetail.md)
 - [XiqPcgPortAssignmentEntryDeviceMeta](docs/XiqPcgPortAssignmentEntryDeviceMeta.md)
 - [XiqPcgPortAssignmentEntryEthUserMeta](docs/XiqPcgPortAssignmentEntryEthUserMeta.md)
 - [XiqPcgType](docs/XiqPcgType.md)
 - [XiqPermission](docs/XiqPermission.md)
 - [XiqPostExpirationAction](docs/XiqPostExpirationAction.md)
 - [XiqPskGenerationMethod](docs/XiqPskGenerationMethod.md)
 - [XiqRadioMode](docs/XiqRadioMode.md)
 - [XiqRadioProfile](docs/XiqRadioProfile.md)
 - [XiqRadiusClient](docs/XiqRadiusClient.md)
 - [XiqRadiusClientObject](docs/XiqRadiusClientObject.md)
 - [XiqRadiusClientObjectEntry](docs/XiqRadiusClientObjectEntry.md)
 - [XiqRadiusClientObjectType](docs/XiqRadiusClientObjectType.md)
 - [XiqRadiusProxy](docs/XiqRadiusProxy.md)
 - [XiqRadiusProxyFormatType](docs/XiqRadiusProxyFormatType.md)
 - [XiqRadiusProxyRealm](docs/XiqRadiusProxyRealm.md)
 - [XiqRadiusServerType](docs/XiqRadiusServerType.md)
 - [XiqRegenerateEndUserPasswordResponse](docs/XiqRegenerateEndUserPasswordResponse.md)
 - [XiqRfEnvironmentType](docs/XiqRfEnvironmentType.md)
 - [XiqRpChannelSelection](docs/XiqRpChannelSelection.md)
 - [XiqRpMacOuiProfile](docs/XiqRpMacOuiProfile.md)
 - [XiqRpMiscellaneousSettings](docs/XiqRpMiscellaneousSettings.md)
 - [XiqRpNeighborhoodAnalysis](docs/XiqRpNeighborhoodAnalysis.md)
 - [XiqRpRadioUsageOptimization](docs/XiqRpRadioUsageOptimization.md)
 - [XiqRpSensorScanSettings](docs/XiqRpSensorScanSettings.md)
 - [XiqRpWmmQosSettings](docs/XiqRpWmmQosSettings.md)
 - [XiqSendCliRequest](docs/XiqSendCliRequest.md)
 - [XiqSendCliResponse](docs/XiqSendCliResponse.md)
 - [XiqServerRole](docs/XiqServerRole.md)
 - [XiqSetSsidModeDot1xRequest](docs/XiqSetSsidModeDot1xRequest.md)
 - [XiqSetSsidModePpskRequest](docs/XiqSetSsidModePpskRequest.md)
 - [XiqSetSsidModePskRequest](docs/XiqSetSsidModePskRequest.md)
 - [XiqSetSsidModeWepRequest](docs/XiqSetSsidModeWepRequest.md)
 - [XiqSmsLog](docs/XiqSmsLog.md)
 - [XiqSmsLogStatus](docs/XiqSmsLogStatus.md)
 - [XiqSmsTemplate](docs/XiqSmsTemplate.md)
 - [XiqSortOrder](docs/XiqSortOrder.md)
 - [XiqSsid](docs/XiqSsid.md)
 - [XiqSsidDot1xEncryptionMethod](docs/XiqSsidDot1xEncryptionMethod.md)
 - [XiqSsidDot1xKeyManagement](docs/XiqSsidDot1xKeyManagement.md)
 - [XiqSsidKeyType](docs/XiqSsidKeyType.md)
 - [XiqSsidPpskKeyManagement](docs/XiqSsidPpskKeyManagement.md)
 - [XiqSsidPskEncryptionMethod](docs/XiqSsidPskEncryptionMethod.md)
 - [XiqSsidPskKeyManagement](docs/XiqSsidPskKeyManagement.md)
 - [XiqSsidSaeGroup](docs/XiqSsidSaeGroup.md)
 - [XiqSsidWepAuthenticationMethod](docs/XiqSsidWepAuthenticationMethod.md)
 - [XiqSsidWepDefaultKey](docs/XiqSsidWepDefaultKey.md)
 - [XiqSsidWepEncryptionMethod](docs/XiqSsidWepEncryptionMethod.md)
 - [XiqSsidWepKeyManagement](docs/XiqSsidWepKeyManagement.md)
 - [XiqSubscriptionDataType](docs/XiqSubscriptionDataType.md)
 - [XiqSubscriptionMessageType](docs/XiqSubscriptionMessageType.md)
 - [XiqSubscriptionStatus](docs/XiqSubscriptionStatus.md)
 - [XiqTopApplicationsUsage](docs/XiqTopApplicationsUsage.md)
 - [XiqUpdateBuildingRequest](docs/XiqUpdateBuildingRequest.md)
 - [XiqUpdateClassificationRequest](docs/XiqUpdateClassificationRequest.md)
 - [XiqUpdateClassificationRuleRequest](docs/XiqUpdateClassificationRuleRequest.md)
 - [XiqUpdateCloudConfigGroupRequest](docs/XiqUpdateCloudConfigGroupRequest.md)
 - [XiqUpdateDeviceLevelSsidStatus](docs/XiqUpdateDeviceLevelSsidStatus.md)
 - [XiqUpdateEndUserRequest](docs/XiqUpdateEndUserRequest.md)
 - [XiqUpdateExternalRadiusServerRequest](docs/XiqUpdateExternalRadiusServerRequest.md)
 - [XiqUpdateExternalUserRequest](docs/XiqUpdateExternalUserRequest.md)
 - [XiqUpdateFloorRequest](docs/XiqUpdateFloorRequest.md)
 - [XiqUpdateInternalRadiusServerRequest](docs/XiqUpdateInternalRadiusServerRequest.md)
 - [XiqUpdateKeyBasedPcgUsersRequest](docs/XiqUpdateKeyBasedPcgUsersRequest.md)
 - [XiqUpdateLdapServerRequest](docs/XiqUpdateLdapServerRequest.md)
 - [XiqUpdateLocationRequest](docs/XiqUpdateLocationRequest.md)
 - [XiqUpdateNetworkPolicyRequest](docs/XiqUpdateNetworkPolicyRequest.md)
 - [XiqUpdateRadioProfileRequest](docs/XiqUpdateRadioProfileRequest.md)
 - [XiqUpdateRadiusClient](docs/XiqUpdateRadiusClient.md)
 - [XiqUpdateRadiusClientObjectRequest](docs/XiqUpdateRadiusClientObjectRequest.md)
 - [XiqUpdateRadiusProxyRealm](docs/XiqUpdateRadiusProxyRealm.md)
 - [XiqUpdateRadiusProxyRequest](docs/XiqUpdateRadiusProxyRequest.md)
 - [XiqUpdateRpChannelSelectionRequest](docs/XiqUpdateRpChannelSelectionRequest.md)
 - [XiqUpdateRpMacOuiProfileRequest](docs/XiqUpdateRpMacOuiProfileRequest.md)
 - [XiqUpdateRpMiscellaneousSettingsRequest](docs/XiqUpdateRpMiscellaneousSettingsRequest.md)
 - [XiqUpdateRpNeighborhoodAnalysisRequest](docs/XiqUpdateRpNeighborhoodAnalysisRequest.md)
 - [XiqUpdateRpRadioUsageOptimizationRequest](docs/XiqUpdateRpRadioUsageOptimizationRequest.md)
 - [XiqUpdateRpSensorScanSettingsRequest](docs/XiqUpdateRpSensorScanSettingsRequest.md)
 - [XiqUpdateRpWmmQosSettingsRequest](docs/XiqUpdateRpWmmQosSettingsRequest.md)
 - [XiqUpdateUserGroupRequest](docs/XiqUpdateUserGroupRequest.md)
 - [XiqUpdateUserProfileRequest](docs/XiqUpdateUserProfileRequest.md)
 - [XiqUpdateUserRequest](docs/XiqUpdateUserRequest.md)
 - [XiqUpdateVlanObjectClassifiedEntryRequest](docs/XiqUpdateVlanObjectClassifiedEntryRequest.md)
 - [XiqUpdateVlanProfileRequest](docs/XiqUpdateVlanProfileRequest.md)
 - [XiqUser](docs/XiqUser.md)
 - [XiqUserGroup](docs/XiqUserGroup.md)
 - [XiqUserProfile](docs/XiqUserProfile.md)
 - [XiqUserRole](docs/XiqUserRole.md)
 - [XiqValidDailySettings](docs/XiqValidDailySettings.md)
 - [XiqValidDuringDateSettings](docs/XiqValidDuringDateSettings.md)
 - [XiqValidForTimePeriodSettings](docs/XiqValidForTimePeriodSettings.md)
 - [XiqValidTimePeriodAfterFirstLogin](docs/XiqValidTimePeriodAfterFirstLogin.md)
 - [XiqValidTimePeriodAfterIdCreation](docs/XiqValidTimePeriodAfterIdCreation.md)
 - [XiqValidTimePeriodAfterType](docs/XiqValidTimePeriodAfterType.md)
 - [XiqViq](docs/XiqViq.md)
 - [XiqViqLicense](docs/XiqViqLicense.md)
 - [XiqVlanObjectClassifiedEntry](docs/XiqVlanObjectClassifiedEntry.md)
 - [XiqVlanProfile](docs/XiqVlanProfile.md)
 - [XiqVossDevices](docs/XiqVossDevices.md)
 - [XiqWebhookSubscription](docs/XiqWebhookSubscription.md)
 - [XiqWingDevices](docs/XiqWingDevices.md)
 - [XiqWirelessIfName](docs/XiqWirelessIfName.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication (JWT)


## Author

support@extremenetworks.com


