from enum import Enum


class CreditRequestType(Enum):
    INDIVIDUAL = "INDIVIDUAL"
    JOIN = "JOINT"


class InquiryPurposeType(Enum):
    ACCT_ORIG = "ACCT-ORIG"
    ACCT_MAINT = "ACCT-MAINT"
    OTHER = "OTHER"


class InquiryPurposeTypeDescription(Enum):
    AUTO_LOAN = "AUTO_LOAN"
    AUTO_OVERDRAFT = "AUTO_OVERDRAFT"
    TWO_WHEELER_LOAN = "TWO_WHEELER_LOAN"
    COMMERCIAL_VEHICLE_LOAN = "COMMERCIAL_VEHICLE_LOAN"
    COMMERCIAL_EQUIPMENT_LOAN = "COMMERCIAL_EQUIPMENT_LOAN"
    HOUSING_LOAN = "HOUSING_LOAN"
    PROPERTY_LOAN = "PROPERTY_LOAN"
    LOAN_AGAINST_SHARES_SECURITIES = "LOAN_AGAINST_SHARES_SECURITIES"
    GOLD_LOAN = "GOLD_LOAN"
    EDUCATION_LOAN = "EDUCATION_LOAN"
    LEASING = "LEASING"
    PERSONAL_LOAN = "PERSONAL_LOAN"
    CONSUMER_LOAN = "CONSUMER_LOAN"
    LOAN_TO_PROFESSIONAL = "LOAN_TO_PROFESSIONAL"
    CREDIT_CARD = "CREDIT_CARD"
    CHARGE_CARD = "CHARGE_CARD"
    FLEET_CARD = "FLEET_CARD"
    LOAN_AGAINST_CARD = "LOAN_AGAINST_CARD"
    OVERDRAFT = "OVERDRAFT"
    LOAN_AGAINST_BANK_DEPOSITS = "LOAN_AGAINST_BANK_DEPOSITS"
    OD_ON_SAVINGS_ACCOUNT = "OD_ON_SAVINGS_ACCOUNT"
    NON_FUNDED_CREDIT_FACILITY = "NON_FUNDED_CREDIT_FACILITY"
    BUSINESS_LOAN_GENERAL = "BUSINESS_LOAN_GENERAL"
    BUSINESS_LOAN_PRIORITY_SMALL_BUSINESS = "BUSINESS_LOAN_PRIORITY_SMALL_BUSINESS"
    BUSINESS_LOAN_PRIORITY_AGRICULTURE = "BUSINESS_LOAN_PRIORITY_AGRICULTURE"
    BUSINESS_LOAN_PRIORITY_OTHERS = "BUSINESS_LOAN_PRIORITY_OTHERS"
    BUSINESS_NON_FUNDED_CREDIT_GENERAL = "BUSINESS_NON_FUNDED_CREDIT_GENERAL"
    BUSINESS_NON_FUNDED_CREDIT_PRIORITY_SMALL_BUSINESS = (
        "BUSINESS_NON_FUNDED_CREDIT_PRIORITY_SMALL_BUSINESS"
    )
    BUSINESS_NON_FUNDED_CREDIT_PRIORITY_AGRICULTURE = (
        "BUSINESS_NON_FUNDED_CREDIT_PRIORITY_AGRICULTURE"
    )
    BUSINESS_NON_FUNDED_CREDIT_PRIORITY_OTHERS = (
        "BUSINESS_NON_FUNDED_CREDIT_PRIORITY_OTHERS"
    )
    BUSINESS_LOAN_AGAINST_BANK_DEPOSITS = "BUSINESS_LOAN_AGAINST_BANK_DEPOSITS"
    OTHER = "OTHER"
    TELCO_WIRELESS = "TELCO_WIRELESS"
    TELCO_BROADBAND = "TELCO_BROADBAND"
    TELCO_LANDLINE = "TELCO_LANDLINE"
    MICROFINANCE_BUSINESS_LOAN = "MICROFINANCE_BUSINESS_LOAN"
    MICROFINANCE_PERSONAL_LOAN = "MICROFINANCE_PERSONAL_LOAN"
    MICROFINANCE_HOUSING_LOAN = "MICROFINANCE_HOUSING_LOAN"
    MICROFINANCE_OTHERS = "MICROFINANCE_OTHERS"
    USED_CAR_LOAN = "USED_CAR_LOAN"
    CONSTRUCTION_EQUIPMENT_LOAN = "CONSTRUCTION_EQUIPMENT_LOAN"
    USED_TRACTOR_LOAN = "USED_TRACTOR_LOAN"
    STAFF_LOAN = "STAFF_LOAN"
    SECURED_CREDIT_CARD = "SECURED_CREDIT_CARD"
    CORPORATE_CREDIT_CARD = "CORPORATE_CREDIT_CARD"
    KISAN_CREDIT_CARD = "KISAN_CREDIT_CARD"
    LOAN_ON_CREDIT_CARD = "LOAN_ON_CREDIT_CARD"
    PRIME_MINISTER_JAAN_DHAN_YOJANA_OVERDRAFT = (
        "PRIME_MINISTER_JAAN_DHAN_YOJANA_OVERDRAFT"
    )
    MUDRA_LOANS = "MUDRA_LOANS"
    BUSINESS_LOAN_SECURED = "BUSINESS_LOAN_SECURED"
    BUSINESS_LOAN_UNSECURED = "BUSINESS_LOAN_UNSECURED"
    PRADHAN_MANTRI_AWAS_YOJANA_CLSS = "PRADHAN_MANTRI_AWAS_YOJANA_CLSS"
    JLG_GROUP = "JLG_GROUP"
    JLG_INDIVIDUAL = "JLG_INDIVIDUAL"
    INDIVIDUAL = "INDIVIDUAL"
    SHG_GROUP = "SHG_GROUP"
    SHG_INDIVIDUAL = "SHG_INDIVIDUAL"
    SHG_GROUP_GOVT = "SHG_GROUP_GOVT"
    SHG_INTRA_GROUP = "SHG_INTRA_GROUP"


class InquiryStage(Enum):
    PRE_SCREEN = "PRE_SCREEN"
    PRE_DISBURSEMENT = "PRE_DISBURSEMENT"
    UW_REVIEW = "UW_REVIEW"
    COLLECTION = "COLLECTION"
    RENEWAL = "RENEWAL"


class IdentityType(Enum):
    PASSPORT = "PASSPORT"
    VOTER_ID = "VOTER_ID"
    UID = "UID"
    OTHERS = "OTHERS"
    RATION_CARD = "RATION_CARD"
    DRIVING_LICENSE = "DRIVING_LICENSE"
    PAN_CARD = "PAN_CARD"


class RelationType(Enum):
    FATHER = "FATHER"
    HUSBAND = "HUSBAND"
    MOTHER = "MOTHER"
    SON = "SON"
    DAUGHTER = "DAUGHTER"
    WIFE = "WIFE"
    BROTHER = "BROTHER"
    MOTHER_IN_LAW = "MOTHER_IN_LAW"
    FATHER_IN_LAW = "FATHER_IN_LAW"
    DAUGHTER_IN_LAW = "DAUGHTER_IN_LAW"
    SISTER_IN_LAW = "SISTER_IN_LAW"
    SON_IN_LAW = "SON_IN_LAW"
    BROTHER_IN_LAW = "BROTHER_IN_LAW"
    OTHER = "OTHER"


class PhoneNumberType(Enum):
    HOME = "HOME"
    OFFICE = "OFFICE"
    MOBILE = "MOBILE"
    PERMANENT = "PERMANENT"
    FOREIGN = "FOREIGN"
    OTHER = "OTHER"
    NOT_CLASSIFIED = "NOT_CLASSIFIED"


class Gender(Enum):
    MALE = "MALE"
    FEMALE = "FEMALE"
    OTHER = "OTHER"


class AddressType(Enum):
    RESIDENCE = "RESIDENCE"
    COMPANY = "COMPANY"
    RES_CUM_OFF = "RES_CUM_OFF"
    PERMANENT = "PERMANENT"
    CURRENT = "CURRENT"
    FOREIGN = "FOREIGN"
    MILITARY = "MILITARY"
    OTHER = "OTHER"


class State(Enum):
    ANDHRA_PRADESH = "ANDHRA_PRADESH"
    ARUNACHAL_PRADESH = "ARUNACHAL_PRADESH"
    ASSAM = "ASSAM"
    BIHAR = "BIHAR"
    CHATTISGARH = "CHATTISGARH"
    GOA = "GOA"
    GUJARAT = "GUJARAT"
    HARYANA = "HARYANA"
    HIMACHAL_PRADESH = "HIMACHAL_PRADESH"
    JAMMU_KASHMIR = "JAMMU_KASHMIR"
    JHARKHAND = "JHARKHAND"
    KARNATAKA = "KARNATAKA"
    KERALA = "KERALA"
    MADHYA_PRADESH = "MADHYA_PRADESH"
    MAHARASHTRA = "MAHARASHTRA"
    MANIPUR = "MANIPUR"
    MEGHALAYA = "MEGHALAYA"
    MIZORAM = "MIZORAM"
    NAGALAND = "NAGALAND"
    ORISSA = "ORISSA"
    PUNJAB = "PUNJAB"
    RAJASTHAN = "RAJASTHAN"
    SIKKIM = "SIKKIM"
    TAMIL_NADU = "TAMIL_NADU"
    TELANGANA = "TELANGANA"
    TRIPURA = "TRIPURA"
    UTTARAKHAND = "UTTARAKHAND"
    UTTAR_PRADESH = "UTTAR_PRADESH"
    WEST_BENGAL = "WEST_BENGAL"
    ANDAMAN_NICOBAR = "ANDAMAN_NICOBAR"
    CHANDIGARH = "CHANDIGARH"
    DADRA_NAGAR_HAVELI = "DADRA_NAGAR_HAVELI"
    DAMAN_DIU = "DAMAN_DIU"
    DELHI = "DELHI"
    LAKSHADWEEP = "LAKSHADWEEP"
    PONDICHERRY = "PONDICHERRY"
