# coding: utf-8
# pynput
# Copyright (C) 2015-2018 Moses Palmér
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

# pylint: disable=C0111,C0302

SYMBOLS = {
    "0": (0x0030, "\u0030"),
    "1": (0x0031, "\u0031"),
    "2": (0x0032, "\u0032"),
    "3": (0x0033, "\u0033"),
    "4": (0x0034, "\u0034"),
    "5": (0x0035, "\u0035"),
    "6": (0x0036, "\u0036"),
    "7": (0x0037, "\u0037"),
    "8": (0x0038, "\u0038"),
    "9": (0x0039, "\u0039"),
    "A": (0x0041, "\u0041"),
    "AE": (0x00C6, "\u00C6"),
    "Aacute": (0x00C1, "\u00C1"),
    "Abelowdot": (0x1001EA0, "\u1EA0"),
    "Abreve": (0x01C3, "\u0102"),
    "Abreveacute": (0x1001EAE, "\u1EAE"),
    "Abrevebelowdot": (0x1001EB6, "\u1EB6"),
    "Abrevegrave": (0x1001EB0, "\u1EB0"),
    "Abrevehook": (0x1001EB2, "\u1EB2"),
    "Abrevetilde": (0x1001EB4, "\u1EB4"),
    "Acircumflex": (0x00C2, "\u00C2"),
    "Acircumflexacute": (0x1001EA4, "\u1EA4"),
    "Acircumflexbelowdot": (0x1001EAC, "\u1EAC"),
    "Acircumflexgrave": (0x1001EA6, "\u1EA6"),
    "Acircumflexhook": (0x1001EA8, "\u1EA8"),
    "Acircumflextilde": (0x1001EAA, "\u1EAA"),
    "Adiaeresis": (0x00C4, "\u00C4"),
    "Agrave": (0x00C0, "\u00C0"),
    "Ahook": (0x1001EA2, "\u1EA2"),
    "Amacron": (0x03C0, "\u0100"),
    "Aogonek": (0x01A1, "\u0104"),
    "Arabic_0": (0x1000660, "\u0660"),
    "Arabic_1": (0x1000661, "\u0661"),
    "Arabic_2": (0x1000662, "\u0662"),
    "Arabic_3": (0x1000663, "\u0663"),
    "Arabic_4": (0x1000664, "\u0664"),
    "Arabic_5": (0x1000665, "\u0665"),
    "Arabic_6": (0x1000666, "\u0666"),
    "Arabic_7": (0x1000667, "\u0667"),
    "Arabic_8": (0x1000668, "\u0668"),
    "Arabic_9": (0x1000669, "\u0669"),
    "Arabic_ain": (0x05D9, "\u0639"),
    "Arabic_alef": (0x05C7, "\u0627"),
    "Arabic_alefmaksura": (0x05E9, "\u0649"),
    "Arabic_beh": (0x05C8, "\u0628"),
    "Arabic_comma": (0x05AC, "\u060C"),
    "Arabic_dad": (0x05D6, "\u0636"),
    "Arabic_dal": (0x05CF, "\u062F"),
    "Arabic_damma": (0x05EF, "\u064F"),
    "Arabic_dammatan": (0x05EC, "\u064C"),
    "Arabic_ddal": (0x1000688, "\u0688"),
    "Arabic_farsi_yeh": (0x10006CC, "\u06CC"),
    "Arabic_fatha": (0x05EE, "\u064E"),
    "Arabic_fathatan": (0x05EB, "\u064B"),
    "Arabic_feh": (0x05E1, "\u0641"),
    "Arabic_fullstop": (0x10006D4, "\u06D4"),
    "Arabic_gaf": (0x10006AF, "\u06AF"),
    "Arabic_ghain": (0x05DA, "\u063A"),
    "Arabic_ha": (0x05E7, "\u0647"),
    "Arabic_hah": (0x05CD, "\u062D"),
    "Arabic_hamza": (0x05C1, "\u0621"),
    "Arabic_hamza_above": (0x1000654, "\u0654"),
    "Arabic_hamza_below": (0x1000655, "\u0655"),
    "Arabic_hamzaonalef": (0x05C3, "\u0623"),
    "Arabic_hamzaonwaw": (0x05C4, "\u0624"),
    "Arabic_hamzaonyeh": (0x05C6, "\u0626"),
    "Arabic_hamzaunderalef": (0x05C5, "\u0625"),
    "Arabic_heh_doachashmee": (0x10006BE, "\u06BE"),
    "Arabic_heh_goal": (0x10006C1, "\u06C1"),
    "Arabic_jeem": (0x05CC, "\u062C"),
    "Arabic_jeh": (0x1000698, "\u0698"),
    "Arabic_kaf": (0x05E3, "\u0643"),
    "Arabic_kasra": (0x05F0, "\u0650"),
    "Arabic_kasratan": (0x05ED, "\u064D"),
    "Arabic_keheh": (0x10006A9, "\u06A9"),
    "Arabic_khah": (0x05CE, "\u062E"),
    "Arabic_lam": (0x05E4, "\u0644"),
    "Arabic_madda_above": (0x1000653, "\u0653"),
    "Arabic_maddaonalef": (0x05C2, "\u0622"),
    "Arabic_meem": (0x05E5, "\u0645"),
    "Arabic_noon": (0x05E6, "\u0646"),
    "Arabic_noon_ghunna": (0x10006BA, "\u06BA"),
    "Arabic_peh": (0x100067E, "\u067E"),
    "Arabic_percent": (0x100066A, "\u066A"),
    "Arabic_qaf": (0x05E2, "\u0642"),
    "Arabic_question_mark": (0x05BF, "\u061F"),
    "Arabic_ra": (0x05D1, "\u0631"),
    "Arabic_rreh": (0x1000691, "\u0691"),
    "Arabic_sad": (0x05D5, "\u0635"),
    "Arabic_seen": (0x05D3, "\u0633"),
    "Arabic_semicolon": (0x05BB, "\u061B"),
    "Arabic_shadda": (0x05F1, "\u0651"),
    "Arabic_sheen": (0x05D4, "\u0634"),
    "Arabic_sukun": (0x05F2, "\u0652"),
    "Arabic_superscript_alef": (0x1000670, "\u0670"),
    "Arabic_tah": (0x05D7, "\u0637"),
    "Arabic_tatweel": (0x05E0, "\u0640"),
    "Arabic_tcheh": (0x1000686, "\u0686"),
    "Arabic_teh": (0x05CA, "\u062A"),
    "Arabic_tehmarbuta": (0x05C9, "\u0629"),
    "Arabic_thal": (0x05D0, "\u0630"),
    "Arabic_theh": (0x05CB, "\u062B"),
    "Arabic_tteh": (0x1000679, "\u0679"),
    "Arabic_veh": (0x10006A4, "\u06A4"),
    "Arabic_waw": (0x05E8, "\u0648"),
    "Arabic_yeh": (0x05EA, "\u064A"),
    "Arabic_yeh_baree": (0x10006D2, "\u06D2"),
    "Arabic_zah": (0x05D8, "\u0638"),
    "Arabic_zain": (0x05D2, "\u0632"),
    "Aring": (0x00C5, "\u00C5"),
    "Armenian_AT": (0x1000538, "\u0538"),
    "Armenian_AYB": (0x1000531, "\u0531"),
    "Armenian_BEN": (0x1000532, "\u0532"),
    "Armenian_CHA": (0x1000549, "\u0549"),
    "Armenian_DA": (0x1000534, "\u0534"),
    "Armenian_DZA": (0x1000541, "\u0541"),
    "Armenian_E": (0x1000537, "\u0537"),
    "Armenian_FE": (0x1000556, "\u0556"),
    "Armenian_GHAT": (0x1000542, "\u0542"),
    "Armenian_GIM": (0x1000533, "\u0533"),
    "Armenian_HI": (0x1000545, "\u0545"),
    "Armenian_HO": (0x1000540, "\u0540"),
    "Armenian_INI": (0x100053B, "\u053B"),
    "Armenian_JE": (0x100054B, "\u054B"),
    "Armenian_KE": (0x1000554, "\u0554"),
    "Armenian_KEN": (0x100053F, "\u053F"),
    "Armenian_KHE": (0x100053D, "\u053D"),
    "Armenian_LYUN": (0x100053C, "\u053C"),
    "Armenian_MEN": (0x1000544, "\u0544"),
    "Armenian_NU": (0x1000546, "\u0546"),
    "Armenian_O": (0x1000555, "\u0555"),
    "Armenian_PE": (0x100054A, "\u054A"),
    "Armenian_PYUR": (0x1000553, "\u0553"),
    "Armenian_RA": (0x100054C, "\u054C"),
    "Armenian_RE": (0x1000550, "\u0550"),
    "Armenian_SE": (0x100054D, "\u054D"),
    "Armenian_SHA": (0x1000547, "\u0547"),
    "Armenian_TCHE": (0x1000543, "\u0543"),
    "Armenian_TO": (0x1000539, "\u0539"),
    "Armenian_TSA": (0x100053E, "\u053E"),
    "Armenian_TSO": (0x1000551, "\u0551"),
    "Armenian_TYUN": (0x100054F, "\u054F"),
    "Armenian_VEV": (0x100054E, "\u054E"),
    "Armenian_VO": (0x1000548, "\u0548"),
    "Armenian_VYUN": (0x1000552, "\u0552"),
    "Armenian_YECH": (0x1000535, "\u0535"),
    "Armenian_ZA": (0x1000536, "\u0536"),
    "Armenian_ZHE": (0x100053A, "\u053A"),
    "Armenian_accent": (0x100055B, "\u055B"),
    "Armenian_amanak": (0x100055C, "\u055C"),
    "Armenian_apostrophe": (0x100055A, "\u055A"),
    "Armenian_at": (0x1000568, "\u0568"),
    "Armenian_ayb": (0x1000561, "\u0561"),
    "Armenian_ben": (0x1000562, "\u0562"),
    "Armenian_but": (0x100055D, "\u055D"),
    "Armenian_cha": (0x1000579, "\u0579"),
    "Armenian_da": (0x1000564, "\u0564"),
    "Armenian_dza": (0x1000571, "\u0571"),
    "Armenian_e": (0x1000567, "\u0567"),
    "Armenian_exclam": (0x100055C, "\u055C"),
    "Armenian_fe": (0x1000586, "\u0586"),
    "Armenian_full_stop": (0x1000589, "\u0589"),
    "Armenian_ghat": (0x1000572, "\u0572"),
    "Armenian_gim": (0x1000563, "\u0563"),
    "Armenian_hi": (0x1000575, "\u0575"),
    "Armenian_ho": (0x1000570, "\u0570"),
    "Armenian_hyphen": (0x100058A, "\u058A"),
    "Armenian_ini": (0x100056B, "\u056B"),
    "Armenian_je": (0x100057B, "\u057B"),
    "Armenian_ke": (0x1000584, "\u0584"),
    "Armenian_ken": (0x100056F, "\u056F"),
    "Armenian_khe": (0x100056D, "\u056D"),
    "Armenian_ligature_ew": (0x1000587, "\u0587"),
    "Armenian_lyun": (0x100056C, "\u056C"),
    "Armenian_men": (0x1000574, "\u0574"),
    "Armenian_nu": (0x1000576, "\u0576"),
    "Armenian_o": (0x1000585, "\u0585"),
    "Armenian_paruyk": (0x100055E, "\u055E"),
    "Armenian_pe": (0x100057A, "\u057A"),
    "Armenian_pyur": (0x1000583, "\u0583"),
    "Armenian_question": (0x100055E, "\u055E"),
    "Armenian_ra": (0x100057C, "\u057C"),
    "Armenian_re": (0x1000580, "\u0580"),
    "Armenian_se": (0x100057D, "\u057D"),
    "Armenian_separation_mark": (0x100055D, "\u055D"),
    "Armenian_sha": (0x1000577, "\u0577"),
    "Armenian_shesht": (0x100055B, "\u055B"),
    "Armenian_tche": (0x1000573, "\u0573"),
    "Armenian_to": (0x1000569, "\u0569"),
    "Armenian_tsa": (0x100056E, "\u056E"),
    "Armenian_tso": (0x1000581, "\u0581"),
    "Armenian_tyun": (0x100057F, "\u057F"),
    "Armenian_verjaket": (0x1000589, "\u0589"),
    "Armenian_vev": (0x100057E, "\u057E"),
    "Armenian_vo": (0x1000578, "\u0578"),
    "Armenian_vyun": (0x1000582, "\u0582"),
    "Armenian_yech": (0x1000565, "\u0565"),
    "Armenian_yentamna": (0x100058A, "\u058A"),
    "Armenian_za": (0x1000566, "\u0566"),
    "Armenian_zhe": (0x100056A, "\u056A"),
    "Atilde": (0x00C3, "\u00C3"),
    "B": (0x0042, "\u0042"),
    "Babovedot": (0x1001E02, "\u1E02"),
    "Byelorussian_SHORTU": (0x06BE, "\u040E"),
    "Byelorussian_shortu": (0x06AE, "\u045E"),
    "C": (0x0043, "\u0043"),
    "Cabovedot": (0x02C5, "\u010A"),
    "Cacute": (0x01C6, "\u0106"),
    "Ccaron": (0x01C8, "\u010C"),
    "Ccedilla": (0x00C7, "\u00C7"),
    "Ccircumflex": (0x02C6, "\u0108"),
    "ColonSign": (0x10020A1, "\u20A1"),
    "CruzeiroSign": (0x10020A2, "\u20A2"),
    "Cyrillic_A": (0x06E1, "\u0410"),
    "Cyrillic_BE": (0x06E2, "\u0411"),
    "Cyrillic_CHE": (0x06FE, "\u0427"),
    "Cyrillic_CHE_descender": (0x10004B6, "\u04B6"),
    "Cyrillic_CHE_vertstroke": (0x10004B8, "\u04B8"),
    "Cyrillic_DE": (0x06E4, "\u0414"),
    "Cyrillic_DZHE": (0x06BF, "\u040F"),
    "Cyrillic_E": (0x06FC, "\u042D"),
    "Cyrillic_EF": (0x06E6, "\u0424"),
    "Cyrillic_EL": (0x06EC, "\u041B"),
    "Cyrillic_EM": (0x06ED, "\u041C"),
    "Cyrillic_EN": (0x06EE, "\u041D"),
    "Cyrillic_EN_descender": (0x10004A2, "\u04A2"),
    "Cyrillic_ER": (0x06F2, "\u0420"),
    "Cyrillic_ES": (0x06F3, "\u0421"),
    "Cyrillic_GHE": (0x06E7, "\u0413"),
    "Cyrillic_GHE_bar": (0x1000492, "\u0492"),
    "Cyrillic_HA": (0x06E8, "\u0425"),
    "Cyrillic_HARDSIGN": (0x06FF, "\u042A"),
    "Cyrillic_HA_descender": (0x10004B2, "\u04B2"),
    "Cyrillic_I": (0x06E9, "\u0418"),
    "Cyrillic_IE": (0x06E5, "\u0415"),
    "Cyrillic_IO": (0x06B3, "\u0401"),
    "Cyrillic_I_macron": (0x10004E2, "\u04E2"),
    "Cyrillic_JE": (0x06B8, "\u0408"),
    "Cyrillic_KA": (0x06EB, "\u041A"),
    "Cyrillic_KA_descender": (0x100049A, "\u049A"),
    "Cyrillic_KA_vertstroke": (0x100049C, "\u049C"),
    "Cyrillic_LJE": (0x06B9, "\u0409"),
    "Cyrillic_NJE": (0x06BA, "\u040A"),
    "Cyrillic_O": (0x06EF, "\u041E"),
    "Cyrillic_O_bar": (0x10004E8, "\u04E8"),
    "Cyrillic_PE": (0x06F0, "\u041F"),
    "Cyrillic_SCHWA": (0x10004D8, "\u04D8"),
    "Cyrillic_SHA": (0x06FB, "\u0428"),
    "Cyrillic_SHCHA": (0x06FD, "\u0429"),
    "Cyrillic_SHHA": (0x10004BA, "\u04BA"),
    "Cyrillic_SHORTI": (0x06EA, "\u0419"),
    "Cyrillic_SOFTSIGN": (0x06F8, "\u042C"),
    "Cyrillic_TE": (0x06F4, "\u0422"),
    "Cyrillic_TSE": (0x06E3, "\u0426"),
    "Cyrillic_U": (0x06F5, "\u0423"),
    "Cyrillic_U_macron": (0x10004EE, "\u04EE"),
    "Cyrillic_U_straight": (0x10004AE, "\u04AE"),
    "Cyrillic_U_straight_bar": (0x10004B0, "\u04B0"),
    "Cyrillic_VE": (0x06F7, "\u0412"),
    "Cyrillic_YA": (0x06F1, "\u042F"),
    "Cyrillic_YERU": (0x06F9, "\u042B"),
    "Cyrillic_YU": (0x06E0, "\u042E"),
    "Cyrillic_ZE": (0x06FA, "\u0417"),
    "Cyrillic_ZHE": (0x06F6, "\u0416"),
    "Cyrillic_ZHE_descender": (0x1000496, "\u0496"),
    "Cyrillic_a": (0x06C1, "\u0430"),
    "Cyrillic_be": (0x06C2, "\u0431"),
    "Cyrillic_che": (0x06DE, "\u0447"),
    "Cyrillic_che_descender": (0x10004B7, "\u04B7"),
    "Cyrillic_che_vertstroke": (0x10004B9, "\u04B9"),
    "Cyrillic_de": (0x06C4, "\u0434"),
    "Cyrillic_dzhe": (0x06AF, "\u045F"),
    "Cyrillic_e": (0x06DC, "\u044D"),
    "Cyrillic_ef": (0x06C6, "\u0444"),
    "Cyrillic_el": (0x06CC, "\u043B"),
    "Cyrillic_em": (0x06CD, "\u043C"),
    "Cyrillic_en": (0x06CE, "\u043D"),
    "Cyrillic_en_descender": (0x10004A3, "\u04A3"),
    "Cyrillic_er": (0x06D2, "\u0440"),
    "Cyrillic_es": (0x06D3, "\u0441"),
    "Cyrillic_ghe": (0x06C7, "\u0433"),
    "Cyrillic_ghe_bar": (0x1000493, "\u0493"),
    "Cyrillic_ha": (0x06C8, "\u0445"),
    "Cyrillic_ha_descender": (0x10004B3, "\u04B3"),
    "Cyrillic_hardsign": (0x06DF, "\u044A"),
    "Cyrillic_i": (0x06C9, "\u0438"),
    "Cyrillic_i_macron": (0x10004E3, "\u04E3"),
    "Cyrillic_ie": (0x06C5, "\u0435"),
    "Cyrillic_io": (0x06A3, "\u0451"),
    "Cyrillic_je": (0x06A8, "\u0458"),
    "Cyrillic_ka": (0x06CB, "\u043A"),
    "Cyrillic_ka_descender": (0x100049B, "\u049B"),
    "Cyrillic_ka_vertstroke": (0x100049D, "\u049D"),
    "Cyrillic_lje": (0x06A9, "\u0459"),
    "Cyrillic_nje": (0x06AA, "\u045A"),
    "Cyrillic_o": (0x06CF, "\u043E"),
    "Cyrillic_o_bar": (0x10004E9, "\u04E9"),
    "Cyrillic_pe": (0x06D0, "\u043F"),
    "Cyrillic_schwa": (0x10004D9, "\u04D9"),
    "Cyrillic_sha": (0x06DB, "\u0448"),
    "Cyrillic_shcha": (0x06DD, "\u0449"),
    "Cyrillic_shha": (0x10004BB, "\u04BB"),
    "Cyrillic_shorti": (0x06CA, "\u0439"),
    "Cyrillic_softsign": (0x06D8, "\u044C"),
    "Cyrillic_te": (0x06D4, "\u0442"),
    "Cyrillic_tse": (0x06C3, "\u0446"),
    "Cyrillic_u": (0x06D5, "\u0443"),
    "Cyrillic_u_macron": (0x10004EF, "\u04EF"),
    "Cyrillic_u_straight": (0x10004AF, "\u04AF"),
    "Cyrillic_u_straight_bar": (0x10004B1, "\u04B1"),
    "Cyrillic_ve": (0x06D7, "\u0432"),
    "Cyrillic_ya": (0x06D1, "\u044F"),
    "Cyrillic_yeru": (0x06D9, "\u044B"),
    "Cyrillic_yu": (0x06C0, "\u044E"),
    "Cyrillic_ze": (0x06DA, "\u0437"),
    "Cyrillic_zhe": (0x06D6, "\u0436"),
    "Cyrillic_zhe_descender": (0x1000497, "\u0497"),
    "D": (0x0044, "\u0044"),
    "Dabovedot": (0x1001E0A, "\u1E0A"),
    "Dcaron": (0x01CF, "\u010E"),
    "DongSign": (0x10020AB, "\u20AB"),
    "Dstroke": (0x01D0, "\u0110"),
    "E": (0x0045, "\u0045"),
    "ENG": (0x03BD, "\u014A"),
    "ETH": (0x00D0, "\u00D0"),
    "EZH": (0x10001B7, "\u01B7"),
    "Eabovedot": (0x03CC, "\u0116"),
    "Eacute": (0x00C9, "\u00C9"),
    "Ebelowdot": (0x1001EB8, "\u1EB8"),
    "Ecaron": (0x01CC, "\u011A"),
    "Ecircumflex": (0x00CA, "\u00CA"),
    "Ecircumflexacute": (0x1001EBE, "\u1EBE"),
    "Ecircumflexbelowdot": (0x1001EC6, "\u1EC6"),
    "Ecircumflexgrave": (0x1001EC0, "\u1EC0"),
    "Ecircumflexhook": (0x1001EC2, "\u1EC2"),
    "Ecircumflextilde": (0x1001EC4, "\u1EC4"),
    "EcuSign": (0x10020A0, "\u20A0"),
    "Ediaeresis": (0x00CB, "\u00CB"),
    "Egrave": (0x00C8, "\u00C8"),
    "Ehook": (0x1001EBA, "\u1EBA"),
    "Emacron": (0x03AA, "\u0112"),
    "Eogonek": (0x01CA, "\u0118"),
    "Etilde": (0x1001EBC, "\u1EBC"),
    "EuroSign": (0x20AC, "\u20AC"),
    "F": (0x0046, "\u0046"),
    "FFrancSign": (0x10020A3, "\u20A3"),
    "Fabovedot": (0x1001E1E, "\u1E1E"),
    "Farsi_0": (0x10006F0, "\u06F0"),
    "Farsi_1": (0x10006F1, "\u06F1"),
    "Farsi_2": (0x10006F2, "\u06F2"),
    "Farsi_3": (0x10006F3, "\u06F3"),
    "Farsi_4": (0x10006F4, "\u06F4"),
    "Farsi_5": (0x10006F5, "\u06F5"),
    "Farsi_6": (0x10006F6, "\u06F6"),
    "Farsi_7": (0x10006F7, "\u06F7"),
    "Farsi_8": (0x10006F8, "\u06F8"),
    "Farsi_9": (0x10006F9, "\u06F9"),
    "Farsi_yeh": (0x10006CC, "\u06CC"),
    "G": (0x0047, "\u0047"),
    "Gabovedot": (0x02D5, "\u0120"),
    "Gbreve": (0x02AB, "\u011E"),
    "Gcaron": (0x10001E6, "\u01E6"),
    "Gcedilla": (0x03AB, "\u0122"),
    "Gcircumflex": (0x02D8, "\u011C"),
    "Georgian_an": (0x10010D0, "\u10D0"),
    "Georgian_ban": (0x10010D1, "\u10D1"),
    "Georgian_can": (0x10010EA, "\u10EA"),
    "Georgian_char": (0x10010ED, "\u10ED"),
    "Georgian_chin": (0x10010E9, "\u10E9"),
    "Georgian_cil": (0x10010EC, "\u10EC"),
    "Georgian_don": (0x10010D3, "\u10D3"),
    "Georgian_en": (0x10010D4, "\u10D4"),
    "Georgian_fi": (0x10010F6, "\u10F6"),
    "Georgian_gan": (0x10010D2, "\u10D2"),
    "Georgian_ghan": (0x10010E6, "\u10E6"),
    "Georgian_hae": (0x10010F0, "\u10F0"),
    "Georgian_har": (0x10010F4, "\u10F4"),
    "Georgian_he": (0x10010F1, "\u10F1"),
    "Georgian_hie": (0x10010F2, "\u10F2"),
    "Georgian_hoe": (0x10010F5, "\u10F5"),
    "Georgian_in": (0x10010D8, "\u10D8"),
    "Georgian_jhan": (0x10010EF, "\u10EF"),
    "Georgian_jil": (0x10010EB, "\u10EB"),
    "Georgian_kan": (0x10010D9, "\u10D9"),
    "Georgian_khar": (0x10010E5, "\u10E5"),
    "Georgian_las": (0x10010DA, "\u10DA"),
    "Georgian_man": (0x10010DB, "\u10DB"),
    "Georgian_nar": (0x10010DC, "\u10DC"),
    "Georgian_on": (0x10010DD, "\u10DD"),
    "Georgian_par": (0x10010DE, "\u10DE"),
    "Georgian_phar": (0x10010E4, "\u10E4"),
    "Georgian_qar": (0x10010E7, "\u10E7"),
    "Georgian_rae": (0x10010E0, "\u10E0"),
    "Georgian_san": (0x10010E1, "\u10E1"),
    "Georgian_shin": (0x10010E8, "\u10E8"),
    "Georgian_tan": (0x10010D7, "\u10D7"),
    "Georgian_tar": (0x10010E2, "\u10E2"),
    "Georgian_un": (0x10010E3, "\u10E3"),
    "Georgian_vin": (0x10010D5, "\u10D5"),
    "Georgian_we": (0x10010F3, "\u10F3"),
    "Georgian_xan": (0x10010EE, "\u10EE"),
    "Georgian_zen": (0x10010D6, "\u10D6"),
    "Georgian_zhar": (0x10010DF, "\u10DF"),
    "Greek_ALPHA": (0x07C1, "\u0391"),
    "Greek_ALPHAaccent": (0x07A1, "\u0386"),
    "Greek_BETA": (0x07C2, "\u0392"),
    "Greek_CHI": (0x07D7, "\u03A7"),
    "Greek_DELTA": (0x07C4, "\u0394"),
    "Greek_EPSILON": (0x07C5, "\u0395"),
    "Greek_EPSILONaccent": (0x07A2, "\u0388"),
    "Greek_ETA": (0x07C7, "\u0397"),
    "Greek_ETAaccent": (0x07A3, "\u0389"),
    "Greek_GAMMA": (0x07C3, "\u0393"),
    "Greek_IOTA": (0x07C9, "\u0399"),
    "Greek_IOTAaccent": (0x07A4, "\u038A"),
    "Greek_IOTAdieresis": (0x07A5, "\u03AA"),
    "Greek_KAPPA": (0x07CA, "\u039A"),
    "Greek_LAMBDA": (0x07CB, "\u039B"),
    "Greek_LAMDA": (0x07CB, "\u039B"),
    "Greek_MU": (0x07CC, "\u039C"),
    "Greek_NU": (0x07CD, "\u039D"),
    "Greek_OMEGA": (0x07D9, "\u03A9"),
    "Greek_OMEGAaccent": (0x07AB, "\u038F"),
    "Greek_OMICRON": (0x07CF, "\u039F"),
    "Greek_OMICRONaccent": (0x07A7, "\u038C"),
    "Greek_PHI": (0x07D6, "\u03A6"),
    "Greek_PI": (0x07D0, "\u03A0"),
    "Greek_PSI": (0x07D8, "\u03A8"),
    "Greek_RHO": (0x07D1, "\u03A1"),
    "Greek_SIGMA": (0x07D2, "\u03A3"),
    "Greek_TAU": (0x07D4, "\u03A4"),
    "Greek_THETA": (0x07C8, "\u0398"),
    "Greek_UPSILON": (0x07D5, "\u03A5"),
    "Greek_UPSILONaccent": (0x07A8, "\u038E"),
    "Greek_UPSILONdieresis": (0x07A9, "\u03AB"),
    "Greek_XI": (0x07CE, "\u039E"),
    "Greek_ZETA": (0x07C6, "\u0396"),
    "Greek_accentdieresis": (0x07AE, "\u0385"),
    "Greek_alpha": (0x07E1, "\u03B1"),
    "Greek_alphaaccent": (0x07B1, "\u03AC"),
    "Greek_beta": (0x07E2, "\u03B2"),
    "Greek_chi": (0x07F7, "\u03C7"),
    "Greek_delta": (0x07E4, "\u03B4"),
    "Greek_epsilon": (0x07E5, "\u03B5"),
    "Greek_epsilonaccent": (0x07B2, "\u03AD"),
    "Greek_eta": (0x07E7, "\u03B7"),
    "Greek_etaaccent": (0x07B3, "\u03AE"),
    "Greek_finalsmallsigma": (0x07F3, "\u03C2"),
    "Greek_gamma": (0x07E3, "\u03B3"),
    "Greek_horizbar": (0x07AF, "\u2015"),
    "Greek_iota": (0x07E9, "\u03B9"),
    "Greek_iotaaccent": (0x07B4, "\u03AF"),
    "Greek_iotaaccentdieresis": (0x07B6, "\u0390"),
    "Greek_iotadieresis": (0x07B5, "\u03CA"),
    "Greek_kappa": (0x07EA, "\u03BA"),
    "Greek_lambda": (0x07EB, "\u03BB"),
    "Greek_lamda": (0x07EB, "\u03BB"),
    "Greek_mu": (0x07EC, "\u03BC"),
    "Greek_nu": (0x07ED, "\u03BD"),
    "Greek_omega": (0x07F9, "\u03C9"),
    "Greek_omegaaccent": (0x07BB, "\u03CE"),
    "Greek_omicron": (0x07EF, "\u03BF"),
    "Greek_omicronaccent": (0x07B7, "\u03CC"),
    "Greek_phi": (0x07F6, "\u03C6"),
    "Greek_pi": (0x07F0, "\u03C0"),
    "Greek_psi": (0x07F8, "\u03C8"),
    "Greek_rho": (0x07F1, "\u03C1"),
    "Greek_sigma": (0x07F2, "\u03C3"),
    "Greek_tau": (0x07F4, "\u03C4"),
    "Greek_theta": (0x07E8, "\u03B8"),
    "Greek_upsilon": (0x07F5, "\u03C5"),
    "Greek_upsilonaccent": (0x07B8, "\u03CD"),
    "Greek_upsilonaccentdieresis": (0x07BA, "\u03B0"),
    "Greek_upsilondieresis": (0x07B9, "\u03CB"),
    "Greek_xi": (0x07EE, "\u03BE"),
    "Greek_zeta": (0x07E6, "\u03B6"),
    "H": (0x0048, "\u0048"),
    "Hcircumflex": (0x02A6, "\u0124"),
    "Hstroke": (0x02A1, "\u0126"),
    "I": (0x0049, "\u0049"),
    "Iabovedot": (0x02A9, "\u0130"),
    "Iacute": (0x00CD, "\u00CD"),
    "Ibelowdot": (0x1001ECA, "\u1ECA"),
    "Ibreve": (0x100012C, "\u012C"),
    "Icircumflex": (0x00CE, "\u00CE"),
    "Idiaeresis": (0x00CF, "\u00CF"),
    "Igrave": (0x00CC, "\u00CC"),
    "Ihook": (0x1001EC8, "\u1EC8"),
    "Imacron": (0x03CF, "\u012A"),
    "Iogonek": (0x03C7, "\u012E"),
    "Itilde": (0x03A5, "\u0128"),
    "J": (0x004A, "\u004A"),
    "Jcircumflex": (0x02AC, "\u0134"),
    "K": (0x004B, "\u004B"),
    "KP_0": (0xFFB0, None),
    "KP_1": (0xFFB1, None),
    "KP_2": (0xFFB2, None),
    "KP_3": (0xFFB3, None),
    "KP_4": (0xFFB4, None),
    "KP_5": (0xFFB5, None),
    "KP_6": (0xFFB6, None),
    "KP_7": (0xFFB7, None),
    "KP_8": (0xFFB8, None),
    "KP_9": (0xFFB9, None),
    "KP_Add": (0xFFAB, None),
    "KP_Begin": (0xFF9D, None),
    "KP_Decimal": (0xFFAE, None),
    "KP_Delete": (0xFF9F, None),
    "KP_Divide": (0xFFAF, None),
    "KP_Down": (0xFF99, None),
    "KP_End": (0xFF9C, None),
    "KP_Enter": (0xFF8D, None),
    "KP_Equal": (0xFFBD, None),
    "KP_F1": (0xFF91, None),
    "KP_F2": (0xFF92, None),
    "KP_F3": (0xFF93, None),
    "KP_F4": (0xFF94, None),
    "KP_Home": (0xFF95, None),
    "KP_Insert": (0xFF9E, None),
    "KP_Left": (0xFF96, None),
    "KP_Multiply": (0xFFAA, None),
    "KP_Next": (0xFF9B, None),
    "KP_Page_Down": (0xFF9B, None),
    "KP_Page_Up": (0xFF9A, None),
    "KP_Prior": (0xFF9A, None),
    "KP_Right": (0xFF98, None),
    "KP_Separator": (0xFFAC, None),
    "KP_Space": (0xFF80, None),
    "KP_Subtract": (0xFFAD, None),
    "KP_Tab": (0xFF89, None),
    "KP_Up": (0xFF97, None),
    "Kcedilla": (0x03D3, "\u0136"),
    "L": (0x004C, "\u004C"),
    "Lacute": (0x01C5, "\u0139"),
    "Lbelowdot": (0x1001E36, "\u1E36"),
    "Lcaron": (0x01A5, "\u013D"),
    "Lcedilla": (0x03A6, "\u013B"),
    "LiraSign": (0x10020A4, "\u20A4"),
    "Lstroke": (0x01A3, "\u0141"),
    "M": (0x004D, "\u004D"),
    "Mabovedot": (0x1001E40, "\u1E40"),
    "Macedonia_DSE": (0x06B5, "\u0405"),
    "Macedonia_GJE": (0x06B2, "\u0403"),
    "Macedonia_KJE": (0x06BC, "\u040C"),
    "Macedonia_dse": (0x06A5, "\u0455"),
    "Macedonia_gje": (0x06A2, "\u0453"),
    "Macedonia_kje": (0x06AC, "\u045C"),
    "MillSign": (0x10020A5, "\u20A5"),
    "N": (0x004E, "\u004E"),
    "Nacute": (0x01D1, "\u0143"),
    "NairaSign": (0x10020A6, "\u20A6"),
    "Ncaron": (0x01D2, "\u0147"),
    "Ncedilla": (0x03D1, "\u0145"),
    "NewSheqelSign": (0x10020AA, "\u20AA"),
    "Ntilde": (0x00D1, "\u00D1"),
    "O": (0x004F, "\u004F"),
    "OE": (0x13BC, "\u0152"),
    "Oacute": (0x00D3, "\u00D3"),
    "Obarred": (0x100019F, "\u019F"),
    "Obelowdot": (0x1001ECC, "\u1ECC"),
    "Ocaron": (0x10001D1, "\u01D2"),
    "Ocircumflex": (0x00D4, "\u00D4"),
    "Ocircumflexacute": (0x1001ED0, "\u1ED0"),
    "Ocircumflexbelowdot": (0x1001ED8, "\u1ED8"),
    "Ocircumflexgrave": (0x1001ED2, "\u1ED2"),
    "Ocircumflexhook": (0x1001ED4, "\u1ED4"),
    "Ocircumflextilde": (0x1001ED6, "\u1ED6"),
    "Odiaeresis": (0x00D6, "\u00D6"),
    "Odoubleacute": (0x01D5, "\u0150"),
    "Ograve": (0x00D2, "\u00D2"),
    "Ohook": (0x1001ECE, "\u1ECE"),
    "Ohorn": (0x10001A0, "\u01A0"),
    "Ohornacute": (0x1001EDA, "\u1EDA"),
    "Ohornbelowdot": (0x1001EE2, "\u1EE2"),
    "Ohorngrave": (0x1001EDC, "\u1EDC"),
    "Ohornhook": (0x1001EDE, "\u1EDE"),
    "Ohorntilde": (0x1001EE0, "\u1EE0"),
    "Omacron": (0x03D2, "\u014C"),
    "Ooblique": (0x00D8, "\u00D8"),
    "Oslash": (0x00D8, "\u00D8"),
    "Otilde": (0x00D5, "\u00D5"),
    "P": (0x0050, "\u0050"),
    "Pabovedot": (0x1001E56, "\u1E56"),
    "PesetaSign": (0x10020A7, "\u20A7"),
    "Q": (0x0051, "\u0051"),
    "R": (0x0052, "\u0052"),
    "Racute": (0x01C0, "\u0154"),
    "Rcaron": (0x01D8, "\u0158"),
    "Rcedilla": (0x03A3, "\u0156"),
    "RupeeSign": (0x10020A8, "\u20A8"),
    "S": (0x0053, "\u0053"),
    "SCHWA": (0x100018F, "\u018F"),
    "Sabovedot": (0x1001E60, "\u1E60"),
    "Sacute": (0x01A6, "\u015A"),
    "Scaron": (0x01A9, "\u0160"),
    "Scedilla": (0x01AA, "\u015E"),
    "Scircumflex": (0x02DE, "\u015C"),
    "Serbian_DJE": (0x06B1, "\u0402"),
    "Serbian_TSHE": (0x06BB, "\u040B"),
    "Serbian_dje": (0x06A1, "\u0452"),
    "Serbian_tshe": (0x06AB, "\u045B"),
    "Sinh_a": (0x1000D85, "\u0D85"),
    "Sinh_aa": (0x1000D86, "\u0D86"),
    "Sinh_aa2": (0x1000DCF, "\u0DCF"),
    "Sinh_ae": (0x1000D87, "\u0D87"),
    "Sinh_ae2": (0x1000DD0, "\u0DD0"),
    "Sinh_aee": (0x1000D88, "\u0D88"),
    "Sinh_aee2": (0x1000DD1, "\u0DD1"),
    "Sinh_ai": (0x1000D93, "\u0D93"),
    "Sinh_ai2": (0x1000DDB, "\u0DDB"),
    "Sinh_al": (0x1000DCA, "\u0DCA"),
    "Sinh_au": (0x1000D96, "\u0D96"),
    "Sinh_au2": (0x1000DDE, "\u0DDE"),
    "Sinh_ba": (0x1000DB6, "\u0DB6"),
    "Sinh_bha": (0x1000DB7, "\u0DB7"),
    "Sinh_ca": (0x1000DA0, "\u0DA0"),
    "Sinh_cha": (0x1000DA1, "\u0DA1"),
    "Sinh_dda": (0x1000DA9, "\u0DA9"),
    "Sinh_ddha": (0x1000DAA, "\u0DAA"),
    "Sinh_dha": (0x1000DAF, "\u0DAF"),
    "Sinh_dhha": (0x1000DB0, "\u0DB0"),
    "Sinh_e": (0x1000D91, "\u0D91"),
    "Sinh_e2": (0x1000DD9, "\u0DD9"),
    "Sinh_ee": (0x1000D92, "\u0D92"),
    "Sinh_ee2": (0x1000DDA, "\u0DDA"),
    "Sinh_fa": (0x1000DC6, "\u0DC6"),
    "Sinh_ga": (0x1000D9C, "\u0D9C"),
    "Sinh_gha": (0x1000D9D, "\u0D9D"),
    "Sinh_h2": (0x1000D83, "\u0D83"),
    "Sinh_ha": (0x1000DC4, "\u0DC4"),
    "Sinh_i": (0x1000D89, "\u0D89"),
    "Sinh_i2": (0x1000DD2, "\u0DD2"),
    "Sinh_ii": (0x1000D8A, "\u0D8A"),
    "Sinh_ii2": (0x1000DD3, "\u0DD3"),
    "Sinh_ja": (0x1000DA2, "\u0DA2"),
    "Sinh_jha": (0x1000DA3, "\u0DA3"),
    "Sinh_jnya": (0x1000DA5, "\u0DA5"),
    "Sinh_ka": (0x1000D9A, "\u0D9A"),
    "Sinh_kha": (0x1000D9B, "\u0D9B"),
    "Sinh_kunddaliya": (0x1000DF4, "\u0DF4"),
    "Sinh_la": (0x1000DBD, "\u0DBD"),
    "Sinh_lla": (0x1000DC5, "\u0DC5"),
    "Sinh_lu": (0x1000D8F, "\u0D8F"),
    "Sinh_lu2": (0x1000DDF, "\u0DDF"),
    "Sinh_luu": (0x1000D90, "\u0D90"),
    "Sinh_luu2": (0x1000DF3, "\u0DF3"),
    "Sinh_ma": (0x1000DB8, "\u0DB8"),
    "Sinh_mba": (0x1000DB9, "\u0DB9"),
    "Sinh_na": (0x1000DB1, "\u0DB1"),
    "Sinh_ndda": (0x1000DAC, "\u0DAC"),
    "Sinh_ndha": (0x1000DB3, "\u0DB3"),
    "Sinh_ng": (0x1000D82, "\u0D82"),
    "Sinh_ng2": (0x1000D9E, "\u0D9E"),
    "Sinh_nga": (0x1000D9F, "\u0D9F"),
    "Sinh_nja": (0x1000DA6, "\u0DA6"),
    "Sinh_nna": (0x1000DAB, "\u0DAB"),
    "Sinh_nya": (0x1000DA4, "\u0DA4"),
    "Sinh_o": (0x1000D94, "\u0D94"),
    "Sinh_o2": (0x1000DDC, "\u0DDC"),
    "Sinh_oo": (0x1000D95, "\u0D95"),
    "Sinh_oo2": (0x1000DDD, "\u0DDD"),
    "Sinh_pa": (0x1000DB4, "\u0DB4"),
    "Sinh_pha": (0x1000DB5, "\u0DB5"),
    "Sinh_ra": (0x1000DBB, "\u0DBB"),
    "Sinh_ri": (0x1000D8D, "\u0D8D"),
    "Sinh_rii": (0x1000D8E, "\u0D8E"),
    "Sinh_ru2": (0x1000DD8, "\u0DD8"),
    "Sinh_ruu2": (0x1000DF2, "\u0DF2"),
    "Sinh_sa": (0x1000DC3, "\u0DC3"),
    "Sinh_sha": (0x1000DC1, "\u0DC1"),
    "Sinh_ssha": (0x1000DC2, "\u0DC2"),
    "Sinh_tha": (0x1000DAD, "\u0DAD"),
    "Sinh_thha": (0x1000DAE, "\u0DAE"),
    "Sinh_tta": (0x1000DA7, "\u0DA7"),
    "Sinh_ttha": (0x1000DA8, "\u0DA8"),
    "Sinh_u": (0x1000D8B, "\u0D8B"),
    "Sinh_u2": (0x1000DD4, "\u0DD4"),
    "Sinh_uu": (0x1000D8C, "\u0D8C"),
    "Sinh_uu2": (0x1000DD6, "\u0DD6"),
    "Sinh_va": (0x1000DC0, "\u0DC0"),
    "Sinh_ya": (0x1000DBA, "\u0DBA"),
    "T": (0x0054, "\u0054"),
    "THORN": (0x00DE, "\u00DE"),
    "Tabovedot": (0x1001E6A, "\u1E6A"),
    "Tcaron": (0x01AB, "\u0164"),
    "Tcedilla": (0x01DE, "\u0162"),
    "Thai_baht": (0x0DDF, "\u0E3F"),
    "Thai_bobaimai": (0x0DBA, "\u0E1A"),
    "Thai_chochan": (0x0DA8, "\u0E08"),
    "Thai_chochang": (0x0DAA, "\u0E0A"),
    "Thai_choching": (0x0DA9, "\u0E09"),
    "Thai_chochoe": (0x0DAC, "\u0E0C"),
    "Thai_dochada": (0x0DAE, "\u0E0E"),
    "Thai_dodek": (0x0DB4, "\u0E14"),
    "Thai_fofa": (0x0DBD, "\u0E1D"),
    "Thai_fofan": (0x0DBF, "\u0E1F"),
    "Thai_hohip": (0x0DCB, "\u0E2B"),
    "Thai_honokhuk": (0x0DCE, "\u0E2E"),
    "Thai_khokhai": (0x0DA2, "\u0E02"),
    "Thai_khokhon": (0x0DA5, "\u0E05"),
    "Thai_khokhuat": (0x0DA3, "\u0E03"),
    "Thai_khokhwai": (0x0DA4, "\u0E04"),
    "Thai_khorakhang": (0x0DA6, "\u0E06"),
    "Thai_kokai": (0x0DA1, "\u0E01"),
    "Thai_lakkhangyao": (0x0DE5, "\u0E45"),
    "Thai_lekchet": (0x0DF7, "\u0E57"),
    "Thai_lekha": (0x0DF5, "\u0E55"),
    "Thai_lekhok": (0x0DF6, "\u0E56"),
    "Thai_lekkao": (0x0DF9, "\u0E59"),
    "Thai_leknung": (0x0DF1, "\u0E51"),
    "Thai_lekpaet": (0x0DF8, "\u0E58"),
    "Thai_leksam": (0x0DF3, "\u0E53"),
    "Thai_leksi": (0x0DF4, "\u0E54"),
    "Thai_leksong": (0x0DF2, "\u0E52"),
    "Thai_leksun": (0x0DF0, "\u0E50"),
    "Thai_lochula": (0x0DCC, "\u0E2C"),
    "Thai_loling": (0x0DC5, "\u0E25"),
    "Thai_lu": (0x0DC6, "\u0E26"),
    "Thai_maichattawa": (0x0DEB, "\u0E4B"),
    "Thai_maiek": (0x0DE8, "\u0E48"),
    "Thai_maihanakat": (0x0DD1, "\u0E31"),
    "Thai_maitaikhu": (0x0DE7, "\u0E47"),
    "Thai_maitho": (0x0DE9, "\u0E49"),
    "Thai_maitri": (0x0DEA, "\u0E4A"),
    "Thai_maiyamok": (0x0DE6, "\u0E46"),
    "Thai_moma": (0x0DC1, "\u0E21"),
    "Thai_ngongu": (0x0DA7, "\u0E07"),
    "Thai_nikhahit": (0x0DED, "\u0E4D"),
    "Thai_nonen": (0x0DB3, "\u0E13"),
    "Thai_nonu": (0x0DB9, "\u0E19"),
    "Thai_oang": (0x0DCD, "\u0E2D"),
    "Thai_paiyannoi": (0x0DCF, "\u0E2F"),
    "Thai_phinthu": (0x0DDA, "\u0E3A"),
    "Thai_phophan": (0x0DBE, "\u0E1E"),
    "Thai_phophung": (0x0DBC, "\u0E1C"),
    "Thai_phosamphao": (0x0DC0, "\u0E20"),
    "Thai_popla": (0x0DBB, "\u0E1B"),
    "Thai_rorua": (0x0DC3, "\u0E23"),
    "Thai_ru": (0x0DC4, "\u0E24"),
    "Thai_saraa": (0x0DD0, "\u0E30"),
    "Thai_saraaa": (0x0DD2, "\u0E32"),
    "Thai_saraae": (0x0DE1, "\u0E41"),
    "Thai_saraaimaimalai": (0x0DE4, "\u0E44"),
    "Thai_saraaimaimuan": (0x0DE3, "\u0E43"),
    "Thai_saraam": (0x0DD3, "\u0E33"),
    "Thai_sarae": (0x0DE0, "\u0E40"),
    "Thai_sarai": (0x0DD4, "\u0E34"),
    "Thai_saraii": (0x0DD5, "\u0E35"),
    "Thai_sarao": (0x0DE2, "\u0E42"),
    "Thai_sarau": (0x0DD8, "\u0E38"),
    "Thai_saraue": (0x0DD6, "\u0E36"),
    "Thai_sarauee": (0x0DD7, "\u0E37"),
    "Thai_sarauu": (0x0DD9, "\u0E39"),
    "Thai_sorusi": (0x0DC9, "\u0E29"),
    "Thai_sosala": (0x0DC8, "\u0E28"),
    "Thai_soso": (0x0DAB, "\u0E0B"),
    "Thai_sosua": (0x0DCA, "\u0E2A"),
    "Thai_thanthakhat": (0x0DEC, "\u0E4C"),
    "Thai_thonangmontho": (0x0DB1, "\u0E11"),
    "Thai_thophuthao": (0x0DB2, "\u0E12"),
    "Thai_thothahan": (0x0DB7, "\u0E17"),
    "Thai_thothan": (0x0DB0, "\u0E10"),
    "Thai_thothong": (0x0DB8, "\u0E18"),
    "Thai_thothung": (0x0DB6, "\u0E16"),
    "Thai_topatak": (0x0DAF, "\u0E0F"),
    "Thai_totao": (0x0DB5, "\u0E15"),
    "Thai_wowaen": (0x0DC7, "\u0E27"),
    "Thai_yoyak": (0x0DC2, "\u0E22"),
    "Thai_yoying": (0x0DAD, "\u0E0D"),
    "Tslash": (0x03AC, "\u0166"),
    "U": (0x0055, "\u0055"),
    "Uacute": (0x00DA, "\u00DA"),
    "Ubelowdot": (0x1001EE4, "\u1EE4"),
    "Ubreve": (0x02DD, "\u016C"),
    "Ucircumflex": (0x00DB, "\u00DB"),
    "Udiaeresis": (0x00DC, "\u00DC"),
    "Udoubleacute": (0x01DB, "\u0170"),
    "Ugrave": (0x00D9, "\u00D9"),
    "Uhook": (0x1001EE6, "\u1EE6"),
    "Uhorn": (0x10001AF, "\u01AF"),
    "Uhornacute": (0x1001EE8, "\u1EE8"),
    "Uhornbelowdot": (0x1001EF0, "\u1EF0"),
    "Uhorngrave": (0x1001EEA, "\u1EEA"),
    "Uhornhook": (0x1001EEC, "\u1EEC"),
    "Uhorntilde": (0x1001EEE, "\u1EEE"),
    "Ukrainian_GHE_WITH_UPTURN": (0x06BD, "\u0490"),
    "Ukrainian_I": (0x06B6, "\u0406"),
    "Ukrainian_IE": (0x06B4, "\u0404"),
    "Ukrainian_YI": (0x06B7, "\u0407"),
    "Ukrainian_ghe_with_upturn": (0x06AD, "\u0491"),
    "Ukrainian_i": (0x06A6, "\u0456"),
    "Ukrainian_ie": (0x06A4, "\u0454"),
    "Ukrainian_yi": (0x06A7, "\u0457"),
    "Umacron": (0x03DE, "\u016A"),
    "Uogonek": (0x03D9, "\u0172"),
    "Uring": (0x01D9, "\u016E"),
    "Utilde": (0x03DD, "\u0168"),
    "V": (0x0056, "\u0056"),
    "W": (0x0057, "\u0057"),
    "Wacute": (0x1001E82, "\u1E82"),
    "Wcircumflex": (0x1000174, "\u0174"),
    "Wdiaeresis": (0x1001E84, "\u1E84"),
    "Wgrave": (0x1001E80, "\u1E80"),
    "WonSign": (0x10020A9, "\u20A9"),
    "X": (0x0058, "\u0058"),
    "Xabovedot": (0x1001E8A, "\u1E8A"),
    "Y": (0x0059, "\u0059"),
    "Yacute": (0x00DD, "\u00DD"),
    "Ybelowdot": (0x1001EF4, "\u1EF4"),
    "Ycircumflex": (0x1000176, "\u0176"),
    "Ydiaeresis": (0x13BE, "\u0178"),
    "Ygrave": (0x1001EF2, "\u1EF2"),
    "Yhook": (0x1001EF6, "\u1EF6"),
    "Ytilde": (0x1001EF8, "\u1EF8"),
    "Z": (0x005A, "\u005A"),
    "Zabovedot": (0x01AF, "\u017B"),
    "Zacute": (0x01AC, "\u0179"),
    "Zcaron": (0x01AE, "\u017D"),
    "Zstroke": (0x10001B5, "\u01B5"),
    "a": (0x0061, "\u0061"),
    "aacute": (0x00E1, "\u00E1"),
    "abelowdot": (0x1001EA1, "\u1EA1"),
    "abovedot": (0x01FF, "\u02D9"),
    "abreve": (0x01E3, "\u0103"),
    "abreveacute": (0x1001EAF, "\u1EAF"),
    "abrevebelowdot": (0x1001EB7, "\u1EB7"),
    "abrevegrave": (0x1001EB1, "\u1EB1"),
    "abrevehook": (0x1001EB3, "\u1EB3"),
    "abrevetilde": (0x1001EB5, "\u1EB5"),
    "acircumflex": (0x00E2, "\u00E2"),
    "acircumflexacute": (0x1001EA5, "\u1EA5"),
    "acircumflexbelowdot": (0x1001EAD, "\u1EAD"),
    "acircumflexgrave": (0x1001EA7, "\u1EA7"),
    "acircumflexhook": (0x1001EA9, "\u1EA9"),
    "acircumflextilde": (0x1001EAB, "\u1EAB"),
    "acute": (0x00B4, "\u00B4"),
    "adiaeresis": (0x00E4, "\u00E4"),
    "ae": (0x00E6, "\u00E6"),
    "agrave": (0x00E0, "\u00E0"),
    "ahook": (0x1001EA3, "\u1EA3"),
    "amacron": (0x03E0, "\u0101"),
    "ampersand": (0x0026, "\u0026"),
    "aogonek": (0x01B1, "\u0105"),
    "apostrophe": (0x0027, "\u0027"),
    "approxeq": (0x1002248, "\u2245"),
    "approximate": (0x08C8, "\u223C"),
    "aring": (0x00E5, "\u00E5"),
    "asciicircum": (0x005E, "\u005E"),
    "asciitilde": (0x007E, "\u007E"),
    "asterisk": (0x002A, "\u002A"),
    "at": (0x0040, "\u0040"),
    "atilde": (0x00E3, "\u00E3"),
    "b": (0x0062, "\u0062"),
    "babovedot": (0x1001E03, "\u1E03"),
    "backslash": (0x005C, "\u005C"),
    "ballotcross": (0x0AF4, "\u2717"),
    "bar": (0x007C, "\u007C"),
    "because": (0x1002235, "\u2235"),
    "botintegral": (0x08A5, "\u2321"),
    "botleftparens": (0x08AC, "\u239D"),
    "botleftsqbracket": (0x08A8, "\u23A3"),
    "botrightparens": (0x08AE, "\u23A0"),
    "botrightsqbracket": (0x08AA, "\u23A6"),
    "bott": (0x09F6, "\u2534"),
    "braceleft": (0x007B, "\u007B"),
    "braceright": (0x007D, "\u007D"),
    "bracketleft": (0x005B, "\u005B"),
    "bracketright": (0x005D, "\u005D"),
    "braille_blank": (0x1002800, "\u2800"),
    "braille_dots_1": (0x1002801, "\u2801"),
    "braille_dots_12": (0x1002803, "\u2803"),
    "braille_dots_123": (0x1002807, "\u2807"),
    "braille_dots_1234": (0x100280F, "\u280f"),
    "braille_dots_12345": (0x100281F, "\u281f"),
    "braille_dots_123456": (0x100283F, "\u283f"),
    "braille_dots_1234567": (0x100287F, "\u287f"),
    "braille_dots_12345678": (0x10028FF, "\u28ff"),
    "braille_dots_1234568": (0x10028BF, "\u28bf"),
    "braille_dots_123457": (0x100285F, "\u285f"),
    "braille_dots_1234578": (0x10028DF, "\u28df"),
    "braille_dots_123458": (0x100289F, "\u289f"),
    "braille_dots_12346": (0x100282F, "\u282f"),
    "braille_dots_123467": (0x100286F, "\u286f"),
    "braille_dots_1234678": (0x10028EF, "\u28ef"),
    "braille_dots_123468": (0x10028AF, "\u28af"),
    "braille_dots_12347": (0x100284F, "\u284f"),
    "braille_dots_123478": (0x10028CF, "\u28cf"),
    "braille_dots_12348": (0x100288F, "\u288f"),
    "braille_dots_1235": (0x1002817, "\u2817"),
    "braille_dots_12356": (0x1002837, "\u2837"),
    "braille_dots_123567": (0x1002877, "\u2877"),
    "braille_dots_1235678": (0x10028F7, "\u28f7"),
    "braille_dots_123568": (0x10028B7, "\u28b7"),
    "braille_dots_12357": (0x1002857, "\u2857"),
    "braille_dots_123578": (0x10028D7, "\u28d7"),
    "braille_dots_12358": (0x1002897, "\u2897"),
    "braille_dots_1236": (0x1002827, "\u2827"),
    "braille_dots_12367": (0x1002867, "\u2867"),
    "braille_dots_123678": (0x10028E7, "\u28e7"),
    "braille_dots_12368": (0x10028A7, "\u28a7"),
    "braille_dots_1237": (0x1002847, "\u2847"),
    "braille_dots_12378": (0x10028C7, "\u28c7"),
    "braille_dots_1238": (0x1002887, "\u2887"),
    "braille_dots_124": (0x100280B, "\u280b"),
    "braille_dots_1245": (0x100281B, "\u281b"),
    "braille_dots_12456": (0x100283B, "\u283b"),
    "braille_dots_124567": (0x100287B, "\u287b"),
    "braille_dots_1245678": (0x10028FB, "\u28fb"),
    "braille_dots_124568": (0x10028BB, "\u28bb"),
    "braille_dots_12457": (0x100285B, "\u285b"),
    "braille_dots_124578": (0x10028DB, "\u28db"),
    "braille_dots_12458": (0x100289B, "\u289b"),
    "braille_dots_1246": (0x100282B, "\u282b"),
    "braille_dots_12467": (0x100286B, "\u286b"),
    "braille_dots_124678": (0x10028EB, "\u28eb"),
    "braille_dots_12468": (0x10028AB, "\u28ab"),
    "braille_dots_1247": (0x100284B, "\u284b"),
    "braille_dots_12478": (0x10028CB, "\u28cb"),
    "braille_dots_1248": (0x100288B, "\u288b"),
    "braille_dots_125": (0x1002813, "\u2813"),
    "braille_dots_1256": (0x1002833, "\u2833"),
    "braille_dots_12567": (0x1002873, "\u2873"),
    "braille_dots_125678": (0x10028F3, "\u28f3"),
    "braille_dots_12568": (0x10028B3, "\u28b3"),
    "braille_dots_1257": (0x1002853, "\u2853"),
    "braille_dots_12578": (0x10028D3, "\u28d3"),
    "braille_dots_1258": (0x1002893, "\u2893"),
    "braille_dots_126": (0x1002823, "\u2823"),
    "braille_dots_1267": (0x1002863, "\u2863"),
    "braille_dots_12678": (0x10028E3, "\u28e3"),
    "braille_dots_1268": (0x10028A3, "\u28a3"),
    "braille_dots_127": (0x1002843, "\u2843"),
    "braille_dots_1278": (0x10028C3, "\u28c3"),
    "braille_dots_128": (0x1002883, "\u2883"),
    "braille_dots_13": (0x1002805, "\u2805"),
    "braille_dots_134": (0x100280D, "\u280d"),
    "braille_dots_1345": (0x100281D, "\u281d"),
    "braille_dots_13456": (0x100283D, "\u283d"),
    "braille_dots_134567": (0x100287D, "\u287d"),
    "braille_dots_1345678": (0x10028FD, "\u28fd"),
    "braille_dots_134568": (0x10028BD, "\u28bd"),
    "braille_dots_13457": (0x100285D, "\u285d"),
    "braille_dots_134578": (0x10028DD, "\u28dd"),
    "braille_dots_13458": (0x100289D, "\u289d"),
    "braille_dots_1346": (0x100282D, "\u282d"),
    "braille_dots_13467": (0x100286D, "\u286d"),
    "braille_dots_134678": (0x10028ED, "\u28ed"),
    "braille_dots_13468": (0x10028AD, "\u28ad"),
    "braille_dots_1347": (0x100284D, "\u284d"),
    "braille_dots_13478": (0x10028CD, "\u28cd"),
    "braille_dots_1348": (0x100288D, "\u288d"),
    "braille_dots_135": (0x1002815, "\u2815"),
    "braille_dots_1356": (0x1002835, "\u2835"),
    "braille_dots_13567": (0x1002875, "\u2875"),
    "braille_dots_135678": (0x10028F5, "\u28f5"),
    "braille_dots_13568": (0x10028B5, "\u28b5"),
    "braille_dots_1357": (0x1002855, "\u2855"),
    "braille_dots_13578": (0x10028D5, "\u28d5"),
    "braille_dots_1358": (0x1002895, "\u2895"),
    "braille_dots_136": (0x1002825, "\u2825"),
    "braille_dots_1367": (0x1002865, "\u2865"),
    "braille_dots_13678": (0x10028E5, "\u28e5"),
    "braille_dots_1368": (0x10028A5, "\u28a5"),
    "braille_dots_137": (0x1002845, "\u2845"),
    "braille_dots_1378": (0x10028C5, "\u28c5"),
    "braille_dots_138": (0x1002885, "\u2885"),
    "braille_dots_14": (0x1002809, "\u2809"),
    "braille_dots_145": (0x1002819, "\u2819"),
    "braille_dots_1456": (0x1002839, "\u2839"),
    "braille_dots_14567": (0x1002879, "\u2879"),
    "braille_dots_145678": (0x10028F9, "\u28f9"),
    "braille_dots_14568": (0x10028B9, "\u28b9"),
    "braille_dots_1457": (0x1002859, "\u2859"),
    "braille_dots_14578": (0x10028D9, "\u28d9"),
    "braille_dots_1458": (0x1002899, "\u2899"),
    "braille_dots_146": (0x1002829, "\u2829"),
    "braille_dots_1467": (0x1002869, "\u2869"),
    "braille_dots_14678": (0x10028E9, "\u28e9"),
    "braille_dots_1468": (0x10028A9, "\u28a9"),
    "braille_dots_147": (0x1002849, "\u2849"),
    "braille_dots_1478": (0x10028C9, "\u28c9"),
    "braille_dots_148": (0x1002889, "\u2889"),
    "braille_dots_15": (0x1002811, "\u2811"),
    "braille_dots_156": (0x1002831, "\u2831"),
    "braille_dots_1567": (0x1002871, "\u2871"),
    "braille_dots_15678": (0x10028F1, "\u28f1"),
    "braille_dots_1568": (0x10028B1, "\u28b1"),
    "braille_dots_157": (0x1002851, "\u2851"),
    "braille_dots_1578": (0x10028D1, "\u28d1"),
    "braille_dots_158": (0x1002891, "\u2891"),
    "braille_dots_16": (0x1002821, "\u2821"),
    "braille_dots_167": (0x1002861, "\u2861"),
    "braille_dots_1678": (0x10028E1, "\u28e1"),
    "braille_dots_168": (0x10028A1, "\u28a1"),
    "braille_dots_17": (0x1002841, "\u2841"),
    "braille_dots_178": (0x10028C1, "\u28c1"),
    "braille_dots_18": (0x1002881, "\u2881"),
    "braille_dots_2": (0x1002802, "\u2802"),
    "braille_dots_23": (0x1002806, "\u2806"),
    "braille_dots_234": (0x100280E, "\u280e"),
    "braille_dots_2345": (0x100281E, "\u281e"),
    "braille_dots_23456": (0x100283E, "\u283e"),
    "braille_dots_234567": (0x100287E, "\u287e"),
    "braille_dots_2345678": (0x10028FE, "\u28fe"),
    "braille_dots_234568": (0x10028BE, "\u28be"),
    "braille_dots_23457": (0x100285E, "\u285e"),
    "braille_dots_234578": (0x10028DE, "\u28de"),
    "braille_dots_23458": (0x100289E, "\u289e"),
    "braille_dots_2346": (0x100282E, "\u282e"),
    "braille_dots_23467": (0x100286E, "\u286e"),
    "braille_dots_234678": (0x10028EE, "\u28ee"),
    "braille_dots_23468": (0x10028AE, "\u28ae"),
    "braille_dots_2347": (0x100284E, "\u284e"),
    "braille_dots_23478": (0x10028CE, "\u28ce"),
    "braille_dots_2348": (0x100288E, "\u288e"),
    "braille_dots_235": (0x1002816, "\u2816"),
    "braille_dots_2356": (0x1002836, "\u2836"),
    "braille_dots_23567": (0x1002876, "\u2876"),
    "braille_dots_235678": (0x10028F6, "\u28f6"),
    "braille_dots_23568": (0x10028B6, "\u28b6"),
    "braille_dots_2357": (0x1002856, "\u2856"),
    "braille_dots_23578": (0x10028D6, "\u28d6"),
    "braille_dots_2358": (0x1002896, "\u2896"),
    "braille_dots_236": (0x1002826, "\u2826"),
    "braille_dots_2367": (0x1002866, "\u2866"),
    "braille_dots_23678": (0x10028E6, "\u28e6"),
    "braille_dots_2368": (0x10028A6, "\u28a6"),
    "braille_dots_237": (0x1002846, "\u2846"),
    "braille_dots_2378": (0x10028C6, "\u28c6"),
    "braille_dots_238": (0x1002886, "\u2886"),
    "braille_dots_24": (0x100280A, "\u280a"),
    "braille_dots_245": (0x100281A, "\u281a"),
    "braille_dots_2456": (0x100283A, "\u283a"),
    "braille_dots_24567": (0x100287A, "\u287a"),
    "braille_dots_245678": (0x10028FA, "\u28fa"),
    "braille_dots_24568": (0x10028BA, "\u28ba"),
    "braille_dots_2457": (0x100285A, "\u285a"),
    "braille_dots_24578": (0x10028DA, "\u28da"),
    "braille_dots_2458": (0x100289A, "\u289a"),
    "braille_dots_246": (0x100282A, "\u282a"),
    "braille_dots_2467": (0x100286A, "\u286a"),
    "braille_dots_24678": (0x10028EA, "\u28ea"),
    "braille_dots_2468": (0x10028AA, "\u28aa"),
    "braille_dots_247": (0x100284A, "\u284a"),
    "braille_dots_2478": (0x10028CA, "\u28ca"),
    "braille_dots_248": (0x100288A, "\u288a"),
    "braille_dots_25": (0x1002812, "\u2812"),
    "braille_dots_256": (0x1002832, "\u2832"),
    "braille_dots_2567": (0x1002872, "\u2872"),
    "braille_dots_25678": (0x10028F2, "\u28f2"),
    "braille_dots_2568": (0x10028B2, "\u28b2"),
    "braille_dots_257": (0x1002852, "\u2852"),
    "braille_dots_2578": (0x10028D2, "\u28d2"),
    "braille_dots_258": (0x1002892, "\u2892"),
    "braille_dots_26": (0x1002822, "\u2822"),
    "braille_dots_267": (0x1002862, "\u2862"),
    "braille_dots_2678": (0x10028E2, "\u28e2"),
    "braille_dots_268": (0x10028A2, "\u28a2"),
    "braille_dots_27": (0x1002842, "\u2842"),
    "braille_dots_278": (0x10028C2, "\u28c2"),
    "braille_dots_28": (0x1002882, "\u2882"),
    "braille_dots_3": (0x1002804, "\u2804"),
    "braille_dots_34": (0x100280C, "\u280c"),
    "braille_dots_345": (0x100281C, "\u281c"),
    "braille_dots_3456": (0x100283C, "\u283c"),
    "braille_dots_34567": (0x100287C, "\u287c"),
    "braille_dots_345678": (0x10028FC, "\u28fc"),
    "braille_dots_34568": (0x10028BC, "\u28bc"),
    "braille_dots_3457": (0x100285C, "\u285c"),
    "braille_dots_34578": (0x10028DC, "\u28dc"),
    "braille_dots_3458": (0x100289C, "\u289c"),
    "braille_dots_346": (0x100282C, "\u282c"),
    "braille_dots_3467": (0x100286C, "\u286c"),
    "braille_dots_34678": (0x10028EC, "\u28ec"),
    "braille_dots_3468": (0x10028AC, "\u28ac"),
    "braille_dots_347": (0x100284C, "\u284c"),
    "braille_dots_3478": (0x10028CC, "\u28cc"),
    "braille_dots_348": (0x100288C, "\u288c"),
    "braille_dots_35": (0x1002814, "\u2814"),
    "braille_dots_356": (0x1002834, "\u2834"),
    "braille_dots_3567": (0x1002874, "\u2874"),
    "braille_dots_35678": (0x10028F4, "\u28f4"),
    "braille_dots_3568": (0x10028B4, "\u28b4"),
    "braille_dots_357": (0x1002854, "\u2854"),
    "braille_dots_3578": (0x10028D4, "\u28d4"),
    "braille_dots_358": (0x1002894, "\u2894"),
    "braille_dots_36": (0x1002824, "\u2824"),
    "braille_dots_367": (0x1002864, "\u2864"),
    "braille_dots_3678": (0x10028E4, "\u28e4"),
    "braille_dots_368": (0x10028A4, "\u28a4"),
    "braille_dots_37": (0x1002844, "\u2844"),
    "braille_dots_378": (0x10028C4, "\u28c4"),
    "braille_dots_38": (0x1002884, "\u2884"),
    "braille_dots_4": (0x1002808, "\u2808"),
    "braille_dots_45": (0x1002818, "\u2818"),
    "braille_dots_456": (0x1002838, "\u2838"),
    "braille_dots_4567": (0x1002878, "\u2878"),
    "braille_dots_45678": (0x10028F8, "\u28f8"),
    "braille_dots_4568": (0x10028B8, "\u28b8"),
    "braille_dots_457": (0x1002858, "\u2858"),
    "braille_dots_4578": (0x10028D8, "\u28d8"),
    "braille_dots_458": (0x1002898, "\u2898"),
    "braille_dots_46": (0x1002828, "\u2828"),
    "braille_dots_467": (0x1002868, "\u2868"),
    "braille_dots_4678": (0x10028E8, "\u28e8"),
    "braille_dots_468": (0x10028A8, "\u28a8"),
    "braille_dots_47": (0x1002848, "\u2848"),
    "braille_dots_478": (0x10028C8, "\u28c8"),
    "braille_dots_48": (0x1002888, "\u2888"),
    "braille_dots_5": (0x1002810, "\u2810"),
    "braille_dots_56": (0x1002830, "\u2830"),
    "braille_dots_567": (0x1002870, "\u2870"),
    "braille_dots_5678": (0x10028F0, "\u28f0"),
    "braille_dots_568": (0x10028B0, "\u28b0"),
    "braille_dots_57": (0x1002850, "\u2850"),
    "braille_dots_578": (0x10028D0, "\u28d0"),
    "braille_dots_58": (0x1002890, "\u2890"),
    "braille_dots_6": (0x1002820, "\u2820"),
    "braille_dots_67": (0x1002860, "\u2860"),
    "braille_dots_678": (0x10028E0, "\u28e0"),
    "braille_dots_68": (0x10028A0, "\u28a0"),
    "braille_dots_7": (0x1002840, "\u2840"),
    "braille_dots_78": (0x10028C0, "\u28c0"),
    "braille_dots_8": (0x1002880, "\u2880"),
    "breve": (0x01A2, "\u02D8"),
    "brokenbar": (0x00A6, "\u00A6"),
    "c": (0x0063, "\u0063"),
    "cabovedot": (0x02E5, "\u010B"),
    "cacute": (0x01E6, "\u0107"),
    "careof": (0x0AB8, "\u2105"),
    "caret": (0x0AFC, "\u2038"),
    "caron": (0x01B7, "\u02C7"),
    "ccaron": (0x01E8, "\u010D"),
    "ccedilla": (0x00E7, "\u00E7"),
    "ccircumflex": (0x02E6, "\u0109"),
    "cedilla": (0x00B8, "\u00B8"),
    "cent": (0x00A2, "\u00A2"),
    "checkerboard": (0x09E1, "\u2592"),
    "checkmark": (0x0AF3, "\u2713"),
    "circle": (0x0BCF, "\u25CB"),
    "club": (0x0AEC, "\u2663"),
    "colon": (0x003A, "\u003A"),
    "comma": (0x002C, "\u002C"),
    "containsas": (0x100220B, "\u220B"),
    "copyright": (0x00A9, "\u00A9"),
    "cr": (0x09E4, "\u240D"),
    "crossinglines": (0x09EE, "\u253C"),
    "cuberoot": (0x100221B, "\u221B"),
    "currency": (0x00A4, "\u00A4"),
    "d": (0x0064, "\u0064"),
    "dabovedot": (0x1001E0B, "\u1E0B"),
    "dagger": (0x0AF1, "\u2020"),
    "dcaron": (0x01EF, "\u010F"),
    "dead_A": (0xFE81, None),
    "dead_E": (0xFE83, None),
    "dead_I": (0xFE85, None),
    "dead_O": (0xFE87, None),
    "dead_U": (0xFE89, None),
    "dead_a": (0xFE80, None),
    "dead_abovecomma": (0xFE64, "\u0315"),
    "dead_abovedot": (0xFE56, "\u0307"),
    "dead_abovereversedcomma": (0xFE65, "\u0312"),
    "dead_abovering": (0xFE58, "\u030A"),
    "dead_aboveverticalline": (0xFE91, "\u030D"),
    "dead_acute": (0xFE51, "\u0301"),
    "dead_belowbreve": (0xFE6B, "\u032E"),
    "dead_belowcircumflex": (0xFE69, "\u032D"),
    "dead_belowcomma": (0xFE6E, "\u0326"),
    "dead_belowdiaeresis": (0xFE6C, "\u0324"),
    "dead_belowdot": (0xFE60, "\u0323"),
    "dead_belowmacron": (0xFE68, "\u0331"),
    "dead_belowring": (0xFE67, "\u0325"),
    "dead_belowtilde": (0xFE6A, "\u0330"),
    "dead_belowverticalline": (0xFE92, "\u0329"),
    "dead_breve": (0xFE55, "\u0306"),
    "dead_capital_schwa": (0xFE8B, None),
    "dead_caron": (0xFE5A, "\u030C"),
    "dead_cedilla": (0xFE5B, "\u0327"),
    "dead_circumflex": (0xFE52, "\u0302"),
    "dead_currency": (0xFE6F, None),
    "dead_diaeresis": (0xFE57, "\u0308"),
    "dead_doubleacute": (0xFE59, "\u030B"),
    "dead_doublegrave": (0xFE66, "\u030F"),
    "dead_e": (0xFE82, None),
    "dead_grave": (0xFE50, "\u0300"),
    "dead_greek": (0xFE8C, None),
    "dead_hook": (0xFE61, "\u0309"),
    "dead_horn": (0xFE62, "\u031B"),
    "dead_i": (0xFE84, None),
    "dead_invertedbreve": (0xFE6D, "\u032F"),
    "dead_iota": (0xFE5D, "\u0345"),
    "dead_longsolidusoverlay": (0xFE93, "\u0338"),
    "dead_lowline": (0xFE90, "\u0332"),
    "dead_macron": (0xFE54, "\u0304"),
    "dead_o": (0xFE86, None),
    "dead_ogonek": (0xFE5C, "\u0328"),
    "dead_semivoiced_sound": (0xFE5F, None),
    "dead_small_schwa": (0xFE8A, None),
    "dead_stroke": (0xFE63, "\u0335"),
    "dead_tilde": (0xFE53, "\u0303"),
    "dead_u": (0xFE88, None),
    "dead_voiced_sound": (0xFE5E, None),
    "degree": (0x00B0, "\u00B0"),
    "diaeresis": (0x00A8, "\u00A8"),
    "diamond": (0x0AED, "\u2666"),
    "digitspace": (0x0AA5, "\u2007"),
    "dintegral": (0x100222C, "\u222C"),
    "division": (0x00F7, "\u00F7"),
    "dollar": (0x0024, "\u0024"),
    "doubbaselinedot": (0x0AAF, "\u2025"),
    "doubleacute": (0x01BD, "\u02DD"),
    "doubledagger": (0x0AF2, "\u2021"),
    "doublelowquotemark": (0x0AFE, "\u201E"),
    "downarrow": (0x08FE, "\u2193"),
    "downstile": (0x0BC4, "\u230A"),
    "downtack": (0x0BC2, "\u22A4"),
    "dstroke": (0x01F0, "\u0111"),
    "e": (0x0065, "\u0065"),
    "eabovedot": (0x03EC, "\u0117"),
    "eacute": (0x00E9, "\u00E9"),
    "ebelowdot": (0x1001EB9, "\u1EB9"),
    "ecaron": (0x01EC, "\u011B"),
    "ecircumflex": (0x00EA, "\u00EA"),
    "ecircumflexacute": (0x1001EBF, "\u1EBF"),
    "ecircumflexbelowdot": (0x1001EC7, "\u1EC7"),
    "ecircumflexgrave": (0x1001EC1, "\u1EC1"),
    "ecircumflexhook": (0x1001EC3, "\u1EC3"),
    "ecircumflextilde": (0x1001EC5, "\u1EC5"),
    "ediaeresis": (0x00EB, "\u00EB"),
    "egrave": (0x00E8, "\u00E8"),
    "ehook": (0x1001EBB, "\u1EBB"),
    "eightsubscript": (0x1002088, "\u2088"),
    "eightsuperior": (0x1002078, "\u2078"),
    "elementof": (0x1002208, "\u2208"),
    "ellipsis": (0x0AAE, "\u2026"),
    "em3space": (0x0AA3, "\u2004"),
    "em4space": (0x0AA4, "\u2005"),
    "emacron": (0x03BA, "\u0113"),
    "emdash": (0x0AA9, "\u2014"),
    "emptyset": (0x1002205, "\u2205"),
    "emspace": (0x0AA1, "\u2003"),
    "endash": (0x0AAA, "\u2013"),
    "eng": (0x03BF, "\u014B"),
    "enspace": (0x0AA2, "\u2002"),
    "eogonek": (0x01EA, "\u0119"),
    "equal": (0x003D, "\u003D"),
    "eth": (0x00F0, "\u00F0"),
    "etilde": (0x1001EBD, "\u1EBD"),
    "exclam": (0x0021, "\u0021"),
    "exclamdown": (0x00A1, "\u00A1"),
    "ezh": (0x1000292, "\u0292"),
    "f": (0x0066, "\u0066"),
    "fabovedot": (0x1001E1F, "\u1E1F"),
    "femalesymbol": (0x0AF8, "\u2640"),
    "ff": (0x09E3, "\u240C"),
    "figdash": (0x0ABB, "\u2012"),
    "fiveeighths": (0x0AC5, "\u215D"),
    "fivesixths": (0x0AB7, "\u215A"),
    "fivesubscript": (0x1002085, "\u2085"),
    "fivesuperior": (0x1002075, "\u2075"),
    "fourfifths": (0x0AB5, "\u2158"),
    "foursubscript": (0x1002084, "\u2084"),
    "foursuperior": (0x1002074, "\u2074"),
    "fourthroot": (0x100221C, "\u221C"),
    "function": (0x08F6, "\u0192"),
    "g": (0x0067, "\u0067"),
    "gabovedot": (0x02F5, "\u0121"),
    "gbreve": (0x02BB, "\u011F"),
    "gcaron": (0x10001E7, "\u01E7"),
    "gcedilla": (0x03BB, "\u0123"),
    "gcircumflex": (0x02F8, "\u011D"),
    "grave": (0x0060, "\u0060"),
    "greater": (0x003E, "\u003E"),
    "greaterthanequal": (0x08BE, "\u2265"),
    "guillemotleft": (0x00AB, "\u00AB"),
    "guillemotright": (0x00BB, "\u00BB"),
    "h": (0x0068, "\u0068"),
    "hairspace": (0x0AA8, "\u200A"),
    "hcircumflex": (0x02B6, "\u0125"),
    "heart": (0x0AEE, "\u2665"),
    "hebrew_aleph": (0x0CE0, "\u05D0"),
    "hebrew_ayin": (0x0CF2, "\u05E2"),
    "hebrew_bet": (0x0CE1, "\u05D1"),
    "hebrew_chet": (0x0CE7, "\u05D7"),
    "hebrew_dalet": (0x0CE3, "\u05D3"),
    "hebrew_doublelowline": (0x0CDF, "\u2017"),
    "hebrew_finalkaph": (0x0CEA, "\u05DA"),
    "hebrew_finalmem": (0x0CED, "\u05DD"),
    "hebrew_finalnun": (0x0CEF, "\u05DF"),
    "hebrew_finalpe": (0x0CF3, "\u05E3"),
    "hebrew_finalzade": (0x0CF5, "\u05E5"),
    "hebrew_gimel": (0x0CE2, "\u05D2"),
    "hebrew_he": (0x0CE4, "\u05D4"),
    "hebrew_kaph": (0x0CEB, "\u05DB"),
    "hebrew_lamed": (0x0CEC, "\u05DC"),
    "hebrew_mem": (0x0CEE, "\u05DE"),
    "hebrew_nun": (0x0CF0, "\u05E0"),
    "hebrew_pe": (0x0CF4, "\u05E4"),
    "hebrew_qoph": (0x0CF7, "\u05E7"),
    "hebrew_resh": (0x0CF8, "\u05E8"),
    "hebrew_samech": (0x0CF1, "\u05E1"),
    "hebrew_shin": (0x0CF9, "\u05E9"),
    "hebrew_taw": (0x0CFA, "\u05EA"),
    "hebrew_tet": (0x0CE8, "\u05D8"),
    "hebrew_waw": (0x0CE5, "\u05D5"),
    "hebrew_yod": (0x0CE9, "\u05D9"),
    "hebrew_zade": (0x0CF6, "\u05E6"),
    "hebrew_zain": (0x0CE6, "\u05D6"),
    "horizlinescan1": (0x09EF, "\u23BA"),
    "horizlinescan3": (0x09F0, "\u23BB"),
    "horizlinescan5": (0x09F1, "\u2500"),
    "horizlinescan7": (0x09F2, "\u23BC"),
    "horizlinescan9": (0x09F3, "\u23BD"),
    "hstroke": (0x02B1, "\u0127"),
    "ht": (0x09E2, "\u2409"),
    "hyphen": (0x00AD, "\u00AD"),
    "i": (0x0069, "\u0069"),
    "iacute": (0x00ED, "\u00ED"),
    "ibelowdot": (0x1001ECB, "\u1ECB"),
    "ibreve": (0x100012D, "\u012D"),
    "icircumflex": (0x00EE, "\u00EE"),
    "identical": (0x08CF, "\u2261"),
    "idiaeresis": (0x00EF, "\u00EF"),
    "idotless": (0x02B9, "\u0131"),
    "ifonlyif": (0x08CD, "\u21D4"),
    "igrave": (0x00EC, "\u00EC"),
    "ihook": (0x1001EC9, "\u1EC9"),
    "imacron": (0x03EF, "\u012B"),
    "implies": (0x08CE, "\u21D2"),
    "includedin": (0x08DA, "\u2282"),
    "includes": (0x08DB, "\u2283"),
    "infinity": (0x08C2, "\u221E"),
    "integral": (0x08BF, "\u222B"),
    "intersection": (0x08DC, "\u2229"),
    "iogonek": (0x03E7, "\u012F"),
    "itilde": (0x03B5, "\u0129"),
    "j": (0x006A, "\u006A"),
    "jcircumflex": (0x02BC, "\u0135"),
    "jot": (0x0BCA, "\u2218"),
    "k": (0x006B, "\u006B"),
    "kana_A": (0x04B1, "\u30A2"),
    "kana_CHI": (0x04C1, "\u30C1"),
    "kana_E": (0x04B4, "\u30A8"),
    "kana_FU": (0x04CC, "\u30D5"),
    "kana_HA": (0x04CA, "\u30CF"),
    "kana_HE": (0x04CD, "\u30D8"),
    "kana_HI": (0x04CB, "\u30D2"),
    "kana_HO": (0x04CE, "\u30DB"),
    "kana_I": (0x04B2, "\u30A4"),
    "kana_KA": (0x04B6, "\u30AB"),
    "kana_KE": (0x04B9, "\u30B1"),
    "kana_KI": (0x04B7, "\u30AD"),
    "kana_KO": (0x04BA, "\u30B3"),
    "kana_KU": (0x04B8, "\u30AF"),
    "kana_MA": (0x04CF, "\u30DE"),
    "kana_ME": (0x04D2, "\u30E1"),
    "kana_MI": (0x04D0, "\u30DF"),
    "kana_MO": (0x04D3, "\u30E2"),
    "kana_MU": (0x04D1, "\u30E0"),
    "kana_N": (0x04DD, "\u30F3"),
    "kana_NA": (0x04C5, "\u30CA"),
    "kana_NE": (0x04C8, "\u30CD"),
    "kana_NI": (0x04C6, "\u30CB"),
    "kana_NO": (0x04C9, "\u30CE"),
    "kana_NU": (0x04C7, "\u30CC"),
    "kana_O": (0x04B5, "\u30AA"),
    "kana_RA": (0x04D7, "\u30E9"),
    "kana_RE": (0x04DA, "\u30EC"),
    "kana_RI": (0x04D8, "\u30EA"),
    "kana_RO": (0x04DB, "\u30ED"),
    "kana_RU": (0x04D9, "\u30EB"),
    "kana_SA": (0x04BB, "\u30B5"),
    "kana_SE": (0x04BE, "\u30BB"),
    "kana_SHI": (0x04BC, "\u30B7"),
    "kana_SO": (0x04BF, "\u30BD"),
    "kana_SU": (0x04BD, "\u30B9"),
    "kana_TA": (0x04C0, "\u30BF"),
    "kana_TE": (0x04C3, "\u30C6"),
    "kana_TO": (0x04C4, "\u30C8"),
    "kana_TSU": (0x04C2, "\u30C4"),
    "kana_U": (0x04B3, "\u30A6"),
    "kana_WA": (0x04DC, "\u30EF"),
    "kana_WO": (0x04A6, "\u30F2"),
    "kana_YA": (0x04D4, "\u30E4"),
    "kana_YO": (0x04D6, "\u30E8"),
    "kana_YU": (0x04D5, "\u30E6"),
    "kana_a": (0x04A7, "\u30A1"),
    "kana_closingbracket": (0x04A3, "\u300D"),
    "kana_comma": (0x04A4, "\u3001"),
    "kana_conjunctive": (0x04A5, "\u30FB"),
    "kana_e": (0x04AA, "\u30A7"),
    "kana_fullstop": (0x04A1, "\u3002"),
    "kana_i": (0x04A8, "\u30A3"),
    "kana_o": (0x04AB, "\u30A9"),
    "kana_openingbracket": (0x04A2, "\u300C"),
    "kana_tsu": (0x04AF, "\u30C3"),
    "kana_u": (0x04A9, "\u30A5"),
    "kana_ya": (0x04AC, "\u30E3"),
    "kana_yo": (0x04AE, "\u30E7"),
    "kana_yu": (0x04AD, "\u30E5"),
    "kcedilla": (0x03F3, "\u0137"),
    "kra": (0x03A2, "\u0138"),
    "l": (0x006C, "\u006C"),
    "lacute": (0x01E5, "\u013A"),
    "latincross": (0x0AD9, "\u271D"),
    "lbelowdot": (0x1001E37, "\u1E37"),
    "lcaron": (0x01B5, "\u013E"),
    "lcedilla": (0x03B6, "\u013C"),
    "leftarrow": (0x08FB, "\u2190"),
    "leftdoublequotemark": (0x0AD2, "\u201C"),
    "leftmiddlecurlybrace": (0x08AF, "\u23A8"),
    "leftradical": (0x08A1, "\u23B7"),
    "leftsinglequotemark": (0x0AD0, "\u2018"),
    "leftt": (0x09F4, "\u251C"),
    "lefttack": (0x0BDC, "\u22A3"),
    "less": (0x003C, "\u003C"),
    "lessthanequal": (0x08BC, "\u2264"),
    "lf": (0x09E5, "\u240A"),
    "logicaland": (0x08DE, "\u2227"),
    "logicalor": (0x08DF, "\u2228"),
    "lowleftcorner": (0x09ED, "\u2514"),
    "lowrightcorner": (0x09EA, "\u2518"),
    "lstroke": (0x01B3, "\u0142"),
    "m": (0x006D, "\u006D"),
    "mabovedot": (0x1001E41, "\u1E41"),
    "macron": (0x00AF, "\u00AF"),
    "malesymbol": (0x0AF7, "\u2642"),
    "maltesecross": (0x0AF0, "\u2720"),
    "masculine": (0x00BA, "\u00BA"),
    "minus": (0x002D, "\u002D"),
    "minutes": (0x0AD6, "\u2032"),
    "mu": (0x00B5, "\u00B5"),
    "multiply": (0x00D7, "\u00D7"),
    "musicalflat": (0x0AF6, "\u266D"),
    "musicalsharp": (0x0AF5, "\u266F"),
    "n": (0x006E, "\u006E"),
    "nabla": (0x08C5, "\u2207"),
    "nacute": (0x01F1, "\u0144"),
    "ncaron": (0x01F2, "\u0148"),
    "ncedilla": (0x03F1, "\u0146"),
    "ninesubscript": (0x1002089, "\u2089"),
    "ninesuperior": (0x1002079, "\u2079"),
    "nl": (0x09E8, "\u2424"),
    "nobreakspace": (0x00A0, "\u00A0"),
    "notapproxeq": (0x1002247, "\u2247"),
    "notelementof": (0x1002209, "\u2209"),
    "notequal": (0x08BD, "\u2260"),
    "notidentical": (0x1002262, "\u2262"),
    "notsign": (0x00AC, "\u00AC"),
    "ntilde": (0x00F1, "\u00F1"),
    "numbersign": (0x0023, "\u0023"),
    "numerosign": (0x06B0, "\u2116"),
    "o": (0x006F, "\u006F"),
    "oacute": (0x00F3, "\u00F3"),
    "obarred": (0x1000275, "\u0275"),
    "obelowdot": (0x1001ECD, "\u1ECD"),
    "ocaron": (0x10001D2, "\u01D2"),
    "ocircumflex": (0x00F4, "\u00F4"),
    "ocircumflexacute": (0x1001ED1, "\u1ED1"),
    "ocircumflexbelowdot": (0x1001ED9, "\u1ED9"),
    "ocircumflexgrave": (0x1001ED3, "\u1ED3"),
    "ocircumflexhook": (0x1001ED5, "\u1ED5"),
    "ocircumflextilde": (0x1001ED7, "\u1ED7"),
    "odiaeresis": (0x00F6, "\u00F6"),
    "odoubleacute": (0x01F5, "\u0151"),
    "oe": (0x13BD, "\u0153"),
    "ogonek": (0x01B2, "\u02DB"),
    "ograve": (0x00F2, "\u00F2"),
    "ohook": (0x1001ECF, "\u1ECF"),
    "ohorn": (0x10001A1, "\u01A1"),
    "ohornacute": (0x1001EDB, "\u1EDB"),
    "ohornbelowdot": (0x1001EE3, "\u1EE3"),
    "ohorngrave": (0x1001EDD, "\u1EDD"),
    "ohornhook": (0x1001EDF, "\u1EDF"),
    "ohorntilde": (0x1001EE1, "\u1EE1"),
    "omacron": (0x03F2, "\u014D"),
    "oneeighth": (0x0AC3, "\u215B"),
    "onefifth": (0x0AB2, "\u2155"),
    "onehalf": (0x00BD, "\u00BD"),
    "onequarter": (0x00BC, "\u00BC"),
    "onesixth": (0x0AB6, "\u2159"),
    "onesubscript": (0x1002081, "\u2081"),
    "onesuperior": (0x00B9, "\u00B9"),
    "onethird": (0x0AB0, "\u2153"),
    "ooblique": (0x00F8, "\u00F8"),
    "ordfeminine": (0x00AA, "\u00AA"),
    "oslash": (0x00F8, "\u00F8"),
    "otilde": (0x00F5, "\u00F5"),
    "overline": (0x047E, "\u203E"),
    "p": (0x0070, "\u0070"),
    "pabovedot": (0x1001E57, "\u1E57"),
    "paragraph": (0x00B6, "\u00B6"),
    "parenleft": (0x0028, "\u0028"),
    "parenright": (0x0029, "\u0029"),
    "partdifferential": (0x1002202, "\u2202"),
    "partialderivative": (0x08EF, "\u2202"),
    "percent": (0x0025, "\u0025"),
    "period": (0x002E, "\u002E"),
    "periodcentered": (0x00B7, "\u00B7"),
    "permille": (0x0AD5, "\u2030"),
    "phonographcopyright": (0x0AFB, "\u2117"),
    "plus": (0x002B, "\u002B"),
    "plusminus": (0x00B1, "\u00B1"),
    "prescription": (0x0AD4, "\u211E"),
    "prolongedsound": (0x04B0, "\u30FC"),
    "punctspace": (0x0AA6, "\u2008"),
    "q": (0x0071, "\u0071"),
    "quad": (0x0BCC, "\u2395"),
    "question": (0x003F, "\u003F"),
    "questiondown": (0x00BF, "\u00BF"),
    "quotedbl": (0x0022, "\u0022"),
    "r": (0x0072, "\u0072"),
    "racute": (0x01E0, "\u0155"),
    "radical": (0x08D6, "\u221A"),
    "rcaron": (0x01F8, "\u0159"),
    "rcedilla": (0x03B3, "\u0157"),
    "registered": (0x00AE, "\u00AE"),
    "rightarrow": (0x08FD, "\u2192"),
    "rightdoublequotemark": (0x0AD3, "\u201D"),
    "rightmiddlecurlybrace": (0x08B0, "\u23AC"),
    "rightsinglequotemark": (0x0AD1, "\u2019"),
    "rightt": (0x09F5, "\u2524"),
    "righttack": (0x0BFC, "\u22A2"),
    "s": (0x0073, "\u0073"),
    "sabovedot": (0x1001E61, "\u1E61"),
    "sacute": (0x01B6, "\u015B"),
    "scaron": (0x01B9, "\u0161"),
    "scedilla": (0x01BA, "\u015F"),
    "schwa": (0x1000259, "\u0259"),
    "scircumflex": (0x02FE, "\u015D"),
    "seconds": (0x0AD7, "\u2033"),
    "section": (0x00A7, "\u00A7"),
    "semicolon": (0x003B, "\u003B"),
    "semivoicedsound": (0x04DF, "\u309C"),
    "seveneighths": (0x0AC6, "\u215E"),
    "sevensubscript": (0x1002087, "\u2087"),
    "sevensuperior": (0x1002077, "\u2077"),
    "similarequal": (0x08C9, "\u2243"),
    "singlelowquotemark": (0x0AFD, "\u201A"),
    "sixsubscript": (0x1002086, "\u2086"),
    "sixsuperior": (0x1002076, "\u2076"),
    "slash": (0x002F, "\u002F"),
    "soliddiamond": (0x09E0, "\u25C6"),
    "space": (0x0020, "\u0020"),
    "squareroot": (0x100221A, "\u221A"),
    "ssharp": (0x00DF, "\u00DF"),
    "sterling": (0x00A3, "\u00A3"),
    "stricteq": (0x1002263, "\u2263"),
    "t": (0x0074, "\u0074"),
    "tabovedot": (0x1001E6B, "\u1E6B"),
    "tcaron": (0x01BB, "\u0165"),
    "tcedilla": (0x01FE, "\u0163"),
    "telephone": (0x0AF9, "\u260E"),
    "telephonerecorder": (0x0AFA, "\u2315"),
    "therefore": (0x08C0, "\u2234"),
    "thinspace": (0x0AA7, "\u2009"),
    "thorn": (0x00FE, "\u00FE"),
    "threeeighths": (0x0AC4, "\u215C"),
    "threefifths": (0x0AB4, "\u2157"),
    "threequarters": (0x00BE, "\u00BE"),
    "threesubscript": (0x1002083, "\u2083"),
    "threesuperior": (0x00B3, "\u00B3"),
    "tintegral": (0x100222D, "\u222D"),
    "topintegral": (0x08A4, "\u2320"),
    "topleftparens": (0x08AB, "\u239B"),
    "topleftsqbracket": (0x08A7, "\u23A1"),
    "toprightparens": (0x08AD, "\u239E"),
    "toprightsqbracket": (0x08A9, "\u23A4"),
    "topt": (0x09F7, "\u252C"),
    "trademark": (0x0AC9, "\u2122"),
    "tslash": (0x03BC, "\u0167"),
    "twofifths": (0x0AB3, "\u2156"),
    "twosubscript": (0x1002082, "\u2082"),
    "twosuperior": (0x00B2, "\u00B2"),
    "twothirds": (0x0AB1, "\u2154"),
    "u": (0x0075, "\u0075"),
    "uacute": (0x00FA, "\u00FA"),
    "ubelowdot": (0x1001EE5, "\u1EE5"),
    "ubreve": (0x02FD, "\u016D"),
    "ucircumflex": (0x00FB, "\u00FB"),
    "udiaeresis": (0x00FC, "\u00FC"),
    "udoubleacute": (0x01FB, "\u0171"),
    "ugrave": (0x00F9, "\u00F9"),
    "uhook": (0x1001EE7, "\u1EE7"),
    "uhorn": (0x10001B0, "\u01B0"),
    "uhornacute": (0x1001EE9, "\u1EE9"),
    "uhornbelowdot": (0x1001EF1, "\u1EF1"),
    "uhorngrave": (0x1001EEB, "\u1EEB"),
    "uhornhook": (0x1001EED, "\u1EED"),
    "uhorntilde": (0x1001EEF, "\u1EEF"),
    "umacron": (0x03FE, "\u016B"),
    "underscore": (0x005F, "\u005F"),
    "union": (0x08DD, "\u222A"),
    "uogonek": (0x03F9, "\u0173"),
    "uparrow": (0x08FC, "\u2191"),
    "upleftcorner": (0x09EC, "\u250C"),
    "uprightcorner": (0x09EB, "\u2510"),
    "upstile": (0x0BD3, "\u2308"),
    "uptack": (0x0BCE, "\u22A5"),
    "uring": (0x01F9, "\u016F"),
    "utilde": (0x03FD, "\u0169"),
    "v": (0x0076, "\u0076"),
    "variation": (0x08C1, "\u221D"),
    "vertbar": (0x09F8, "\u2502"),
    "voicedsound": (0x04DE, "\u309B"),
    "vt": (0x09E9, "\u240B"),
    "w": (0x0077, "\u0077"),
    "wacute": (0x1001E83, "\u1E83"),
    "wcircumflex": (0x1000175, "\u0175"),
    "wdiaeresis": (0x1001E85, "\u1E85"),
    "wgrave": (0x1001E81, "\u1E81"),
    "x": (0x0078, "\u0078"),
    "xabovedot": (0x1001E8B, "\u1E8B"),
    "y": (0x0079, "\u0079"),
    "yacute": (0x00FD, "\u00FD"),
    "ybelowdot": (0x1001EF5, "\u1EF5"),
    "ycircumflex": (0x1000177, "\u0177"),
    "ydiaeresis": (0x00FF, "\u00FF"),
    "yen": (0x00A5, "\u00A5"),
    "ygrave": (0x1001EF3, "\u1EF3"),
    "yhook": (0x1001EF7, "\u1EF7"),
    "ytilde": (0x1001EF9, "\u1EF9"),
    "z": (0x007A, "\u007A"),
    "zabovedot": (0x01BF, "\u017C"),
    "zacute": (0x01BC, "\u017A"),
    "zcaron": (0x01BE, "\u017E"),
    "zerosubscript": (0x1002080, "\u2080"),
    "zerosuperior": (0x1002070, "\u2070"),
    "zstroke": (0x10001B6, "\u01B6"),
}

DEAD_KEYS = {
    "\u0307": "\u02D9",
    "\u030A": "\u02DA",
    "\u0301": "\u00B4",
    "\u0306": "\u02D8",
    "\u030C": "\u02C7",
    "\u0327": "\u00B8",
    "\u0302": "\u005E",
    "\u0308": "\u00A8",
    "\u030B": "\u02DD",
    "\u0300": "\u0060",
    "\u0345": "\u037A",
    "\u0332": "\u005F",
    "\u0304": "\u00AF",
    "\u0328": "\u02DB",
    "\u0303": "\u007E",
}

KEYPAD_KEYS = {
    "KP_0": 0xFFB0,
    "KP_1": 0xFFB1,
    "KP_2": 0xFFB2,
    "KP_3": 0xFFB3,
    "KP_4": 0xFFB4,
    "KP_5": 0xFFB5,
    "KP_6": 0xFFB6,
    "KP_7": 0xFFB7,
    "KP_8": 0xFFB8,
    "KP_9": 0xFFB9,
    "KP_Add": 0xFFAB,
    "KP_Begin": 0xFF9D,
    "KP_Decimal": 0xFFAE,
    "KP_Delete": 0xFF9F,
    "KP_Divide": 0xFFAF,
    "KP_Down": 0xFF99,
    "KP_End": 0xFF9C,
    "KP_Enter": 0xFF8D,
    "KP_Equal": 0xFFBD,
    "KP_F1": 0xFF91,
    "KP_F2": 0xFF92,
    "KP_F3": 0xFF93,
    "KP_F4": 0xFF94,
    "KP_Home": 0xFF95,
    "KP_Insert": 0xFF9E,
    "KP_Left": 0xFF96,
    "KP_Multiply": 0xFFAA,
    "KP_Next": 0xFF9B,
    "KP_Page_Down": 0xFF9B,
    "KP_Page_Up": 0xFF9A,
    "KP_Prior": 0xFF9A,
    "KP_Right": 0xFF98,
    "KP_Separator": 0xFFAC,
    "KP_Space": 0xFF80,
    "KP_Subtract": 0xFFAD,
    "KP_Tab": 0xFF89,
    "KP_Up": 0xFF97,
}

CHARS = {codepoint: name for name, (keysym, codepoint) in SYMBOLS.items() if codepoint}

KEYSYMS = {keysym: name for name, (keysym, codepoint) in SYMBOLS.items() if codepoint}
