
#################### selected genomes ####################

s1	GCF_001708465	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_E;s__Pseudomonas_E fluorescens_AN
s2	GCF_002072675	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_E;s__Pseudomonas_E tolaasii
s3	GCA_000397205	5	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_E;s__Pseudomonas_E protegens
s4	GCA_000761155	6	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_E;s__Pseudomonas_E rhizosphaerae
s5	GCA_000026105	7	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_E;s__Pseudomonas_E entomophila

g1	GCF_000148745	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas;s__Pseudomonas aeruginosa
g2	GCF_000756775	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_A;s__Pseudomonas_A saudiphocaensis
g3	GCA_002355475	5	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Pseudomonas_F;s__Pseudomonas_F furukawaii
g4	GCA_001267175	5	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Oblitimonas;s__Oblitimonas alkaliphila
g5	GCF_000380335	6	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Pseudomonadaceae;g__Azotobacter;s__Azotobacter vinelandii

f1	GCF_000831005	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Oleiphilaceae;g__Marinobacter;s__Marinobacter salarius
f2	GCA_000307975	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Moraxellaceae;g__Acinetobacter;s__Acinetobacter baumannii
f3	GCA_002117105	2	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Spongiibacteraceae;g__Oceanicoccus;s__Oceanicoccus sagamiensis	
f4	GCA_000009365	3	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Alcanivoracaceae;g__Alcanivorax;s__Alcanivorax borkumensis
f5	GCA_000196875	4	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Pseudomonadales;f__Halomonadaceae;g__Halomonas;s__Halomonas elongata	

o1	GCF_000485905	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Nitrococcales;f__Nitrococcaceae;g__Spiribacter;s__Spiribacter curvatus
o2	GCF_002028405	1	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Burkholderiales;f__Burkholderiaceae;g__Thiomonas;s__Thiomonas intermedia
o3	GCF_000953135	4	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Legionellales;f__Legionellaceae;g__Legionella;s__Legionella fallonii	
o4	GCF_000300295	6	d__Bacteria;p__Proteobacteria;c__Gammaproteobacteria;o__Piscirickettsiales;f__Piscirickettsiaceae;g__Piscirickettsia;s__Piscirickettsia salmonis
o5	GCF_000347635	6	d__Bacteria; p__Proteobacteria; c__Gammaproteobacteria; o__Enterobacterales; f__Alteromonadaceae; g__Paraglaciecola; s__Paraglaciecola psychrophila

c1	GCF_002795825	1	d__Bacteria;p__Proteobacteria;c__Zetaproteobacteria;o__Mariprofundales;f__Mariprofundaceae;g__Mariprofundus;s__Mariprofundus ferrinatatus		
c2	GCF_002080435	2	d__Bacteria;p__Proteobacteria;c__Alphaproteobacteria;o__Sphingomonadales;f__Sphingomonadaceae;g__Sphingobium;s__Sphingobium herbicidovorans
c3	GCF_000014865	3	d__Bacteria;p__Proteobacteria;c__Magnetococcia;o__Magnetococcales;f__Magnetococcaceae;g__Magnetococcus;s__Magnetococcus marinus	

p1	GCA_000723365	1	d__Bacteria;p__Firmicutes;c__Bacilli;o__Mycoplasmatales;f__Mycoplasmoidaceae;g__Mycoplasmoides;s__Mycoplasmoides amphoriforme
p2	GCF_000007605	1	d__Bacteria;p__Verrucomicrobiota_A;c__Chlamydiia;o__Chlamydiales;f__Chlamydiaceae;g__Chlamydophila;s__Chlamydophila caviae
p3	GCF_900476215	2	d__Bacteria;p__Campylobacterota;c__Campylobacteria;o__Campylobacterales;f__Helicobacteraceae;g__Helicobacter_H;s__Helicobacter_H mustelae
p4	GCF_900091495	3	d__Bacteria;p__Actinobacteriota;c__Actinomycetia;o__Mycobacteriales;f__Micromonosporaceae;g__Micromonospora;s__Micromonospora echinospora
p5	GCF_901482695	7	d__Bacteria;p__Bacteroidota;c__Bacteroidia;o__Sphingobacteriales;f__Sphingobacteriaceae;g__Sphingobacterium;s__Sphingobacterium thalpophilum


######################################### Prokka #########################################

module load perl/5.28.0
module load infernal/1.1.2 
module load blast+/2.9.0 
module load hmmer/3.2.1
module load prodigal/2.6.3
module load tbl2asn/25.8
module load parallel/20190522 
module load aragorn/1.2.38 
module load bedtools/2.27.1
module load barrnap/0.9 
module load prokka/1.14.5
cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/selected_genomes_renamed_no_plasmid
prokka --force --prefix c1 --locustag c1 --strain c1 --outdir c1 c1.fna --cpus 6
prokka --force --prefix c2 --locustag c2 --strain c2 --outdir c2 c2.fna --cpus 6
prokka --force --prefix c3 --locustag c3 --strain c3 --outdir c3 c3.fna --cpus 6
prokka --force --prefix f1 --locustag f1 --strain f1 --outdir f1 f1.fna --cpus 6
prokka --force --prefix f2 --locustag f2 --strain f2 --outdir f2 f2.fna --cpus 6
prokka --force --prefix f3 --locustag f3 --strain f3 --outdir f3 f3.fna --cpus 6
prokka --force --prefix f4 --locustag f4 --strain f4 --outdir f4 f4.fna --cpus 6
prokka --force --prefix f5 --locustag f5 --strain f5 --outdir f5 f5.fna --cpus 6
prokka --force --prefix g1 --locustag g1 --strain g1 --outdir g1 g1.fna --cpus 6
prokka --force --prefix g2 --locustag g2 --strain g2 --outdir g2 g2.fna --cpus 6
prokka --force --prefix g3 --locustag g3 --strain g3 --outdir g3 g3.fna --cpus 6
prokka --force --prefix g4 --locustag g4 --strain g4 --outdir g4 g4.fna --cpus 6
prokka --force --prefix g5 --locustag g5 --strain g5 --outdir g5 g5.fna --cpus 6
prokka --force --prefix o1 --locustag o1 --strain o1 --outdir o1 o1.fna --cpus 6
prokka --force --prefix o2 --locustag o2 --strain o2 --outdir o2 o2.fna --cpus 6
prokka --force --prefix o3 --locustag o3 --strain o3 --outdir o3 o3.fna --cpus 6
prokka --force --prefix o4 --locustag o4 --strain o4 --outdir o4 o4.fna --cpus 6
prokka --force --prefix o5 --locustag o5 --strain o5 --outdir o5 o5.fna --cpus 6
prokka --force --prefix p1 --locustag p1 --strain p1 --outdir p1 p1.fna --cpus 6
prokka --force --prefix p2 --locustag p2 --strain p2 --outdir p2 p2.fna --cpus 6
prokka --force --prefix p3 --locustag p3 --strain p3 --outdir p3 p3.fna --cpus 6
prokka --force --prefix p4 --locustag p4 --strain p4 --outdir p4 p4.fna --cpus 6
prokka --force --prefix p5 --locustag p5 --strain p5 --outdir p5 p5.fna --cpus 6
prokka --force --prefix s1 --locustag s1 --strain s1 --outdir s1 s1.fna --cpus 6
prokka --force --prefix s2 --locustag s2 --strain s2 --outdir s2 s2.fna --cpus 6
prokka --force --prefix s3 --locustag s3 --strain s3 --outdir s3 s3.fna --cpus 6
prokka --force --prefix s4 --locustag s4 --strain s4 --outdir s4 s4.fna --cpus 6
prokka --force --prefix s5 --locustag s5 --strain s5 --outdir s5 s5.fna --cpus 6


# get 16S tree
module load mafft/7.407
module load fasttree/2.1.11
cd /srv/scratch/z5039045/MarkerMAG_wd/genome_selection
mafft --quiet --maxiterate 1000 --thread 6 --globalpair combined_16S.ffn > combined_16S.aln 
fasttree -nt -quiet combined_16S.aln > combined_16S.newick

module load python/3.7.3
source ~/mypython3env/bin/activate
cd /srv/scratch/z5039045/MarkerMAG_wd/genome_selection
BioSAK iTOL -ColorStrip -lg 16S_grouping_rank.txt -lt rank -out 16S_grouping_rank_iTol.txt
BioSAK iTOL -ColorRange -lg 16S_grouping_strain.txt -lt strain -out 16S_grouping_strain_iTol.txt


####################################### Even depth #######################################

module load python/3.7.3
source ~/mypython3env/bin/activate

# get the number of reads to simulate
cd /srv/scratch/z5039045/MarkerMAG_wd
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 1 -l 150 -i 200
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 2 -l 150 -i 200
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 3 -l 150 -i 200
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 5 -l 150 -i 200
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 10 -l 150 -i 200
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 25 -l 150 -i 200
python3 z_simulate_reads.py -g genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -a abundance_even2.txt -d 50 -l 150 -i 200

cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > combined_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > combined_R2.fasta
mv combined_R1.fasta simulation_even_depth/combined_2x_R1.5.fasta
mv combined_R2.fasta simulation_even_depth/combined_2x_R2.5.fasta
rm *_R1.fasta
rm *_R2.fasta


# link
module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd

./MarkerMAG -p EvenDepth1x -r1 ../simulation_even_depth/combined_1x_R1.fasta -r2 ../simulation_even_depth/combined_1x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth2x -r1 ../simulation_even_depth/combined_2x_R1.fasta -r2 ../simulation_even_depth/combined_2x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth3x -r1 ../simulation_even_depth/combined_3x_R1.fasta -r2 ../simulation_even_depth/combined_3x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth5x -r1 ../simulation_even_depth/combined_5x_R1.fasta -r2 ../simulation_even_depth/combined_5x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth10x -r1 ../simulation_even_depth/combined_10x_R1.fasta -r2 ../simulation_even_depth/combined_10x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth25x -r1 ../simulation_even_depth/combined_25x_R1.fasta -r2 ../simulation_even_depth/combined_25x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth50x -r1 ../simulation_even_depth/combined_50x_R1.fasta -r2 ../simulation_even_depth/combined_50x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force

							  Depth			Paired	Paired	Clip	Clip	Intxn	Intxn
M30_S30	[2020-10-17 18:48:09] EvenDepth1x	80.23	100.0	53.49	97.01	40.7	100.0
M30_S30	[2020-10-17 18:48:09] EvenDepth2x	91.86	100.0	79.07	100.0	74.42	100.0
M30_S30	[2020-10-17 18:48:09] EvenDepth3x	97.67	100.0	82.56	99.84	82.56	100.0
M30_S30	[2020-10-17 18:48:09] EvenDepth5x	96.51	100.0	90.7	99.48	90.7	100.0
M30_S30	[2020-10-17 18:48:09] EvenDepth10x	96.51	100.0	89.53	97.35	88.37	100.0
M30_S30	[2020-10-17 18:48:09] EvenDepth25x	97.67	100.0	94.19	99.3	94.19	100.0
M30_S30	[2020-10-17 18:48:09] EvenDepth50x	97.67	100.0	97.67	100.0	97.67	100.0

M50_S50	[2020-10-17 18:48:09] EvenDepth1x	87.21	100.0	38.37	95.0	34.88	100.0
M50_S50	[2020-10-17 18:48:28] EvenDepth2x	96.51	100.0	59.3	99.57	58.14	100.0
M50_S50	[2020-10-17 18:48:51] EvenDepth3x	97.67	100.0	59.3	96.53	59.3	100.0
M50_S50	[2020-10-17 18:49:22] EvenDepth5x	96.51	100.0	84.88	99.24	84.88	100.0
M50_S50	[2020-10-17 18:50:13] EvenDepth10x	96.51	100.0	93.02	99.91	91.86	100.0
M50_S50	[2020-10-17 18:52:04] EvenDepth25x	97.67	100.0	94.19	99.25	94.19	100.0
M50_S50	[2020-10-17 18:55:34] EvenDepth50x	97.67	100.0	94.19	99.54	94.19	100.0

M70_S70	[2020-10-17 18:56:51] EvenDepth1x	88.37	100.0	10.47	89.13	8.14	100.0
M70_S70	[2020-10-17 18:57:10] EvenDepth2x	97.67	100.0	18.6	100.0	16.28	100.0
M70_S70	[2020-10-17 18:57:33] EvenDepth3x	97.67	100.0	19.77	86.76	19.77	100.0
M70_S70	[2020-10-17 18:58:05] EvenDepth5x	96.51	100.0	44.19	100.0	43.02	100.0
M70_S70	[2020-10-17 18:58:56] EvenDepth10x	94.19	100.0	54.65	100.0	52.33	100.0
M70_S70	[2020-10-17 19:00:48] EvenDepth25x	97.67	100.0	83.72	99.16	83.72	100.0
M70_S70	[2020-10-17 19:04:22] EvenDepth50x	97.67	100.0	95.35	99.77	95.35	100.0

M70_S50	[2020-10-19 09:34:19] EvenDepth1x	88.37	100.0	27.91	98.02	25.58	100.0
M70_S50	[2020-10-17 19:08:46] EvenDepth2x	97.67	100.0	43.02	99.39	43.02	100.0
M70_S50	[2020-10-17 19:09:10] EvenDepth3x	97.67	100.0	44.19	95.71	44.19	100.0
M70_S50	[2020-10-17 19:09:41] EvenDepth5x	96.51	100.0	80.23	100.0	80.23	100.0
M70_S50	[2020-10-17 19:10:32] EvenDepth10x	96.51	100.0	89.53	100.0	89.53	100.0
M70_S50	[2020-10-17 19:12:23] EvenDepth25x	97.67	100.0	96.51	100.0	96.51	100.0
M70_S50	[2020-10-17 19:15:56] EvenDepth50x	97.67	100.0	96.51	100.0	96.51	100.0


./MarkerMAG -p EvenDepth2x -r1 ../simulation_even_depth/combined_2x_R1.fasta -r2 ../simulation_even_depth/combined_2x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -cigarM 70 -cigarS 70
./MarkerMAG -p EvenDepth3x -r1 ../simulation_even_depth/combined_3x_R1.fasta -r2 ../simulation_even_depth/combined_3x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -cigarM 70 -cigarS 70
./MarkerMAG -p EvenDepth5x -r1 ../simulation_even_depth/combined_5x_R1.fasta -r2 ../simulation_even_depth/combined_5x_R2.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -cigarM 70 -cigarS 70

[2020-10-19 11:17:28] EvenDepth2x	97.67	100.0	18.6	100.0	16.28	100.0
[2020-10-19 11:18:03] EvenDepth3x	97.67	100.0	19.77	86.76	19.77	100.0
[2020-10-19 11:18:53] EvenDepth5x	96.51	100.0	44.19	100.0	43.02	100.0

simulation_1	EvenDepth2x	18.6	100
simulation_2	EvenDepth2x	18.6	88.24
simulation_3	EvenDepth2x	18.6	100
simulation_4	EvenDepth2x	12.79	87.23
simulation_5	EvenDepth2x	18.6	91.67		

simulation_1	EvenDepth3x	19.77	86.76
simulation_2	EvenDepth3x	18.6	92.5
simulation_3	EvenDepth3x	24.42	100
simulation_4	EvenDepth3x	25.58	98.55
simulation_5	EvenDepth3x	22.09	93.83
			
			
################################# InSilicoSeq even depth #################################

module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1

cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd
./MarkerMAG -p InSilicoSeq_EvenDepth1x -r1 ../simulation_even_depth_InSilicoSeq/ISS_1x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_1x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p InSilicoSeq_EvenDepth2x -r1 ../simulation_even_depth_InSilicoSeq/ISS_2x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_2x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p InSilicoSeq_EvenDepth3x -r1 ../simulation_even_depth_InSilicoSeq/ISS_3x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_3x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p InSilicoSeq_EvenDepth5x -r1 ../simulation_even_depth_InSilicoSeq/ISS_5x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_5x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p InSilicoSeq_EvenDepth10x -r1 ../simulation_even_depth_InSilicoSeq/ISS_10x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_10x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p InSilicoSeq_EvenDepth25x -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p InSilicoSeq_EvenDepth50x -r1 ../simulation_even_depth_InSilicoSeq/ISS_50x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_50x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force

[2020-10-19 23:02:39] InSilicoSeq_EvenDepth1x_30M_30S	95.35	100.0	31.4	79.63
[2020-10-19 23:03:01] InSilicoSeq_EvenDepth2x_30M_30S	96.51	100.0	44.19	89.17
[2020-10-19 23:03:28] InSilicoSeq_EvenDepth3x_30M_30S	94.19	100.0	56.98	95.77
[2020-10-19 23:35:14] InSilicoSeq_EvenDepth5x_30M_30S	96.51	100.0	66.28	93.8
[2020-10-19 23:04:37] InSilicoSeq_EvenDepth10x_30M_30S	97.67	100.0	96.51	100.0
[2020-10-20 08:14:43] InSilicoSeq_EvenDepth25x_30M_30S	96.51	100.0	94.19	99.53
[2020-10-20 08:22:37] InSilicoSeq_EvenDepth50x_30M_30S	94.19	100.0	91.86	99.52

[2020-10-20 00:05:51] InSilicoSeq_EvenDepth1x_20M_20S	95.35	100.0	31.4	79.63
[2020-10-20 00:06:13] InSilicoSeq_EvenDepth2x_20M_20S	96.51	100.0	56.98	95.11
[2020-10-20 00:06:41] InSilicoSeq_EvenDepth3x_20M_20S	94.19	100.0	59.3	96.17
[2020-10-20 00:07:21] InSilicoSeq_EvenDepth5x_20M_20S	96.51	100.0	66.28	93.49
[2020-10-20 00:08:29] InSilicoSeq_EvenDepth10x_20M_20S	97.67	100.0	96.51	100.0
[2020-10-20 08:31:08] InSilicoSeq_EvenDepth25x_20M_20S	96.51	100.0	94.19	99.45
[2020-10-20 08:39:10] InSilicoSeq_EvenDepth50x_20M_20S	94.19	100.0	91.86	99.48

[2020-10-19 22:41:44] InSilicoSeq_EvenDepth1x_50M_50S	95.35	100.0	13.95	70.33
[2020-10-19 22:42:53] InSilicoSeq_EvenDepth2x_50M_50S	94.19	100.0	27.91	79.19
[2020-10-19 22:55:54] InSilicoSeq_EvenDepth3x_50M_50S	94.19	100.0	30.23	80.66
[2020-10-19 23:36:07] InSilicoSeq_EvenDepth5x_50M_50S	96.51	100.0	47.67	92.66
[2020-10-19 22:44:10] InSilicoSeq_EvenDepth10x_50M_50S	97.67	100.0	82.56	98.25
[2020-10-20 08:47:09] InSilicoSeq_EvenDepth25x_50M_50S	96.51	100.0	76.74	95.31
[2020-10-20 08:55:01] InSilicoSeq_EvenDepth50x_50M_50S	94.19	100.0	94.19	99.41


./link_Marker_MAG.py -p InSilicoSeq_EvenDepth1x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_1x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_1x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p InSilicoSeq_EvenDepth2x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_2x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_2x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p InSilicoSeq_EvenDepth3x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_3x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_3x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p InSilicoSeq_EvenDepth5x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_5x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_5x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p InSilicoSeq_EvenDepth10x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_10x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_10x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p InSilicoSeq_EvenDepth25x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p InSilicoSeq_EvenDepth50x_uniq -r1 ../simulation_even_depth_InSilicoSeq/ISS_50x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_50x_even_Q30_P_R2_renamed.fasta -m ../genome_selection_3/combined_16S_uniq.ffn -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
[2020-10-24 09:28:53] InSilicoSeq_EvenDepth1x_uniq	Marker	91.3	100.0	45.65	80.39	Unrecovered_Paired(4):p5_00515,p5_00656,p5_00944,p5_03129	Unrecovered_Clipping(25):c2_01869,c3_00259,c3_02816,f1_05369,f2_03131,f4_00381,f5_00225,g1_00650,g2_03471,g3_00108,g3_00537,g3_04871,o1_01731,o5_03923,p1_01191,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s2_00537,s3_00124,s4_02679
[2020-10-24 09:29:16] InSilicoSeq_EvenDepth2x_uniq	Marker	93.48	100.0	67.39	91.39	Unrecovered_Paired(3):p5_00515,p5_01238,p5_03129	Unrecovered_Clipping(15):f1_05369,f5_00225,g1_00650,g3_00108,g3_00537,g3_04871,p3_00101,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,s1_00644,s2_00537,s4_03140
[2020-10-24 09:29:45] InSilicoSeq_EvenDepth3x_uniq	Marker	89.13	100.0	71.74	99.77	Unrecovered_Paired(5):p5_00656,p5_00944,p5_01238,p5_01648,p5_02332	Unrecovered_Clipping(13):c2_01869,f1_05369,g2_03471,o1_01731,o2_01394,o3_00426,p2_00901,p5_00515,p5_00656,p5_00944,p5_03129,s2_00537,s4_00580
[2020-10-24 10:11:31] InSilicoSeq_EvenDepth5x_uniq	Marker	91.3	100.0	89.13	98.9	Unrecovered_Paired(4):p5_00515,p5_00656,p5_00944,p5_03129	Unrecovered_Clipping(5):g1_00650,p5_00515,p5_03129,s1_00644,s2_00537
[2020-10-24 09:31:35] InSilicoSeq_EvenDepth10x_uniq	Marker	93.48	100.0	82.61	99.78	Unrecovered_Paired(3):p5_00515,p5_01238,p5_03129	Unrecovered_Clipping(8):g1_00650,g2_03471,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,s4_03140
[2020-10-24 09:34:11] InSilicoSeq_EvenDepth25x_uniq	Marker	89.13	100.0	89.13	99.46	Unrecovered_Paired(5):p5_00656,p5_00944,p5_01238,p5_01648,p5_02332	Unrecovered_Clipping(5):p5_00515,p5_01238,p5_03129,s1_00644,s2_00537
[2020-10-24 09:39:13] InSilicoSeq_EvenDepth50x_uniq	Marker	89.13	100.0	93.48	100.0	Unrecovered_Paired(5):p5_00656,p5_00944,p5_01238,p5_01648,p5_02332	Unrecovered_Clipping(3):p5_00515,p5_01238,p5_03129
[2020-10-24 09:28:53] InSilicoSeq_EvenDepth1x_uniq	Genome	100.0	100.0	50.0	73.68	Unrecovered_Paired(0):	Unrecovered_Clipping(14):c2,c3,f1,f2,f4,f5,g1,g2,g3,o1,p1,p5,s2,s3
[2020-10-24 09:29:16] InSilicoSeq_EvenDepth2x_uniq	Genome	100.0	100.0	75.0	87.5	Unrecovered_Paired(0):	Unrecovered_Clipping(7):f1,f5,g1,g3,p3,s1,s2
[2020-10-24 09:29:45] InSilicoSeq_EvenDepth3x_uniq	Genome	100.0	100.0	75.0	95.45	Unrecovered_Paired(0):	Unrecovered_Clipping(7):c2,f1,g2,o1,o2,p2,s2
[2020-10-24 10:11:31] InSilicoSeq_EvenDepth5x_uniq	Genome	100.0	100.0	89.29	92.59	Unrecovered_Paired(0):	Unrecovered_Clipping(3):g1,s1,s2
[2020-10-24 09:31:35] InSilicoSeq_EvenDepth10x_uniq	Genome	100.0	100.0	92.86	96.3	Unrecovered_Paired(0):	Unrecovered_Clipping(2):g1,g2
[2020-10-24 09:34:11] InSilicoSeq_EvenDepth25x_uniq	Genome	100.0	100.0	92.86	92.86	Unrecovered_Paired(0):	Unrecovered_Clipping(2):s1,s2
[2020-10-24 09:39:13] InSilicoSeq_EvenDepth50x_uniq	Genome	100.0	100.0	100.0	100.0	Unrecovered_Paired(0):	Unrecovered_Clipping(0):


# rename Matam assemblies
module load python/3.7.3
source ~/mypython3env/bin/activate
module load blast+/2.9.0
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_1x/workdir
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_2x/workdir
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_3x/workdir
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_5x/workdir
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_10x/workdir
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_25x/workdir
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/Matam_InSilicoSeq_50x/workdir
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m scaffolds.NR.min_500bp.abd.fa
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1300 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m scaffolds.NR.min_500bp.abd.fa
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1200 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m scaffolds.NR.min_500bp.abd.fa
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1000 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m scaffolds.NR.min_500bp.abd.fa
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 900 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m scaffolds.NR.min_500bp.abd.fa
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 800 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m scaffolds.NR.min_500bp.abd.fa

2x	Marker	99.5%	1500bp	0/86	0	Unrecovered(86):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s4_00580,s4_02579,s4_02679,s4_03140,s4_03687,s4_04216,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
2x	Marker	99.5%	1300bp	0/86	0	Unrecovered(86):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s4_00580,s4_02579,s4_02679,s4_03140,s4_03687,s4_04216,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
2x	Marker	99.5%	1200bp	6/86	1	Unrecovered(80):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
2x	Marker	99.5%	1000bp	12/86	2	Unrecovered(74):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
2x	Marker	99.5%	900bp	12/86	2	Unrecovered(74):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
2x	Marker	99.5%	800bp	19/86	3	Unrecovered(67):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
2x	Genome	99.5%	1500bp	0/28	0	Unrecovered(28):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g4,g5,o1,o2,o3,o4,o5,p1,p2,p3,p4,p5,s1,s2,s3,s4,s5
2x	Genome	99.5%	1300bp	0/28	0	Unrecovered(28):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g4,g5,o1,o2,o3,o4,o5,p1,p2,p3,p4,p5,s1,s2,s3,s4,s5
2x	Genome	99.5%	1200bp	1/28	1	Unrecovered(27):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g4,g5,o1,o2,o3,o4,o5,p1,p2,p3,p4,p5,s1,s2,s3,s5
2x	Genome	99.5%	1000bp	2/28	2	Unrecovered(26):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g4,g5,o1,o2,o3,o5,p1,p2,p3,p4,p5,s1,s2,s3,s5
2x	Genome	99.5%	900bp	2/28	2	Unrecovered(26):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g4,g5,o1,o2,o3,o5,p1,p2,p3,p4,p5,s1,s2,s3,s5
2x	Genome	99.5%	800bp	3/28	3	Unrecovered(25):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g4,g5,o1,o2,o3,o5,p1,p2,p3,p4,p5,s1,s2,s3

3x	Marker	99.5%	1500bp	11/86	2	Unrecovered(75):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
3x	Marker	99.5%	1300bp	29/86	5	Unrecovered(57):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
3x	Marker	99.5%	1200bp	33/86	6	Unrecovered(53):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
3x	Marker	99.5%	1000bp	39/86	7	Unrecovered(47):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
3x	Marker	99.5%	900bp	45/86	10	Unrecovered(41):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
3x	Marker	99.5%	800bp	52/86	12	Unrecovered(34):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
3x	Genome	99.5%	1500bp	2/28	2	Unrecovered(26):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g5,o1,o2,o3,o4,o5,p1,p2,p3,p4,p5,s1,s2,s3,s5
3x	Genome	99.5%	1300bp	5/28	5	Unrecovered(23):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g5,o1,o2,o3,o5,p1,p2,p3,p4,p5,s1,s2,s3
3x	Genome	99.5%	1200bp	6/28	6	Unrecovered(22):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g5,o1,o2,o5,p1,p2,p3,p4,p5,s1,s2,s3
3x	Genome	99.5%	1000bp	7/28	7	Unrecovered(21):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,o5,p1,p2,p3,p4,p5,s1,s2,s3
3x	Genome	99.5%	900bp	8/28	10	Unrecovered(20):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,p1,p2,p3,p4,p5,s1,s2,s3
3x	Genome	99.5%	800bp	9/28	12	Unrecovered(19):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2,s3

5x	Marker	99.5%	1500bp	41/86	8	Unrecovered(45):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537
5x	Marker	99.5%	1300bp	53/86	12	Unrecovered(33):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
5x	Marker	99.5%	1200bp	57/86	14	Unrecovered(29):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
5x	Marker	99.5%	1000bp	59/86	16	Unrecovered(27):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,s1_00644,s2_00537
5x	Marker	99.5%	900bp	62/86	17	Unrecovered(24):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,s1_00644,s2_00537
5x	Marker	99.5%	800bp	67/86	20	Unrecovered(19):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,s1_00644,s2_00537
5x	Genome	99.5%	1500bp	7/28	8	Unrecovered(21):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,o1,o2,o3,p1,p2,p3,p4,p5,s1,s2
5x	Genome	99.5%	1300bp	10/28	12	Unrecovered(18):c1,c2,c3,f1,f2,f3,g1,g2,g3,o1,o2,o3,p1,p2,p3,p4,s1,s2
5x	Genome	99.5%	1200bp	11/28	14	Unrecovered(17):c1,c2,c3,f1,f2,f3,g1,g2,g3,o1,o2,p1,p2,p3,p4,s1,s2
5x	Genome	99.5%	1000bp	11/28	16	Unrecovered(17):c1,c2,c3,f1,f2,f3,g1,g2,g3,o1,o2,p1,p2,p3,p
5x	Genome	99.5%	900bp	12/28	17	Unrecovered(16):c1,c2,f1,f2,f3,g1,g2,g3,o1,o2,p1,p2,p3,p4,s1,s2
5x	Genome	99.5%	800bp	13/28	20	Unrecovered(15):c1,c2,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2

10x	Marker	99.5%	1500bp	39/86	12	Unrecovered(47):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_04871,o1_01731,o2_01394,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
10x	Marker	99.5%	1300bp	62/86	19	Unrecovered(24):c1_01889,c2_01869,f1_05369,f2_03131,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p1_01191,p2_00901,p5_00515,p5_03129,s1_00644,s2_00537
10x	Marker	99.5%	1200bp	67/86	21	Unrecovered(19):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,g2_03471,o1_01731,o2_01394,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p1_01191,p2_00901,p5_00515,p5_03129,s2_00537
10x	Marker	99.5%	1000bp	69/86	22	Unrecovered(17):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,g2_03471,o1_01731,o2_01394,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p1_01191,p2_00901,s2_00537
10x	Marker	99.5%	900bp	70/86	24	Unrecovered(16):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,o1_01731,o2_01394,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p1_01191,p2_00901,s2_00537
10x	Marker	99.5%	800bp	73/86	27	Unrecovered(13):c1_01889,c2_01869,f1_05369,f2_03131,o1_01731,o2_01394,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p2_00901
10x	Genome	99.5%	1500bp	8/28	12	Unrecovered(20):c1,c2,c3,f1,f2,f3,f5,g1,g2,o1,o2,o4,p1,p2,p3,p4,p5,s1,s2,s5
10x	Genome	99.5%	1300bp	14/28	19	Unrecovered(14):c1,c2,f1,f2,f5,g1,g2,o1,o2,o4,p1,p2,s1,s2
10x	Genome	99.5%	1200bp	16/28	21	Unrecovered(12):c1,c2,f1,f2,g1,g2,o1,o2,o4,p1,p2,s2
10x	Genome	99.5%	1000bp	16/28	22	Unrecovered(12):c1,c2,f1,f2,g1,g2,o1,o2,o4,p1,p2,s2
10x	Genome	99.5%	900bp	17/28	24	Unrecovered(11):c1,c2,f1,f2,g1,o1,o2,o4,p1,p2,s2
10x	Genome	99.5%	800bp	20/28	27	Unrecovered(8):c1,c2,f1,f2,o1,o2,o4,p2

25x	Marker	99.5%	1500bp	24/86	13	Unrecovered(62):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g4_00414,g4_01091,g4_01774,g4_01998,g4_02419,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
25x	Marker	99.5%	1300bp	50/86	22	Unrecovered(36):c1_01889,c3_00259,c3_02816,c3_03081,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
25x	Marker	99.5%	1200bp	56/86	25	Unrecovered(30):c1_01889,c3_00259,c3_02816,c3_03081,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
25x	Marker	99.5%	1000bp	59/86	27	Unrecovered(27):c1_01889,c3_00259,c3_02816,c3_03081,f4_00381,f4_00512,f4_02069,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
25x	Marker	99.5%	900bp	61/86	28	Unrecovered(25):c1_01889,c3_00259,c3_02816,c3_03081,f4_00381,f4_00512,f4_02069,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_03129
25x	Marker	99.5%	800bp	73/86	33	Unrecovered(13):c3_00259,c3_02816,c3_03081,o3_00282,o3_00426,o3_02626,o3_03185,p4_02304,p4_03395,p4_06318,p5_00515,p5_01238,p5_03129
25x	Genome	99.5%	1500bp	10/28	13	Unrecovered(18):c1,c2,c3,f3,f4,f5,g3,g4,o2,o3,o4,o5,p1,p3,p4,p5,s1,s5
25x	Genome	99.5%	1300bp	18/28	22	Unrecovered(10):c1,c3,f3,f4,o2,o3,o4,o5,p4,p5
25x	Genome	99.5%	1200bp	19/28	25	Unrecovered(9):c1,c3,f3,f4,o2,o3,o4,p4,p5
25x	Genome	99.5%	1000bp	21/28	27	Unrecovered(7):c1,c3,f4,o3,o4,p4,p5
25x	Genome	99.5%	900bp	22/28	28	Unrecovered(6):c1,c3,f4,o3,o4,p4
25x	Genome	99.5%	800bp	25/28	33	Unrecovered(3):c3,o3,p4

50x	Marker	99.5%	1500bp	36/86	9	Unrecovered(50):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g2_03471,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537
50x	Marker	99.5%	1300bp	41/86	18	Unrecovered(45):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
50x	Marker	99.5%	1200bp	41/86	18	Unrecovered(45):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
50x	Marker	99.5%	1000bp	44/86	20	Unrecovered(42):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
50x	Marker	99.5%	900bp	45/86	21	Unrecovered(41):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129
50x	Marker	99.5%	800bp	51/86	25	Unrecovered(35):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_01238
50x	Genome	99.5%	1500bp	8/28	9	Unrecovered(20):c1,c2,c3,f1,f2,f3,f4,f5,g2,o1,o2,o3,o4,o5,p1,p3,p4,p5,s1,s2
50x	Genome	99.5%	1300bp	13/28	18	Unrecovered(15):c1,c2,c3,f1,f3,f4,f5,o1,o2,o3,o4,o5,p3,p4,p5
50x	Genome	99.5%	1200bp	13/28	18	Unrecovered(15):c1,c2,c3,f1,f3,f4,f5,o1,o2,o3,o4,o5,p3,p4,p5
50x	Genome	99.5%	1000bp	15/28	20	Unrecovered(13):c1,c2,c3,f4,f5,o1,o2,o3,o4,o5,p3,p4,p5
50x	Genome	99.5%	900bp	16/28	21	Unrecovered(12):c1,c2,c3,f4,f5,o2,o3,o4,o5,p3,p4,p5
50x	Genome	99.5%	800bp	17/28	25	Unrecovered(11):c1,c2,c3,f4,f5,o2,o3,o4,o5,p3,p4


# put all Matam assemblies together
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq
cp Matam_InSilicoSeq_2x/workdir/scaffolds.NR.min_500bp.abd.fa all_depth_assemblies/scaffolds.NR.min_500bp.abd.2x.fa
cp Matam_InSilicoSeq_3x/workdir/scaffolds.NR.min_500bp.abd.fa all_depth_assemblies/scaffolds.NR.min_500bp.abd.3x.fa
cp Matam_InSilicoSeq_5x/workdir/scaffolds.NR.min_500bp.abd.fa all_depth_assemblies/scaffolds.NR.min_500bp.abd.5x.fa
cp Matam_InSilicoSeq_10x/workdir/scaffolds.NR.min_500bp.abd.fa all_depth_assemblies/scaffolds.NR.min_500bp.abd.10x.fa
cp Matam_InSilicoSeq_25x/workdir/scaffolds.NR.min_500bp.abd.fa all_depth_assemblies/scaffolds.NR.min_500bp.abd.25x.fa
cp Matam_InSilicoSeq_50x/workdir/scaffolds.NR.min_500bp.abd.fa all_depth_assemblies/scaffolds.NR.min_500bp.abd.50x.fa

# rename Matam assemblies
module load python/3.7.3
source ~/mypython3env/bin/activate
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/all_depth_assemblies/rename_wd
BioSAK rename_seq -in scaffolds.NR.min_500bp.abd.2x.fa -prefix d2x
BioSAK rename_seq -in scaffolds.NR.min_500bp.abd.3x.fa -prefix d3x
BioSAK rename_seq -in scaffolds.NR.min_500bp.abd.5x.fa -prefix d5x
BioSAK rename_seq -in scaffolds.NR.min_500bp.abd.10x.fa -prefix d10x
BioSAK rename_seq -in scaffolds.NR.min_500bp.abd.25x.fa -prefix d25x
BioSAK rename_seq -in scaffolds.NR.min_500bp.abd.50x.fa -prefix d50x

cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/all_depth_assemblies/rename_wd
cat scaffolds.NR.min_500bp.abd.2x_renamed.fa scaffolds.NR.min_500bp.abd.3x_renamed.fa > ../combined_2x-3x_assemblies.fa
cat scaffolds.NR.min_500bp.abd.2x_renamed.fa scaffolds.NR.min_500bp.abd.3x_renamed.fa scaffolds.NR.min_500bp.abd.5x_renamed.fa > ../combined_2x-5x_assemblies.fa
cat scaffolds.NR.min_500bp.abd.2x_renamed.fa scaffolds.NR.min_500bp.abd.3x_renamed.fa scaffolds.NR.min_500bp.abd.5x_renamed.fa scaffolds.NR.min_500bp.abd.10x_renamed.fa > ../combined_2x-10x_assemblies.fa
cat scaffolds.NR.min_500bp.abd.2x_renamed.fa scaffolds.NR.min_500bp.abd.3x_renamed.fa scaffolds.NR.min_500bp.abd.5x_renamed.fa scaffolds.NR.min_500bp.abd.10x_renamed.fa scaffolds.NR.min_500bp.abd.25x_renamed.fa > ../combined_2x-25x_assemblies.fa
cat *_renamed.fa > ../combined_all_depth_assemblies.fa

# cluster marker genes
module load usearch/10.0.240
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/all_depth_assemblies
python3 /srv/scratch/z5039045/Scripts/uclust_16S.py -in combined_2x-3x_assemblies.fa -i 0.995 -out combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/Scripts/uclust_16S.py -in combined_2x-5x_assemblies.fa -i 0.995 -out combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/Scripts/uclust_16S.py -in combined_2x-10x_assemblies.fa -i 0.995 -out combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/Scripts/uclust_16S.py -in combined_2x-25x_assemblies.fa -i 0.995 -out combined_2x-25x_assemblies_uclust99.5.fasta

# renamed dereplicated all-depth Matam assemblies
module load python/3.7.3
source ~/mypython3env/bin/activate
module load blast+/2.9.0
cd /srv/scratch/z5039045/MarkerMAG_wd/simulation_even_depth_InSilicoSeq/all_depth_assemblies
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 600 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 700 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 800 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 900 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1000 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1200 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1300 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-3x_assemblies_uclust99.5.fasta

python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 600 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 700 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 800 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 900 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1000 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1200 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1300 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-5x_assemblies_uclust99.5.fasta

python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 600 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 700 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 800 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 900 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1000 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1200 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1300 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-10x_assemblies_uclust99.5.fasta

python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 600 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 700 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 800 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 900 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1000 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1200 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1300 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_2x-25x_assemblies_uclust99.5.fasta

python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 600 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 700 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 800 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 900 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1000 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1200 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1300 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -i 99.5 -l 1500 -c /srv/scratch/z5039045/MarkerMAG_wd/genome_selection_3/combined_16S.ffn -m combined_all_depth_assemblies_uclust99.5.fasta

combined_2x-3x	Marker	99.5%	500bp	69/86	17	Unrecovered(17):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509
combined_2x-3x	Marker	99.5%	600bp	65/86	13	Unrecovered(21):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509
combined_2x-3x	Marker	99.5%	700bp	55/86	10	Unrecovered(31):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
combined_2x-3x	Marker	99.5%	800bp	52/86	9	Unrecovered(34):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
combined_2x-3x	Marker	99.5%	900bp	45/86	8	Unrecovered(41):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
combined_2x-3x	Marker	99.5%	1000bp	39/86	7	Unrecovered(47):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,o1_01731,o2_01394,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
combined_2x-3x	Marker	99.5%	1200bp	33/86	6	Unrecovered(53):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
combined_2x-3x	Marker	99.5%	1300bp	29/86	5	Unrecovered(57):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583
combined_2x-3x	Marker	99.5%	1500bp	11/86	2	Unrecovered(75):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,g5_00174,g5_01291,g5_01784,g5_02575,g5_03966,g5_04304,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,o4_00099,o4_00249,o4_01748,o4_02347,o4_02542,o4_03086,o5_00029,o5_03514,o5_03923,o5_04122,o5_04768,o5_05060,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537,s3_00124,s3_00752,s3_04232,s3_05244,s3_05583,s5_00111,s5_00430,s5_00636,s5_01224,s5_02435,s5_03277,s5_04377
combined_2x-3x	Genome	99.5%	500bp	15/28	17	Unrecovered(13):c1,c2,c3,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3
combined_2x-3x	Genome	99.5%	600bp	14/28	13	Unrecovered(14):c1,c2,c3,f1,f2,f3,f5,g1,g2,o1,o2,p1,p2,p3
combined_2x-3x	Genome	99.5%	700bp	10/28	10	Unrecovered(18):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,p1,p2,p3,s1,s2,s3
combined_2x-3x	Genome	99.5%	800bp	9/28	9	Unrecovered(19):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2,s3
combined_2x-3x	Genome	99.5%	900bp	8/28	8	Unrecovered(20):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,p1,p2,p3,p4,p5,s1,s2,s3
combined_2x-3x	Genome	99.5%	1000bp	7/28	7	Unrecovered(21):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,o1,o2,o5,p1,p2,p3,p4,p5,s1,s2,s3
combined_2x-3x	Genome	99.5%	1200bp	6/28	6	Unrecovered(22):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g5,o1,o2,o5,p1,p2,p3,p4,p5,s1,s2,s3
combined_2x-3x	Genome	99.5%	1300bp	5/28	5	Unrecovered(23):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g5,o1,o2,o3,o5,p1,p2,p3,p4,p5,s1,s2,s3
combined_2x-3x	Genome	99.5%	1500bp	2/28	2	Unrecovered(26):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g5,o1,o2,o3,o4,o5,p1,p2,p3,p4,p5,s1,s2,s3,s5

combined_2x-5x	Marker	99.5%	500bp	71/86	18	Unrecovered(15):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p5_00515,p5_03129
combined_2x-5x	Marker	99.5%	600bp	70/86	17	Unrecovered(16):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p5_00515,p5_03129,s2_00537
combined_2x-5x	Marker	99.5%	700bp	68/86	15	Unrecovered(18):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-5x	Marker	99.5%	800bp	65/86	13	Unrecovered(21):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-5x	Marker	99.5%	900bp	65/86	13	Unrecovered(21):c1_01889,c2_01869,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-5x	Marker	99.5%	1000bp	62/86	12	Unrecovered(24):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-5x	Marker	99.5%	1200bp	62/86	12	Unrecovered(24):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-5x	Marker	99.5%	1300bp	58/86	11	Unrecovered(28):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,g1_00650,g2_03471,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-5x	Marker	99.5%	1500bp	41/86	7	Unrecovered(45):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f4_00381,f4_00512,f4_02069,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_00108,g3_00113,g3_00537,g3_02127,g3_04871,o1_01731,o2_01394,o3_00282,o3_00426,o3_02626,o3_03185,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537
combined_2x-5x	Genome	99.5%	500bp	17/28	18	Unrecovered(11):c1,c2,f1,f2,f3,g1,o1,o2,p1,p2,p3
combined_2x-5x	Genome	99.5%	600bp	16/28	17	Unrecovered(12):c1,c2,f1,f2,f3,g1,o1,o2,p1,p2,p3,s2
combined_2x-5x	Genome	99.5%	700bp	14/28	15	Unrecovered(14):c1,c2,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3,s1,s2
combined_2x-5x	Genome	99.5%	800bp	13/28	13	Unrecovered(15):c1,c2,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2
combined_2x-5x	Genome	99.5%	900bp	13/28	13	Unrecovered(15):c1,c2,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2
combined_2x-5x	Genome	99.5%	1000bp	12/28	12	Unrecovered(16):c1,c2,c3,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2
combined_2x-5x	Genome	99.5%	1200bp	12/28	12	Unrecovered(16):c1,c2,c3,f1,f2,f3,g1,g2,o1,o2,p1,p2,p3,p4,s1,s2
combined_2x-5x	Genome	99.5%	1300bp	11/28	11	Unrecovered(17):c1,c2,c3,f1,f2,f3,g1,g2,o1,o2,o3,p1,p2,p3,p4,s1,s2
combined_2x-5x	Genome	99.5%	1500bp	7/28	7	Unrecovered(21):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,o1,o2,o3,p1,p2,p3,p4,p5,s1

combined_2x-10x	Marker	99.5%	500bp	82/86	26	Unrecovered(4):c1_01889,f1_05369,f2_03131,o2_01394
combined_2x-10x	Marker	99.5%	600bp	81/86	25	Unrecovered(5):c1_01889,f1_05369,f2_03131,o2_01394,s2_00537
combined_2x-10x	Marker	99.5%	700bp	80/86	23	Unrecovered(6):c1_01889,f1_05369,f2_03131,o1_01731,o2_01394,s2_00537
combined_2x-10x	Marker	99.5%	800bp	78/86	21	Unrecovered(8):c1_01889,c2_01869,f1_05369,f2_03131,o1_01731,o2_01394,p2_00901,s2_00537
combined_2x-10x	Marker	99.5%	900bp	76/86	19	Unrecovered(10):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,o1_01731,o2_01394,p1_01191,p2_00901,s2_00537
combined_2x-10x	Marker	99.5%	1000bp	75/86	18	Unrecovered(11):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,s2_00537
combined_2x-10x	Marker	99.5%	1200bp	73/86	17	Unrecovered(13):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p5_00515,p5_03129,s2_00537
combined_2x-10x	Marker	99.5%	1300bp	72/86	16	Unrecovered(14):c1_01889,c2_01869,f1_05369,f2_03131,g1_00650,g2_03471,o1_01731,o2_01394,p1_01191,p2_00901,p5_00515,p5_03129,s1_00644,s2_00537
combined_2x-10x	Marker	99.5%	1500bp	52/86	10	Unrecovered(34):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f1_05369,f2_03131,f3_00209,f3_02041,f5_00225,f5_00355,f5_00795,f5_03420,g1_00650,g2_03471,g3_04871,o1_01731,o2_01394,p1_01191,p2_00901,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644,s2_00537
combined_2x-10x	Genome	99.5%	500bp	24/28	26	Unrecovered(4):c1,f1,f2,o2
combined_2x-10x	Genome	99.5%	600bp	23/28	25	Unrecovered(5):c1,f1,f2,o2,s2
combined_2x-10x	Genome	99.5%	700bp	22/28	23	Unrecovered(6):c1,f1,f2,o1,o2,s2
combined_2x-10x	Genome	99.5%	800bp	20/28	21	Unrecovered(8):c1,c2,f1,f2,o1,o2,p2,s2
combined_2x-10x	Genome	99.5%	900bp	18/28	19	Unrecovered(10):c1,c2,f1,f2,g1,o1,o2,p1,p2,s2
combined_2x-10x	Genome	99.5%	1000bp	17/28	18	Unrecovered(11):c1,c2,f1,f2,g1,g2,o1,o2,p1,p2,s2
combined_2x-10x	Genome	99.5%	1200bp	17/28	17	Unrecovered(11):c1,c2,f1,f2,g1,g2,o1,o2,p1,p2,s2
combined_2x-10x	Genome	99.5%	1300bp	16/28	16	Unrecovered(12):c1,c2,f1,f2,g1,g2,o1,o2,p1,p2,s1,s2
combined_2x-10x	Genome	99.5%	1500bp	10/28	10	Unrecovered(18):c1,c2,c3,f1,f2,f3,f5,g1,g2,o1,o2,p1,p2,p3,p4,p5,s1,s2

combined_2x-25x	Marker	99.5%	500bp	86/86	31	Unrecovered(0):
combined_2x-25x	Marker	99.5%	600bp	86/86	31	Unrecovered(0):
combined_2x-25x	Marker	99.5%	700bp	86/86	30	Unrecovered(0):
combined_2x-25x	Marker	99.5%	800bp	86/86	30	Unrecovered(0):
combined_2x-25x	Marker	99.5%	900bp	85/86	28	Unrecovered(1):c1_01889
combined_2x-25x	Marker	99.5%	800bp	86/86	30	Unrecovered(0):
combined_2x-25x	Marker	99.5%	900bp	85/86	28	Unrecovered(1):c1_01889
combined_2x-25x	Marker	99.5%	1000bp	85/86	28	Unrecovered(1):c1_01889
combined_2x-25x	Marker	99.5%	1200bp	82/86	26	Unrecovered(4):c1_01889,o2_01394,p5_00515,p5_03129
combined_2x-25x	Marker	99.5%	1300bp	82/86	26	Unrecovered(4):c1_01889,o2_01394,p5_00515,p5_03129
combined_2x-25x	Marker	99.5%	1500bp	59/86	17	Unrecovered(27):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f3_00209,f3_02041,f5_00225,f5_00355,f5_00795,f5_03420,g3_04871,o2_01394,p1_01191,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644
combined_2x-25x	Genome	99.5%	500bp	28/28	31	Unrecovered(0):
combined_2x-25x	Genome	99.5%	600bp	28/28	31	Unrecovered(0):
combined_2x-25x	Genome	99.5%	700bp	28/28	30	Unrecovered(0):
combined_2x-25x	Genome	99.5%	800bp	28/28	30	Unrecovered(0):
combined_2x-25x	Genome	99.5%	900bp	27/28	28	Unrecovered(1):c1
combined_2x-25x	Genome	99.5%	800bp	28/28	30	Unrecovered(0):
combined_2x-25x	Genome	99.5%	900bp	27/28	28	Unrecovered(1):c1
combined_2x-25x	Genome	99.5%	1000bp	27/28	28	Unrecovered(1):c1
combined_2x-25x	Genome	99.5%	1200bp	26/28	26	Unrecovered(2):c1,o2
combined_2x-25x	Genome	99.5%	1300bp	26/28	26	Unrecovered(2):c1,o2
combined_2x-25x	Genome	99.5%	1500bp	17/28	17	Unrecovered(11):c1,c2,c3,f3,f5,o2,p1,p3,p4,p5,s1

combined_2x-50x	Marker	99.5%	500bp	86/86	31	Unrecovered(0):
combined_2x-50x	Marker	99.5%	600bp	86/86	31	Unrecovered(0):
combined_2x-50x	Marker	99.5%	700bp	86/86	30	Unrecovered(0):
combined_2x-50x	Marker	99.5%	800bp	86/86	30	Unrecovered(0):
combined_2x-50x	Marker	99.5%	900bp	85/86	28	Unrecovered(1):c1_01889
combined_2x-50x	Marker	99.5%	1000bp	85/86	28	Unrecovered(1):c1_01889
combined_2x-50x	Marker	99.5%	1200bp	82/86	26	Unrecovered(4):c1_01889,o2_01394,p5_00515,p5_03129
combined_2x-50x	Marker	99.5%	1300bp	82/86	26	Unrecovered(4):c1_01889,o2_01394,p5_00515,p5_03129
combined_2x-50x	Marker	99.5%	1500bp	60/86	17	Unrecovered(26):c1_01889,c2_01869,c3_00259,c3_02816,c3_03081,f3_00209,f3_02041,f5_00225,f5_00355,f5_00795,f5_03420,o2_01394,p1_01191,p3_00101,p3_00509,p4_02304,p4_03395,p4_06318,p5_00515,p5_00656,p5_00944,p5_01238,p5_01648,p5_02332,p5_03129,s1_00644
combined_2x-50x	Genome	99.5%	500bp	28/28	31	Unrecovered(0):
combined_2x-50x	Genome	99.5%	600bp	28/28	31	Unrecovered(0):
combined_2x-50x	Genome	99.5%	700bp	28/28	30	Unrecovered(0):
combined_2x-50x	Genome	99.5%	800bp	28/28	30	Unrecovered(0):
combined_2x-50x	Genome	99.5%	900bp	27/28	28	Unrecovered(1):c1
combined_2x-50x	Genome	99.5%	1000bp	27/28	28	Unrecovered(1):c1
combined_2x-50x	Genome	99.5%	1200bp	26/28	26	Unrecovered(2):c1,o2
combined_2x-50x	Genome	99.5%	1300bp	26/28	26	Unrecovered(2):c1,o2
combined_2x-50x	Genome	99.5%	1500bp	17/28	17	Unrecovered(11):c1,c2,c3,f3,f5,o2,p1,p3,p4,p5,s1


# run MarkerMAG
module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_500 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_500bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_600 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_600bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_700 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_700bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_800 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_800bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_900 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_900bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1000 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_1000bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1200 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_1200bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1300 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_1300bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./link_Marker_MAG.py -p Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1500 -r1 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R1_renamed.fasta -r2 ../simulation_even_depth_InSilicoSeq/ISS_25x_even_Q30_P_R2_renamed.fasta -m ../simulation_even_depth_InSilicoSeq/all_depth_assemblies/combined_2x-25x_assemblies_uclust99.5_99.5_1500bp.fasta -mag ../genome_selection_3/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
[2020-10-24 16:16:22] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_800	Marker	93.33	100.0	80.0	88.98	Unrecovered_Paired(2):p5_m1,p5_m3	Unrecovered_Clipping(6):g1_m1,g2_m1,g3_m1,g5_m1,p5_m1,p5_m3
[2020-10-24 16:18:56] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_900	Marker	96.43	100.0	82.14	88.68	Unrecovered_Paired(1):p5_m2	Unrecovered_Clipping(5):g1_m1,g2_m1,g3_m1,g5_m1,p5_m2
[2020-10-24 16:21:35] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1000	Marker	96.43	100.0	82.14	88.68	Unrecovered_Paired(1):p5_m1	Unrecovered_Clipping(5):g1_m1,g2_m1,g3_m1,g5_m1,p5_m1
[2020-10-24 16:24:08] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1200	Marker	100.0	100.0	76.92	87.91	Unrecovered_Paired(0):	Unrecovered_Clipping(6):g1_m1,g2_m1,g3_m1,g5_m1,s1_m1,s2_m1
[2020-10-24 16:26:42] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1300	Marker	100.0	100.0	76.92	87.91	Unrecovered_Paired(0):	Unrecovered_Clipping(6):g1_m1,g2_m1,g3_m1,g5_m1,s1_m1,s2_m1
[2020-10-24 16:29:14] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1500	Marker	94.12	99.33	52.94	70.89	Unrecovered_Paired(1):f1_m1	Unrecovered_Clipping(8):f1_m1,f2_m1,f4_m1,g1_m1,g2_m1,g3_m1,g5_m1,o1_m1

[2020-10-24 16:16:22] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_800	Genome	100.0	100.0	85.71	88.89	Unrecovered_Paired(0):	Unrecovered_Clipping(4):g1,g2,g3,g5
[2020-10-24 16:18:56] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_900	Genome	96.43	100.0	82.14	85.19	Unrecovered_Paired(1):c1	Unrecovered_Clipping(5):c1,g1,g2,g3,g5
[2020-10-24 16:21:35] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1000	Genome	96.43	100.0	82.14	85.19	Unrecovered_Paired(1):c1	Unrecovered_Clipping(5):c1,g1,g2,g3,g5
[2020-10-24 16:24:08] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1200	Genome	92.86	100.0	71.43	76.92	Unrecovered_Paired(2):c1,o2	Unrecovered_Clipping(8):c1,g1,g2,g3,g5,o2,s1,s2
[2020-10-24 16:26:42] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1300	Genome	92.86	100.0	71.43	76.92	Unrecovered_Paired(2):c1,o2	Unrecovered_Clipping(8):c1,g1,g2,g3,g5,o2,s1,s2
[2020-10-24 16:29:14] Matam_EvenDepth25x_clusters_99.5_99.5_2-25x_1500	Genome	57.14	94.12	32.14	52.94	Unrecovered_Paired(12):c1,c2,c3,f1,f3,f5,o2,p1,p3,p4,p5,s1	Unrecovered_Clipping(19):c1,c2,c3,f1,f2,f3,f4,f5,g1,g2,g3,g5,o1,o2,p1,p3,p4,p5,s1
# f5 genome matched to f1 16S, which is not recovered by Matam.


######################################### Spades #########################################

cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads/rep_1
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_rep_1_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_rep_1_R2.fasta

cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads/rep_2
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_rep_2_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_rep_2_R2.fasta

cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads/rep_3
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_rep_3_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_rep_3_R2.fasta


module load python/3.7.3
source ~/mypython3env/bin/activate
cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads
BioSAK rename_reads_for_Reago -in combined_rep_1_R1.fasta -out combined_rep_1_R1_renamed.fasta -p rep1 -d 1
BioSAK rename_reads_for_Reago -in combined_rep_1_R2.fasta -out combined_rep_1_R2_renamed.fasta -p rep1 -d 2
BioSAK rename_reads_for_Reago -in combined_rep_2_R1.fasta -out combined_rep_2_R1_renamed.fasta -p rep2 -d 1
BioSAK rename_reads_for_Reago -in combined_rep_2_R2.fasta -out combined_rep_2_R2_renamed.fasta -p rep2 -d 2
BioSAK rename_reads_for_Reago -in combined_rep_3_R1.fasta -out combined_rep_3_R1_renamed.fasta -p rep3 -d 1
BioSAK rename_reads_for_Reago -in combined_rep_3_R2.fasta -out combined_rep_3_R2_renamed.fasta -p rep3 -d 2

rm combined_rep_1_R1.fasta
rm combined_rep_1_R2.fasta
rm combined_rep_2_R1.fasta
rm combined_rep_2_R2.fasta
rm combined_rep_3_R1.fasta
rm combined_rep_3_R2.fasta

cat combined_rep_1_R1_renamed.fasta combined_rep_2_R1_renamed.fasta combined_rep_3_R1_renamed.fasta > combined_rep123_R1.fasta
cat combined_rep_1_R2_renamed.fasta combined_rep_2_R2_renamed.fasta combined_rep_3_R2_renamed.fasta > combined_rep123_R2.fasta


module load spades/3.14.0
cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads
export TMPDIR=/srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads/spades_wd_TMPDIR 
spades.py --meta -1 combined_rep123_R1.fasta -2 combined_rep123_R2.fasta -o spades_wd -t 12 --only-assembler


module load idba/1.1.3
fq2fa --merge combined_rep123_R1.fasta combined_rep123_R2.fasta combined_rep123.fasta
idba_ud -r combined_rep123.fasta -o idba_ud_wd --num_threads 12
# idba_ud --num_threads 14 --mink 20 --maxk 124 --step 20 --read combined_reads_m0_l100i250_10_million.fasta --out IDBA_UD_m0_l100i250_10_million


######################################### Binning ########################################

cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads/spades_wd
perl /srv/scratch/z5039045/Scripts/select_contig.pl -m 2500 scaffolds.fasta scaffolds_lt2500bp.fasta

module load bowtie/2.3.5.1
bowtie2-build -f scaffolds_lt2500bp.fasta scaffolds_lt2500bp
bowtie2 -x scaffolds_lt2500bp -1 ../combined_rep_1_R1_renamed.fasta -2 ../combined_rep_1_R2_renamed.fasta -S rep_1.sam -p 6 -f
bowtie2 -x scaffolds_lt2500bp -1 ../combined_rep_2_R1_renamed.fasta -2 ../combined_rep_2_R2_renamed.fasta -S rep_2.sam -p 6 -f
bowtie2 -x scaffolds_lt2500bp -1 ../combined_rep_3_R1_renamed.fasta -2 ../combined_rep_3_R2_renamed.fasta -S rep_3.sam -p 6 -f

# convert sam files to bam files with samtools
module load samtools/1.10
samtools view -bS rep_1.sam -o rep_1.bam
samtools view -bS rep_2.sam -o rep_2.bam
samtools view -bS rep_3.sam -o rep_3.bam

samtools sort rep_1.bam -o rep_1_sorted.bam
samtools sort rep_2.bam -o rep_2_sorted.bam
samtools sort rep_3.bam -o rep_3_sorted.bam

samtools index rep_1_sorted.bam
samtools index rep_2_sorted.bam
samtools index rep_3_sorted.bam

# run MetaBAT
module load metabat/2.12.1
jgi_summarize_bam_contig_depths --outputDepth rep_123_depth.txt rep_1_sorted.bam rep_2_sorted.bam rep_3_sorted.bam
metabat -i scaffolds_lt2500bp.fasta -a rep_123_depth.txt -o rep_123_MAGs

# run MyCC
module load python/2.7.15
module load perl/5.28.0
module load bedtools/2.27.1
module load hmmer/3.3
module load barrnap/0.9
module load aragorn/1.2.38
module load cdhit/4.6.8
module load parallel/20200722
module load prodigal/2.6.3
module load mycc/20170301
MyCC.py scaffolds_lt2500bp.fasta -a rep_123_depth.txt 56mer

module load R/3.6.3
Binning_refiner -i Binning_refiner_wd -plot


# run barrnap on refined MAGs
module load perl/5.28.0
module load hmmer/3.2.1
module load bedtools/2.27.1
module load barrnap/0.9
cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads/spades_wd/Refined_Binning_refiner_outputs/Refined_refined_bins
barrnap Refined_10.fasta > barrnap_Refined_10.gff3
barrnap Refined_11.fasta > barrnap_Refined_11.gff3
barrnap Refined_12.fasta > barrnap_Refined_12.gff3
barrnap Refined_13.fasta > barrnap_Refined_13.gff3
barrnap Refined_14.fasta > barrnap_Refined_14.gff3
barrnap Refined_15.fasta > barrnap_Refined_15.gff3
barrnap Refined_16.fasta > barrnap_Refined_16.gff3
barrnap Refined_17.fasta > barrnap_Refined_17.gff3
barrnap Refined_18.fasta > barrnap_Refined_18.gff3
barrnap Refined_19.fasta > barrnap_Refined_19.gff3
barrnap Refined_1.fasta > barrnap_Refined_1.gff3
barrnap Refined_20.fasta > barrnap_Refined_20.gff3
barrnap Refined_21.fasta > barrnap_Refined_21.gff3
barrnap Refined_22.fasta > barrnap_Refined_22.gff3
barrnap Refined_23.fasta > barrnap_Refined_23.gff3
barrnap Refined_24.fasta > barrnap_Refined_24.gff3
barrnap Refined_25.fasta > barrnap_Refined_25.gff3
barrnap Refined_26.fasta > barrnap_Refined_26.gff3
barrnap Refined_27.fasta > barrnap_Refined_27.gff3
barrnap Refined_28.fasta > barrnap_Refined_28.gff3
barrnap Refined_29.fasta > barrnap_Refined_29.gff3
barrnap Refined_2.fasta > barrnap_Refined_2.gff3
barrnap Refined_30.fasta > barrnap_Refined_30.gff3
barrnap Refined_31.fasta > barrnap_Refined_31.gff3
barrnap Refined_3.fasta > barrnap_Refined_3.gff3
barrnap Refined_4.fasta > barrnap_Refined_4.gff3
barrnap Refined_5.fasta > barrnap_Refined_5.gff3
barrnap Refined_6.fasta > barrnap_Refined_6.gff3
barrnap Refined_7.fasta > barrnap_Refined_7.gff3
barrnap Refined_8.fasta > barrnap_Refined_8.gff3
barrnap Refined_9.fasta > barrnap_Refined_9.gff3
bedtools getfasta -fi Refined_10.fasta-bed barrnap_Refined_10.gff3 -fo rRNA_seq_Refined_10.fasta -name -s
bedtools getfasta -fi Refined_11.fasta-bed barrnap_Refined_11.gff3 -fo rRNA_seq_Refined_11.fasta -name -s
bedtools getfasta -fi Refined_12.fasta-bed barrnap_Refined_12.gff3 -fo rRNA_seq_Refined_12.fasta -name -s
bedtools getfasta -fi Refined_13.fasta-bed barrnap_Refined_13.gff3 -fo rRNA_seq_Refined_13.fasta -name -s
bedtools getfasta -fi Refined_14.fasta-bed barrnap_Refined_14.gff3 -fo rRNA_seq_Refined_14.fasta -name -s
bedtools getfasta -fi Refined_15.fasta-bed barrnap_Refined_15.gff3 -fo rRNA_seq_Refined_15.fasta -name -s
bedtools getfasta -fi Refined_16.fasta-bed barrnap_Refined_16.gff3 -fo rRNA_seq_Refined_16.fasta -name -s
bedtools getfasta -fi Refined_17.fasta-bed barrnap_Refined_17.gff3 -fo rRNA_seq_Refined_17.fasta -name -s
bedtools getfasta -fi Refined_18.fasta-bed barrnap_Refined_18.gff3 -fo rRNA_seq_Refined_18.fasta -name -s
bedtools getfasta -fi Refined_19.fasta-bed barrnap_Refined_19.gff3 -fo rRNA_seq_Refined_19.fasta -name -s
bedtools getfasta -fi Refined_1.fasta-bed barrnap_Refined_1.gff3 -fo rRNA_seq_Refined_1.fasta -name -s
bedtools getfasta -fi Refined_20.fasta-bed barrnap_Refined_20.gff3 -fo rRNA_seq_Refined_20.fasta -name -s
bedtools getfasta -fi Refined_21.fasta-bed barrnap_Refined_21.gff3 -fo rRNA_seq_Refined_21.fasta -name -s
bedtools getfasta -fi Refined_22.fasta-bed barrnap_Refined_22.gff3 -fo rRNA_seq_Refined_22.fasta -name -s
bedtools getfasta -fi Refined_23.fasta-bed barrnap_Refined_23.gff3 -fo rRNA_seq_Refined_23.fasta -name -s
bedtools getfasta -fi Refined_24.fasta-bed barrnap_Refined_24.gff3 -fo rRNA_seq_Refined_24.fasta -name -s
bedtools getfasta -fi Refined_25.fasta-bed barrnap_Refined_25.gff3 -fo rRNA_seq_Refined_25.fasta -name -s
bedtools getfasta -fi Refined_26.fasta-bed barrnap_Refined_26.gff3 -fo rRNA_seq_Refined_26.fasta -name -s
bedtools getfasta -fi Refined_27.fasta-bed barrnap_Refined_27.gff3 -fo rRNA_seq_Refined_27.fasta -name -s
bedtools getfasta -fi Refined_28.fasta-bed barrnap_Refined_28.gff3 -fo rRNA_seq_Refined_28.fasta -name -s
bedtools getfasta -fi Refined_29.fasta-bed barrnap_Refined_29.gff3 -fo rRNA_seq_Refined_29.fasta -name -s
bedtools getfasta -fi Refined_2.fasta-bed barrnap_Refined_2.gff3 -fo rRNA_seq_Refined_2.fasta -name -s
bedtools getfasta -fi Refined_30.fasta-bed barrnap_Refined_30.gff3 -fo rRNA_seq_Refined_30.fasta -name -s
bedtools getfasta -fi Refined_31.fasta-bed barrnap_Refined_31.gff3 -fo rRNA_seq_Refined_31.fasta -name -s
bedtools getfasta -fi Refined_3.fasta-bed barrnap_Refined_3.gff3 -fo rRNA_seq_Refined_3.fasta -name -s
bedtools getfasta -fi Refined_4.fasta-bed barrnap_Refined_4.gff3 -fo rRNA_seq_Refined_4.fasta -name -s
bedtools getfasta -fi Refined_5.fasta-bed barrnap_Refined_5.gff3 -fo rRNA_seq_Refined_5.fasta -name -s
bedtools getfasta -fi Refined_6.fasta-bed barrnap_Refined_6.gff3 -fo rRNA_seq_Refined_6.fasta -name -s
bedtools getfasta -fi Refined_7.fasta-bed barrnap_Refined_7.gff3 -fo rRNA_seq_Refined_7.fasta -name -s
bedtools getfasta -fi Refined_8.fasta-bed barrnap_Refined_8.gff3 -fo rRNA_seq_Refined_8.fasta -name -s
bedtools getfasta -fi Refined_9.fasta-bed barrnap_Refined_9.gff3 -fo rRNA_seq_Refined_9.fasta -name -s


######################################### Matam ##########################################

module load python/3.6.5
module load java/7u51
module load gcc/8.4.0
module load sparsehash/2.0.3
module load matam/1.5.3
module load samtools/1.9
export PATH=/home/z5039045/anaconda3/bin:$PATH
cd /srv/scratch/z5039045/LinkMAG16S/simulated_dataset/1_simulate_reads
python3 /home/z5039045/anaconda3/pkgs/matam-v1.5.3-0/bin/matam_assembly.py -d /srv/scratch/z5039045/DB/Matam/SILVA_128_SSURef_NR95 -i combined_rep123_cat.fasta --cpu 12 --max_memory 100000 -v -o combined_rep123_matam


###################################### Link (depth) ######################################

# on Mac
export PATH=/Users/songweizhi/Softwares/bowtie2:$PATH
cd /Users/songweizhi/Desktop/link_wd
~/PycharmProjects/MarkerMAG/bin/MarkerMAG -p EvenDepth -r1 R1.fasta -r2 R2.fasta -m combined_16S.ffn -mag selected_genomes_renamed_no_plasmid -x fna -t 4 -tmp -force -test_mode

# combine simulated reads
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_1x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_2x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_3x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_5x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_7x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_10x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_25x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_50x
cd /srv/scratch/z5039045/MarkerMAG_wd/even_depth_100x
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_7x_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_7x_R2.fasta

# on Katana
module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1

cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd
./MarkerMAG -p EvenDepth1x -r1 ../1_simulate_reads_even_depth/combined_1x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_1x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth2x -r1 ../1_simulate_reads_even_depth/combined_2x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_2x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth3x -r1 ../1_simulate_reads_even_depth/combined_3x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_3x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth5x -r1 ../1_simulate_reads_even_depth/combined_5x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_5x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth7x -r1 ../1_simulate_reads_even_depth/combined_7x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_7x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth10x -r1 ../1_simulate_reads_even_depth/combined_10x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_10x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth25x -r1 ../1_simulate_reads_even_depth/combined_25x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_25x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth50x -r1 ../1_simulate_reads_even_depth/combined_50x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_50x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth100x -r1 ../1_simulate_reads_even_depth/combined_100x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_100x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force

Depth	Paired	Paired	Clip	Clip	Intxn	Intxn
1x		73.49	98.48	56.63	97.33	40.96	100.0
2x		96.39	99.88	54.22	94.89	51.81	100.0
3x		100.0	100.0	90.36	99.72	90.36	100.0
5x		100.0	100.0	93.98	99.9	93.98	100.0
7x		100.0	100.0	96.39	99.81	96.39	100.0
10x		100.0	100.0	100.0	100.0	100.0	100.0
25x		100.0	100.0	100.0	100.0	100.0	100.0
50x		100.0	100.0	100.0	100.0	100.0	100.0
100x	100.0	100.0	100.0	100.0	100.0	100.0


############################### effect of ambiguous mapping ##############################

module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load java/8u121
module load bbmap/38.51
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd

./MarkerMAG -p EvenDepth_10x_ambiguous_y -r1 ../1_simulate_reads_even_depth/combined_10x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_10x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth_10x_ambiguous_n -r1 ../1_simulate_reads_even_depth/combined_10x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_10x_R2.fasta -m ../genome_selection/combined_16S_drep.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -no_ambiguous
./MarkerMAG -p EvenDepth_10x_ambiguous_n2 -r1 ../1_simulate_reads_even_depth/combined_10x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_10x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -no_ambiguous
# 10x	default			100.0	100.0	100.0	100.0	100.0	100.0
# 10x	no_ambiguous	100.0	100.0	82.14	100.0	82.14	100.0
# 10x	no-drep			18.07	96.43	12.05	100.0	9.64	100.0


./MarkerMAG -p EvenDepth_7x_ambiguous_y -r1 ../1_simulate_reads_even_depth/combined_7x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_7x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth_7x_ambiguous_n -r1 ../1_simulate_reads_even_depth/combined_7x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_7x_R2.fasta -m ../genome_selection/combined_16S_drep.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -no_ambiguous
./MarkerMAG -p EvenDepth_7x_ambiguous_n2 -r1 ../1_simulate_reads_even_depth/combined_7x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_7x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -no_ambiguous
# 7x	default			100.0	100.0	96.39	99.81	96.39	100.0
# 7x	no_ambiguous	100.0	100.0	85.71	100.0	85.71	100.0
# 7x	no-drep			19.28	88.18	12.05	100.0	12.05	100.0


./MarkerMAG -p EvenDepth_5x_ambiguous_y -r1 ../1_simulate_reads_even_depth/combined_5x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_5x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force
./MarkerMAG -p EvenDepth_5x_ambiguous_n -r1 ../1_simulate_reads_even_depth/combined_5x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_5x_R2.fasta -m ../genome_selection/combined_16S_drep.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -no_ambiguous
./MarkerMAG -p EvenDepth_5x_ambiguous_n2 -r1 ../1_simulate_reads_even_depth/combined_5x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_5x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force -no_ambiguous
# 5x	default			100.0	100.0	93.98	99.9	93.98	100.0
# 5x	no_ambiguous	100.0	100.0	85.71	100.0	85.71	100.0
# 5x	no-drep			15.66	77.41	10.84	100.0	9.64	100.0


############################## Link (Matam and InSilicoSeq) ##############################

# rename Matam assemblies
module load blast+/2.9.0
module load python/3.7.3
source ~/mypython3env/bin/activate
cd /srv/scratch/z5039045/MarkerMAG_wd/InSilicoSeq_wd/Matam_InSilicoSeq_50x/workdir
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -matam scaffolds.NR.min_500bp.fa -barrnap /srv/scratch/z5039045/MarkerMAG_wd/genome_selection/combined_16S.ffn -iden 99.5 -aln 1500
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -matam scaffolds.NR.min_500bp.fa -barrnap /srv/scratch/z5039045/MarkerMAG_wd/genome_selection/combined_16S.ffn -iden 99.5 -aln 1300
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -matam scaffolds.NR.min_500bp.fa -barrnap /srv/scratch/z5039045/MarkerMAG_wd/genome_selection/combined_16S.ffn -iden 99.5 -aln 1200
python3 /srv/scratch/z5039045/MarkerMAG_wd/rename_matam_assemblies.py -matam scaffolds.NR.min_500bp.fa -barrnap /srv/scratch/z5039045/MarkerMAG_wd/genome_selection/combined_16S.ffn -iden 99.5 -aln 1000

depth	iden	aln		Matam	Barrnap
10x		99.5	1500	10		41
10x		99.5	1300	21		60
10x		99.5	1200	25		68
10x		99.5	1000	26		69

depth	iden	aln		Matam	Barrnap
25x		99.5	1500	14		38
25x		99.5	1300	24		56
25x		99.5	1200	25		58
25x		99.5	1000	28		60

depth	iden	aln		Matam	Barrnap
50x		99.5	1500	13		38
50x		99.5	1300	18		41
50x		99.5	1200	23		48
50x		99.5	1000	27		49


###################################### Link (Matam) ######################################

# link Matam assemblies with predicted 16S sequences
# aln   iden    query   subject
# 1500, 100:    19      42
# 1500, 99.9:   22      52
# 1500, 99.5:   24      66

# 1200, 100:    28      55
# 1200, 99.9:   34      77
# 1200, 99.5:   36      83

# 1000, 100:    30      58
# 1000, 99.9:   36      80
# 1000, 99.5:   38      86


module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd

./MarkerMAG -p Matam16S_to_Genome_99.5_1000 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1000bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode
./MarkerMAG -p Matam16S_to_Genome_99.5_1200 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1200bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode
./MarkerMAG -p Matam16S_to_Genome_99.5_1300 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1300bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode
./MarkerMAG -p Matam16S_to_Genome_99.5_1500 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1500bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode
# reads iden100 cov100
# 1000bp Intxn:	0.84210526	1.0
# 1200bp Intxn:	0.77777778	1.0
# 1300bp Intxn:	0.82352941	1.0
# 1500bp Intxn:	0.75	1.0

./MarkerMAG -p Matam16S_to_Genome_99.5_1000 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1000bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -rc 80
./MarkerMAG -p Matam16S_to_Genome_99.5_1200 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1200bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -rc 80
./MarkerMAG -p Matam16S_to_Genome_99.5_1300 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1300bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -rc 80
./MarkerMAG -p Matam16S_to_Genome_99.5_1500 -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1500bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -rc 80
# reads iden100 cov80
# 1000bp Intxn:	0.84210526	1.0
# 1200bp Intxn:	0.83333333	1.0
# 1300bp Intxn:	0.88235294	1.0
# 1500bp Intxn:	0.75	1.0

./MarkerMAG_bitscore -p Matam16S_to_Genome_99.5_1000_bitscore -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1000bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -ri 99.2
./MarkerMAG_bitscore -p Matam16S_to_Genome_99.5_1200_bitscore -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1200bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -ri 99.2
./MarkerMAG_bitscore -p Matam16S_to_Genome_99.5_1300_bitscore -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1300bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -ri 99.2
./MarkerMAG_bitscore -p Matam16S_to_Genome_99.5_1500_bitscore -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly_99.5_1500bp.fasta -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode -ri 99.2
# reads iden99.2 best bitscore
# 1000bp Intxn:	0.84210526	1.0
# 1200bp Intxn:	0.77777778	1.0
# 1300bp 
# 1500bp 

./MarkerMAG -p Matam16S_to_Genome -r1 ../1_simulate_3Rep_25x/combined_rep123_R1.fasta -r2 ../1_simulate_3Rep_25x/combined_rep123_R2.fasta -m ../1_simulate_3Rep_25x/combined_rep123_matam/final_assembly.fa -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force


################################ Link (Matam) with GemSIM ################################

cd /srv/scratch/z5039045/MarkerMAG_wd/1_GemSIM_even_depth
/srv/scratch/z5039045/Softwares/seqtk/seqtk mergepe GemSIM_5x_R1_renamed.fasta GemSIM_5x_R2_renamed.fasta > GemSIM_5x_renamed.fasta
/srv/scratch/z5039045/Softwares/seqtk/seqtk mergepe GemSIM_10x_R1_renamed.fasta GemSIM_10x_R2_renamed.fasta > GemSIM_10x_renamed.fasta
/srv/scratch/z5039045/Softwares/seqtk/seqtk mergepe GemSIM_25x_R1_renamed.fasta GemSIM_25x_R2_renamed.fasta > GemSIM_25x_renamed.fasta


# link Matam assemblies with predicted 16S sequences
# aln   iden    query   subject
# 1500, 100:    
# 1500, 99.9:   
# 1500, 99.5:   

# 1200, 100:    
# 1200, 99.9:   
# 1200, 99.5:   

# 1000, 100:    
# 1000, 99.9:   
# 1000, 99.5:   


module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd

# 5x
./MarkerMAG -p GemSIM_EvenDepth5x -r1 ../1_GemSIM_even_depth/GemSIM_5x_R1_renamed.fasta -r2 ../1_GemSIM_even_depth/GemSIM_5x_R2_renamed.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force

# 10x
./MarkerMAG -p GemSIM_EvenDepth10x -r1 ../1_GemSIM_even_depth/GemSIM_10x_R1_renamed.fasta -r2 ../1_GemSIM_even_depth/GemSIM_10x_R2_renamed.fasta -m ../genome_selection/combined_16S.ffn -mag ../genome_selection/selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -test_mode -force


##################################### Link (Binning) #####################################

# combine simulated reads
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x/reads_rep1
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_rep1_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_rep1_R2.fasta
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x/reads_rep2
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_rep2_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_rep2_R2.fasta
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x/reads_rep3
cat c1_R1.fasta f2_R1.fasta g1_R1.fasta g5_R1.fasta o4_R1.fasta p3_R1.fasta s2_R1.fasta c2_R1.fasta f3_R1.fasta g2_R1.fasta o1_R1.fasta o5_R1.fasta p4_R1.fasta s3_R1.fasta c3_R1.fasta f4_R1.fasta g3_R1.fasta o2_R1.fasta p1_R1.fasta p5_R1.fasta s4_R1.fasta f1_R1.fasta f5_R1.fasta g4_R1.fasta o3_R1.fasta p2_R1.fasta s1_R1.fasta s5_R1.fasta > ../combined_rep3_R1.fasta
cat c1_R2.fasta f2_R2.fasta g1_R2.fasta g5_R2.fasta o4_R2.fasta p3_R2.fasta s2_R2.fasta c2_R2.fasta f3_R2.fasta g2_R2.fasta o1_R2.fasta o5_R2.fasta p4_R2.fasta s3_R2.fasta c3_R2.fasta f4_R2.fasta g3_R2.fasta o2_R2.fasta p1_R2.fasta p5_R2.fasta s4_R2.fasta f1_R2.fasta f5_R2.fasta g4_R2.fasta o3_R2.fasta p2_R2.fasta s1_R2.fasta s5_R2.fasta > ../combined_rep3_R2.fasta

# rename simulated reads
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x
BioSAK rename_seq -in combined_rep1_R1.fasta -prefix rep1 -oneline
BioSAK rename_seq -in combined_rep1_R2.fasta -prefix rep1 -oneline
BioSAK rename_seq -in combined_rep2_R1.fasta -prefix rep2 -oneline
BioSAK rename_seq -in combined_rep2_R2.fasta -prefix rep2 -oneline
BioSAK rename_seq -in combined_rep3_R1.fasta -prefix rep3 -oneline
BioSAK rename_seq -in combined_rep3_R2.fasta -prefix rep3 -oneline

# combine reads for assembly
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x
cat combined_rep1_R1_renamed.fasta combined_rep2_R1_renamed.fasta combined_rep3_R1_renamed.fasta > combined_rep123_R1_renamed.fasta
cat combined_rep1_R2_renamed.fasta combined_rep2_R2_renamed.fasta combined_rep3_R2_renamed.fasta > combined_rep123_R2_renamed.fasta

# assembly
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x/spades_wd
perl /srv/scratch/z5039045/Scripts/select_contig.pl -m 2500 scaffolds.fasta scaffolds_lt2500.fasta

# mapping
module load bowtie/2.3.5.1
module load samtools/1.10
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x/spades_wd
bowtie2-build -f scaffolds_lt2500.fasta scaffolds_lt2500
bowtie2 -x scaffolds_lt2500 -1 ../combined_rep1_R1_renamed.fasta -2 ../combined_rep1_R2_renamed.fasta -S rep1.sam -p 6 -f
bowtie2 -x scaffolds_lt2500 -1 ../combined_rep2_R1_renamed.fasta -2 ../combined_rep2_R2_renamed.fasta -S rep2.sam -p 6 -f
bowtie2 -x scaffolds_lt2500 -1 ../combined_rep3_R1_renamed.fasta -2 ../combined_rep3_R2_renamed.fasta -S rep3.sam -p 6 -f
samtools view -bS rep1.sam -o rep1.bam
samtools view -bS rep2.sam -o rep2.bam
samtools view -bS rep3.sam -o rep3.bam
samtools sort rep1.bam -o rep1_sorted.bam
samtools sort rep2.bam -o rep2_sorted.bam
samtools sort rep3.bam -o rep3_sorted.bam
samtools index rep1_sorted.bam
samtools index rep2_sorted.bam
samtools index rep3_sorted.bam

# binning with MetaBAT
module load metabat/2.12.1
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x/spades_wd
jgi_summarize_bam_contig_depths --outputDepth rep123_depth.txt rep1_sorted.bam rep2_sorted.bam rep3_sorted.bam
metabat -i scaffolds_lt2500.fasta -a rep123_depth.txt -o rep123_MAGs

# binning with MyCC
module load python/2.7.15
module load perl/5.28.0
module load bedtools/2.27.1
module load hmmer/3.3
module load barrnap/0.9
module load aragorn/1.2.38
module load cdhit/4.6.8
module load parallel/20200722
module load prodigal/2.6.3
module load mycc/20170301
MyCC.py scaffolds_lt2500.fasta -a rep123_depth.txt 56mer

# refine bins
module load R/3.6.3
cd /srv/scratch/z5039045/MarkerMAG_wd/1_simulate_3Rep_25x
Binning_refiner -i Binning_refiner_wd -plot

# MarkerMAG
module load python/3.7.3
source ~/mypython3env/bin/activate
module unload R
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd
./MarkerMAG -p Binning25x -r1 ../1_simulate_reads_even_depth/combined_25x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_25x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../1_simulate_3Rep_25x/Refined_Binning_refiner_outputs/Refined_refined_bins -x fasta -t 12 -tmp -force
./MarkerMAG -p Binning25x -r1 ../1_simulate_reads_even_depth/combined_25x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_25x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../1_simulate_3Rep_25x/Refined_Binning_refiner_outputs/Refined_refined_bins -x fasta -t 12 -tmp -force -rc 90
./MarkerMAG -p Binning25x -r1 ../1_simulate_reads_even_depth/combined_25x_R1.fasta -r2 ../1_simulate_reads_even_depth/combined_25x_R2.fasta -m ../genome_selection/combined_16S.ffn -mag ../1_simulate_3Rep_25x/Refined_Binning_refiner_outputs/Refined_refined_bins -x fasta -t 12 -tmp -force -rc 80


################################ Link (Binning and Matam) ################################

module load python/3.7.3
source ~/mypython3env/bin/activate
module load R/4.0.2
module load blast+/2.9.0
module load bowtie/2.3.5.1
cd /srv/scratch/z5039045/MarkerMAG_wd/2_link_wd

./MarkerMAG -p Matam16S_to_MAG -r1 ../1_simulate_reads/combined_rep123_R1.fasta -r2 ../1_simulate_reads/combined_rep123_R2.fasta -m ../1_simulate_reads/combined_rep123_matam/final_assembly.fa -mag ../1_simulate_reads/spades_wd/Refined_Binning_refiner_outputs/Refined_refined_bins -x fasta -t 12 -tmp -force


######################################### Backup #########################################

./MarkerMAG -p EvenDepth_25x -r1 combined_25x_R1.fasta -r2 combined_25x_R2.fasta -m combined_16S.ffn -mag selected_genomes_renamed_no_plasmid -x fna -t 12 -tmp -force -test_mode

5x, default	0.95402299	1.0	0.94252874	0.99626168	0.93103448	1.0
5x, k=1		0.96551724	1.0	0.90804598	0.99577167	0.89655172	1.0
5x, k=2		0.96551724	1.0	0.94252874	0.99888641	0.94252874	1.0
5x, k=3		0.96551724	1.0	0.94252874	0.9984917	0.93103448	1.0
5x, k=10	0.97701149	1.0	0.68965517	0.90625625	0.68965517	1.0

25x, default	0.95402299	1.0	0.94252874	0.99481141	0.93103448	1.0
25x, k=1		0.95402299	1.0	0.97701149	1.0			0.95402299	1.0
25x, k=2		0.96551724	1.0	0.91954023	0.99482177	0.88505747	1.0
25x, k=3		0.96551724	1.0	0.93103448	0.99642422	0.93103448	1.0

