"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanDefinition = exports.NetworkFileDefinition = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.2.6" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                canInterfaceName: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.2.6" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.2.6" };
class CanVehicleSignal extends VehicleSignal {
    constructor(name, fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                canSignalName: name,
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.2.6" };
class NetworkFileDefinition {
    constructor() {
        this.definition = {};
    }
    toObject() {
        return (this.definition);
    }
}
exports.NetworkFileDefinition = NetworkFileDefinition;
_e = JSII_RTTI_SYMBOL_1;
NetworkFileDefinition[_e] = { fqn: "cdk-aws-iotfleetwise.NetworkFileDefinition", version: "0.2.6" };
class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface, signalsMap, canDbcFiles) {
        super();
        this.definition = {
            networkFileType: 'CAN_DBC',
            canDbc: {
                canDbcFiles,
                networkInterface,
                signalsMap,
            },
        };
    }
}
exports.CanDefinition = CanDefinition;
_f = JSII_RTTI_SYMBOL_1;
CanDefinition[_f] = { fqn: "cdk-aws-iotfleetwise.CanDefinition", version: "0.2.6" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.signalCatalog = {};
        this.name = props.name || '';
        this.signalCatalog = props.signalCatalog;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'vehiclemodelhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
            logRetention: this.signalCatalog.logRetention,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
            logRetention: this.signalCatalog.logRetention,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: (props.signals) ? JSON.stringify(props.signals.map(s => s.toObject())) : '{}',
                network_file_definitions: (props.networkFileDefinitions) ? JSON.stringify(props.networkFileDefinitions.map(s => s.toObject())) : '{}',
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_g = JSII_RTTI_SYMBOL_1;
VehicleModel[_g] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.2.6" };
//# sourceMappingURL=data:application/json;base64,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